/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.news;

import java.io.ByteArrayInputStream;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.tab.TabWindow;
import se.tactel.tvclient.gui.screen.tab.news.SVGProtocol;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;

public class NewsWindow
extends TabWindow {
    final Controller controller;
    UserDialogView userDialogView;
    View topLevelView;

    protected Window getTabToTheLeft() {
        return this.controller.getStoreController().getStartWindow();
    }

    protected Window getTabToTheRight() {
        return this.controller.getTvScreenWindow();
    }

    public NewsWindow(final Controller controller) {
        this.controller = controller;
        OptionsMenuItem[] menuItems = new OptionsMenuItem[3];
        menuItems[0] = OptionsMenuItem.createButtonMenuItem();
        menuItems[0].setText(105);
        menuItems[0].setAction(new Action(){

            public void clicked(View sender) {
                controller.closeOptionMenuWindow();
                NewsWindow.this.userDialogView.event(Event.keyEvent(1, -5));
            }
        });
        menuItems[1] = OptionsMenuItem.HELP_NEWS_BUTTON;
        menuItems[2] = OptionsMenuItem.EXIT_BUTTON;
        this.setOptionMenuItems(menuItems);
        ButtonBar defaultButtonBar = ButtonBar.createDefaultButtonBar(this);
        this.setButtonBar(defaultButtonBar);
        this.setContentView(this.createUI());
    }

    private View createUI() {
        this.topLevelView = new View(){

            public boolean event(Event event) {
                if (event.type() == 1 && (event.keyCode() == -3 || event.keyCode() == -4)) {
                    return true;
                }
                return super.event(event);
            }
        };
        this.topLevelView.setFrame(new Rect(Skin.MAIN_FRAME_EXCLUDING_INTERACTIVITY_VIEW));
        this.topLevelView.setOpaque(true);
        this.topLevelView.setBackgroundColor(-65536);
        this.topLevelView.setDrawsBackground(true);
        ImageView sntImg = new ImageView(new Rect(Skin.SNT_TAB_IMAGE_FRAME), Images.getSNTImage(1));
        this.topLevelView.addSubview(sntImg);
        View shade = new View();
        shade.setFrame(new Rect(Skin.SHADE_FRAME));
        shade.setDrawsBackground(true);
        shade.setBackgroundImage(Images.getShade());
        this.topLevelView.addSubview(shade);
        this.setUserDialogToDisplay("res:///screen/news/default.svg");
        return this.topLevelView;
    }

    public void setUserDialogToDisplay(String url) {
        ByteArrayInputStream bis = new ByteArrayInputStream(ServiceRegistry.instance().getComm().getByteArray(url));
        Log.log(0x80000000000L, "Downloading promotion SVG: " + url);
        SVGProtocol p = new SVGProtocol();
        p.parse(bis);
        if (p.userDialogView != null) {
            if (this.userDialogView != null) {
                this.userDialogView.removeFromParentViewWithoutNeedingDisplay();
            }
            this.userDialogView = p.userDialogView;
            this.userDialogView.setFrame(new Rect(Skin.NEWS_USERDIALOG_RECT));
            this.topLevelView.addSubview(this.userDialogView);
            if (this.userDialogView.getKeyViews().size() > 0) {
                this.userDialogView.setInitialKeyView(0);
            }
            this.topLevelView.setNeedsDisplay();
            RichMediaMIDlet.instance().tController.getInteractivityController().processUserDialogRootCommmands(this.userDialogView);
        } else {
            Log.log(0x40000000L, "Failed parsing novedadas SVG downloaded from: " + url);
        }
    }
}

