/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.store.start;

import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ButtonView;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.MultiTextView;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.list.DataSource;
import se.tactel.tvclient.gui.list.ListDelegate;
import se.tactel.tvclient.gui.list.ListView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.tab.store.StoreWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;

public class StartStoreWindow
extends StoreWindow
implements DataSource,
ListDelegate,
Observer {
    private Vector unsubscribedPacks;
    private ListView listView;
    private ButtonView mySubscriptionsButton;
    private MultiTextView textView;
    static /* synthetic */ Class class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem;

    public StartStoreWindow(Controller controller) {
        super(controller);
        this.setContentView(this.createUI());
        this.updateKeyViews();
        this.setButtonBar(ButtonBar.createDefaultButtonBar(this));
        OptionsMenuItem[] menuItems = new OptionsMenuItem[]{this.OPEN, OptionsMenuItem.HELP_SHOP_BUTTON, OptionsMenuItem.EXIT_BUTTON};
        this.setOptionMenuItems(menuItems);
        ServiceRegistry.instance().getDataProvider().getChannelList().addObserver(this);
    }

    private View createUI() {
        View contentView = new View();
        contentView.setFrame(new Rect(Skin.MAIN_FRAME_EXCLUDING_INTERACTIVITY_VIEW));
        contentView.setOpaque(true);
        contentView.setBackgroundColor(-1972760);
        contentView.setDrawsBackground(true);
        ImageView tabImage = new ImageView();
        tabImage.setFrame(new Rect(Skin.SNT_TAB_IMAGE_FRAME));
        tabImage.setImage(Images.getSNTImage(4));
        contentView.addSubview(tabImage);
        View shadeView = new View();
        shadeView.setFrame(new Rect(Skin.SHADE_FRAME));
        shadeView.setDrawsBackground(true);
        shadeView.setBackgroundImage(Images.getShade());
        contentView.addSubview(shadeView);
        this.textView = new SimpleMultiTextView();
        this.textView.setText(303);
        this.textView.setFont(Fonts.NORMAL_BOLD);
        this.textView.setTextColor(-16777216);
        this.textView.setVerticallyAlignment(true);
        this.textView.setAlignment(1);
        this.mySubscriptionsButton = new ButtonView();
        this.mySubscriptionsButton.setHighlightBackgroundColor(-6697759);
        this.mySubscriptionsButton.setDrawsBackground(true);
        this.mySubscriptionsButton.setTextColor(-16777216);
        this.mySubscriptionsButton.setHighlightTextColor(-16777216);
        this.mySubscriptionsButton.setFont(Fonts.NORMAL);
        this.mySubscriptionsButton.setBackgroundImage(Images.getMyPacksButton());
        this.mySubscriptionsButton.setHighlightBackgroundImage(Images.getMyPacksButtonHighlight());
        this.mySubscriptionsButton.setAction(new Action(){

            public void clicked(View sender) {
                StartStoreWindow.this.controller.getStoreController().getMySubscriptionsWindow().makeKeyAndOrderFront();
                StartStoreWindow.this.close();
            }
        });
        this.unsubscribedPacks = this.getUnsubscribedPacks();
        this.listView = new ListView();
        this.listView.setFrame(new Rect(Skin.STORE_PACK_LIST_FRAME));
        this.listView.setListItemClass(class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem == null ? (class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem = StartStoreWindow.class$("se.tactel.tvclient.gui.screen.tab.store.start.PackItem")) : class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem);
        this.listView.setItemSpacing(7);
        this.listView.setItemOffset(8);
        this.listView.setBackgroundColor(-1);
        this.listView.setDrawsBackground(true);
        this.listView.setDelegate(this);
        this.listView.setHighlight(false);
        contentView.addSubview(this.listView);
        this.listView.setDataSource(this);
        return contentView;
    }

    public boolean eventForWindow(Event event, Window window) {
        if (this.mySubscriptionsButton.isHighlighted() && event.type() == 1 && event.keyCode() == -1) {
            this.listView.selectLastRow();
            return false;
        }
        if (this.mySubscriptionsButton.isHighlighted() && event.type() == 1 && event.keyCode() == -2) {
            this.listView.selectRowAtIndex(0);
            return false;
        }
        return super.eventForWindow(event, window);
    }

    public void listViewDidClickRowIndex(ListView l, int rowIndex) {
        Content c = (Content)this.listViewObjectValueForLocation(this.listView, 2, rowIndex);
        if (c instanceof Folder) {
            this.controller.getStoreController().getPackWindow((Folder)c).makeKeyAndOrderFront();
            this.close();
        }
    }

    public Object listViewObjectValueForLocation(ListView aListView, int cell, int rowIndex) {
        Content pack = (Content)this.unsubscribedPacks.elementAt(rowIndex);
        switch (cell) {
            case 0: {
                return pack.getName();
            }
            case 1: {
                return pack.getDescription();
            }
            case 2: {
                return pack;
            }
        }
        return null;
    }

    public int numberOfRowsInListView(ListView l) {
        return this.unsubscribedPacks.size();
    }

    private Vector getUnsubscribedPacks() {
        Enumeration enumeration = ServiceRegistry.instance().getDataProvider().getFolderList().getAllFolders().elements();
        Vector<Content> v = new Vector<Content>();
        while (enumeration.hasMoreElements()) {
            Content content = (Content)enumeration.nextElement();
            if (!(content instanceof Folder) || content.isSubscribed() && !content.isPaymentAllowed()) continue;
            v.addElement(content);
        }
        return v;
    }

    private void updateKeyViews() {
        boolean userHasSubscribedPacks;
        boolean bl = userHasSubscribedPacks = ServiceRegistry.instance().getDataProvider().getFolderList().getSubscribedFolders().size() > 0;
        if (userHasSubscribedPacks) {
            if (this.mySubscriptionsButton.parent() == null) {
                this.mySubscriptionsButton.setFrame(new Rect(Skin.STORE_MY_SUBSCRIPTIONS_LINK_BUTTON_FRAME));
                this.contentView().addSubview(this.mySubscriptionsButton);
                this.textView.removeFromParentViewWithoutNeedingDisplay();
                this.mySubscriptionsButton.setNextResponder(this.listView);
                this.listView.setNextResponder(this.mySubscriptionsButton);
                this.setInitialFirstResponder(this.listView);
            }
        } else {
            this.mySubscriptionsButton.removeFromParentViewWithoutNeedingDisplay();
            this.mySubscriptionsButton.setHighlight(false);
            if (this.textView.parent() == null) {
                this.textView.setFrame(new Rect(Skin.STORE_START_TEXT_FRAME));
                this.contentView().addSubview(this.textView);
            }
            this.setInitialFirstResponder(this.listView);
            this.contentView().setNeedsDisplay();
        }
    }

    public void update(ObservableData data) {
        this.unsubscribedPacks = this.getUnsubscribedPacks();
        Log.log(0x4000000000L, "Store start screen update: " + this.unsubscribedPacks);
        this.listView.clear();
        this.listView.reloadData();
        this.updateKeyViews();
        this.contentView().setNeedsDisplay();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

