/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.tv;

import se.tactel.tvclient.Controller;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.LocalConfiguration;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.interactivity.SplitScreenSVGWindow;
import se.tactel.tvclient.gui.screen.tab.TabWindow;
import se.tactel.tvclient.gui.screen.tab.tv.PlayerWindowInterface;
import se.tactel.tvclient.gui.screen.tab.tv.TvScreenController;
import se.tactel.tvclient.gui.windowing.Window;

public class TVWindow
extends TabWindow
implements PlayerWindowInterface {
    private TvScreenController tvScreenController;
    private boolean tooltip = true;

    public TVWindow(TvScreenController controller) {
        this.tvScreenController = controller;
    }

    public boolean eventForWindow(Event event, Window window) {
        if (this.tvScreenController.handleEvent(event)) {
            return true;
        }
        if (event.type() == 1 && event.keyCode() == -11) {
            return true;
        }
        return super.eventForWindow(event, window);
    }

    protected synchronized void didLoseTopWindow() {
        super.didLoseTopWindow();
        if (!(ServiceRegistry.instance().getWindowServer().getTopmostWindow() instanceof SplitScreenSVGWindow)) {
            this.tvScreenController.playerView.setActive(false);
            this.tvScreenController.playerView.showTv(false);
            ServiceRegistry.instance().getPlayer().setMutedWithoutNotifing(true);
        }
    }

    protected synchronized void didBecomeTopWindow() {
        super.didBecomeTopWindow();
        this.tvScreenController.playerView.setActive(true);
        this.tvScreenController.playerView.showTv(true);
        ServiceRegistry.instance().getPlayer().setMutedWithoutNotifing(false);
        LocalConfiguration lc = ServiceRegistry.instance().getLocalConfiguration();
        if (this.tooltip && lc.getTooltipTV() < 3) {
            Controller.getTooltipWindow(200).makeKeyAndOrderFront();
            lc.increaseTooltipTV();
            this.tooltip = false;
        }
    }

    protected Window getTabToTheLeft() {
        return this.tvScreenController.controller.getNewsWindow();
    }

    protected Window getTabToTheRight() {
        return this.tvScreenController.controller.getChannelsWindow();
    }

    protected void setVisible(boolean flag) {
        if (this.isVisible() != flag) {
            super.setVisible(flag);
        }
    }
}

