/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tooltip;

import java.util.Timer;
import java.util.TimerTask;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.windowing.NotPossibleToGoBackWindow;
import se.tactel.tvclient.gui.windowing.Window;

public class TooltipWindow
extends Window
implements NotPossibleToGoBackWindow {
    SimpleMultiTextView textView;
    Timer exitTimer;

    public TooltipWindow() {
        View tooltipView = new View();
        tooltipView.setFrame(new Rect(Skin.TOOLTIP_FRAME));
        tooltipView.setOpaque(false);
        tooltipView.setBackgroundImage(Images.getTooltip());
        tooltipView.setDrawsBackground(true);
        this.textView = new SimpleMultiTextView();
        this.textView.setFrame(new Rect(Skin.TOOLTIP_TEXT_FRAME));
        this.textView.setText(-1);
        this.textView.setTextColor(-16777216);
        tooltipView.addSubview(this.textView);
        this.setContentView(tooltipView);
    }

    public boolean event(Event event) {
        this.close();
        return true;
    }

    public void setText(int id) {
        this.textView.setText(id);
        this.textView.setNeedsDisplay();
    }

    public void setActive(boolean flag) {
        super.setActive(flag);
        if (flag) {
            this.exitTimer = new Timer();
            this.exitTimer.schedule(new TimerTask(){

                public void run() {
                    TooltipWindow.this.close();
                }
            }, 3000L);
        } else if (this.exitTimer != null) {
            this.exitTimer.cancel();
        }
    }

    protected void didLoseTopWindow() {
        super.didLoseTopWindow();
        if (this.isVisible()) {
            this.close();
        }
    }
}

