/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.windowing;

import java.util.Vector;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.windowing.ApplicationCanvas;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowServer;
import se.tactel.tvclient.util.Log;

public class Runloop
implements Runnable {
    WindowServer server;
    ApplicationCanvas canvas;
    boolean run;
    Vector events;

    public Runloop(WindowServer server) {
        Thread t = new Thread(this);
        this.server = server;
        this.canvas = (ApplicationCanvas)server.canvas();
        this.events = new Vector();
        t.setPriority(1);
        this.run = true;
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event) {
        Vector vector = this.events;
        synchronized (vector) {
            this.events.addElement(event);
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean res = false;
        try {
            while (this.run) {
                try {
                    Event event;
                    Vector vector = this.events;
                    synchronized (vector) {
                        if (this.events.size() == 0) {
                            this.events.wait();
                        } else {
                            this.events.wait(10L);
                        }
                        event = (Event)this.events.firstElement();
                        this.events.removeElement(event);
                    }
                    System.out.println("post event thread " + Thread.currentThread());
                    try {
                        Window kw;
                        if (this.canvas.delegate != null) {
                            res |= this.canvas.delegate.eventForApplication(event, this.canvas);
                        }
                        if ((kw = this.server.keyWindow()) != null) {
                            res |= kw.event(event);
                        }
                        if (event.type() == 2) {
                            this.server.redraw();
                        }
                        Thread.yield();
                    }
                    catch (Throwable t) {
                        Log.exception(this, t);
                        Log.log(0x80000000L, "exception in event: " + t);
                    }
                }
                catch (Exception e) {
                    Log.exception(this, e);
                    Log.log(0x80000000L, "exception in event loop: " + e);
                }
            }
            return;
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }
}

