/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.HttpConnection;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.network.protocols.NinProtocolVersion1_0;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class Comm
implements Runnable {
    static int MAXIMUM_NUMBER_OF_CONNECTIONS;
    static final boolean USE_DEDICATED_CONNECTION = true;
    private Hashtable keys = new Hashtable();
    static int numberOfConnections;
    public static final int DISPLAY_NO_SVG_ON_FAILURE = 0;
    public static final int DISPLAY_CONTINUE_SVG_ON_FAILURE = 1;
    public static final int DISPLAY_EXIT_SVG_ON_FAILURE = 2;
    public static final int DEFAULT_FAILURE_POLICY = 1;
    static Object lock;
    private boolean run;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getByteArray(String URL2) {
        byte[] data = null;
        if (URL2 == null) {
            return data;
        }
        if (URL2.equals("")) {
            return data;
        }
        if (URL2.startsWith("res://")) {
            InputStream is = this.getInputStreamToLocalResource(null, URL2);
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int x = -1;
            try {
                while (true) {
                    if ((x = is.read()) == -1) {
                        return bos.toByteArray();
                    }
                    bos.write(x);
                }
            }
            catch (IOException e) {
                Log.exception(this, e);
                return data;
            }
        }
        HttpConnection conn = null;
        FilterInputStream is = null;
        try {
            if (this.keys.size() > 0) {
                Enumeration e = this.keys.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = (String)this.keys.get(key);
                    URL2 = Utils.urlAppendParameter(URL2, key, value).toString();
                }
            }
            conn = this.openHttpConnection(URL2);
            is = conn.openDataInputStream();
            if (conn.getResponseCode() != 200) return data;
            int lenght = (int)conn.getLength();
            if (lenght > 0) {
                data = new byte[(int)conn.getLength()];
                ((DataInputStream)is).readFully(data);
            } else {
                int ch;
                Log.log(0x200001000L, "Chunked download");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((ch = is.read()) != -1) {
                    bos.write(ch);
                }
                data = bos.toByteArray();
            }
            Log.log(0x200001000L, "Downloaded " + data.length + "b from: " + URL2);
            return data;
        }
        catch (Exception e) {
            Log.exception(this, e);
            return data;
        }
        catch (Error r) {
            Log.log(0x40000000L, "Caught Error " + r.toString());
            return data;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.close();
                    Log.log(0x200001000L, "Closed connection for " + URL2);
                }
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
            finally {
                Comm.releaseConnection(URL2);
            }
        }
    }

    public boolean processUrl(String URL2) {
        return this.processUrl(URL2, 1);
    }

    public boolean processUrl(String URL2, int failurePolicy) {
        return this.processUrl(URL2, failurePolicy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processUrl(String URL2, int failurePolicy, boolean addKeys) {
        boolean returnValue = true;
        if (URL2 == null) {
            return false;
        }
        if (URL2.equals("")) {
            return false;
        }
        if (URL2.startsWith("res://")) {
            InputStream is = this.getInputStreamToLocalResource("/userdialogs", URL2);
            Protocol p = Protocol.parseXml(is, URL2);
            p.performPostParsingProcessing();
            return returnValue;
        }
        if (this.keys.size() > 0 && addKeys) {
            Enumeration e = this.keys.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.keys.get(key);
                URL2 = Utils.urlAppendParameter(URL2, key, value).toString();
            }
        }
        HttpConnection conn = null;
        InputStream is = null;
        Protocol p = null;
        try {
            conn = this.openHttpConnection(URL2);
            is = conn.openInputStream();
            if (conn.getResponseCode() == 200) {
                Log.log(0x200001000L, "Attempting to download " + conn.getLength() + "b from " + URL2);
                p = Protocol.parseXml(is, URL2);
                return returnValue;
            }
            Log.log(0x40000000L, "Received HTTP connection code " + conn.getResponseCode() + " for: " + URL2);
            returnValue = false;
            throw new IOException("Not received HTTP OKEY");
        }
        catch (Exception e) {
            Log.exception(this, e);
            returnValue = false;
            if (failurePolicy == 1) {
                Log.log(0x200001000L, "Showning continue error SVG for call to " + URL2);
                Protocol.parseXml(this.getClass().getResourceAsStream("/userdialogs/error_internet_connect_continue.xml"), "/userdialogs/error_internet_connect_exit.xml").performPostParsingProcessing();
                return returnValue;
            }
            if (failurePolicy == 2) {
                Log.log(0x200001000L, "Showning exit error SVG for call to " + URL2);
                Protocol.parseXml(this.getClass().getResourceAsStream("/userdialogs/error_internet_connect_exit.xml"), "/userdialogs/error_internet_connect_exit.xml").performPostParsingProcessing();
                return returnValue;
            }
            Log.log(0x100001000L, "Showning no error SVG for call to " + URL2);
            return returnValue;
        }
        catch (Error r) {
            Log.log(0x40000000L, "Caught Error " + r.toString());
            returnValue = false;
            return returnValue;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.close();
                    Log.log(0x200001000L, "Closed connection for " + URL2);
                }
            }
            catch (Exception e) {
                Log.exception(this, e);
                returnValue = false;
            }
            finally {
                Comm.releaseConnection(URL2);
                if (p != null) {
                    p.performPostParsingProcessing();
                } else {
                    returnValue = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processNiNUrl(String URLwithoutUID) {
        boolean success;
        block19: {
            String URL2 = URLwithoutUID;
            String UID = ServiceRegistry.instance().getDataProvider().getConfig().getUid();
            if (UID != null && !"".equals(UID)) {
                URL2 = Utils.urlAppendParameter(URL2, "UID", UID).toString();
            }
            success = false;
            HttpConnection dconn = null;
            InputStream is = null;
            try {
                Log.log(0x200001000L, "Open http connection (no limit checking) against: " + URL2);
                dconn = (HttpConnection)Connector.open((String)URL2);
                dconn.setRequestMethod("GET");
                is = dconn.openInputStream();
                if (dconn.getResponseCode() == 200) {
                    Log.log(0x200001000L, "Attempting to download " + dconn.getLength() + "b from: " + URL2);
                    new NinProtocolVersion1_0().parse(is);
                    success = true;
                    break block19;
                }
                Log.log(0x40000000L, "Received HTTP connection code " + dconn.getResponseCode() + " for: " + URL2);
                throw new IOException("Not received HTTP OKEY");
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
            catch (Error r) {
                Log.log(0x40000000L, "Caught Error " + r.toString());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (dconn != null) {
                        dconn.close();
                    }
                }
                catch (Exception e) {
                    Log.exception(this, e);
                }
            }
        }
        return success;
    }

    public void processUrlASync(String URL2, int failurePolicy) {
        Thread t = new Thread(new LoadUrl(this, URL2, failurePolicy));
        t.start();
    }

    public void processUrlASync(String URL2) {
        this.processUrlASync(URL2, 1);
    }

    private HttpConnection openHttpConnection(String url) throws IOException {
        Comm.retainConnection(url);
        String ua = ServiceRegistry.instance().getDataProvider().getConfig().getUserAgent();
        Log.log(0x200001000L, "Open http connection against: " + url + (ua == null ? "" : " using forced UA: " + ua));
        HttpConnection connection = (HttpConnection)Connector.open((String)url);
        connection.setRequestMethod("GET");
        if (ua != null) {
            connection.setRequestProperty("User-Agent", ua);
        }
        return connection;
    }

    private InputStream getInputStreamToLocalResource(String pathPrefix, String url) {
        String localPath = (pathPrefix == null ? "" : pathPrefix) + "/" + url.substring(6);
        InputStream is = this.getClass().getResourceAsStream(localPath);
        Log.log(0x200001000L, "Open input stream to local resource: " + localPath);
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseConnection(String url) {
        Object object = lock;
        synchronized (object) {
            Log.log(8192L, "Released connection: " + ++numberOfConnections + " for " + url);
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retainConnection(String url) {
        Object object = lock;
        synchronized (object) {
            while (Comm.numberOfConnections() <= 0) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    Log.log(0x200000000L, "Interrupted while waiting for HttpConnection lock.");
                }
            }
            Log.log(8192L, "Grabbed connection: " + numberOfConnections + " for " + url);
            --numberOfConnections;
        }
    }

    private static synchronized int numberOfConnections() {
        return numberOfConnections;
    }

    public void addKey(String name, String value) {
        this.keys.put(name, value);
    }

    public void removeKey(String name) {
        this.keys.remove(name);
    }

    public synchronized void startKeepalive() {
        if (!this.run) {
            this.run = true;
            Thread t = new Thread(this);
            t.setPriority(10);
            t.start();
        }
    }

    public void stopKeepalive() {
        this.run = false;
    }

    private String buildAddress() throws Exception {
        StringBuffer destaddr = new StringBuffer("datagram://");
        String init = ServiceRegistry.instance().getDataProvider().getConfig().getInitUrl();
        if (init == null) {
            throw new Exception("No ping without start URL");
        }
        int start = init.indexOf("://") + 3;
        int end = init.indexOf(":", start);
        if (end < 0) {
            end = init.indexOf("?", start);
        }
        if (end < 0) {
            destaddr.append(init.substring(start));
        } else {
            destaddr.append(init.substring(start, end));
        }
        destaddr.append(":9001");
        return destaddr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DatagramConnection conn = null;
        try {
            String url = this.buildAddress();
            conn = (DatagramConnection)Connector.open((String)url);
            byte[] msg = new byte[]{11};
            while (this.run) {
                Datagram datagram = conn.newDatagram(msg, 1);
                conn.send(datagram);
                if (!this.run) continue;
                Thread.sleep(200L);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        numberOfConnections = MAXIMUM_NUMBER_OF_CONNECTIONS = 1;
        lock = new Object();
    }

    static class LoadUrl
    implements Runnable {
        Comm comm;
        String url;
        int policy;

        public LoadUrl(Comm comm, String url, int policy) {
            this.comm = comm;
            this.url = url;
            this.policy = policy;
        }

        public void run() {
            try {
                this.comm.processUrl(this.url, this.policy);
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }
}

