/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.interactivity.EventImageView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.network.protocols.UserDialogProtocol;
import se.tactel.tvclient.util.Log;

public class EventProtocol
extends Protocol {
    public static final int TAG_UNKNOWN = 0;
    public static final int TAG_EVENT = 1;
    public static final int TAG_BLANK = 2;
    public static final int TAG_TICKER = 3;
    public static final int TAG_TEXT = 4;
    public static final int TAG_IMAGE = 5;
    public static final int TAG_FORM = 6;
    private Vector eventViews = new Vector();
    private TextView text;
    private String screenSize;

    public void setScreenSize(String size) {
        this.screenSize = size;
    }

    public void parse(XmlPullParser parser) {
        try {
            int tag = 0;
            boolean finished = false;
            int eventType = parser.getEventType();
            this.text = null;
            do {
                block27: {
                    block1 : switch (eventType) {
                        case 2: {
                            String tagName = parser.getName();
                            if ("event".equals(tagName)) {
                                tag = 1;
                                break;
                            }
                            if ("text".equals(tagName)) {
                                String fontsize = parser.getAttributeValue(null, "font-size");
                                String fill = parser.getAttributeValue(null, "fill");
                                String fillOpac = parser.getAttributeValue(null, "fill-opacity");
                                String fWeight = parser.getAttributeValue(null, "font-weight");
                                String fStyle = parser.getAttributeValue(null, "font-style");
                                String tDecoration = parser.getAttributeValue(null, "text-decoration");
                                int fs = 8;
                                int textDecoration = tDecoration != null && tDecoration.toUpperCase().equals("UNDERLINE") ? 4 : 0;
                                int fontStyle = fStyle != null && fStyle.toUpperCase().equals("ITALIC") ? 2 : 0;
                                int fontWeight = fWeight != null && fWeight.toUpperCase().equals("BOLD") ? 1 : 0;
                                double fillOpacity = 1.0;
                                if (fillOpac != null) {
                                    fillOpacity = Double.parseDouble(fillOpac);
                                }
                                if (fontsize != null) {
                                    fs = fontsize.equals("small") ? 8 : (fontsize.equals("medium") ? 0 : (fontsize.equals("large") ? 16 : ((fs = Integer.parseInt(fontsize)) < 15 ? 8 : (fs > 19 ? 16 : 0))));
                                }
                                this.text = new TextView();
                                Font textFont = Font.getFont((int)0, (int)(fontStyle | fontWeight | textDecoration), (int)fs);
                                if (fill != null) {
                                    this.text.setTextColors(GraphicUtils.getColorValue(fill, fillOpacity));
                                } else {
                                    this.text.setTextColors(GraphicUtils.getColorValue("#000000", fillOpacity));
                                }
                                this.text.setAlignment(0);
                                this.text.setFont(textFont);
                                tag = 4;
                                break;
                            }
                            if ("image".equals(tagName)) {
                                String event = parser.getAttributeValue(null, "event");
                                String xLink = parser.getAttributeValue(null, "xlink:href");
                                Rect interactivityRect = new Rect(Skin.SCREEN_RECT);
                                if ("split".equals(this.screenSize)) {
                                    interactivityRect = new Rect(Skin.INTERACTIVITY_SPLIT_SCREEN);
                                }
                                if (xLink != null && !xLink.equals("")) {
                                    EventImageView adImg = new EventImageView(interactivityRect, xLink);
                                    if (event != null) {
                                        adImg.setActiveImageEvent(event);
                                    }
                                    this.eventViews.addElement(adImg);
                                }
                                tag = 5;
                                break;
                            }
                            if ("userDialog".equals(tagName)) {
                                UserDialogProtocol p = new UserDialogProtocol();
                                ((Protocol)p).parse(parser);
                                p.getUserDialog().setMtvRootUserDialog(false);
                                if (p.getUserDialog() != null) {
                                    this.eventViews.addElement(p.getUserDialog());
                                }
                                tag = 6;
                                break;
                            }
                            tag = 0;
                            break;
                        }
                        case 3: {
                            String name = parser.getName();
                            if (name.equals("event")) {
                                finished = true;
                            }
                            tag = 0;
                            break;
                        }
                        case 4: {
                            switch (tag) {
                                case 4: {
                                    if (this.text == null) break block27;
                                    this.text.setText(parser.getText());
                                    if (this.text != null) {
                                        this.eventViews.addElement(this.text);
                                        break block1;
                                    }
                                    break block27;
                                }
                                case 0: {
                                    break block1;
                                }
                            }
                        }
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    public Vector getEventViews() {
        return this.eventViews;
    }
}

