/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.gui.EllipseView;
import se.tactel.tvclient.gui.InputBoxView;
import se.tactel.tvclient.gui.LineView;
import se.tactel.tvclient.gui.RectView;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.ContainerView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.userdialog.AnchorContainerView;
import se.tactel.tvclient.gui.userdialog.ButtonGroupTag;
import se.tactel.tvclient.gui.userdialog.Command;
import se.tactel.tvclient.gui.userdialog.GroupContainerView;
import se.tactel.tvclient.gui.userdialog.PolylineView;
import se.tactel.tvclient.gui.userdialog.UserDialogContainerView;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.network.protocols.UserDialogParser;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.util.Log;

public class UserDialogProtocol
extends Protocol {
    public static final int TAG_UNKNOWN = 0;
    public static final int TAG_SHOW_EVENT = 2;
    public static final int TAG_CLOSE_DIALOG = 3;
    public static final int TAG_CLOSE_APP = 4;
    public static final int TAG_REDIRECT = 5;
    public static final int TAG_BROWSE = 6;
    public static final int TAG_SWITCH_CHANNEL = 7;
    public static final int TAG_GOTO_SCREEN = 8;
    public static final int TAG_EVENT = 9;
    public static final int TAG_SMS = 10;
    public static final int TAG_RESTART_RTSP = 11;
    public static final int TAG_STOP_PLAYER = 12;
    public static final int TAG_FAST_SWITCH_CHANNEL = 13;
    public static final int TAG_SWITCH_OR_PURCHASE_CHANNEL = 14;
    public static final int TAG_KEY = 15;
    public static final int TAG_NOTIFY = 16;
    public static final int TAG_UPDATE = 17;
    public static final int TAG_LEFTSOFTKEY = 18;
    public static final int TAG_RIGHTSOFTKEY = 19;
    public static final int TAG_HEADER_TEXT = 20;
    public static final int TAG_SVG = 100;
    public static final int TAG_RECT = 101;
    public static final int TAG_TEXT = 102;
    public static final int TAG_A = 103;
    public static final int TAG_LINE = 104;
    public static final int TAG_ELLIPSE = 105;
    public static final int TAG_POLYLINE = 106;
    public static final int TAG_IMAGE = 107;
    public static final int TAG_TEXTAREA = 108;
    public static final int TAG_MTV_LINKPARAMETER = 109;
    public static final int TAG_MTV_BROWSE = 110;
    public static final int TAG_GROUP = 111;
    public static final int TAG_ERROR_CHANNELSWITCH = 112;
    public static final int TAG_USER_DIALOG = 113;
    private ContainerView currentContainer = null;
    private UserDialogView userDialogView = null;
    private Vector rootCommandsVector = new Vector();
    private String url;

    public UserDialogProtocol() {
    }

    public UserDialogProtocol(String url) {
        this.url = url;
    }

    public void parse(XmlPullParser parser) {
        try {
            int yMaxForAllElements = 0;
            boolean finished = false;
            Rect svgFrame = null;
            int eventType = parser.getEventType();
            int tag = 0;
            TextView textElement = null;
            InputBoxView inputTextBox = null;
            boolean firstTime = true;
            ButtonGroupTag gTag = null;
            UserDialogContainerView currentAnchorContainer = null;
            UserDialogContainerView currentGroupContainer = null;
            int isParsingButtonLevel = 0;
            do {
                block168: {
                    block6 : switch (eventType) {
                        case 2: {
                            String fill;
                            String fill2;
                            String strokeOpac;
                            String stroke;
                            Hashtable<String, String> hashAttributes;
                            Hashtable<String, String> hashAttributes2;
                            String name = parser.getName();
                            Log.log(0x200000L, "Parsing userDialog tag: " + name);
                            if (firstTime) {
                                firstTime = false;
                                if (!"userDialog".equals(name)) {
                                    return;
                                }
                            }
                            if ("userDialog".equals(name)) {
                                this.userDialogView = new UserDialogView();
                                this.userDialogView.setUrl(this.url);
                                tag = 113;
                                break;
                            }
                            if ("svg".equals(name)) {
                                if (this.userDialogView == null) {
                                    this.userDialogView = new UserDialogView();
                                }
                                svgFrame = new Rect(Skin.SCREEN_RECT);
                                Rect svgViewBox = null;
                                String strViewBox = parser.getAttributeValue(null, "viewBox");
                                if (strViewBox != null) {
                                    svgViewBox = UserDialogParser.parseSvgViewBox(strViewBox);
                                }
                                if (svgViewBox == null) {
                                    svgViewBox = new Rect(Skin.SCREEN_RECT);
                                }
                                this.userDialogView.setSvgViewBox(svgViewBox);
                                if (strViewBox == null) {
                                    this.userDialogView.setAvoidScaling(true);
                                } else {
                                    this.userDialogView.setAvoidScaling(false);
                                }
                                this.currentContainer = this.userDialogView;
                                this.currentContainer.setFrame(svgFrame);
                                tag = 100;
                                break;
                            }
                            if ("mtv:closeDialog".equals(name)) {
                                this.addCommand(name, null);
                                tag = 3;
                                break;
                            }
                            if ("mtv:closeApp".equals(name)) {
                                this.addCommand(name, null);
                                tag = 4;
                                break;
                            }
                            if ("mtv:browse".equals(name) || "mtv:download".equals(name) || "mtv:go".equals(name) || "mtv:redirect".equals(name)) {
                                String link = parser.getAttributeValue(null, "xlink:href");
                                String appendUrl = parser.getAttributeValue(null, "appendUrl");
                                if (link != null) {
                                    hashAttributes2 = new Hashtable<String, String>();
                                    hashAttributes2.put("xlink:href", link);
                                    if (appendUrl != null) {
                                        hashAttributes2.put("appendUrl", appendUrl);
                                    }
                                    this.addCommand(name, hashAttributes2);
                                }
                                tag = 6;
                                break;
                            }
                            if ("mtv:key".equals(name)) {
                                String keyname = parser.getAttributeValue(null, "name");
                                String value = parser.getAttributeValue(null, "value");
                                String store = parser.getAttributeValue(null, "store");
                                Hashtable<String, String> hashAttributes3 = new Hashtable<String, String>();
                                if (keyname != null) {
                                    hashAttributes3.put("name", keyname);
                                }
                                hashAttributes3.put("value", value);
                                if (store != null) {
                                    hashAttributes3.put("store", store);
                                }
                                if (keyname != null) {
                                    this.addCommand(name, hashAttributes3);
                                }
                                tag = 15;
                                break;
                            }
                            if ("mtv:notify".equals(name)) {
                                String url = parser.getAttributeValue(null, "xlink:href");
                                if (url != null) {
                                    hashAttributes = new Hashtable<String, String>();
                                    hashAttributes.put("xlink:href", url);
                                    this.addCommand(name, hashAttributes);
                                }
                                tag = 16;
                                break;
                            }
                            if ("mtv:update".equals(name)) {
                                String db = parser.getAttributeValue(null, "db");
                                if (db != null) {
                                    hashAttributes = new Hashtable();
                                    hashAttributes.put("db", db);
                                    this.addCommand(name, hashAttributes);
                                }
                                tag = 17;
                                break;
                            }
                            if ("leftSoftKey".equals(name)) {
                                String softkeyname = parser.getAttributeValue(null, "label");
                                this.userDialogView.setLeftKeyText(softkeyname);
                                currentAnchorContainer = new AnchorContainerView();
                                currentAnchorContainer.setFrame(new Rect(svgFrame));
                                currentAnchorContainer.setParentContainer(this.currentContainer);
                                currentAnchorContainer.setParent(this.currentContainer);
                                this.currentContainer = currentAnchorContainer;
                                final UserDialogContainerView leftKeyAnchor = currentAnchorContainer;
                                Action leftKeyAction = new Action(){

                                    public void clicked(View sender) {
                                        Log.log(128L, "User pushed left softkey.");
                                        View v = leftKeyAnchor;
                                        if (v != null && v instanceof AnchorContainerView) {
                                            AnchorContainerView av = (AnchorContainerView)v;
                                            NotificationCenter.defaultCenter().postNotification(new Notification("clicked", av, null));
                                        }
                                    }
                                };
                                this.userDialogView.setLeftKeyAction(leftKeyAction);
                                tag = 18;
                                break;
                            }
                            if ("rightSoftKey".equals(name)) {
                                String softkeyname = parser.getAttributeValue(null, "label");
                                this.userDialogView.setRightKeyText(softkeyname);
                                currentAnchorContainer = new AnchorContainerView();
                                currentAnchorContainer.setFrame(new Rect(svgFrame));
                                currentAnchorContainer.setParentContainer(this.currentContainer);
                                currentAnchorContainer.setParent(this.currentContainer);
                                this.currentContainer = currentAnchorContainer;
                                final UserDialogContainerView rightKeyAnchor = currentAnchorContainer;
                                Action rightKeyAction = new Action(){

                                    public void clicked(View sender) {
                                        Log.log(128L, "User pushed right softkey button (select).");
                                        View v = rightKeyAnchor;
                                        if (v != null && v instanceof AnchorContainerView) {
                                            AnchorContainerView av = (AnchorContainerView)v;
                                            NotificationCenter.defaultCenter().postNotification(new Notification("clicked", av, null));
                                        }
                                    }
                                };
                                this.userDialogView.setRightKeyAction(rightKeyAction);
                                tag = 19;
                                break;
                            }
                            if ("mtv:sms".equals(name)) {
                                String msisdn = parser.getAttributeValue(null, "msisdn");
                                String prefix = parser.getAttributeValue(null, "prefix");
                                String url = parser.getAttributeValue(null, "xlink:href");
                                if (msisdn != null) {
                                    Hashtable<String, String> hashAttributes4 = new Hashtable<String, String>();
                                    if (url != null) {
                                        hashAttributes4.put("xlink:href", url);
                                    }
                                    if (prefix != null) {
                                        hashAttributes4.put("prefix", prefix);
                                    }
                                    hashAttributes4.put("msisdn", msisdn);
                                    this.addCommand(name, hashAttributes4);
                                }
                                tag = 10;
                                break;
                            }
                            if ("mtv:switchChannel".equals(name)) {
                                String channelId = parser.getAttributeValue(null, "channelId");
                                if (channelId != null) {
                                    hashAttributes = new Hashtable();
                                    hashAttributes.put("channelId", channelId);
                                    this.addCommand(name, hashAttributes);
                                }
                                tag = 7;
                                break;
                            }
                            if ("mtv:fastSwitchChannel".equals(name)) {
                                String channelId = parser.getAttributeValue(null, "channelId");
                                if (channelId != null) {
                                    hashAttributes = new Hashtable();
                                    hashAttributes.put("channelId", channelId);
                                    this.addCommand(name, hashAttributes);
                                }
                                tag = 13;
                                break;
                            }
                            if ("mtv:switchOrPurchaseChannel".equals(name)) {
                                String channelId = parser.getAttributeValue(null, "channelId");
                                if (channelId != null) {
                                    hashAttributes = new Hashtable();
                                    hashAttributes.put("channelId", channelId);
                                    this.addCommand(name, hashAttributes);
                                }
                                tag = 14;
                                break;
                            }
                            if ("mtv:startPlayer".equals(name)) {
                                String channelId = parser.getAttributeValue(null, "channelId");
                                String token = parser.getAttributeValue(null, "token");
                                String displaytext = parser.getAttributeValue(null, "displayText");
                                if (channelId != null) {
                                    Hashtable<String, String> hashAttributes5 = new Hashtable<String, String>();
                                    hashAttributes5.put("channelId", channelId);
                                    if (token != null) {
                                        hashAttributes5.put("token", token);
                                    }
                                    if (displaytext != null) {
                                        hashAttributes5.put("displayText", displaytext);
                                    }
                                    this.addCommand(name, hashAttributes5);
                                    ServiceRegistry.instance().getController().setPlayerStartCommandFlag(true);
                                }
                                tag = 11;
                                break;
                            }
                            if ("mtv:stopPlayer".equals(name)) {
                                this.addCommand(name, null);
                                tag = 12;
                                break;
                            }
                            if ("mtv:gotoScreen".equals(name)) {
                                String screen = parser.getAttributeValue(null, "screen");
                                String focus = parser.getAttributeValue(null, "focus");
                                if (screen != null) {
                                    hashAttributes2 = new Hashtable();
                                    hashAttributes2.put("screen", screen);
                                    if (focus != null) {
                                        hashAttributes2.put("focus", focus);
                                    }
                                    this.addCommand(name, hashAttributes2);
                                }
                                tag = 8;
                                break;
                            }
                            if ("mtv:headerText".equals(name)) {
                                Folder f;
                                String text = parser.getAttributeValue(null, "text");
                                String channelId = parser.getAttributeValue(null, "channelId");
                                String bundleId = parser.getAttributeValue(null, "bundleId");
                                if (text != null) {
                                    this.userDialogView.setHeaderText(text);
                                } else if (channelId != null) {
                                    Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(channelId);
                                    if (c != null) {
                                        this.userDialogView.setHeaderText(c.getName());
                                    }
                                } else if (bundleId != null && (f = ServiceRegistry.instance().getDataProvider().getFolderList().getFolder(bundleId)) != null) {
                                    this.userDialogView.setHeaderText(f.getName());
                                }
                                tag = 20;
                                break;
                            }
                            if ("mtv:event".equals(name)) {
                                String link = parser.getAttributeValue(null, "xlink:href");
                                if (link != null) {
                                    hashAttributes = new Hashtable();
                                    hashAttributes.put("xlink:href", link);
                                    this.addCommand(name, hashAttributes);
                                }
                                tag = 9;
                                break;
                            }
                            if ("g".equals(name)) {
                                String gId = parser.getAttributeValue(null, "id");
                                String gDisplay = parser.getAttributeValue(null, "display");
                                String gFocusable = parser.getAttributeValue(null, "focusable");
                                if (isParsingButtonLevel == 0) {
                                    try {
                                        currentGroupContainer = new GroupContainerView();
                                        currentGroupContainer.setFrame(new Rect(svgFrame));
                                        if (gFocusable != null && gFocusable.equals("true")) {
                                            this.userDialogView.addKeyView(currentGroupContainer);
                                        }
                                        ((GroupContainerView)currentGroupContainer).setId(gId);
                                        currentGroupContainer.setParentContainer(this.currentContainer);
                                        currentGroupContainer.setParent(this.currentContainer);
                                        this.currentContainer = currentGroupContainer;
                                    }
                                    catch (Exception e) {
                                        Log.exception(this, e);
                                    }
                                    ++isParsingButtonLevel;
                                } else if (isParsingButtonLevel == 1) {
                                    gTag = new ButtonGroupTag();
                                    if (gId != null) {
                                        gTag.setId(gId);
                                    }
                                    if (gDisplay != null) {
                                        gTag.setDisplay(gDisplay);
                                    }
                                    Vector parameters = UserDialogParser.getButtonIdParameters(gId);
                                    for (int a = 0; a < parameters.size(); ++a) {
                                        String parameter = (String)parameters.elementAt(a);
                                        if (!parameter.equals("up") && !parameter.equals("down")) continue;
                                        gTag.setState(parameter);
                                        break;
                                    }
                                    ++isParsingButtonLevel;
                                }
                                tag = 111;
                                break;
                            }
                            if ("mtv:linkParameter".equals(name)) {
                                if (this.currentContainer instanceof AnchorContainerView) {
                                    String mtvName = parser.getAttributeValue(null, "name");
                                    String mtvXlink = parser.getAttributeValue(null, "xlink:href");
                                    ((AnchorContainerView)this.currentContainer).setMtvAttribute(mtvName);
                                    ((AnchorContainerView)this.currentContainer).setMtvXlink(mtvXlink);
                                }
                                tag = 109;
                                break;
                            }
                            if ("image".equals(name)) {
                                Rect frame = UserDialogParser.parseFrame(parser, this.userDialogView.getSvgViewBox());
                                String xLink = parser.getAttributeValue(null, "xlink:href");
                                String imgDisplay = parser.getAttributeValue(null, "display");
                                if (xLink != null) {
                                    ImageView image = ImageView.createImageNoCache(new Rect(frame), xLink, null);
                                    image.setOpaque(false);
                                    if (imgDisplay != null && imgDisplay.equals("none")) {
                                        image.setActive(false);
                                    }
                                    if (gTag != null) {
                                        gTag.setTagContent(image);
                                    }
                                    this.currentContainer.addSubview(image);
                                    if (image.frame().y + image.frame().height > yMaxForAllElements) {
                                        yMaxForAllElements = image.frame().y + image.frame().height;
                                    }
                                }
                                tag = 107;
                                break;
                            }
                            if (name.equals("line")) {
                                Vector v;
                                LineView line = new LineView();
                                stroke = parser.getAttributeValue(null, "stroke");
                                String strokeOpac2 = parser.getAttributeValue(null, "stroke-opacity");
                                double strokeOpacity = 1.0;
                                if (strokeOpac2 != null) {
                                    strokeOpacity = Double.parseDouble(strokeOpac2);
                                }
                                if (stroke != null) {
                                    line.setStrokeColor(GraphicUtils.getColorValue(stroke, strokeOpacity));
                                }
                                if ((v = UserDialogParser.parseLine(parser, this.userDialogView.getSvgViewBox())) != null && v.size() > 1) {
                                    Rect frame = line.getLineFrame((Point)v.elementAt(0), (Point)v.elementAt(1));
                                    line.setFrame(frame);
                                    this.currentContainer.addSubview(line);
                                    if (line.frame().y + line.frame().height > yMaxForAllElements) {
                                        yMaxForAllElements = line.frame().y + line.frame().height;
                                    }
                                }
                                tag = 104;
                                break;
                            }
                            if (name.equals("polyline")) {
                                String elementPoints = parser.getAttributeValue(null, "points");
                                stroke = parser.getAttributeValue(null, "stroke");
                                Vector v = UserDialogParser.splitString(elementPoints);
                                Vector pointVector = UserDialogParser.splitStringToPoints(v, this.userDialogView.frame());
                                if (pointVector != null && pointVector.size() > 1) {
                                    PolylineView pv = new PolylineView();
                                    strokeOpac = parser.getAttributeValue(null, "stroke-opacity");
                                    double strokeOpacity = 1.0;
                                    if (strokeOpac != null) {
                                        strokeOpacity = Double.parseDouble(strokeOpac);
                                    }
                                    if (stroke != null) {
                                        pv.setStrokeColor(GraphicUtils.getColorValue(stroke, strokeOpacity));
                                    }
                                    pv.setPolylineFrame(pointVector, this.userDialogView.getSvgViewBox());
                                    this.currentContainer.addSubview(pv);
                                    if (pv.frame().y + pv.frame().height > yMaxForAllElements) {
                                        yMaxForAllElements = pv.frame().y + pv.frame().height;
                                    }
                                }
                                tag = 106;
                                break;
                            }
                            if (name.equals("rect")) {
                                Rect frame = UserDialogParser.parseFrame(parser, this.userDialogView.getSvgViewBox());
                                fill2 = parser.getAttributeValue(null, "fill");
                                String stroke2 = parser.getAttributeValue(null, "stroke");
                                String strRx = parser.getAttributeValue(null, "rx");
                                String strRy = parser.getAttributeValue(null, "ry");
                                strokeOpac = parser.getAttributeValue(null, "stroke-opacity");
                                String fillOpac = parser.getAttributeValue(null, "fill-opacity");
                                RectView rect = new RectView();
                                rect.setFrame(frame);
                                try {
                                    int rx = 0;
                                    int ry = 0;
                                    if (strRx != null && strRy != null) {
                                        if (strRx.length() > 0) {
                                            rx = !Character.isDigit(strRx.charAt(strRx.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strRx, this.userDialogView.getSvgViewBox().width) : Integer.parseInt(strRx);
                                        }
                                        if (strRy.length() > 0) {
                                            ry = !Character.isDigit(strRy.charAt(strRy.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strRy, this.userDialogView.getSvgViewBox().height) : Integer.parseInt(strRy);
                                        }
                                        rect.setRounding(new Point(2 * rx, 2 * ry));
                                    }
                                }
                                catch (Exception e) {
                                    Log.exception(this, e);
                                }
                                double strokeOpacity = 1.0;
                                double fillOpacity = 1.0;
                                if (strokeOpac != null) {
                                    strokeOpacity = Double.parseDouble(strokeOpac);
                                }
                                if (fillOpac != null) {
                                    fillOpacity = Double.parseDouble(fillOpac);
                                }
                                if (stroke2 != null) {
                                    rect.setStrokeColor(GraphicUtils.getColorValue(stroke2, strokeOpacity));
                                } else {
                                    rect.setStrokeColor(GraphicUtils.getColorValue("#000000", strokeOpacity));
                                }
                                if (fill2 != null) {
                                    rect.setFillColor(GraphicUtils.getColorValue(fill2, fillOpacity));
                                } else {
                                    rect.setFillColor(GraphicUtils.getColorValue("#000000", fillOpacity));
                                }
                                if (gTag != null) {
                                    gTag.setTagContent(rect);
                                }
                                this.currentContainer.addSubview(rect);
                                if (rect.frame().y + rect.frame().height > yMaxForAllElements) {
                                    yMaxForAllElements = rect.frame().y + rect.frame().height;
                                }
                                tag = 101;
                                break;
                            }
                            if (name.equals("ellipse") || name.equals("circle")) {
                                String strokeOpac3 = parser.getAttributeValue(null, "stroke-opacity");
                                String fillOpac = parser.getAttributeValue(null, "fill-opacity");
                                fill = parser.getAttributeValue(null, "fill");
                                String stroke3 = parser.getAttributeValue(null, "stroke");
                                double strokeOpacity = 1.0;
                                double fillOpacity = 1.0;
                                if (strokeOpac3 != null) {
                                    strokeOpacity = Double.parseDouble(strokeOpac3);
                                }
                                if (fillOpac != null) {
                                    fillOpacity = Double.parseDouble(fillOpac);
                                }
                                EllipseView ellipse = new EllipseView();
                                if (stroke3 != null) {
                                    ellipse.setStrokeColor(GraphicUtils.getColorValue(stroke3, strokeOpacity));
                                }
                                if (fill != null) {
                                    ellipse.setFillColor(GraphicUtils.getColorValue(fill, fillOpacity));
                                }
                                Rect frame = UserDialogParser.parseEllipse(parser, this.userDialogView.getSvgViewBox(), name);
                                ellipse.setFrame(frame);
                                this.currentContainer.addSubview(ellipse);
                                if (ellipse.frame().y + ellipse.frame().height > yMaxForAllElements) {
                                    yMaxForAllElements = ellipse.frame().y + ellipse.frame().height;
                                }
                                tag = 105;
                                break;
                            }
                            if (name.equals("text")) {
                                String fontsize = parser.getAttributeValue(null, "font-size");
                                fill2 = parser.getAttributeValue(null, "fill");
                                String fillOpac = parser.getAttributeValue(null, "fill-opacity");
                                String fWeight = parser.getAttributeValue(null, "font-weight");
                                String fStyle = parser.getAttributeValue(null, "font-style");
                                String tDecoration = parser.getAttributeValue(null, "text-decoration");
                                String textAnchor = parser.getAttributeValue(null, "text-anchor");
                                int fs = 8;
                                int textDecoration = tDecoration != null && tDecoration.toUpperCase().equals("UNDERLINE") ? 4 : 0;
                                int fontStyle = fStyle != null && fStyle.toUpperCase().equals("ITALIC") ? 2 : 0;
                                int fontWeight = fWeight != null && fWeight.toUpperCase().equals("BOLD") ? 1 : 0;
                                double fillOpacity = 1.0;
                                if (fillOpac != null) {
                                    fillOpacity = Double.parseDouble(fillOpac);
                                }
                                if (fontsize != null) {
                                    fs = fontsize.equals("small") ? 8 : (fontsize.equals("medium") ? 0 : (fontsize.equals("large") ? 16 : ((fs = Integer.parseInt(fontsize)) < 15 ? 8 : (fs > 19 ? 16 : 0))));
                                }
                                textElement = new TextView();
                                textElement.setInset(0);
                                textElement.setYCenter(false);
                                Rect frame = UserDialogParser.parseFrame(parser, this.userDialogView.getSvgViewBox());
                                Font textFont = Font.getFont((int)0, (int)(fontStyle | fontWeight | textDecoration), (int)fs);
                                frame.y -= textFont.getBaselinePosition() - 1 - 0;
                                textElement.setFrame(frame);
                                if (fill2 != null) {
                                    textElement.setTextColors(GraphicUtils.getColorValue(fill2, fillOpacity));
                                } else {
                                    textElement.setTextColors(GraphicUtils.getColorValue("#000000", fillOpacity));
                                }
                                if (textAnchor != null) {
                                    if (textAnchor.equals("middle")) {
                                        textElement.setAnchor("middle");
                                    } else if (textAnchor.equals("end")) {
                                        textElement.setAnchor("end");
                                    }
                                }
                                textElement.setAlignment(0);
                                textElement.setFont(textFont);
                                tag = 102;
                                break;
                            }
                            if ("textArea".equals(name)) {
                                boolean hideCharacters;
                                String editable = parser.getAttributeValue(null, "editable");
                                stroke = parser.getAttributeValue(null, "stroke");
                                fill = parser.getAttributeValue(null, "fill");
                                String id = parser.getAttributeValue(null, "id");
                                Rect frame = UserDialogParser.parseFrame(parser, this.userDialogView.getSvgViewBox());
                                String w = parser.getAttributeValue(null, "width");
                                String h = parser.getAttributeValue(null, "height");
                                if (w == null || w.equals("auto")) {
                                    frame.width = this.userDialogView.getSvgViewBox().width - frame.x;
                                }
                                if (h == null || h.equals("auto")) {
                                    frame.height = this.userDialogView.getSvgViewBox().height - frame.y;
                                }
                                boolean constrainToDigits = hideCharacters = "password".equals(id);
                                InputBoxView box = new InputBoxView(Fonts.NORMAL, Fonts.NORMAL, 0, hideCharacters, constrainToDigits, true);
                                box.setFrame(frame);
                                if (id != null) {
                                    this.userDialogView.getTextAreaMap().put(id, box);
                                }
                                if (stroke != null) {
                                    box.setTextColor(GraphicUtils.getColorValue(stroke, 1.0));
                                } else {
                                    box.setTextColor(-16777216);
                                }
                                if (fill != null) {
                                    box.setBackgroundColor(GraphicUtils.getColorValue(fill, 1.0));
                                    box.setDrawsBackground(true);
                                } else {
                                    box.setDrawsBackground(false);
                                }
                                if (editable != null && editable.equals("simple")) {
                                    boolean isContainedInFocusableGroup;
                                    boolean bl = isContainedInFocusableGroup = currentGroupContainer != null && this.userDialogView.getKeyViews().indexOf(currentGroupContainer) != -1;
                                    if (!isContainedInFocusableGroup) {
                                        this.userDialogView.addKeyView(box);
                                    }
                                    box.setEnabled(true);
                                } else {
                                    box.setEnabled(false);
                                }
                                box.deactivateBox();
                                this.currentContainer.addSubview(box);
                                if (box.frame().y + box.frame().height > yMaxForAllElements) {
                                    yMaxForAllElements = box.frame().y + box.frame().height;
                                }
                                inputTextBox = box;
                                tag = 108;
                                break;
                            }
                            if ("a".equals(name)) {
                                try {
                                    currentAnchorContainer = new AnchorContainerView();
                                    currentAnchorContainer.setFrame(new Rect(svgFrame));
                                    String anchorId = parser.getAttributeValue(null, "id");
                                    if (anchorId != null && anchorId.length() > 0) {
                                        currentAnchorContainer.setId(anchorId);
                                    }
                                    ((AnchorContainerView)currentAnchorContainer).setXLink(parser.getAttributeValue(null, "xlink:href"));
                                    currentAnchorContainer.setParentContainer(this.currentContainer);
                                    currentAnchorContainer.setParent(this.currentContainer);
                                    this.currentContainer = currentAnchorContainer;
                                    this.userDialogView.addKeyView(currentAnchorContainer);
                                }
                                catch (Exception e) {
                                    Log.exception(this, e);
                                }
                                tag = 103;
                                break;
                            }
                            tag = 0;
                            break;
                        }
                        case 3: {
                            String name = parser.getName();
                            if ("a".equals(name)) {
                                try {
                                    Rect af = currentAnchorContainer.getAnchorFrame();
                                    currentAnchorContainer.relateSubviewsAbsolutePoint(new Point(af.x, af.y));
                                    currentAnchorContainer.setFrame(af);
                                    this.currentContainer = currentAnchorContainer.getParentContainer();
                                    this.currentContainer.addSubview(currentAnchorContainer);
                                    currentAnchorContainer = null;
                                }
                                catch (Exception e) {
                                    Log.exception(this, e);
                                }
                            } else if ("g".equals(name)) {
                                if (isParsingButtonLevel > 0) {
                                    if (isParsingButtonLevel == 1) {
                                        try {
                                            Rect af = currentGroupContainer.getAnchorFrame();
                                            currentGroupContainer.relateSubviewsAbsolutePoint(new Point(af.x, af.y));
                                            currentGroupContainer.setFrame(af);
                                            this.currentContainer = currentGroupContainer.getParentContainer();
                                            this.currentContainer.addSubview(currentGroupContainer);
                                            currentGroupContainer = null;
                                        }
                                        catch (Exception e) {
                                            Log.exception(this, e);
                                        }
                                    } else if (isParsingButtonLevel == 2) {
                                        if (gTag != null) {
                                            if (gTag.getState().equals("up")) {
                                                ((GroupContainerView)this.currentContainer).setButtonUp(gTag);
                                            } else if (gTag.getState().equals("down")) {
                                                ((GroupContainerView)this.currentContainer).setButtonDown(gTag);
                                            }
                                        }
                                        gTag = null;
                                    }
                                    --isParsingButtonLevel;
                                }
                            } else if ("leftSoftKey".equals(name)) {
                                if (currentAnchorContainer.getAnchorCommands().size() == 0) {
                                    this.userDialogView.setLeftKeyAction(null);
                                }
                            } else if ("rightSoftKey".equals(name)) {
                                if (currentAnchorContainer.getAnchorCommands().size() == 0) {
                                    this.userDialogView.setRightKeyAction(null);
                                }
                            } else if (name.equals("userDialog")) {
                                finished = true;
                            }
                            tag = 0;
                            break;
                        }
                        case 4: {
                            switch (tag) {
                                case 101: {
                                    break block6;
                                }
                                case 108: {
                                    String text = parser.getText();
                                    if (inputTextBox != null) {
                                        if (text != null && text.startsWith("$")) {
                                            text = this.getTextFromVariable(text);
                                        }
                                        inputTextBox.setText(text);
                                        break block6;
                                    }
                                    break block168;
                                }
                                case 102: {
                                    String text;
                                    if (parser.getText() != null) {
                                        text = parser.getText();
                                        if (text != null && text.startsWith("$")) {
                                            text = this.getTextFromVariable(text);
                                        }
                                        textElement.setText(text);
                                        textElement.sizeToFit();
                                        int fontHeight = 0;
                                        fontHeight = textElement.getFont().getHeight();
                                        if (textElement.frame().y + fontHeight > yMaxForAllElements) {
                                            yMaxForAllElements = textElement.frame().y + fontHeight;
                                        }
                                        this.currentContainer.addSubview(textElement);
                                        if (gTag != null) {
                                            gTag.setTagContent(textElement);
                                        }
                                        textElement = null;
                                        break block6;
                                    }
                                    break block168;
                                }
                                case 0: {
                                    break block6;
                                }
                            }
                        }
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
            this.userDialogView.setYMaxForAllSvgElements(yMaxForAllElements);
            if (yMaxForAllElements > this.userDialogView.getSvgViewBox().height) {
                this.userDialogView.setScrollingUserdialog(true);
            }
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        this.userDialogView.setRootCommands(this.rootCommandsVector);
    }

    private void addCommand(String commandName, Hashtable commandAttributes) {
        if (this.currentContainer instanceof UserDialogContainerView) {
            ((UserDialogContainerView)this.currentContainer).addAnchorCommand(new Command(commandName, commandAttributes));
        } else {
            this.rootCommandsVector.addElement(new Command(commandName, commandAttributes));
        }
    }

    private String getTextFromVariable(String text) {
        if (text.equals("$SWITCH_CHANNEL_ERROR")) {
            text = ServiceRegistry.instance().getLocalization().getString(3027);
        } else if (text.equals("$CONNECT_ERROR")) {
            text = ServiceRegistry.instance().getLocalization().getString(3028);
        } else if (text.equals("$START_PLAYER_ERROR")) {
            text = ServiceRegistry.instance().getLocalization().getString(3029);
        } else if (text.equals("$STRING_OPTIONS_EXIT")) {
            text = ServiceRegistry.instance().getLocalization().getString(3032);
        } else if (text.equals("$SVG_OK")) {
            text = ServiceRegistry.instance().getLocalization().getString(3030);
        } else if (text.equals("$SVG_YES")) {
            text = ServiceRegistry.instance().getLocalization().getString(3033);
        } else if (text.equals("$SVG_NO")) {
            text = ServiceRegistry.instance().getLocalization().getString(3034);
        } else if (text.equals("$SVG_CONTINUE")) {
            text = ServiceRegistry.instance().getLocalization().getString(3038);
        } else if (text.equals("$VERSION")) {
            text = RichMediaMIDlet.version;
        } else if (text.equals("$STRING_SVG_LOADING")) {
            text = ServiceRegistry.instance().getLocalization().getString(202);
        } else if (text.equals("$INFO_RESTART_TV")) {
            text = ServiceRegistry.instance().getLocalization().getString(3031);
        }
        int pos = 0;
        while (pos < text.length() && text.indexOf("${#", pos) != -1) {
            int startpos = text.indexOf("${#", pos) + 3;
            int endpos = text.indexOf("#}", pos);
            if (endpos > startpos) {
                String localizationId = text.substring(startpos, endpos);
                text = this.variableReplace(text, "#" + localizationId + "#", ServiceRegistry.instance().getLocalization().getString(Integer.parseInt(localizationId)));
            }
            pos = endpos;
        }
        return text;
    }

    private String variableReplace(String text, String searchFor, String replaceWith) {
        String searchForVariable = "${" + searchFor + "}";
        StringBuffer sb = new StringBuffer();
        String temp = new String(text);
        int pos = temp.indexOf(searchForVariable);
        while (pos != -1) {
            sb.append(temp.substring(0, pos)).append(replaceWith);
            temp = temp.substring(pos + searchForVariable.length());
            pos = temp.indexOf(searchForVariable);
        }
        sb.append(temp);
        return sb.toString();
    }

    public UserDialogView getUserDialog() {
        return this.userDialogView;
    }

    public String getUrl() {
        return this.url;
    }
}

