/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols.vfe;

import java.util.Enumeration;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.ChannelList;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.FolderList;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;

public class VfeContentInfoProtocol
extends Protocol {
    public static final int TAG_UNKNOWN = 0;
    public static final int TAG_ERROR = 1;
    public static final int TAG_CONTENT_INFO = 2;
    public static final int TAG_BUNDLE = 10;
    public static final int TAG_CHANNEL = 11;
    public static final int TAG_STARTUP_CHANNEL_INFO = 12;
    public static final int TAG_CONTENTS = 13;
    private static int contentCnt = 0;
    boolean isParsingStartupChannelInfo;

    public VfeContentInfoProtocol(boolean isParsingStartupChannelInfo) {
        this.isParsingStartupChannelInfo = isParsingStartupChannelInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XmlPullParser parser) {
        boolean updated = false;
        Vector<String> knownChannels = new Vector<String>();
        Vector<String> knownFolders = new Vector<String>();
        try {
            int tag = 0;
            boolean finished = false;
            boolean allowUpdateOfOrder = true;
            Enumeration ec = ServiceRegistry.instance().getDataProvider().getChannelList().getAll().elements();
            while (ec.hasMoreElements()) {
                knownChannels.addElement(((Channel)ec.nextElement()).getId());
            }
            Enumeration ef = ServiceRegistry.instance().getDataProvider().getFolderList().getAllFolders().elements();
            while (ef.hasMoreElements()) {
                knownFolders.addElement(((Folder)ef.nextElement()).getId());
            }
            boolean hasContent = ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().size() > 0;
            Folder currentFolder = null;
            ChannelList channelList = ServiceRegistry.instance().getDataProvider().getChannelList();
            FolderList folderList = ServiceRegistry.instance().getDataProvider().getFolderList();
            int eventType = parser.getEventType();
            do {
                block3 : switch (eventType) {
                    case 2: {
                        String orderStr;
                        String id;
                        String tagName = parser.getName();
                        if ("content_info".equals(tagName)) {
                            tag = 2;
                            break;
                        }
                        if ("error".equals(tagName)) {
                            String code = parser.getAttributeValue(null, "code");
                            String description = parser.getAttributeValue(null, "description");
                            Log.log(0x42000000L, "Received error tag code=\"" + code + "\" description=\"" + description + "\"");
                            tag = 1;
                            break;
                        }
                        if ("startup_channel_info".equals(tagName)) {
                            if (!this.isParsingStartupChannelInfo) {
                                Log.log(0x42000000L, "<startup_channel_info> not expected in this context");
                            }
                            tag = 12;
                            break;
                        }
                        if ("contents".equals(tagName)) {
                            tag = 13;
                            break;
                        }
                        if ("bundle".equals(tagName)) {
                            String folderExtraInfo;
                            String folderDescription;
                            id = parser.getAttributeValue(null, "bundle_id");
                            knownFolders.removeElement("" + id);
                            if (folderList.contains(id)) {
                                currentFolder = folderList.getFolder(id);
                            } else {
                                currentFolder = new Folder(id);
                                Log.log(0x202000000L, "Created folder: " + currentFolder.toString());
                            }
                            String subscribed = parser.getAttributeValue(null, "subscribed");
                            currentFolder.setSubscribed("true".equals(subscribed));
                            String paymentAllowed = parser.getAttributeValue(null, "payment_allowed");
                            if (paymentAllowed == null) {
                                currentFolder.setPaymentAllowed(true);
                            } else {
                                currentFolder.setPaymentAllowed("true".equals(paymentAllowed));
                            }
                            String visible = parser.getAttributeValue(null, "visible");
                            if (visible == null) {
                                currentFolder.setVisible(true);
                            } else {
                                currentFolder.setVisible("true".equals(visible));
                            }
                            String folderName = parser.getAttributeValue(null, "name");
                            if (folderName != null && !"".equals(folderName)) {
                                currentFolder.setName(folderName);
                            }
                            if ((folderDescription = parser.getAttributeValue(null, "description")) != null) {
                                currentFolder.setDescription(folderDescription);
                            }
                            if ((folderExtraInfo = parser.getAttributeValue(null, "extra_info")) != null) {
                                currentFolder.setExtraInfo(folderExtraInfo);
                            }
                            if ((orderStr = parser.getAttributeValue(null, "order")) != null && !"".equals(orderStr)) {
                                currentFolder.setOrder(Integer.parseInt(orderStr));
                            } else {
                                currentFolder.setOrder(contentCnt++);
                            }
                            Log.log(0x202000000L, "Saved folder " + currentFolder.toString() + " UPDATED: " + (updated |= folderList.updateFolder(currentFolder)));
                            tag = 10;
                            break;
                        }
                        if ("channel".equals(tagName)) {
                            String tokenType;
                            String codecType;
                            String visible;
                            String paymentAllowed;
                            String adultUrl;
                            String subscribed;
                            id = parser.getAttributeValue(null, "channel_id");
                            Channel currentChannel = null;
                            Channel oldChannel = null;
                            knownChannels.removeElement("" + id);
                            if (channelList.contains(id)) {
                                currentChannel = channelList.getChannel(id);
                                allowUpdateOfOrder = currentChannel.getOrder() < 0;
                                Log.log(0x202000000L, "Updating existing channel: " + currentChannel.toString());
                            } else {
                                currentChannel = new Channel(id);
                                allowUpdateOfOrder = true;
                                Log.log(0x202000000L, "Created channel: " + currentChannel.toString());
                            }
                            currentChannel.setAvailableOnAs(true);
                            oldChannel = new Channel(currentChannel);
                            if (this.isParsingStartupChannelInfo) {
                                ServiceRegistry.instance().getDataProvider().getConfig().setStartupChannelId(id);
                                Log.log(0x202000000L, "Parsed id@STARTUP_CHANNEL_INFO/CHANNEL: " + id);
                            }
                            if ((subscribed = parser.getAttributeValue(null, "subscribed")) != null && !"".equals(subscribed)) {
                                currentChannel.setSubscribed("true".equals(subscribed));
                            }
                            if ((adultUrl = parser.getAttributeValue(null, "url")) != null) {
                                currentChannel.setAdultUrl(adultUrl);
                            }
                            if ((paymentAllowed = parser.getAttributeValue(null, "payment_allowed")) != null && !"".equals(paymentAllowed)) {
                                currentChannel.setPaymentAllowed("true".equals(paymentAllowed));
                            }
                            if ((visible = parser.getAttributeValue(null, "visible")) != null && !"".equals(visible)) {
                                currentChannel.setVisible("true".equals(visible));
                            }
                            orderStr = parser.getAttributeValue(null, "order");
                            if (currentChannel.isVisibleAccordingToASAttribute()) {
                                int order = ServiceRegistry.instance().getDataProvider().getChannelConfiguration().getLastVisibleContent();
                                if (orderStr != null && !"".equals(orderStr)) {
                                    order = Integer.parseInt(orderStr);
                                }
                                if (allowUpdateOfOrder) {
                                    if (!hasContent) {
                                        currentChannel.setOrder(order);
                                    } else {
                                        int newOrderPos = ServiceRegistry.instance().getDataProvider().getChannelConfiguration().getLastVisibleContent();
                                        currentChannel.setOrder(newOrderPos);
                                        ServiceRegistry.instance().getDataProvider().getChannelConfiguration().insertContentAt(currentChannel, newOrderPos);
                                    }
                                }
                            }
                            if ((codecType = parser.getAttributeValue(null, "codecType")) != null && !"".equals(codecType)) {
                                currentChannel.setCodecType(codecType);
                            }
                            if ((tokenType = parser.getAttributeValue(null, "tokenType")) != null && !"".equals(tokenType)) {
                                currentChannel.setTokenType(tokenType);
                            }
                            channelList.updateChannel(currentChannel);
                            updated |= !currentChannel.equals(oldChannel);
                            if (currentFolder != null) {
                                updated |= currentFolder.updateChild(currentChannel);
                            }
                            Log.log(0x202000000L, "Saved channel: " + currentChannel.toString() + " UPDATED: " + updated);
                            tag = 11;
                            break;
                        }
                        Log.log(0x102000000L, "Unknown tag: " + tagName);
                        tag = 0;
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (name.equals("content_info") || name.equals("startup_channel_info")) {
                            finished = true;
                        } else if ("bundle".equals(name)) {
                            currentFolder = null;
                        }
                        tag = 0;
                        break;
                    }
                    case 4: {
                        switch (tag) {
                            case 0: {
                                break block3;
                            }
                        }
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        finally {
            for (int i = 0; i < knownChannels.size(); ++i) {
                Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel((String)knownChannels.elementAt(i));
                c.setAvailableOnAs(false);
                Log.log(0x202000000L, "The following channel (id=" + c.getId() + ") has been removed from the server and will be marked as unavailable on AS");
                updated = true;
            }
            if (updated) {
                ServiceRegistry.instance().getDataProvider().getChannelConfiguration().compressOrder();
                Log.log(0x202000000L, "Notification of subscribed status listeners!");
                ServiceRegistry.instance().getDataProvider().getChannelList().notifyObservers();
                ServiceRegistry.instance().getDataProvider().getFolderList().notifyObservers();
            } else {
                Log.log(0x202000000L, "No notification needed. No update!");
            }
        }
    }
}

