/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols.vfe;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;

public class VfeEpgProtocol
extends Protocol {
    public void parse(XmlPullParser parser) {
        try {
            boolean finished = false;
            int eventType = parser.getEventType();
            Epg epg = ServiceRegistry.instance().getDataProvider().getEpg();
            boolean epgChanged = false;
            do {
                switch (eventType) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("error".equals(tagName)) {
                            String code = parser.getAttributeValue(null, "code");
                            String description = parser.getAttributeValue(null, "description");
                            Log.log(0x60000000L, "Received error tag code=\"" + code + "\" description=\"" + description + "\"");
                            break;
                        }
                        if ("program".equals(tagName)) {
                            try {
                                epgChanged |= epg.addEpgData(parser.getAttributeValue(null, "channel_id"), parser.getAttributeValue(null, "program_name"), parser.getAttributeValue(null, "description"), parser.getAttributeValue(null, "genre"), parser.getAttributeValue(null, "start_time"), parser.getAttributeValue(null, "stop_time"));
                            }
                            catch (Exception e) {
                                Log.exception(this, e);
                            }
                            break;
                        }
                        if ("epg_info".equals(tagName)) break;
                        Log.log(0x120000000L, "Unknown tag: " + tagName);
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (!"epg_info".equals(name)) break;
                        finished = true;
                        if (epgChanged) {
                            Log.log(0x220000000L, "Notifying observers of EPG that there has been a change");
                            epg.notifyObservers();
                            break;
                        }
                        Log.log(0x220000000L, "No need no notify observers, no epg data has changed");
                    }
                }
                if (finished) continue;
                try {
                    eventType = parser.next();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.exception(this, e);
                }
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }
}

