/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols.vfe;

import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Slideshow;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class VfeSlideshowProtocol
extends Protocol {
    public static final int TAG_UNKNOWN = 0;
    public static final int TAG_SLIDESHOW = 1;
    public static final int TAG_ERROR = 2;
    public static final int TAG_START_IMAGE = 3;
    public static final int TAG_END_IMAGE = 4;
    private Vector dirtyStartupSlides = new Vector();
    private Vector dirtyExitSlides = new Vector();
    private int slideshowGroupId = -1;

    private Slideshow.Slide createSlide(String order, String url, String duration) {
        Slideshow.Slide slide = new Slideshow.Slide();
        try {
            slide.order = Integer.parseInt(order);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        slide.url = url != null && !url.equals("") ? url : null;
        try {
            slide.duration = Integer.parseInt(duration);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        return slide;
    }

    public void parse(XmlPullParser parser) {
        try {
            int tag = 0;
            boolean finished = false;
            int eventType = parser.getEventType();
            do {
                block1 : switch (eventType) {
                    case 2: {
                        Slideshow.Slide s;
                        String duration;
                        String src;
                        String order;
                        String tagName = parser.getName();
                        if ("slide_show_info".equals(tagName)) {
                            String groupId = parser.getAttributeValue(null, "group_id");
                            if (groupId != null && !"".equals(groupId)) {
                                Log.log(0x20200000000L, "Parsed group_id@SLIDESHOW: " + groupId);
                                this.slideshowGroupId = Integer.parseInt(groupId);
                            }
                            tag = 1;
                            break;
                        }
                        if ("error".equals(tagName)) {
                            String code = parser.getAttributeValue(null, "code");
                            String description = parser.getAttributeValue(null, "description");
                            Log.log(0x20040000000L, "Received error tag code=\"" + code + "\" description=\"" + description + "\"");
                            tag = 2;
                            break;
                        }
                        if ("startImage".equals(tagName)) {
                            order = parser.getAttributeValue(null, "order");
                            src = parser.getAttributeValue(null, "src");
                            duration = parser.getAttributeValue(null, "duration");
                            s = this.createSlide(order, src, duration);
                            Log.log(0x20000000000L, "Parsed startup-slide: " + s.toString());
                            this.dirtyStartupSlides.addElement(s);
                            tag = 3;
                            break;
                        }
                        if ("endImage".equals(tagName)) {
                            order = parser.getAttributeValue(null, "order");
                            src = parser.getAttributeValue(null, "src");
                            duration = parser.getAttributeValue(null, "duration");
                            s = this.createSlide(order, src, duration);
                            Log.log(0x20000000000L, "Parsed startup-slide: " + s.toString());
                            this.dirtyExitSlides.addElement(s);
                            tag = 3;
                            break;
                        }
                        Log.log(0x20100000000L, "Unknown tag: " + tagName);
                        tag = 0;
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (name.equals("slide_show_info")) {
                            finished = true;
                            Utils.bubbleSort(this.dirtyStartupSlides, new Utils.Comparator(){

                                public boolean lessThan(Object a, Object b) {
                                    return ((Slideshow.Slide)a).order < ((Slideshow.Slide)b).order;
                                }
                            });
                            Utils.bubbleSort(this.dirtyExitSlides, new Utils.Comparator(){

                                public boolean lessThan(Object a, Object b) {
                                    return ((Slideshow.Slide)a).order < ((Slideshow.Slide)b).order;
                                }
                            });
                            ServiceRegistry.instance().getDataProvider().getSlideShow().setParsedSlides(this.slideshowGroupId, this.dirtyStartupSlides, this.dirtyExitSlides);
                        }
                        tag = 0;
                        break;
                    }
                    case 4: {
                        switch (tag) {
                            case 0: {
                                break block1;
                            }
                        }
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }
}

