/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols.vfe;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Config;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;

public class VfeUrlsProtocol
extends Protocol {
    public static final int TAG_UNKNOWN = 0;
    public static final int TAG_URLS = 1;
    public static final int TAG_ERROR = 2;
    public static final int TAG_NIN_URL = 4;
    public static final int TAG_SLIDESHOW_URL = 5;
    public static final int TAG_EPG_URL = 6;
    public static final int TAG_STREAMSTATUS = 7;
    public static final int TAG_CONTENT_URL = 8;
    public static final int TAG_INTERACTIVITY_URL = 9;
    public static final int TAG_BUNDLE_INFO_URL = 10;
    public static final int TAG_RESTART_STREAM_URL = 11;
    public static final int TAG_STOP_SESSION_URL = 12;
    public static final int TAG_PROMOTION_SVG_URL = 13;
    public static final int TAG_CONTENT_OFFERINGS_URL = 14;
    public static final int TAG_USER_DIALOG_URL = 15;

    public void parse(XmlPullParser parser) {
        try {
            int tag = 0;
            boolean finished = false;
            int eventType = parser.getEventType();
            Config config = ServiceRegistry.instance().getDataProvider().getConfig();
            do {
                block1 : switch (eventType) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("urls".equals(tagName)) {
                            tag = 1;
                            break;
                        }
                        if ("error".equals(tagName)) {
                            String code = parser.getAttributeValue(null, "code");
                            String description = parser.getAttributeValue(null, "description");
                            Log.log(0x40000800L, "Received error tag code=\"" + code + "\" description=\"" + description + "\"");
                            tag = 2;
                            break;
                        }
                        if ("nin_url".equals(tagName)) {
                            tag = 4;
                            break;
                        }
                        if ("restart_stream_url".equals(tagName)) {
                            tag = 11;
                            break;
                        }
                        if ("slideshow_url".equals(tagName)) {
                            tag = 5;
                            break;
                        }
                        if ("stop_session_url".equals(tagName)) {
                            tag = 12;
                            break;
                        }
                        if ("promotion_svg_url".equals(tagName)) {
                            tag = 13;
                            break;
                        }
                        if ("epg_info_url".equals(tagName)) {
                            tag = 6;
                            break;
                        }
                        if ("content_info_url".equals(tagName)) {
                            String refresh_time = parser.getAttributeValue(null, "refresh_time");
                            if (refresh_time != null && !"".equals(refresh_time)) {
                                Log.log(0x200000800L, "Parsed refresh_time@CONTENT_INFO: " + refresh_time);
                                config.setContentInfoUpdateInterval(Integer.parseInt(refresh_time));
                            }
                            tag = 8;
                            break;
                        }
                        if ("interactivity_url".equals(tagName)) {
                            tag = 9;
                            break;
                        }
                        if ("content_offerings_url".equals(tagName)) {
                            tag = 14;
                            break;
                        }
                        if ("user_dialog_url".equals(tagName)) {
                            tag = 15;
                            break;
                        }
                        Log.log(0x100000800L, "Unknown tag: " + tagName);
                        tag = 0;
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (name.equals("urls")) {
                            finished = true;
                        }
                        tag = 0;
                        break;
                    }
                    case 4: {
                        String text = parser.getText();
                        switch (tag) {
                            case 4: {
                                Log.log(0x200000800L, "Parsed NIN_URL: " + text);
                                config.setNinUrl(text);
                                Log.log(0x200000800L, "Assuming FD1 ECDS NIN");
                                config.setNinVersion("1.0");
                                break block1;
                            }
                            case 11: {
                                Log.log(0x200000800L, "Parsed RESTART_STREAM_URL: " + text);
                                config.setRestartStreamUrl(text);
                                break block1;
                            }
                            case 5: {
                                Log.log(0x200000800L, "Parsed SLIDESHOW_INFO_URL: " + text);
                                config.setSlideShowUrl(text);
                                break block1;
                            }
                            case 12: {
                                Log.log(0x200000800L, "Parsed TAG_STOP_SESSION_URL: " + text);
                                config.setStopSessionUrl(text);
                                break block1;
                            }
                            case 8: {
                                Log.log(0x200000800L, "Parsed CONTENT_INFO_URL: " + text);
                                config.setContentInfoUrl(text);
                                break block1;
                            }
                            case 6: {
                                Log.log(0x200000800L, "Parsed EPG_INFO_URL: " + text);
                                config.setEpgUrl(text);
                                break block1;
                            }
                            case 9: {
                                Log.log(0x200000800L, "Parsed INTERACTIVITY_URL: " + text);
                                config.setInteractivityServerUrl(text);
                                break block1;
                            }
                            case 13: {
                                Log.log(0x200000800L, "Parsed PROMOTION_SVG_URL: " + text);
                                config.setPromotionSvgUrl(text);
                                break block1;
                            }
                            case 14: {
                                Log.log(0x200000800L, "Parsed CONTENT_OFFERINGS_URL: " + text);
                                config.setContentOfferingsUrl(text);
                                break block1;
                            }
                            case 15: {
                                Log.log(0x200000800L, "Parsed USER_DIALOG_URL: " + text);
                                config.setUserDialogUrl(text);
                                break block1;
                            }
                            case 0: {
                                break block1;
                            }
                        }
                        break;
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }
}

