/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.notificationcenter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationThread;
import se.tactel.tvclient.notificationcenter.Observer;

public class NotificationCenter {
    static NotificationCenter instance = null;
    Hashtable observers = new Hashtable();
    Vector omniscient = new Vector();

    protected NotificationCenter() {
    }

    public static NotificationCenter defaultCenter() {
        if (instance == null) {
            instance = new NotificationCenter();
        }
        return instance;
    }

    private void addObserverForObject(Observer observer, Object object) {
        Vector<Observer> o = (Vector<Observer>)this.observers.get(object);
        if (o == null) {
            o = new Vector<Observer>();
            o.addElement(observer);
            this.observers.put(object, o);
        } else if (!o.contains(observer)) {
            o.addElement(observer);
        }
    }

    public void addObserver(Observer observer, String name, Object object) {
        if (name != null) {
            this.addObserverForObject(observer, name);
        }
        if (object != null) {
            this.addObserverForObject(observer, object);
        }
    }

    void addOmniscientObserver(Observer observer) {
        this.omniscient.addElement(observer);
    }

    public void postNotification(Notification notification) {
        new NotificationThread(notification).start(this);
    }

    public void removeObserver(Observer observer) {
        Enumeration elements = this.observers.elements();
        while (elements.hasMoreElements()) {
            Vector element = (Vector)elements.nextElement();
            if (!element.contains(observer)) continue;
            element.removeElement(observer);
        }
    }

    void removeObserverFromNotification(Observer observer, Object object, String name) {
        Vector o;
        if (object != null && (o = (Vector)this.observers.get(object)).contains(observer)) {
            o.removeElement(observer);
        }
        if (name != null && (o = (Vector)this.observers.get(name)).contains(observer)) {
            o.removeElement(observer);
        }
    }

    void removeOmniscientObserver(Observer observer) {
        if (this.omniscient.contains(observer)) {
            this.omniscient.removeElement(observer);
        }
    }

    public String toString() {
        return super.toString();
    }
}

