/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.notificationcenter;

import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.notificationcenter.Observer;
import se.tactel.tvclient.util.Log;

class NotificationThread
implements Runnable {
    Notification notification;
    NotificationCenter center;

    public NotificationThread(Notification notification) {
        this.notification = notification;
    }

    public void start(NotificationCenter center) {
        this.center = center;
        new Thread(this).start();
    }

    public void run() {
        try {
            Vector observersToNotify = null;
            if (this.notification == null) {
                Log.log(0x40000000L, "Someone gave me a null notification object. thanks alot..");
                return;
            }
            if (this.notification.object() != null && (observersToNotify = (Vector)this.center.observers.get(this.notification.object())) != null) {
                this.notifyVectorWithNotification(observersToNotify, this.notification);
            }
            if (this.notification.name() != null && (observersToNotify = (Vector)this.center.observers.get(this.notification.name())) != null) {
                this.notifyVectorWithNotification(observersToNotify, this.notification);
            }
            if (this.center.omniscient != null) {
                this.notifyVectorWithNotification(this.center.omniscient, this.notification);
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    private void notifyVectorWithNotification(Vector observersToNotify, Notification notification) {
        if (observersToNotify != null && notification != null) {
            Enumeration enumerator = observersToNotify.elements();
            while (enumerator.hasMoreElements()) {
                try {
                    Observer observer = (Observer)enumerator.nextElement();
                    observer.notifiedWithNotification(notification);
                }
                catch (Exception e) {
                    Log.exception(this, e);
                }
            }
        }
    }
}

