/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.player;

import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.tab.tv.PlayerWindowInterface;
import se.tactel.tvclient.player.PlayerRealizer;
import se.tactel.tvclient.player.TVPlayerAdaptation;
import se.tactel.tvclient.player.TVPlayerListener;
import se.tactel.tvclient.util.Log;

public class TVPlayer {
    private Player player;
    private Vector tvPlayerListeners = new Vector();
    private boolean playerNeedsRestart = false;
    boolean playerRunning = false;
    private boolean userHasMuted = false;
    private boolean muted = false;
    private boolean fullscreen = false;
    private boolean playerVisible = false;
    private int initialVolume = -1;
    private boolean lastNINRespond = true;

    public Player getPlayer() {
        return this.player;
    }

    public TVPlayer() {
        Log.log(0x200000000L, "Creating uninitialized TV Player");
    }

    public boolean isRunning() {
        return this.playerRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean startPlayer() {
        void var1_1;
        boolean success = false;
        try {
            String streamUrl = ServiceRegistry.instance().getDataProvider().getConfig().getStreamingUrl();
            String token = ServiceRegistry.instance().getDataProvider().getConfig().getToken();
            if (streamUrl != null && token != null) {
                char separator = '?';
                if (streamUrl.lastIndexOf(63) >= 0) {
                    separator = '&';
                }
                streamUrl = streamUrl + separator + token;
            }
            Log.log(0x200020000L, "Creating player on: " + streamUrl);
            this.player = Manager.createPlayer((String)streamUrl);
            this.player.addPlayerListener((PlayerListener)new InternalTVPlayerListener());
            Log.log(0x200020000L, "Realizing player...");
            PlayerRealizer pr = new PlayerRealizer(this.player);
            pr.realize();
            Log.log(0x200020000L, "Prefetching player...");
            this.player.prefetch();
            this.player.setLoopCount(-1);
            TVPlayerAdaptation.onPreStartPlayer();
            if (this.initialVolume >= 0) {
                Log.log(0x200020000L, "Set initial volume level...");
                this.setVolumeLevel(this.initialVolume);
                this.initialVolume = -1;
            }
            Log.log(0x200020000L, "Starting player...");
            this.player.start();
            this.forceSetMuted(this.muted);
            TVPlayerAdaptation.onPostStartPlayer();
            this.playerRunning = true;
            this.playerNeedsRestart = false;
            success = true;
            for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
                ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerStarted();
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
        finally {
            if (!this.playerRunning) {
                for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
                    ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerDroppedFromStream();
                }
                ServiceRegistry.instance().getComm().processUrl("res://error_start_player.xml");
            }
        }
        return (boolean)var1_1;
    }

    public boolean isMuted() {
        return this.muted;
    }

    private void forceSetMuted(boolean mute) {
        VolumeControl volumeControl;
        this.muted = mute;
        if (this.player != null && (volumeControl = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            volumeControl.setMute(this.muted);
            Log.log(0x200020000L, "muted: " + this.muted);
        }
    }

    public void setMuted(boolean mute) {
        if (!(ServiceRegistry.instance().getWindowServer().getTopmostWindow() instanceof PlayerWindowInterface) || this.userHasMuted) {
            return;
        }
        this.muted = mute;
        if (this.player != null) {
            VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setMute(this.muted);
                Log.log(0x200020000L, "muted: " + this.muted);
            }
            for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
                ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerMuteStateChanged(this.muted);
            }
        }
    }

    public void setMutedFromUser(boolean mute) {
        this.muted = mute;
        this.userHasMuted = mute;
        if (this.player != null) {
            VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setMute(this.muted);
                Log.log(0x200020000L, "muted: " + this.muted);
            }
            for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
                ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerMuteStateChanged(this.muted);
            }
        }
    }

    public void setMutedWithoutNotifing(boolean mute) {
        VolumeControl volumeControl;
        if (this.userHasMuted) {
            return;
        }
        this.muted = mute;
        if (this.player != null && this.player.getState() != 100 && (volumeControl = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            volumeControl.setMute(this.muted);
            Log.log(0x200020000L, "muted: " + this.muted);
        }
    }

    public int getVolumeLevel() {
        VolumeControl volumeControl;
        if (this.player != null && (volumeControl = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            return volumeControl.getLevel();
        }
        return 0;
    }

    public void setVolumeLevel(int level) {
        VolumeControl volumeControl;
        if (this.player != null && (volumeControl = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            if (level < 0) {
                level = 0;
            } else if (level > 100) {
                level = 100;
            }
            volumeControl.setLevel(level);
            Log.log(0x10000000L, "Volume changed to " + level);
            if (this.muted && level > 0) {
                this.setMuted(false);
            } else if (!this.muted && level == 0) {
                this.setMuted(true);
            }
        }
    }

    public void setInitialVolumeLevel(int level) {
        this.initialVolume = level;
    }

    public void stopPlayer() {
        if (this.player != null && (this.player.getState() == 300 || this.player.getState() == 400)) {
            Log.log(0x200020000L, "Stopping player.");
            this.player.close();
            this.playerRunning = false;
            this.playerVisible = false;
            while (this.player.getState() != 0) {
                try {
                    System.out.println("Not yet closed");
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Log.exception(this, e);
                }
            }
            this.player = null;
            System.gc();
        } else {
            Log.log(0x100020000L, "stop() called on player that isn't ready");
        }
        for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
            ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerStopped();
        }
    }

    public void addTVPlayerListener(TVPlayerListener listener) {
        this.tvPlayerListeners.addElement(listener);
    }

    public void hide() {
        if (!this.playerRunning) {
            Log.log(0x100020000L, "Attempting to hide a player which is not fully running");
            return;
        }
        if (this.player != null) {
            Log.log(0x200020000L, "Hiding player.");
            VideoControl videoControl = (VideoControl)this.player.getControl("VideoControl");
            if (videoControl != null) {
                videoControl.setDisplayLocation(Skin.SCREEN_RECT.width, Skin.SCREEN_RECT.height);
                videoControl.setVisible(false);
                this.playerVisible = false;
            }
        }
    }

    public void show(Rect rect) {
        VideoControl videoControl;
        if (!this.playerRunning) {
            Log.log(0x100020000L, "Attempting to show a player which is not fully running");
            return;
        }
        if (this.player != null && (videoControl = (VideoControl)this.player.getControl("VideoControl")) != null) {
            videoControl.setDisplayLocation(rect.x, rect.y);
            try {
                videoControl.setDisplaySize(rect.width, rect.height);
                Log.log(0x200020000L, "Showing player: " + rect.toString());
            }
            catch (MediaException e) {
                Log.exception(this, e);
            }
            videoControl.setVisible(true);
            this.playerVisible = true;
        }
    }

    public Rect getPlayerFrame() {
        VideoControl videoControl;
        if (this.player != null && this.player.getState() == 400 && (videoControl = (VideoControl)this.player.getControl("VideoControl")) != null) {
            return new Rect(videoControl.getDisplayX(), videoControl.getDisplayY(), videoControl.getDisplayWidth(), videoControl.getDisplayHeight());
        }
        return null;
    }

    public void setPlayerNeedsRestart() {
        this.playerNeedsRestart = true;
    }

    public void setPlayerDroppedFromStream() {
        for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
            ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerDroppedFromStream();
        }
        this.playerRunning = false;
        this.setPlayerNeedsRestart();
    }

    public boolean attemptToSwitchChannel(Channel channel) {
        int i;
        for (i = 0; i < this.tvPlayerListeners.size(); ++i) {
            ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerIsAttemptingToSwitchChannel(channel);
        }
        if (!this.playerNeedsRestart) {
            Log.log(0x200020000L, "TVPlayer, switching to: " + channel.getName());
            String baseNINUrl = ServiceRegistry.instance().getDataProvider().getConfig().getNinURL();
            String baseNINVersion = ServiceRegistry.instance().getDataProvider().getConfig().getNinVersion();
            String channelSwitchURL = baseNINUrl + "?version=" + baseNINVersion + "&cmd=navigate&key=" + channel.getEcdsId();
            Log.log(0x200020000L, "Switch URL:" + channelSwitchURL);
            this.lastNINRespond = false;
            boolean downloadStatus = ServiceRegistry.instance().getComm().processNiNUrl(channelSwitchURL);
            if (!this.lastNINRespond || !downloadStatus) {
                ServiceRegistry.instance().getComm().processUrlASync("res://error_channel_switch.xml");
                for (int i2 = 0; i2 < this.tvPlayerListeners.size(); ++i2) {
                    ((TVPlayerListener)this.tvPlayerListeners.elementAt(i2)).playerSwitchChannelAttemptFailed(channel);
                }
                return false;
            }
            return true;
        }
        if (this.playerVisible) {
            Log.log(131072L, "Hiding player before restart");
            this.hide();
            ServiceRegistry.instance().getController().getTvScreenController().playerView.hideAndRepaintActive();
        }
        for (i = 0; i < this.tvPlayerListeners.size(); ++i) {
            ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).playerIsStarting();
        }
        Log.log(0x200020000L, "Restarting player");
        this.playerNeedsRestart = false;
        if (this.player != null) {
            Log.log(0x200020000L, "Killing previous player...");
            this.playerRunning = false;
            try {
                this.player.stop();
            }
            catch (MediaException e) {
                Log.exception(this, e);
            }
            this.player.deallocate();
            this.player.close();
            this.player = null;
            System.gc();
            Log.log(0x200020000L, "Previous player killed successfuly.");
        } else {
            Log.log(0x200020000L, "NOT Killing previous player as it's null...");
        }
        String ninInitUrl = ServiceRegistry.instance().getDataProvider().getConfig().getNinURL() + "?version=" + ServiceRegistry.instance().getDataProvider().getConfig().getNinVersion() + "&cmd=start";
        ninInitUrl = ninInitUrl + "&menu=" + channel.getMenu() + "&key=" + channel.getEcdsId();
        this.lastNINRespond = false;
        boolean downloadStatus = ServiceRegistry.instance().getComm().processNiNUrl(ninInitUrl);
        if (this.lastNINRespond && downloadStatus) {
            return this.startPlayer();
        }
        ServiceRegistry.instance().getComm().processUrlASync("res://error_start_player.xml");
        for (int i3 = 0; i3 < this.tvPlayerListeners.size(); ++i3) {
            ((TVPlayerListener)this.tvPlayerListeners.elementAt(i3)).playerSwitchChannelAttemptFailed(channel);
        }
        return false;
    }

    public boolean setFullscreen(boolean b) {
        if (b != this.fullscreen) {
            this.fullscreen = b;
            return true;
        }
        return true;
    }

    public boolean orientationRestart() {
        this.setPlayerNeedsRestart();
        boolean success = this.attemptToSwitchChannel((Channel)ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent());
        if (!success) {
            this.fullscreen = false;
        }
        return success;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean isPlayerVisible() {
        return this.playerVisible;
    }

    public void setNINRespond(boolean ok) {
        this.lastNINRespond = ok;
        if (!ok) {
            for (int i = 0; i < this.tvPlayerListeners.size(); ++i) {
                ((TVPlayerListener)this.tvPlayerListeners.elementAt(i)).badNinRespons();
            }
        }
    }

    private static class InternalTVPlayerListener
    implements PlayerListener {
        private InternalTVPlayerListener() {
        }

        public void playerUpdate(Player player, String event, Object eventData) {
            try {
                if (player != null) {
                    Log.log(0x200020000L, "TVPlayerListener received event: " + event + ": " + eventData + " state: " + player.getState());
                } else {
                    Log.log(0x200020000L, "TVPlayerListener received event: " + event + ": " + eventData + " state: (null)");
                }
                if (event.equals("bufferingStarted")) {
                    ServiceRegistry.instance().getIncoming().eventReceived(4);
                } else if (event.equals("bufferingStopped")) {
                    ServiceRegistry.instance().getIncoming().eventReceived(5);
                } else if (event.equals("endOfMedia")) {
                    Log.log(0x200020000L, "Received END_OF_MEDIA " + event);
                } else if (event.equals("error")) {
                    Log.log(0x200020000L, "Received ERROR " + event);
                    ServiceRegistry.instance().getPlayer().setPlayerDroppedFromStream();
                }
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }
}

