/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.resource;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import se.tactel.tvclient.resource.Resource;
import se.tactel.tvclient.resource.ResourceImpl;
import se.tactel.tvclient.util.Log;

class ResourceCache {
    private Hashtable cachedResources = new Hashtable();
    String recordStoreName;
    int maximumStoreSize;
    int maximumImageSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceCache(String storeName, int totMaxSize, int singleMaxSize) {
        this.maximumStoreSize = totMaxSize;
        this.maximumImageSize = singleMaxSize;
        this.recordStoreName = storeName;
        Log.log(0x200000100L, "Constructing ResourceCache instance: " + this.recordStoreName);
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            Log.log(0x200000100L, "Populating cache with " + store.getNumRecords() + " records from record store.");
            RecordEnumeration recordenum = store.enumerateRecords(null, null, false);
            while (recordenum.hasNextElement()) {
                int id = recordenum.nextRecordId();
                byte[] data = store.getRecord(id);
                ResourceImpl res = ResourceImpl.deserialize(data);
                this.cachedResources.put(res.getID(), res);
                Log.log(0x200000100L, "   Inserted resource at store id=\"" + id + ":  " + res.toString());
            }
        }
        catch (RecordStoreNotFoundException e) {
            Log.exception(this, e);
        }
        catch (RecordStoreException e) {
            Log.exception(this, e);
        }
        catch (OutOfMemoryError error) {
            System.gc();
            Log.log(0x40000000L, error.toString());
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
                Log.exception(this, e);
            }
            catch (RecordStoreException e) {
                Log.exception(this, e);
            }
        }
    }

    synchronized void updateResourceInCache(ResourceImpl resource) {
        if (this.maximumImageSize > 0 && resource.byteData.length > this.maximumImageSize) {
            Log.log(0x100000100L, "updataResourceInCache: Not cached due to size restriction: " + resource.id + " " + resource.byteData.length);
            return;
        }
        RecordStore store = null;
        try {
            byte[] dataToStore;
            store = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            Log.log(0x200000100L, "updateResourceInCache: Store size=" + store.getSize());
            if (this.maximumStoreSize > 0 && store.getSize() > this.maximumStoreSize) {
                Log.log(0x100000100L, "Flushing cache");
                Enumeration e = this.cachedResources.elements();
                while (e.hasMoreElements()) {
                    ResourceImpl r = (ResourceImpl)e.nextElement();
                    if (r.recordId == 0) continue;
                    store.deleteRecord(r.recordId);
                    Log.log(0x200000100L, "Deleted record from record storage: " + r.toString());
                }
                this.cachedResources.clear();
            }
            if (!this.cachedResources.containsKey(resource.getID())) {
                int newId;
                resource.recordId = newId = store.getNextRecordID();
                dataToStore = ResourceImpl.serialize(resource);
                int realId = store.addRecord(dataToStore, 0, dataToStore.length);
                Log.log(0x200000100L, "Added record " + resource.recordId + "(=" + realId + ")  (" + store.getSize() + "b used)for resource " + resource.getID());
                if (newId != realId) {
                    throw new RecordStoreException("Unexpected record id");
                }
            } else {
                int recordIdOfCachedOutdatedResource;
                resource.recordId = recordIdOfCachedOutdatedResource = ((ResourceImpl)this.cachedResources.get((Object)resource.getID())).recordId;
                dataToStore = ResourceImpl.serialize(resource);
                store.setRecord(resource.recordId, dataToStore, 0, dataToStore.length);
                Log.log(0x200000100L, "Setted record " + resource.recordId + " (" + store.getSize() + "b used) for resource " + resource.getID());
            }
            this.cachedResources.put(resource.getID(), resource);
        }
        catch (RecordStoreFullException e) {
            Log.log(0x200000100L, "Recordstore full when attempting to persist " + resource.getID());
            this.cachedResources = new Hashtable();
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
                store = null;
                RecordStore.deleteRecordStore((String)this.recordStoreName);
                Log.log(0x200000100L, "Cache flushed successfully.");
            }
            catch (RecordStoreNotOpenException e1) {
                Log.exception(this, e);
                throw new RuntimeException(e1.getMessage());
            }
            catch (RecordStoreException e1) {
                Log.exception(this, e);
                throw new RuntimeException(e1.getMessage());
            }
        }
        catch (RecordStoreNotFoundException e) {
            Log.exception(this, e);
            throw new RuntimeException(e.getMessage());
        }
        catch (RecordStoreException e) {
            Log.exception(this, e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
                Log.exception(this, e);
                throw new RuntimeException(e.getMessage());
            }
            catch (RecordStoreException e) {
                Log.exception(this, e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized ResourceImpl getResourceFromCache(String id) {
        void var2_2;
        ResourceImpl resourceToBeReturned = (ResourceImpl)this.cachedResources.get(id);
        if (resourceToBeReturned != null && resourceToBeReturned.data == null) {
            RecordStore store = null;
            try {
                store = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
                Log.log(256L, "getResourceFromCache: Reading in data for resource: " + resourceToBeReturned.toString());
                resourceToBeReturned.byteData = ResourceImpl.deserialize((byte[])store.getRecord((int)resourceToBeReturned.recordId)).byteData;
            }
            catch (RecordStoreNotFoundException e) {
                Log.exception(this, e);
                throw new RuntimeException(e.getMessage());
            }
            catch (RecordStoreException e) {
                Log.exception(this, e);
                throw new RuntimeException(e.getMessage());
            }
            finally {
                try {
                    if (store != null) {
                        store.closeRecordStore();
                    }
                }
                catch (RecordStoreNotOpenException e1) {
                    Log.exception(this, e1);
                    throw new RuntimeException(e1.getMessage());
                }
                catch (RecordStoreException e1) {
                    Log.exception(this, e1);
                    throw new RuntimeException(e1.getMessage());
                }
            }
        }
        if (resourceToBeReturned != null) {
            Log.log(256L, "getResourceFromCache: Resource has data already present in memory: " + resourceToBeReturned.toString());
        } else {
            Log.log(256L, "getResourceFromCache: Resource with id not present in cache: " + id);
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isResourceCached(Resource resource) {
        ResourceImpl resourceRefInHashmap = (ResourceImpl)this.cachedResources.get(resource.getID());
        if (resourceRefInHashmap != null) {
            RecordStore store = null;
            try {
                store = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
                Log.log(256L, "isResourceCache: Getting record for resource: " + resourceRefInHashmap.toString());
                if (store.getRecord(resourceRefInHashmap.recordId) != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RecordStoreFullException e) {
                Log.exception(this, e);
            }
            catch (RecordStoreNotFoundException e) {
                Log.exception(this, e);
            }
            catch (RecordStoreException e) {
                Log.exception(this, e);
            }
            finally {
                try {
                    if (store != null) {
                        store.closeRecordStore();
                    }
                }
                catch (RecordStoreNotOpenException e1) {
                    Log.exception(this, e1);
                    throw new RuntimeException(e1.getMessage());
                }
                catch (RecordStoreException e1) {
                    Log.exception(this, e1);
                    throw new RuntimeException(e1.getMessage());
                }
            }
        }
        return false;
    }

    boolean releaseDataForResource(Resource resource) {
        ResourceImpl resourceRefInHashmap = (ResourceImpl)this.cachedResources.get(resource.getID());
        Log.log(256L, "Releasing data for resource: " + resource.toString());
        if (resourceRefInHashmap != null) {
            Log.log(256L, "Free mem before release: " + Runtime.getRuntime().freeMemory());
            resourceRefInHashmap.byteData = null;
            resourceRefInHashmap.data = null;
            System.gc();
            Log.log(256L, "Free mem after release: " + Runtime.getRuntime().freeMemory());
            return true;
        }
        return false;
    }

    synchronized void clearCache() {
        try {
            RecordStore.deleteRecordStore((String)this.recordStoreName);
            this.cachedResources = new Hashtable();
        }
        catch (RecordStoreNotFoundException e) {
            Log.exception(this, e);
        }
        catch (RecordStoreException e) {
            Log.exception(this, e);
        }
        Log.log(0x200000100L, "Cache flushed successfully.");
    }
}

