/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.util;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import se.tactel.tvclient.util.LogInterface;
import se.tactel.tvclient.util.Utils;

public class Log {
    public static final long P_CARLSSON = 1L;
    public static final long L_CARLSSON = 2L;
    public static final long JONAS = 4L;
    public static final long INTERACTIVITY_TIMER = 8L;
    public static final long STJARNAS = 16L;
    public static final long PETER = 32L;
    public static final long CALLE = 64L;
    public static final long INTERACTIVITY = 128L;
    public static final long RESOURCE_MANAGEMENT = 256L;
    public static final long NIN_PARSING = 512L;
    public static final long VOD_PARSING = 1024L;
    public static final long AS_PARSING = 2048L;
    public static final long NETWORK = 4096L;
    public static final long NETWORK_DETAILED = 8192L;
    public static final long OBSERVERABLE_DATA = 16384L;
    public static final long LOCALIZATION = 32768L;
    public static final long LOCAL_CONFIGURATION = 65536L;
    public static final long TV_PLAYER = 131072L;
    public static final long CURRENT_CONTENT = 262144L;
    public static final long TV_SCREEN_CONTROLLER = 524288L;
    public static final long GUI_DRAWING = 0x100000L;
    public static final long USERDIALOG_TAGS = 0x200000L;
    public static final long MEMORY = 0x400000L;
    public static final long INCOMING = 0x800000L;
    public static final long SUBSCRIPTION_PARSING = 0x1000000L;
    public static final long CONTENT_PARSING = 0x2000000L;
    public static final long SLIDESHOW = 0x4000000L;
    public static final long CAROUSEL = 0x8000000L;
    public static final long VOLUME = 0x10000000L;
    public static final long EPG = 0x20000000L;
    public static final long ERROR = 0x40000000L;
    public static final long EXCEPTION = 0x80000000L;
    public static final long WARNING = 0x100000000L;
    public static final long INFO = 0x200000000L;
    public static final long WINDOW_SERVER = 0x400000000L;
    public static final long OPTIONS_SCREEN = 0x800000000L;
    public static final long WINDOW = 0x1000000000L;
    public static final long TV_SCREEN = 0x2000000000L;
    public static final long STORE_SCREEN = 0x4000000000L;
    public static final long GUIDE_SCREEN = 0x8000000000L;
    public static final long CHANNEL_SCREEN = 0x10000000000L;
    public static final long SLIDESHOW_PARSING = 0x20000000000L;
    public static final long CHANNEL_CONFIGURAITON = 0x40000000000L;
    public static final long NEWS_SCREEN = 0x80000000000L;
    public static final long NETWORK_RAW = 0x100000000000L;
    public static String[] logContantNames = new String[]{"P_CARLSSON", "L_CARLSSON", "JONAS", "INTERACTIVITY_TIMER", "STJARNAS", "PETER", "CALLE", "INTERACTIVITY", "RESOURCE_MANAGEMENT", "NIN_PARSING", "VOD_PARSING", "AS_PARSING", "NETWORK", "NETWORK_DETAILED", "OBSERVERABLE_DATA", "LOCALIZATION", "LOCAL_CONFIGURATION", "TV_PLAYER", "CURRENT_CONTENT", "TV_SCREEN_CONTROLLER", "GUI_DRAWING", "USERDIALOG_TAGS", "MEMORY", "INCOMING", "SUBSCRIPTION_PARSING", "CONTENT_PARSING", "SLIDESHOW", "CAROUSEL", "VOLUME", "EPG", "ERROR", "EXCEPTION", "WARNING", "INFO", "WINDOW_SERVER", "OPTIONS_SCREEN", "WINDOW", "TV_SCREEN", "STORE_SCREEN", "GUIDE_SCREEN", "CHANNEL_SCREEN", "SLIDESHOW_PARSING", "CHANNEL_CONFIGURATION", "NEWS_SCREEN", "NETWORK_RAW"};
    private static long conditionMask = 0L;
    public static final int NONE = 0;
    public static final int ALL = 1;
    public static final int INCLUSIVE = 2;
    public static final int EXCLUSIVE = 3;
    public static final int NET = 4;
    public static final int BT = 5;
    public static final int FILE = 6;
    public static final String[] logTypeNames = new String[]{"NONE", "ALL", "OR", "AND", "NET", "BT", "FILE"};
    private static int logType = 2;
    private static boolean initialized = false;
    private static Object mutex = new Object();
    private static Object bt = null;
    private static Object localFile = null;

    public static void initWithJADProperties(String type, String logOrigins) {
        int i;
        for (i = 0; i < logContantNames.length; ++i) {
            if (logOrigins.indexOf(logContantNames[i]) == -1) continue;
            System.out.println("Log-origin: " + logContantNames[i]);
            conditionMask |= 1L << i;
        }
        for (i = 0; i < logTypeNames.length; ++i) {
            if (!logTypeNames[i].equals(type)) continue;
            logType = i;
            initialized = true;
            if (logType == 5) {
                Log.setupBT();
            } else if (logType == 6) {
                Log.setupLocalFile();
            }
            return;
        }
        System.out.println("Error setting up logging!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(long type, String s) {
        if (!initialized) {
            System.out.println("Log class not initilized. This can be done by invoking the method initWithLogTypeForContition().");
        }
        switch (logType) {
            case 1: {
                System.out.println(Log.getLogMessage(type, s));
                break;
            }
            case 2: {
                if ((conditionMask & type) != 0L) {
                    System.out.println(Log.getLogMessage(type, s));
                    break;
                }
                if ((type & 0xC0000000L) == 0L) break;
                System.out.println(Log.getLogMessage(type, s));
                break;
            }
            case 3: {
                if (conditionMask != type) break;
                System.out.println(Log.getLogMessage(type, s));
                break;
            }
            case 4: {
                if ((conditionMask & type) == 0L) break;
                Object object = mutex;
                synchronized (object) {
                    HttpConnection http = null;
                    try {
                        http = (HttpConnection)Connector.open((String)("http://wesley.tactel.se/static-www/as/log.jsp?file=vfe-esp2&log=" + Utils.urlEncodeString(Log.getLogMessage(type, s))));
                        if (http.getResponseCode() != 200) {
                            System.out.println("Unable to upload log post ->");
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        System.out.println(Log.getLogMessage(type, s));
                        if (http != null) {
                            try {
                                http.close();
                            }
                            catch (IOException e) {
                                System.out.println(e.toString());
                            }
                        }
                    }
                    break;
                }
            }
            case 5: {
                if (bt == null || (conditionMask & type) == 0L && (type & 0x1C0000000L) == 0L) break;
                ((LogInterface)bt).log(Log.getLogMessage(type, s));
                break;
            }
            case 6: {
                if ((conditionMask & type) == 0L) break;
                ((LogInterface)localFile).log(Log.getLogMessage(type, s));
                break;
            }
        }
    }

    public static void exception(Object sender, Throwable e) {
        switch (logType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                String className = "null class";
                if (sender != null) {
                    className = sender.getClass().getName();
                }
                Log.log(0x80000000L, "Exception " + e.getClass().getName() + " caught in class: " + className + (e.getMessage() == null ? ": the message was 'null'" : ": " + e.getMessage()));
                e.printStackTrace();
                break;
            }
        }
    }

    private static String getLogMessage(long type, String message) {
        for (int i = 0; i < logContantNames.length; ++i) {
            if ((1L << i & type) == 0L) continue;
            message = logContantNames[i] + ":" + message;
        }
        return message;
    }

    private static void setupBT() {
        try {
            Class<?> btc = Class.forName("se.tactel.tvclient.util.BluetoothLog");
            bt = btc.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setupLocalFile() {
        try {
            Class<?> lfl = Class.forName("se.tactel.tvclient.util.LocalFileLog");
            localFile = lfl.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        if (bt != null) {
            ((LogInterface)bt).close();
        }
        if (localFile != null) {
            ((LogInterface)localFile).close();
        }
    }

    public static boolean isLoggingOn(long type) {
        return (conditionMask & type) != 0L;
    }
}

