/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Config;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.util.Log;

public class Utils {
    public static int[] march = new int[]{26, 25, 30, 29, 28, 27, 25, 31, 30, 29, 27};
    public static int[] octob = new int[]{29, 28, 26, 25, 31, 30, 28, 27, 26, 25, 30};
    static /* synthetic */ Class class$se$tactel$tvclient$util$Utils;

    public static Date getTime() {
        long diff = ServiceRegistry.instance().getDataProvider().getConfig().getServerLocalTimeDiff();
        return new Date(System.currentTimeMillis() - diff);
    }

    public static long currentTimeMillis() {
        long diff = ServiceRegistry.instance().getDataProvider().getConfig().getServerLocalTimeDiff();
        return System.currentTimeMillis() - diff;
    }

    public static Calendar getDate() {
        return Utils.getDate(Utils.getTime());
    }

    public static long getMillisAtBeginningOfDay(Date day) {
        long millis = day.getTime();
        millis -= millis % 86400000L;
        Calendar localTimeMidnight = Utils.getDate(new Date(millis));
        millis -= localTimeMidnight.getTime().getTime() - millis;
        return millis;
    }

    public static long getMillisAtEndOfDay(Date day) {
        long begin = Utils.getMillisAtBeginningOfDay(day);
        return begin + 86399000L;
    }

    public static Calendar getDate(Date d) {
        Config config = ServiceRegistry.instance().getDataProvider().getConfig();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(config.getTimeZone()));
        c.setTime(d);
        boolean daylightSavings = false;
        switch (c.get(2)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                daylightSavings = true;
                break;
            }
            case 2: {
                try {
                    if (c.get(5) >= march[(c.get(1) - 2006) % 11]) {
                        daylightSavings = true;
                        break;
                    }
                    daylightSavings = false;
                }
                catch (Exception e) {
                    Log.exception(class$se$tactel$tvclient$util$Utils == null ? (class$se$tactel$tvclient$util$Utils = Utils.class$("se.tactel.tvclient.util.Utils")) : class$se$tactel$tvclient$util$Utils, e);
                }
                break;
            }
            case 9: {
                try {
                    if (c.get(5) < octob[(c.get(1) - 2006) % 11]) {
                        daylightSavings = true;
                        break;
                    }
                    daylightSavings = false;
                }
                catch (Exception e) {
                    Log.exception(class$se$tactel$tvclient$util$Utils == null ? (class$se$tactel$tvclient$util$Utils = Utils.class$("se.tactel.tvclient.util.Utils")) : class$se$tactel$tvclient$util$Utils, e);
                }
                break;
            }
            default: {
                daylightSavings = false;
            }
        }
        if (daylightSavings) {
            c.setTime(new Date(d.getTime() + 3600000L));
        }
        return c;
    }

    public static void bubbleSort(Vector v, Comparator comp) {
        int n = v.size();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                if (!comp.lessThan(v.elementAt(j + 1), v.elementAt(j))) continue;
                Object tmp = v.elementAt(j);
                v.setElementAt(v.elementAt(j + 1), j);
                v.setElementAt(tmp, j + 1);
            }
        }
    }

    public static String urlEncodeString(String url) {
        byte[] temp = url.getBytes();
        int size = temp.length;
        StringBuffer buffer = new StringBuffer(size);
        block27: for (int i = 0; i < size; ++i) {
            byte test = temp[i];
            switch (test) {
                case 36: {
                    buffer.append("%24");
                    continue block27;
                }
                case 38: {
                    buffer.append("%26");
                    continue block27;
                }
                case 43: {
                    buffer.append("%2B");
                    continue block27;
                }
                case 44: {
                    buffer.append("%2C");
                    continue block27;
                }
                case 47: {
                    buffer.append("%2F");
                    continue block27;
                }
                case 58: {
                    buffer.append("%3A");
                    continue block27;
                }
                case 59: {
                    buffer.append("%3B");
                    continue block27;
                }
                case 61: {
                    buffer.append("%3D");
                    continue block27;
                }
                case 63: {
                    buffer.append("%3F");
                    continue block27;
                }
                case 64: {
                    buffer.append("%40");
                    continue block27;
                }
                case 32: {
                    buffer.append("%20");
                    continue block27;
                }
                case 34: {
                    buffer.append("%22");
                    continue block27;
                }
                case 60: {
                    buffer.append("%3C");
                    continue block27;
                }
                case 62: {
                    buffer.append("%3E");
                    continue block27;
                }
                case 35: {
                    buffer.append("%23");
                    continue block27;
                }
                case 37: {
                    buffer.append("%25");
                    continue block27;
                }
                case 123: {
                    buffer.append("%7B");
                    continue block27;
                }
                case 125: {
                    buffer.append("%7D");
                    continue block27;
                }
                case 124: {
                    buffer.append("%7C");
                    continue block27;
                }
                case 92: {
                    buffer.append("%5C");
                    continue block27;
                }
                case 94: {
                    buffer.append("%5E");
                    continue block27;
                }
                case 126: {
                    buffer.append("%7E");
                    continue block27;
                }
                case 91: {
                    buffer.append("%5B");
                    continue block27;
                }
                case 93: {
                    buffer.append("%5D");
                    continue block27;
                }
                case 96: {
                    buffer.append("%60");
                    continue block27;
                }
                default: {
                    if (test < 32) {
                        buffer.append('%');
                        buffer.append(Integer.toHexString(test));
                        continue block27;
                    }
                    if (test > 127) {
                        buffer.append('%');
                        buffer.append(Integer.toHexString(test));
                        continue block27;
                    }
                    buffer.append((char)test);
                }
            }
        }
        String res = buffer.toString();
        buffer = null;
        return res;
    }

    public static StringBuffer urlAppendParameter(String url, String parameter, String value) {
        StringBuffer buffer = new StringBuffer(url);
        if (parameter.length() > 0 && value.length() > 0) {
            buffer.ensureCapacity(url.length() + parameter.length() + value.length());
            char separator = '?';
            if (url.lastIndexOf(63) >= 0) {
                separator = '&';
            }
            buffer.append(separator);
            buffer.append(parameter);
            buffer.append("=");
            buffer.append(value);
        }
        return buffer;
    }

    public static StringBuffer urlAppendParameter(StringBuffer url, String parameter, String value) {
        if (parameter != null && parameter.length() > 0 && value != null && value.length() > 0) {
            char separator = '?';
            if (url.toString().lastIndexOf(63) >= 0) {
                separator = '&';
            }
            url.append(separator);
            url.append(parameter);
            url.append("=");
            url.append(value);
        }
        return url;
    }

    public static boolean isEqual(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(int[] a, int[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(Integer[] a, Integer[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static Vector returnCopyOf(Vector oldVector) {
        Vector newVector = new Vector(oldVector.size());
        Enumeration e = oldVector.elements();
        while (e.hasMoreElements()) {
            newVector.addElement(e.nextElement());
        }
        return newVector;
    }

    public static Vector returnCopyOfChannelVector(Vector oldVector) {
        Vector<Channel> newVector = new Vector<Channel>(oldVector.size());
        Enumeration e = oldVector.elements();
        while (e.hasMoreElements()) {
            Channel c = (Channel)e.nextElement();
            newVector.addElement(new Channel(c));
        }
        return newVector;
    }

    public static boolean isContainingIdenticalData(Vector a, Vector b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.elementAt(i) == b.elementAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainingEqualData(Vector a, Vector b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.elementAt(i).equals(b.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getFormatedTime(Date time) {
        String minute;
        Calendar cal = Utils.getDate(time);
        String hour = Integer.toString(cal.get(11));
        if (hour.length() < 2) {
            hour = "0" + hour;
        }
        if ((minute = Integer.toString(cal.get(12))).length() < 2) {
            minute = "0" + minute;
        }
        return hour + ":" + minute;
    }

    public static int getNumberKey(int keyCode) {
        int numberKeyPressed = -1;
        switch (keyCode) {
            case 48: {
                numberKeyPressed = 0;
                break;
            }
            case 49: {
                numberKeyPressed = 1;
                break;
            }
            case 50: {
                numberKeyPressed = 2;
                break;
            }
            case 51: {
                numberKeyPressed = 3;
                break;
            }
            case 52: {
                numberKeyPressed = 4;
                break;
            }
            case 53: {
                numberKeyPressed = 5;
                break;
            }
            case 54: {
                numberKeyPressed = 6;
                break;
            }
            case 55: {
                numberKeyPressed = 7;
                break;
            }
            case 56: {
                numberKeyPressed = 8;
                break;
            }
            case 57: {
                numberKeyPressed = 9;
                break;
            }
            default: {
                numberKeyPressed = -1;
            }
        }
        return numberKeyPressed;
    }

    public static void sleep(long tm) {
        try {
            Thread.sleep(tm);
        }
        catch (InterruptedException e) {
            Log.exception(class$se$tactel$tvclient$util$Utils == null ? (class$se$tactel$tvclient$util$Utils = Utils.class$("se.tactel.tvclient.util.Utils")) : class$se$tactel$tvclient$util$Utils, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ContentOrderComparator
    implements Comparator {
        public boolean lessThan(Object a, Object b) {
            return ((Content)a).getOrder() < ((Content)b).getOrder();
        }
    }

    public static interface Comparator {
        public boolean lessThan(Object var1, Object var2);
    }
}

