/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class DeluxeMIDlet
extends MIDlet
implements CommandListener {
    private Display mDisplay;
    private Form mMainForm;
    private DeluxeWorker mWorker;
    private WaitCanvas mWaitCanvas;
    private Command mExitCommand;
    private Command mConnectCommand;
    private Command mCancelCommand;

    public void startApp() {
        this.mDisplay = Display.getDisplay((MIDlet)this);
        if (this.mMainForm == null) {
            this.mMainForm = new Form("DeluxeMIDlet");
            this.mMainForm.append((Item)new StringItem("", "Select Connect to make a network connection"));
            this.mExitCommand = new Command("Exit", 7, 0);
            this.mConnectCommand = new Command("Connect", 1, 0);
            this.mMainForm.addCommand(this.mExitCommand);
            this.mMainForm.addCommand(this.mConnectCommand);
            this.mMainForm.setCommandListener((CommandListener)this);
            this.mWaitCanvas = new WaitCanvas();
            this.mCancelCommand = new Command("Cancel", 3, 0);
            this.mWaitCanvas.addCommand(this.mCancelCommand);
            this.mWaitCanvas.setCommandListener(this);
            String string = this.getAppProperty("NetworkThreading.URL");
            this.mWorker = new DeluxeWorker(this, this.mWaitCanvas, string);
            this.mWorker.start();
        }
        this.mDisplay.setCurrent((Displayable)this.mMainForm);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.mExitCommand) {
            this.notifyDestroyed();
        } else if (command == this.mConnectCommand) {
            this.mDisplay.setCurrent((Displayable)this.mWaitCanvas);
            this.mWorker.go();
        } else if (command == this.mCancelCommand) {
            this.mDisplay.setCurrent((Displayable)this.mMainForm);
            this.mWorker.cancel();
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.mWorker.stop();
    }

    public void networkResponse(String string) {
        Alert alert = new Alert("Response", string, null, null);
        alert.setTimeout(-2);
        this.mDisplay.setCurrent(alert, (Displayable)this.mMainForm);
    }

    public void networkException(IOException iOException) {
        Alert alert = new Alert("Exception", iOException.toString(), null, null);
        alert.setTimeout(-2);
        this.mDisplay.setCurrent(alert, (Displayable)this.mMainForm);
    }
}

