/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundManager_MMAPI_MIDP20_Runnable
implements ISoundManager,
Runnable {
    private static String[] musicFiles = new String[0];
    private static long[] musicDurations = null;
    private static long curDuration = 0L;
    private static int curDurationIndex = 0;
    private static Thread musicDurationThread = null;
    private static boolean isSoundActivated = false;
    private static int playerState = 3;
    private static int playerActiveState = 0;
    private static int threadHashCode = -1;
    private static Player soundPlayer = null;
    private static int lastSoundIndex = -1;
    private static int soundIndex = -1;
    private static boolean lastLoopMusicIsLoop = false;
    private static boolean lastLoopMusicNeedResume = false;
    private static int volumeLevel = 100;
    private InputStream _soundIS = null;
    private static int mainCount = 0;
    private static int curSoundIndex = 0;
    private static boolean curLoop = false;
    private static Thread workThread = null;
    private Player plFix = null;
    public static final byte[] silenceSoundBinary = new byte[]{77, 84, 104, 100, 0, 0, 0, 6, 0, 1, 0, 2, 3, -64, 77, 84, 114, 107, 0, 0, 0, 73, 0, -1, 3, 8, 117, 110, 116, 105, 116, 108, 101, 100, 0, -1, 2, 32, 70, 105, 108, 101, 32, 103, 101, 110, 101, 114, 97, 116, 101, 100, 32, 98, 121, 32, 110, 45, 84, 114, 97, 99, 107, 32, 83, 116, 117, 100, 105, 111, 0, -1, 89, 2, 0, 0, 0, -1, 81, 3, 7, 83, 0, 0, -1, 88, 4, 4, 2, 24, 8, 0, -1, 47, 0, 77, 84, 114, 107, 0, 0, 0, 58, 0, -1, 3, 12, 77, 73, 68, 73, 32, 84, 114, 97, 99, 107, 32, 50, 0, -1, 4, 12, 77, 73, 68, 73, 32, 84, 114, 97, 99, 107, 32, 50, 0, -55, 0, 0, -71, 7, 127, 0, -71, 93, -1, 0, -71, 91, -1, 0, -71, 10, 63, 0, -55, 0, 0, -1, 47, 0};
    private PlayerListener playerListenerFix = new PlayerListener(){

        public void playerUpdate(Player player, String string, Object object) {
            if (string.equals("deviceAvailable")) {
                playerState = 0;
            } else if (string.equals("deviceUnavailable")) {
                playerState = 1;
            }
        }
    };
    public PlayerListener playerListener = new PlayerListener(){

        public void playerUpdate(Player player, String string, Object object) {
            if (string.equals("deviceAvailable") || string.equals("stopped") || string.equals("error") || string.equals("endOfMedia")) {
                playerState = 0;
            } else if (string.equals("deviceUnavailable")) {
                SoundManager_MMAPI_MIDP20_Runnable.this.pause();
            } else if (string.equals("started")) {
                Scene.instace.songStart();
                playerState = 2;
            }
        }
    };

    public boolean setMusicFiles(String[] files) {
        musicFiles = files;
        musicDurations = null;
        return true;
    }

    public void setSoundEnable(boolean isSoundOn) {
        this.stopSound(0);
        lastSoundIndex = -1;
        isSoundActivated = isSoundOn;
        if (isSoundOn) {
            playerActiveState = 0;
            playerState = 3;
        }
        if (isSoundOn) {
            if (workThread == null) {
                workThread = new Thread(this);
                workThread.start();
            }
        } else {
            workThread = null;
        }
    }

    public boolean getSoundEnable() {
        return isSoundActivated;
    }

    public boolean setMusicDurations(long[] durations) {
        if (durations == null || musicFiles == null) {
            return false;
        }
        if (durations.length != musicFiles.length) {
            return false;
        }
        musicDurations = new long[durations.length];
        for (int i = 0; i < durations.length; ++i) {
            SoundManager_MMAPI_MIDP20_Runnable.musicDurations[i] = Math.abs(durations[i]);
        }
        return true;
    }

    public boolean getUseMusicDurations() {
        return musicDurations != null;
    }

    public void pause() {
        if (playerActiveState == 1) {
            return;
        }
        playerActiveState = 1;
        if (!isSoundActivated) {
            return;
        }
        if (lastLoopMusicIsLoop) {
            lastLoopMusicNeedResume = true;
        }
        this.stopSound(lastSoundIndex);
        playerState = 1;
    }

    public void resume(boolean isResumeMusic) {
        if (playerActiveState == 0) {
            return;
        }
        playerActiveState = 0;
        playerState = 3;
        if (!isSoundActivated) {
            return;
        }
        if (lastLoopMusicNeedResume) {
            lastLoopMusicNeedResume = false;
            if (isResumeMusic) {
                this.playSound(lastSoundIndex, true);
            }
        }
    }

    public int getPlayerState() {
        return playerState;
    }

    public boolean isPlayerStateBlocked() {
        return playerState == 1;
    }

    public int getLastSoundIndex() {
        return lastSoundIndex;
    }

    public int getVolume() {
        return volumeLevel;
    }

    public boolean setVolume(int value) {
        volumeLevel = value;
        try {
            ((VolumeControl)soundPlayer.getControl("VolumeControl")).setLevel(value);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean playSound(int index, boolean loop) {
        if (!isSoundActivated || index < 0 || index >= musicFiles.length || playerState == 1 || playerActiveState == 1) {
            return false;
        }
        if (loop && lastLoopMusicIsLoop && index == lastSoundIndex && this.getPlayerState() == 2) {
            return true;
        }
        lastSoundIndex = index;
        soundIndex = index;
        curSoundIndex = index;
        curLoop = loop;
        ++mainCount;
        return true;
    }

    public void run() {
        threadHashCode = Thread.currentThread().getClass().hashCode();
        while (isSoundActivated && threadHashCode == Thread.currentThread().getClass().hashCode()) {
            if (mainCount > 0) {
                if (this.plFix == null) {
                    DataInputStream inputStream = null;
                    try {
                        inputStream = new DataInputStream(new ByteArrayInputStream(silenceSoundBinary));
                        this.plFix = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                        this.plFix.addPlayerListener(this.playerListenerFix);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    inputStream = null;
                }
                this.stopSound(lastSoundIndex);
                this.prefetchSound(curSoundIndex);
                lastLoopMusicIsLoop = curLoop;
                try {
                    soundPlayer.realize();
                    soundPlayer.addPlayerListener(this.playerListener);
                    if (curLoop) {
                        soundPlayer.setLoopCount(-1);
                    } else {
                        soundPlayer.setLoopCount(1);
                    }
                    if (playerState == 1 || playerActiveState == 1) {
                        mainCount = 0;
                        playerActiveState = 0;
                        this.pause();
                        return;
                    }
                    soundPlayer.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                mainCount = 0;
            }
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean prefetchSound(int index) {
        block14: {
            this._soundIS = this.getClass().getResourceAsStream(musicFiles[index]);
            try {
                if (musicFiles[index].toLowerCase().endsWith(".wav")) {
                    soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)"audio/x-wav");
                    soundPlayer.prefetch();
                    break block14;
                }
                if (musicFiles[index].toLowerCase().endsWith(".mp3")) {
                    try {
                        soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)"audio/mpeg");
                    }
                    catch (MediaException mex) {
                        soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)"audio/mp3");
                    }
                    soundPlayer.prefetch();
                    break block14;
                }
                if (musicFiles[index].toLowerCase().endsWith(".amr")) {
                    soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)"audio/amr");
                    soundPlayer.prefetch();
                } else if (musicFiles[index].toLowerCase().endsWith(".mid")) {
                    soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)"audio/midi");
                    soundPlayer.prefetch();
                } else {
                    soundPlayer = Manager.createPlayer((InputStream)this._soundIS, (String)"audio/midi");
                    soundPlayer.prefetch();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    this._soundIS.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
                this._soundIS = null;
                return false;
            }
        }
        try {
            this._soundIS.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this._soundIS = null;
        return true;
    }

    public void stopSound(int index) {
        lastLoopMusicIsLoop = false;
        try {
            if (soundPlayer != null) {
                soundPlayer.stop();
                soundPlayer.deallocate();
                soundPlayer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this._soundIS != null) {
                this._soundIS.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._soundIS = null;
        soundPlayer = null;
        if (playerState == 2) {
            playerState = 3;
        }
    }
}

