/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas;

import com.pacmobile.yp.mypcard.rms.LanguageRMS;
import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.utility.Locale;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreenCanvas
extends BaseCanvas {
    private Image splashTitleImage = null;
    private Image splashImage = null;
    private Image splashTextImage = null;

    public SplashScreenCanvas() {
        System.gc();
        LanguageRMS.loadLanguage();
        try {
            if (Locale.getDefaultLocale().equals(Locale.localeZH)) {
                this.splashTitleImage = Image.createImage((String)"/images/splash_title_chi.png");
                this.splashTextImage = Image.createImage((String)"/images/splash_yp_chi.png");
            } else {
                this.splashTitleImage = Image.createImage((String)"/images/splash_title_eng.png");
                this.splashTextImage = Image.createImage((String)"/images/splash_yp_eng.png");
            }
            this.splashImage = Image.createImage((String)"/images/splash.png");
        }
        catch (Exception e) {
            System.out.println("Cannot load splashImage: " + e);
        }
    }

    public void draw() {
        Graphics g = this.getStaticGraphics();
        if (g != null) {
            g.setColor(Color.DEFAULT_BACKGROUNG_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int y = 0;
            if (this.splashTitleImage != null) {
                g.drawImage(this.splashTitleImage, 0, 0, 20);
                y += this.splashTitleImage.getHeight();
            }
            if (this.splashImage != null) {
                g.drawImage(this.splashImage, 0, y, 20);
            }
            if (this.splashTextImage != null) {
                g.drawImage(this.splashTextImage, 73, 97, 20);
            }
            BaseCanvas.drawDebugMsg(g);
            this.flushGraphics();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.commandListener != null && this.selectCommand != null) {
            this.commandListener.commandAction(this.selectCommand, (Displayable)this);
        }
    }

    public synchronized void unload() {
        this.splashTitleImage = null;
        this.splashImage = null;
        this.splashTextImage = null;
        System.gc();
        super.unload();
    }
}

