/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas.item;

import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItemStyle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageCanvasItem
extends CanvasItem {
    long flashTime = System.currentTimeMillis();
    long flashTimePeriod = 750L;
    boolean flashFlag = false;
    boolean isFlash = false;
    boolean isSmallFont = false;
    boolean isWarning = false;
    Image image = null;

    public ImageCanvasItem(BaseCanvas canvas, Image image, int itemWidth, boolean isSelectable) {
        this(canvas, image, itemWidth, isSelectable, new CanvasItemStyle());
    }

    public ImageCanvasItem(BaseCanvas canvas, Image image, int itemWidth, boolean isSelectable, CanvasItemStyle canvasItemStyle) {
        this(canvas);
        this.setItemWidth(itemWidth);
        this.setSelectable(isSelectable);
        this.image = image;
        this.canvasItemStyle = canvasItemStyle;
    }

    public ImageCanvasItem(BaseCanvas canvas) {
        super(canvas);
        this.setSelectable(false);
    }

    public void setIsFlash(boolean isFlash) {
        this.isFlash = isFlash;
    }

    public boolean isFlash() {
        return this.isFlash;
    }

    public void setIsSmallFont(boolean isSmallFont) {
        this.isSmallFont = isSmallFont;
    }

    public boolean isSmallFont() {
        return this.isSmallFont;
    }

    public void setIsWarning(boolean isWarning) {
        this.isWarning = isWarning;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public int getItemHeight() {
        int height = 0;
        if (this.image != null) {
            height = this.image.getHeight();
        }
        return height;
    }

    public int draw(Graphics g, int x, int y) {
        int initY = y;
        if (g != null) {
            if (this.image != null) {
                x = (this.getItemWidth() - this.image.getWidth()) / 2;
                g.drawImage(this.image, x, y, 20);
            } else {
                System.out.println("image == null");
            }
        }
        return initY + this.getItemHeight();
    }

    public int getItemContentWidth() {
        int result = 0;
        if (this.image != null) {
            result = this.image.getWidth();
        }
        return result;
    }

    public void unload() {
        this.image = null;
        System.gc();
        super.unload();
    }
}

