/*
 * Decompiled with CFR 0.152.
 */
import com.mgie.darkchess.DarkChessConfig;
import com.mgie.lib.MGIEConfig;
import com.mgie.lib.MGIESoundAdvance;
import com.mgie.tools.StringFunction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class GameControl
implements Runnable,
GameConfig,
DarkChessConfig,
MGIEConfig {
    public static GameControl instance;
    public final GameDisplay gameDisplay;
    public GameRes res = null;
    public Thread currentThread;
    public int gameState = 1;
    public int play_action_state = 10;
    public int last_action_state = 10;
    public Displayable lastDisplay;
    public boolean schChangeState;
    public int lastState;
    public int nextState;
    public boolean isRunning = false;
    public boolean isPause = false;
    public int lastKey = 1;
    public int runTick = 0;
    public int counter = 0;
    public int menuIdx;
    public int[] menuTextIdx = new int[0];
    public String[] displayTexts;
    public int pageSize = 0;
    private boolean tryAndBuy = true;

    public GameControl(GameRes gameRes) {
        instance = this;
        this.res = gameRes;
        this.gameDisplay = new GameDisplay(this);
    }

    public void run() {
        Thread thread = Thread.currentThread();
        thread.setPriority(10);
        long l = 0L;
        long l2 = 0L;
        while (this.isRunning && this.currentThread == thread) {
            if (this.isPause) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            l = System.currentTimeMillis();
            try {
                this.updateCore();
                this.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            l2 = 150L - (System.currentTimeMillis() - l);
            if (l2 > 0L) {
                try {
                    Thread.sleep(l2);
                }
                catch (Exception exception) {}
                continue;
            }
            Thread.yield();
        }
        this.endMidlet();
    }

    public void startControl() {
        this.isRunning = true;
        this.currentThread = new Thread(this);
        this.currentThread.start();
        if (this.gameState == 1) {
            this.gameDisplay.loadImage();
        }
        Display.getDisplay((MIDlet)GameMidlet.midlet).setCurrent((Displayable)this.gameDisplay);
    }

    public void resume() {
        this.isPause = false;
        Display.getDisplay((MIDlet)GameMidlet.midlet).setCurrent(this.lastDisplay);
        if (MGIESoundAdvance.soundBuffer != null && this.gameState == 4) {
            this.res.mgsound.play(2, 200, this.res.soundVol * 100 / 5);
        }
    }

    private void print() {
        this.gameDisplay.repaintCanvas();
    }

    private void endMidlet() {
        GameMidlet.midlet.notifyDestroyed();
    }

    private void updateCore() {
        ++this.runTick;
        if (this.changeState()) {
            return;
        }
        if (this.gameDisplay.isLoading) {
            return;
        }
        this.keyAction();
        switch (this.gameState) {
            case 1: {
                if (this.counter++ <= 10) break;
                this.switchState(2);
                break;
            }
            case 6: 
            case 13: {
                this.updateGame();
                break;
            }
            case 12: {
                if (this.counter++ <= 10) break;
                this.endMidlet();
                break;
            }
            case 4: {
                if (!this.tryAndBuy) break;
                if (!GameMidlet.productIsActivated()) {
                    this.initMainMenu_();
                    break;
                }
                this.initMainMenu();
            }
        }
    }

    private void updateGame() {
        switch (this.play_action_state) {
            case 12: {
                this.initNewGame();
                break;
            }
            case 13: {
                break;
            }
            case 11: {
                this.updateController();
                break;
            }
            case -1: {
                if (this.counter++ <= 2) break;
                this.counter = 0;
                this.cupPlay();
                break;
            }
            case -3: 
            case 3: {
                if (this.counter == 0 && MGIESoundAdvance.soundBuffer != null) {
                    this.res.mgsound.play(0, 1, this.res.soundVol * 100 / 5);
                }
                if (this.counter++ <= 4) break;
                this.counter = 0;
                if (this.play_action_state == -3) {
                    this.play_action_state = 1;
                    this.tryAndBuy();
                    break;
                }
                this.play_action_state = -1;
                break;
            }
        }
    }

    private void updateController() {
        this.res.display_chess_map = this.res.drakChessCntrol.getDisplayChessMap();
        this.res.delete_chess_total = this.res.drakChessCntrol.getRivalChessDeleteTotal();
        this.res.player_chess_color = this.res.drakChessCntrol.getPlayerChessColor();
        this.res.lastChess = this.res.drakChessCntrol.getLiseChess();
        if (this.res.drakChessCntrol.checkWin(this.res.drakChessCntrol.getPlayerChessColor())) {
            this.res.player_winner = true;
            int n = this.res.player_rival;
            this.res.winner_count[n] = this.res.winner_count[n] + 1;
            this.saveGame();
            this.play_action_state = 13;
            if (MGIESoundAdvance.soundBuffer != null) {
                this.res.mgsound.play(3, 1, this.res.soundVol * 100 / 5);
            }
            return;
        }
        if (this.res.drakChessCntrol.checkLost(this.res.drakChessCntrol.getPlayerChessColor())) {
            this.res.player_winner = false;
            int n = this.res.player_rival;
            this.res.loser_count[n] = this.res.loser_count[n] + 1;
            this.saveGame();
            this.play_action_state = 13;
            if (MGIESoundAdvance.soundBuffer != null) {
                this.res.mgsound.play(1, 1, this.res.soundVol * 100 / 5);
            }
            return;
        }
        if (this.res.drakChessCntrol.checkStandoff()) {
            int n = this.res.player_rival;
            this.res.loser_count[n] = this.res.loser_count[n] + 1;
            this.saveGame();
            this.play_action_state = 16;
            if (MGIESoundAdvance.soundBuffer != null) {
                this.res.mgsound.play(1, 1, this.res.soundVol * 100 / 5);
            }
            return;
        }
        this.play_action_state = this.res.drakChessCntrol.getTurnState();
        this.tryAndBuy();
    }

    private void cupPlay() {
        this.play_action_state = this.res.drakChessCntrol.AIRunning(this.play_action_state);
    }

    private void tryAndBuy() {
        if (this.play_action_state == 1 && !GameMidlet.productIsActivated()) {
            GameMidlet.deductPlayerCount();
            if (GameMidlet.playerCount < 0) {
                GameMidlet.showBuyPage();
                this.switchState(4);
                return;
            }
        }
    }

    private void keyAction() {
        if (!this.gameDisplay.handleKey()) {
            return;
        }
        if (!GameMidlet.productIsActivated()) {
            this.inputMagicKey();
        }
        switch (this.gameState) {
            case 2: {
                this.inputPressAnyKey();
                break;
            }
            case 3: {
                this.inputEnableSound();
                break;
            }
            case 4: {
                this.inputMenuMenu();
                break;
            }
            case 5: {
                this.inputQuit();
                break;
            }
            case 6: 
            case 13: {
                this.inputGame();
                break;
            }
            case 8: {
                this.inputSetting();
                break;
            }
            case 7: 
            case 9: {
                this.inputPage();
                break;
            }
            case 10: {
                this.inputSeleteRole();
                break;
            }
            case 11: {
                this.inputBalance();
                break;
            }
            case 14: {
                this.inputSaveGame();
                break;
            }
            case 15: {
                this.inputMagicKey();
            }
        }
    }

    private void inputMagicKey() {
        int n = this.gameDisplay.schKeyIdx;
        switch (n) {
            case 18: 
            case 21: 
            case 23: {
                break;
            }
            case 22: {
                break;
            }
            case 0: {
                GameMidlet.keyPressed(0);
                break;
            }
            case 1: {
                GameMidlet.keyPressed(1);
                break;
            }
            case 2: {
                GameMidlet.keyPressed(2);
                break;
            }
            case 3: {
                GameMidlet.keyPressed(3);
                break;
            }
            case 4: {
                GameMidlet.keyPressed(4);
                break;
            }
            case 6: {
                GameMidlet.keyPressed(5);
                break;
            }
            case 5: {
                GameMidlet.keyPressed(6);
                break;
            }
            case 7: {
                GameMidlet.keyPressed(7);
                break;
            }
            case 8: {
                GameMidlet.keyPressed(8);
                break;
            }
            case 9: {
                GameMidlet.keyPressed(9);
                break;
            }
            case 14: {
                GameMidlet.keyPressed(10);
                break;
            }
            case 15: {
                GameMidlet.keyPressed(11);
                break;
            }
            case 16: {
                GameMidlet.keyPressed(12);
                break;
            }
            case 17: {
                GameMidlet.keyPressed(13);
                break;
            }
            case 19: {
                GameMidlet.keyPressed(14);
                break;
            }
            case 20: {
                GameMidlet.keyPressed(15);
            }
        }
    }

    private void inputGame() {
        switch (this.play_action_state) {
            case 10: {
                if (this.gameDisplay.up || this.gameDisplay.down) {
                    this.res.player_first = !this.res.player_first;
                    break;
                }
                if (this.gameDisplay.fire || this.gameDisplay.softL) {
                    this.play_action_state = this.res.drakChessCntrol.selectFirstPlayer(this.res.player_first);
                    if (GameMidlet.productIsActivated()) break;
                    GameMidlet.resetPlayerCount(this.res.player_first);
                    break;
                }
                if (!this.gameDisplay.softR) break;
                this.switchState(4);
                break;
            }
            case 13: 
            case 16: {
                if (!this.gameDisplay.fire && !this.gameDisplay.softL) break;
                if (MGIESoundAdvance.soundBuffer != null) {
                    this.res.mgsound.stop();
                }
                this.play_action_state = 12;
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                if (!this.res.drakChessCntrol.checkMyTurn()) {
                    return;
                }
                if (this.gameDisplay.softR) {
                    this.last_action_state = this.play_action_state;
                    this.play_action_state = 14;
                    break;
                }
                if (this.gameDisplay.fire || this.gameDisplay.softL) {
                    if (this.play_action_state == 1) {
                        this.play_action_state = this.res.drakChessCntrol.checkInputForMoveState(this.res.game_row, this.res.game_col);
                        if (this.play_action_state != 2) break;
                        this.res.attack_chess_col = this.res.game_col;
                        this.res.attack_chess_row = this.res.game_row;
                        break;
                    }
                    if (this.play_action_state != 2) break;
                    this.play_action_state = this.res.drakChessCntrol.checkInputForChooseState(this.res.game_row, this.res.game_col);
                    break;
                }
                if (this.gameDisplay.left) {
                    if (this.res.game_col <= 0) break;
                    --this.res.game_col;
                    break;
                }
                if (this.gameDisplay.right) {
                    if (this.res.game_col >= 3) break;
                    ++this.res.game_col;
                    break;
                }
                if (this.gameDisplay.up) {
                    if (this.res.game_row <= 0) break;
                    --this.res.game_row;
                    break;
                }
                if (!this.gameDisplay.down || this.res.game_row >= 7) break;
                ++this.res.game_row;
                break;
            }
            case 14: {
                if (this.gameDisplay.softR) {
                    this.play_action_state = this.last_action_state;
                    break;
                }
                if (this.gameDisplay.up) {
                    --this.menuIdx;
                    if (this.menuIdx >= 0) break;
                    this.menuIdx = this.menuTextIdx.length - 1;
                    break;
                }
                if (this.gameDisplay.down) {
                    ++this.menuIdx;
                    if (this.menuIdx <= this.menuTextIdx.length - 1) break;
                    this.menuIdx = 0;
                    break;
                }
                if (!this.gameDisplay.fire && !this.gameDisplay.softL) break;
                switch (this.menuTextIdx[this.menuIdx]) {
                    case 20: {
                        this.play_action_state = this.last_action_state;
                        break;
                    }
                    case 21: {
                        this.switchState(14);
                        break;
                    }
                    case 22: {
                        this.play_action_state = 15;
                    }
                }
                break;
            }
            case 15: {
                if (this.gameDisplay.softR) {
                    this.play_action_state = this.last_action_state;
                    break;
                }
                if (!this.gameDisplay.fire && !this.gameDisplay.softL) break;
                this.switchState(12);
            }
        }
    }

    private void inputSaveGame() {
        if (this.gameDisplay.softR) {
            this.res.continue_game = false;
            this.saveGame();
            this.switchState(4);
        } else if ((this.gameDisplay.fire || this.gameDisplay.softL) && !this.res.game_saving) {
            this.res.game_saving = true;
            this.res.drakChessCntrol.saveGame();
            this.res.continue_game = true;
            this.saveGame();
            this.switchState(4);
            this.res.game_saving = false;
        }
    }

    private void inputBalance() {
        if (this.gameDisplay.softR) {
            this.switchState(4);
        } else if (this.gameDisplay.left || this.gameDisplay.right) {
            this.res.delete_store = !this.res.delete_store;
        } else if (this.gameDisplay.softL || this.gameDisplay.fire) {
            if (this.res.delete_store) {
                this.initSaveStore();
            }
            this.switchState(4);
        }
    }

    private void inputPressAnyKey() {
        if (!GameMidlet.productIsActivated()) {
            GameMidlet.showBuyPage();
        }
        if (MGIESoundAdvance.soundBuffer != null) {
            this.switchState(3);
        } else {
            this.switchState(4);
        }
    }

    private void inputEnableSound() {
        if (this.gameDisplay.softL || this.gameDisplay.fire) {
            this.res.soundVol = 5;
            this.switchState(4);
        } else if (this.gameDisplay.softR) {
            this.res.soundVol = 0;
            this.switchState(4);
        }
    }

    private void inputQuit() {
        if (this.gameDisplay.softR) {
            this.switchState(4);
        } else if (this.gameDisplay.fire || this.gameDisplay.softL) {
            this.switchState(12);
        }
    }

    private void inputSeleteRole() {
        if (this.gameDisplay.softR) {
            this.switchState(4);
        }
        if (this.gameDisplay.left || this.gameDisplay.right) {
            if (this.gameDisplay.left) {
                --this.menuIdx;
                if (this.menuIdx < 0) {
                    this.menuIdx = this.menuTextIdx.length - 1;
                }
            } else if (this.gameDisplay.right) {
                ++this.menuIdx;
                if (this.menuIdx > this.menuTextIdx.length - 1) {
                    this.menuIdx = 0;
                }
            }
        } else if (this.gameDisplay.fire || this.gameDisplay.softL) {
            switch (this.menuTextIdx[this.menuIdx]) {
                case 10: 
                case 11: 
                case 12: {
                    this.res.player_rival = this.menuIdx;
                    this.res.drakChessCntrol.setPlayerRivalID(this.res.player_rival);
                    this.switchState(6);
                }
            }
        }
    }

    private void inputSetting() {
        if (this.gameDisplay.softR || this.gameDisplay.softL || this.gameDisplay.fire) {
            this.res.soundVol = this.menuIdx;
            this.switchState(4);
        }
        if (this.gameDisplay.right) {
            if (this.menuIdx < 5) {
                ++this.menuIdx;
            }
        } else if (this.gameDisplay.left && this.menuIdx > 0) {
            --this.menuIdx;
        }
    }

    private void inputMenuMenu() {
        if (this.gameDisplay.softR) {
            this.switchState(5);
        }
        if (this.gameDisplay.left || this.gameDisplay.right) {
            if (this.gameDisplay.left) {
                --this.menuIdx;
                if (this.menuIdx < 0) {
                    this.menuIdx = this.menuTextIdx.length - 1;
                }
            } else if (this.gameDisplay.right) {
                ++this.menuIdx;
                if (this.menuIdx > this.menuTextIdx.length - 1) {
                    this.menuIdx = 0;
                }
            }
        } else if (this.gameDisplay.fire || this.gameDisplay.softL) {
            switch (this.menuTextIdx[this.menuIdx]) {
                case 33: {
                    if (GameMidlet.productIsActivated()) break;
                    GameMidlet.showActivationMainMenu();
                    break;
                }
                case 34: {
                    GameMidlet.showPlatformRequest();
                    break;
                }
                case 2: {
                    this.switchState(10);
                    break;
                }
                case 3: {
                    this.switchState(7);
                    break;
                }
                case 4: {
                    this.switchState(8);
                    break;
                }
                case 5: {
                    this.switchState(9);
                    break;
                }
                case 6: {
                    this.switchState(5);
                    break;
                }
                case 14: {
                    this.switchState(11);
                    break;
                }
                case 29: {
                    this.switchState(13);
                    break;
                }
                case 35: {
                    this.switchState(15);
                }
            }
        }
    }

    private void inputPage() {
        if (this.gameDisplay.softR) {
            this.switchState(4);
        } else {
            this.controlScroll(9);
        }
    }

    private void controlScroll(int n) {
        this.controlScroll(n, this.displayTexts.length);
    }

    private void controlScroll(int n, int n2) {
        int n3 = n2 - n + 1;
        if (n3 > 1) {
            if (this.gameDisplay.up) {
                this.menuIdx = (this.menuIdx - 1 + n3) % n3;
            } else if (this.gameDisplay.down) {
                this.menuIdx = (this.menuIdx + 1) % n3;
            } else if (this.gameDisplay.left) {
                this.menuIdx = Math.max(0, this.menuIdx - n);
            } else if (this.gameDisplay.right) {
                this.menuIdx = Math.min(this.menuIdx + n, n3 - 1);
            }
        }
    }

    public void switchState(int n) {
        this.schChangeState = true;
        this.nextState = n;
    }

    public void stateChangeAction_BeforeLoad() {
        this.counter = 0;
        this.menuIdx = 0;
        this.runTick = 0;
        switch (this.gameState) {
            case 1: {
                break;
            }
            case 4: {
                if (!GameMidlet.productIsActivated()) {
                    this.initMainMenu_();
                    break;
                }
                this.initMainMenu();
                break;
            }
            case 10: 
            case 11: {
                this.menuTextIdx = new int[]{10, 11, 12};
                this.res.delete_store = false;
                break;
            }
            case 8: {
                this.menuIdx = this.res.soundVol;
                break;
            }
            case 6: 
            case 13: {
                this.menuTextIdx = new int[]{20, 21, 22};
            }
        }
    }

    public boolean changeState() {
        if (this.schChangeState) {
            this.schChangeState = false;
            this.lastState = this.gameState;
            this.gameState = this.nextState;
            this.stateChangeAction_BeforeLoad();
            this.gameDisplay.changeState();
            return true;
        }
        return false;
    }

    public void stateChangeAction_AfterLoad() {
        if (MGIESoundAdvance.soundBuffer != null) {
            this.res.mgsound.stop();
        }
        switch (this.gameState) {
            case 1: {
                break;
            }
            case 4: {
                if (MGIESoundAdvance.soundBuffer == null) break;
                this.res.mgsound.play(2, 200, this.res.soundVol * 100 / 5);
                break;
            }
            case 6: {
                this.initNewGame();
                break;
            }
            case 13: {
                this.initLoadGame();
                break;
            }
            case 8: {
                break;
            }
            case 7: {
                this.initIntroduction();
                break;
            }
            case 9: {
                this.initCredit();
                break;
            }
            case 12: {
                this.initDisplayText(23);
            }
        }
    }

    private void initMainMenu() {
        this.tryAndBuy = false;
        this.menuTextIdx = this.res.continue_game ? (MGIESoundAdvance.soundBuffer != null ? new int[]{2, 29, 3, 14, 4, 5, 34, 6} : new int[]{2, 29, 3, 14, 5, 34, 6}) : (MGIESoundAdvance.soundBuffer != null ? new int[]{2, 3, 14, 4, 5, 34, 6} : new int[]{2, 3, 14, 5, 34, 6});
    }

    private void initMainMenu_() {
        this.menuTextIdx = this.res.continue_game ? (MGIESoundAdvance.soundBuffer != null ? new int[]{2, 29, 3, 14, 4, 5, 33, 34, 6} : new int[]{2, 29, 3, 14, 5, 33, 34, 6}) : (MGIESoundAdvance.soundBuffer != null ? new int[]{2, 3, 14, 4, 5, 33, 34, 6} : new int[]{2, 3, 14, 5, 33, 34, 6});
    }

    private void initNewGame() {
        this.runTick = 0;
        this.res.continue_game = false;
        this.saveGame();
        this.res.drakChessCntrol.initGame();
        this.res.player_first = true;
        this.res.display_chess_map = this.res.drakChessCntrol.getDisplayChessMap();
        this.res.delete_chess_total = this.res.drakChessCntrol.getRivalChessDeleteTotal();
        this.res.game_col = 0;
        this.res.game_row = 0;
        this.res.player_chess_color = 0;
        this.play_action_state = 10;
    }

    private void initLoadGame() {
        if (!this.res.game_loading) {
            this.res.game_loading = true;
            this.res.drakChessCntrol.loadGame();
            this.res.player_first = this.res.drakChessCntrol.getPlayerFirst();
            this.res.display_chess_map = this.res.drakChessCntrol.getDisplayChessMap();
            this.res.delete_chess_total = this.res.drakChessCntrol.getRivalChessDeleteTotal();
            this.res.game_col = 0;
            this.res.game_row = 0;
            this.res.player_chess_color = this.res.drakChessCntrol.getPlayerChessColor();
            this.res.player_rival = this.res.drakChessCntrol.getPlayerRivalID();
            this.play_action_state = 1;
            this.res.game_loading = false;
        }
    }

    private void initDisplayText(int n) {
        try {
            this.displayTexts = StringFunction.stringToDisplayArray(GameRes.font, GameRes.gameText[n], 216);
            this.menuIdx = 0;
            this.pageSize = this.displayTexts.length - 9 + 1;
            if (this.pageSize < 1) {
                this.pageSize = 1;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void initIntroduction() {
        this.initDisplayText(8);
    }

    private void initCredit() {
        this.initDisplayText(9);
    }

    private void initSaveStore() {
        this.res.winner_count = new int[]{0, 0, 0};
        this.res.loser_count = new int[]{0, 0, 0};
        this.res.continue_game = false;
        this.saveGame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sequenceData() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            int n;
            dataOutputStream.writeBoolean(this.res.continue_game);
            dataOutputStream.writeInt(this.res.winner_count.length);
            for (n = 0; n < this.res.winner_count.length; ++n) {
                dataOutputStream.writeInt(this.res.winner_count[n]);
            }
            dataOutputStream.writeInt(this.res.loser_count.length);
            for (n = 0; n < this.res.loser_count.length; ++n) {
                dataOutputStream.writeInt(this.res.loser_count[n]);
            }
            dataOutputStream.writeInt(GameMidlet.playerCount);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                    dataOutputStream = null;
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        DataInputStream dataInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n;
            this.res.continue_game = dataInputStream.readBoolean();
            int n2 = dataInputStream.readInt();
            this.res.winner_count = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.res.winner_count[n] = dataInputStream.readInt();
            }
            n2 = dataInputStream.readInt();
            this.res.loser_count = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.res.loser_count[n] = dataInputStream.readInt();
            }
            GameMidlet.playerCount = dataInputStream.readInt();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (IOException iOException) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveGame() {
        byte[] byArray = this.sequenceData();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"SAVE_BALANCE_STORE", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGame() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"SAVE_BALANCE_STORE", (boolean)false);
            if (recordStore != null && recordStore.getNumRecords() > 0) {
                this.importData(recordStore.getRecord(1));
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.saveGame();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
        }
    }
}

