/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

class ScreenMenu {
    private final byte[][] FixedMenuItems = new byte[][]{this.LoadText("/res/text_menu_resume"), this.LoadText("/res/text_menu_main"), this.LoadText("/res/text_menu_exit")};
    private byte[][] mMenuItems;
    public boolean ShowAbout = false;
    private int mSelectedItem = 0;
    private Main MainMenuPtr;
    TextHandler txtHandler;
    int smallFontHeight;

    public ScreenMenu(Main ptr, boolean isMainMenu) {
        this.txtHandler = Menu.mMenuPtr.txtHandler;
        this.smallFontHeight = this.txtHandler.font_heights[0];
        this.MainMenuPtr = ptr;
        int size = isMainMenu ? this.FixedMenuItems.length - 1 : this.FixedMenuItems.length;
        this.mMenuItems = new byte[size][];
        int j = 0;
        for (int i = 0; i < this.FixedMenuItems.length; ++i) {
            if (isMainMenu && i == 1) continue;
            this.mMenuItems[j++] = this.FixedMenuItems[i];
        }
    }

    public void SelectNextItem() {
        this.mSelectedItem = (this.mSelectedItem + 1) % this.mMenuItems.length;
    }

    public void SelectPrevItem() {
        --this.mSelectedItem;
        if (this.mSelectedItem < 0) {
            this.mSelectedItem += this.mMenuItems.length;
        }
    }

    public boolean FireCurrentItem() {
        switch (this.mSelectedItem) {
            case 0: {
                return true;
            }
            case 1: {
                if (this.mMenuItems.length > 2) {
                    this.MainMenuPtr.CloseScreen = true;
                    break;
                }
            }
            case 2: {
                Menu.Exit = true;
            }
        }
        return false;
    }

    public void DrawMenu(Graphics g, int width, int height) {
        int i;
        int[] yArr = new int[this.mMenuItems.length];
        g.setColor(0);
        g.fillRect(10, 160, width - 20, 80);
        g.setColor(255, 255, 255);
        g.drawRect(10, 160, width - 20, 80);
        yArr[0] = 179;
        for (i = 1; i < yArr.length; ++i) {
            yArr[i] = yArr[i - 1] + this.smallFontHeight + 5;
        }
        g.setColor(0xFF6600);
        g.fillRect(10 + (width - 20) / 4, yArr[this.mSelectedItem], (width - 20) / 2, this.smallFontHeight);
        for (i = 0; i < this.mMenuItems.length; ++i) {
            this.txtHandler.paintText(g, 0, this.mMenuItems[i], width / 2 + this.txtHandler.getTextWidth(0, this.mMenuItems[i]) / 2, yArr[i], width, height);
        }
    }

    private byte[] LoadText(String DetText) {
        byte[] ret = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(DetText);
            int s = is.read() + is.read() * 256;
            ret = new byte[s];
            is.read(ret);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ret;
    }
}

