/*
 * Decompiled with CFR 0.152.
 */
package actions.settings;

import actions.settings.Setting;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import util.FindFilter;

public class SettingByRMS {
    private static SettingByRMS settingByRms;
    private String recordStoreName = "SettingConfig";
    private RecordStore rs;

    public static SettingByRMS getInstance() {
        if (settingByRms == null) {
            settingByRms = new SettingByRMS();
        }
        return settingByRms;
    }

    public RecordStore openRecordStore() {
        if (this.recordStoreName == null) {
            throw new RuntimeException("\u5c1a\u672a\u6307\u5b9a\u66f8\u7c3d\u3002");
        }
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true, (int)0, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return rs;
    }

    public void closeRecordStore(RecordStore rs) {
        try {
            rs.closeRecordStore();
        }
        catch (Exception e) {
            throw new RuntimeException("Error when closing record store!" + e.toString());
        }
    }

    public void delteRecordStore() {
        RecordStore rs = this.openRecordStore();
        try {
            rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)this.recordStoreName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when deleting record store!\n" + e.toString());
        }
    }

    public Setting[] checkSetting() {
        Vector<Setting> result = new Vector<Setting>();
        RecordStore rs = this.openRecordStore();
        RecordEnumeration re = null;
        try {
            re = rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreNotOpenException e) {
            throw new RuntimeException("Error when getting enumer!\n" + e.toString());
        }
        if (re.numRecords() > 0) {
            int recordId = 0;
            byte[] rec = null;
            try {
                recordId = re.nextRecordId();
            }
            catch (InvalidRecordIDException e) {
                e.printStackTrace();
            }
            try {
                rec = rs.getRecord(recordId);
            }
            catch (RecordStoreNotOpenException e) {
                e.printStackTrace();
            }
            catch (InvalidRecordIDException e) {
                e.printStackTrace();
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
            Setting setting = null;
            try {
                setting = Setting.deserialize(rec);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            setting = new Setting(setting.getType(), setting.getAutoJetso(), setting.getAutoRunHSBC(), setting.getIsVibrationAlert(), setting.getIsSoundAlert(), setting.getDefaultLang(), setting.getUpdateBookMark());
            result.addElement(setting);
        }
        try {
            rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        Object[] setting = new Setting[result.size()];
        result.copyInto(setting);
        return setting;
    }

    public void InitRecordStore(int i) {
        RecordStore rs;
        byte[] rec = null;
        if (i == 0) {
            rs = this.openRecordStore();
            Setting settings = new Setting("system", "N", "N", "Y", "Y", "CH", "N");
            try {
                rec = settings.serialize();
                rs.addRecord(rec, 0, rec.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.closeRecordStore(rs);
        }
        if (i == 1) {
            rs = this.openRecordStore();
            FindFilter rf = new FindFilter("system");
            RecordEnumeration re1 = null;
            try {
                re1 = rs.enumerateRecords((RecordFilter)rf, null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (re1.numRecords() > 0) {
                Object setting = null;
                byte[] rec3 = null;
                try {
                    int recordId = re1.nextRecordId();
                    rec3 = rs.getRecord(recordId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.closeRecordStore(rs);
        }
    }

    public static SettingByRMS getSettingByRms() {
        return settingByRms;
    }

    public static void setSettingByRms(SettingByRMS settingByRms) {
        SettingByRMS.settingByRms = settingByRms;
    }

    public String getRecordStoreName() {
        return this.recordStoreName;
    }

    public void setRecordStoreName(String recordStoreName) {
        this.recordStoreName = recordStoreName;
    }

    public RecordStore getRs() {
        return this.rs;
    }

    public void setRs(RecordStore rs) {
        this.rs = rs;
    }
}

