/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene;

import com.pacmobile.yp.mypcard.MYPManager;
import com.pacmobile.yp.mypcard.scene.DisplayMypCardScene;
import com.pacmobile.yp.mypcard.scene.HelpScene;
import com.pacmobile.yp.mypcard.scene.InternetSettingScene;
import com.pacmobile.yp.mypcard.scene.LoginScene;
import com.pacmobile.yp.mypcard.scene.MainMenuScene;
import com.pacmobile.yp.mypcard.scene.PersonalDetailUpdateScene;
import com.pacmobile.yp.mypcard.scene.PreferencesScene;
import com.pacmobile.yp.mypcard.scene.Scene;
import com.pacmobile.yp.mypcard.scene.SplashScreenScene;
import javax.microedition.midlet.MIDlet;

public class SceneController {
    public static final String SPLASH_SCREEN_SCENE_NAME = "SplashScreenScene";
    public static final String LOGIN_SCENE_NAME = "LoginScene";
    public static final String MAIN_MENU_SCENE_NAME = "MainMenuScene";
    public static final String DISPLAY_MYP_CARD_SCENE_NAME = "DisplayMypCardScene";
    public static final String PREFERENCES_SCENE_NAME = "PreferencesScene";
    public static final String INTERNET_SETTING_SCENE_NAME = "InternetSettingScene";
    public static final String PERONAL_DETAIL_UPDATE_SCENE_NAME = "PersonalDetailUpdateScene";
    public static final String HELP_SCENE_NAME = "HelpScene";
    private static SceneController controller = null;
    private static MIDlet midlet = null;
    private String className = this.getClass().getName();
    private Scene splashScreenScene = null;
    private Scene loginScene = null;
    private Scene mainMenuScene = null;
    private Scene displayMypCardScene = null;
    private Scene preferencesScene = null;
    private Scene internetSettingScene = null;
    private Scene personalDetailUpdateScene = null;
    private Scene helpScene = null;

    private SceneController() {
    }

    public void destroy() {
        controller = null;
    }

    public static synchronized SceneController getInstance() {
        if (controller == null) {
            controller = new SceneController();
        }
        return controller;
    }

    public static void init(MIDlet parent) {
        midlet = parent;
    }

    public Scene getScene(String sceneInstanceName) {
        Scene scene = null;
        if (sceneInstanceName == null || sceneInstanceName.length() <= 0) {
            return null;
        }
        if (sceneInstanceName.equals(MAIN_MENU_SCENE_NAME)) {
            if (this.mainMenuScene != null) {
                this.mainMenuScene.unload();
                this.mainMenuScene = null;
            }
            scene = this.mainMenuScene = new MainMenuScene();
        } else if (sceneInstanceName.equals(LOGIN_SCENE_NAME)) {
            if (this.loginScene != null) {
                this.loginScene.unload();
                this.loginScene = null;
            }
            scene = this.loginScene = new LoginScene();
        } else if (sceneInstanceName.equals(SPLASH_SCREEN_SCENE_NAME)) {
            if (this.splashScreenScene != null) {
                this.splashScreenScene.unload();
                this.splashScreenScene = null;
            }
            scene = this.splashScreenScene = new SplashScreenScene();
        } else if (sceneInstanceName.equals(PREFERENCES_SCENE_NAME)) {
            if (this.preferencesScene != null) {
                this.preferencesScene.unload();
                this.preferencesScene = null;
            }
            scene = this.preferencesScene = new PreferencesScene();
        } else if (sceneInstanceName.equals(DISPLAY_MYP_CARD_SCENE_NAME)) {
            if (this.displayMypCardScene != null) {
                this.displayMypCardScene.unload();
                this.displayMypCardScene = null;
            }
            scene = this.displayMypCardScene = new DisplayMypCardScene();
        } else if (sceneInstanceName.equals(INTERNET_SETTING_SCENE_NAME)) {
            if (this.internetSettingScene != null) {
                this.internetSettingScene.unload();
                this.internetSettingScene = null;
            }
            scene = this.internetSettingScene = new InternetSettingScene();
        } else if (sceneInstanceName.equals(PERONAL_DETAIL_UPDATE_SCENE_NAME)) {
            if (this.personalDetailUpdateScene != null) {
                this.personalDetailUpdateScene.unload();
                this.personalDetailUpdateScene = null;
            }
            scene = this.personalDetailUpdateScene = new PersonalDetailUpdateScene();
        } else if (sceneInstanceName.equals(HELP_SCENE_NAME)) {
            if (this.helpScene != null) {
                this.helpScene.unload();
                this.helpScene = null;
            }
            scene = this.helpScene = new HelpScene();
        }
        System.gc();
        return scene;
    }

    public synchronized void forward(String forwardSceneInstanceName, Scene scene) {
        Scene forwardScene = this.getScene(forwardSceneInstanceName);
        forwardScene.setIsDrawingDisabled(true);
        if (forwardScene != null) {
            if (forwardScene instanceof MainMenuScene && scene instanceof LoginScene) {
                ((MainMenuScene)forwardScene).setIsNewlyReg(true);
                ((MainMenuScene)forwardScene).loadPage();
            } else if (scene instanceof MainMenuScene && forwardScene instanceof LoginScene) {
                ((LoginScene)forwardScene).setState(LoginScene.STATE_CONGRATULATION);
                ((LoginScene)forwardScene).loadPage();
            } else if (forwardScene instanceof PreferencesScene && scene instanceof PersonalDetailUpdateScene) {
                if (((PersonalDetailUpdateScene)scene).isUpdated()) {
                    ((PreferencesScene)forwardScene).setIsPersonalDetailUpdated(true);
                    ((PreferencesScene)forwardScene).loadPage();
                }
            } else if (forwardScene instanceof HelpScene && scene instanceof DisplayMypCardScene) {
                forwardScene.setPrevSceneName(DISPLAY_MYP_CARD_SCENE_NAME);
            }
            forwardScene.setDisplayHandle(midlet);
            MYPManager.getInstance().setActiveScene(forwardScene);
            MYPManager.getInstance().displayActiveScene();
            forwardScene.display();
        }
        try {
            if (scene != null) {
                scene.unload();
                scene = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }
}

