/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas;

import com.pacmobile.yp.mypcard.MYPConstants;
import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.utility.Locale;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LoginCanvas
extends BaseCanvas {
    Font font = Font.getFont((int)0);
    int fontColor = Color.DEFAULT_ITEM_FONT_COLOR;
    Image headerImage = null;
    Image headerChiImage = null;
    Image headerEngImage = null;
    int itemsOffsetY = MYPConstants.ITEM_OFFSET_Y;

    public LoginCanvas() {
        System.gc();
        this.setDrawableHeight(this.getHeight() - this.itemsOffsetY - this.getSoftKeyBarHeight());
        this.setDrawableWidth(this.getWidth() - this.getScrollBarWidth());
        this.setDrawableX(0);
        this.setDrawableY(0);
        this.setContentRelativeY(0);
        try {
            this.headerChiImage = Image.createImage((String)"/images/header_chi.png");
            this.headerEngImage = Image.createImage((String)"/images/header_eng.png");
            this.headerImage = Locale.getDefaultLocale().equals(Locale.localeEN) ? this.headerEngImage : this.headerChiImage;
        }
        catch (Exception e) {
            System.out.println("Cannot load headerImage: " + e);
        }
        if (this.headerImage != null) {
            this.setDrawableHeight(this.getHeight() - this.itemsOffsetY - this.getSoftKeyBarHeight());
            this.setDrawableY(this.itemsOffsetY);
            this.setContentRelativeY(this.itemsOffsetY);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.isDisabled()) {
            return;
        }
        super.keyPressed(keyCode);
        if (this.displayStatus == BaseCanvas.DISPLAY_STATUS_NORMAL) {
            if (keyCode == BaseCanvas.KEY_UP || keyCode == BaseCanvas.KEY_2) {
                this.prevSelectableItem();
            }
            if (keyCode == BaseCanvas.KEY_DOWN || keyCode == BaseCanvas.KEY_8) {
                this.nextSelectableItem();
            }
        }
    }

    public void draw() {
        if (this.isDisabled()) {
            return;
        }
        Graphics g = this.getStaticGraphics();
        if (g != null) {
            this.drawBuffer(g);
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            this.drawSoftKeyBar(g);
            this.drawScrollBar(g, this.getWidth() - this.getScrollBarWidth(), this.itemsOffsetY, this.getItemsHeight(), this.drawableHeight, this.contentRelativeY, this.scrollBarHeight);
            BaseCanvas.drawDebugMsg(g);
            this.flushGraphics();
        }
    }

    public void drawBuffer(Graphics g) {
        this.drawBackground(g);
        int x = 0;
        this.headerImage = Locale.getDefaultLocale().equals(Locale.localeEN) ? this.headerEngImage : this.headerChiImage;
        if (this.headerImage != null) {
            g.drawImage(this.headerImage, 0, 0, 20);
        }
        g.setClip(this.getDrawableX(), this.getDrawableY(), this.getDrawableWidth(), this.getDrawableHeight());
        int y = this.itemsOffsetY + this.getContentRelativeY();
        g.setFont(this.font);
        g.setColor(this.fontColor);
        int i = 0;
        while (i < this.canvasItems.size()) {
            if (this.canvasItems.elementAt(i) != null) {
                y = ((CanvasItem)this.canvasItems.elementAt(i)).draw(g, x, y);
            }
            ++i;
        }
        g.setClip(0, 0, this.getDrawableWidth(), this.getDrawableHeight());
    }

    public synchronized void unload() {
        this.headerChiImage = null;
        this.headerEngImage = null;
        this.font = null;
        System.gc();
        super.unload();
    }
}

