/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitter;

import java.util.Calendar;
import java.util.TimeZone;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import se.vitamin.ui.UI;

public class TimeStamp {
    private long time;
    private static final String JANUARY = "Jan";
    private static final String FEBRUARY = "Feb";
    private static final String MARCH = "Mar";
    private static final String APRIL = "Apr";
    private static final String MAY = "May";
    private static final String JUNE = "Jun";
    private static final String JULY = "Jul";
    private static final String AUGUST = "Aug";
    private static final String SEPTEMBER = "Sep";
    private static final String OCTOBER = "Oct";
    private static final String NOVEMBER = "Nov";
    private static final String DECEMBER = "Dec";
    private static final int MINUTES = 0;
    private static final int HOURS = 2;
    private static final int DAYS = 4;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long HOUR_MILLIS = 3600000L;
    private static final long DAY_MILLIS = 86400000L;
    private static final long HALF_MINUTE_MILLIS = 30000L;
    private static final long HALF_HOUR_MILLIS = 1800000L;
    private static final long HALF_DAY_MILLIS = 43200000L;
    private int right = 24;
    private static int height;
    private static Image[] numbers;
    private static Image[][] labels;
    private static int[] labelint;

    public TimeStamp(String timeStamp) {
        this.time = TimeStamp.getTimeStampLong(timeStamp);
    }

    public static void init() {
        if (numbers == null) {
            numbers = new Image[10];
            for (int i = 0; i < 10; ++i) {
                TimeStamp.numbers[i] = TimeStamp.shrinkText(Integer.toString(i));
            }
            height = (Font.getFont((int)0, (int)0, (int)16).getHeight() + 1) / 2;
        }
        labels = null;
        labels = new Image[6][2];
        for (int i = 0; i < 6; ++i) {
            String s = UI.getString(labelint[i]);
            int index = s.indexOf("$NBR");
            if (index == 0) {
                TimeStamp.labels[i][0] = null;
                TimeStamp.labels[i][1] = TimeStamp.shrinkText(s.substring(4));
                continue;
            }
            if (index == s.length() - 4) {
                TimeStamp.labels[i][0] = TimeStamp.shrinkText(s.substring(0, s.length() - 4));
                TimeStamp.labels[i][1] = null;
                continue;
            }
            TimeStamp.labels[i][0] = TimeStamp.shrinkText(s.substring(0, index));
            TimeStamp.labels[i][1] = TimeStamp.shrinkText(s.substring(index + 4, s.length()));
        }
    }

    public void paint(Graphics g, int x, int y, boolean alignRight, long currentTime) {
        int label;
        int ago;
        if ((currentTime -= this.time) <= 0L) {
            if (currentTime < -60000L) {
                return;
            }
            currentTime = 0L;
        }
        if (currentTime < 3600000L) {
            ago = (int)((currentTime + 30000L) / 60000L);
            if (ago == 0) {
                ago = 1;
            }
            label = 0;
        } else if (currentTime < 86400000L) {
            ago = (int)((currentTime + 1800000L) / 3600000L);
            label = 2;
        } else {
            ago = (int)((currentTime + 43200000L) / 86400000L);
            label = 4;
        }
        if (ago > 1) {
            ++label;
        }
        int order = 10;
        int length = 1;
        while (ago >= order) {
            order *= 10;
            ++length;
        }
        order /= 10;
        if (alignRight) {
            if (labels[label][1] != null) {
                g.drawImage(labels[label][1], x, y, this.right);
                x -= labels[label][1].getWidth();
            }
            for (int i = 0; i < length; ++i) {
                int curr = ago % 10;
                g.drawImage(numbers[curr], x, y, this.right);
                x -= numbers[curr].getWidth();
                ago /= 10;
            }
            if (labels[label][0] != null) {
                g.drawImage(labels[label][0], x, y, this.right);
            }
        } else {
            if (labels[label][0] != null) {
                g.drawImage(labels[label][0], x, y, 0);
                x += labels[label][0].getWidth();
            }
            for (int i = 0; i < length; ++i) {
                int curr = ago / order;
                g.drawImage(numbers[curr], x, y, 0);
                x += numbers[curr].getWidth();
                ago %= order;
                order /= 10;
            }
            if (labels[label][1] != null) {
                g.drawImage(labels[label][1], x, y, 0);
            }
        }
    }

    public int getHeight() {
        return height;
    }

    private static Image shrinkText(String text) {
        int fl;
        Font f = Font.getFont((int)0, (int)0, (int)16);
        int fh = f.getHeight();
        if (fh % 2 == 1) {
            ++fh;
        }
        if ((fl = f.stringWidth(text)) % 2 == 1) {
            ++fl;
        }
        int oh = fh;
        int ow = fl;
        int os = ow * oh;
        int nh = fh / 2;
        int nw = fl / 2;
        int ns = nh * nw;
        Image img = Image.createImage((int)ow, (int)oh);
        Graphics g = img.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, ow, oh);
        g.setColor(0xFFFFFF);
        g.setFont(f);
        g.drawString(text, 0, 0, 0);
        int[] oldimg = new int[os];
        int[] newimg = new int[ns];
        img.getRGB(oldimg, 0, ow, 0, 0, ow, oh);
        int j = 0;
        int l = nw - 1;
        int textColor = 0xFFFFFF;
        for (int i = 0; i < ns; ++i) {
            int A = (oldimg[j] & 0xFF) + (oldimg[j + 1] & 0xFF) + (oldimg[j + ow] & 0xFF) + (oldimg[j + ow + 1] & 0xFF) >> 2;
            newimg[i] = (A <<= 24) | textColor;
            j += 2;
            if (i % nw != l) continue;
            j += ow;
        }
        return Image.createRGBImage((int[])newimg, (int)nw, (int)nh, (boolean)true);
    }

    private static long getTimeStampLong(String timeStamp) {
        if (timeStamp.indexOf(",") == -1) {
            int month = TimeStamp.getMonth(timeStamp.substring(4, 7));
            int day = timeStamp.substring(8, 9).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(9, 10)) : Integer.parseInt(timeStamp.substring(8, 10));
            int hour = timeStamp.substring(11, 12).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(12, 13)) : Integer.parseInt(timeStamp.substring(11, 13));
            int minute = timeStamp.substring(14, 15).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(15, 16)) : Integer.parseInt(timeStamp.substring(14, 16));
            int second = timeStamp.substring(17, 18).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(18, 19)) : Integer.parseInt(timeStamp.substring(17, 19));
            int year = Integer.parseInt(timeStamp.substring(26, 30));
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(11, hour);
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, 0);
            return cal.getTime().getTime();
        }
        int month = TimeStamp.getMonth(timeStamp.substring(8, 11));
        int day = 1;
        day = timeStamp.substring(5, 6).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(6, 7)) : Integer.parseInt(timeStamp.substring(5, 7));
        int hour = 1;
        hour = timeStamp.substring(17, 18).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(18, 19)) : Integer.parseInt(timeStamp.substring(17, 19));
        int minute = 1;
        minute = timeStamp.substring(20, 21).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(21, 22)) : Integer.parseInt(timeStamp.substring(20, 22));
        int second = 1;
        second = timeStamp.substring(23, 24).equalsIgnoreCase("0") ? Integer.parseInt(timeStamp.substring(24, 25)) : Integer.parseInt(timeStamp.substring(23, 25));
        int year = Integer.parseInt(timeStamp.substring(12, 16));
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(11, hour);
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    private static int getMonth(String month) {
        if (month.equals(JANUARY)) {
            return 0;
        }
        if (month.equals(FEBRUARY)) {
            return 1;
        }
        if (month.equals(MARCH)) {
            return 2;
        }
        if (month.equals(APRIL)) {
            return 3;
        }
        if (month.equals(MAY)) {
            return 4;
        }
        if (month.equals(JUNE)) {
            return 5;
        }
        if (month.equals(JULY)) {
            return 6;
        }
        if (month.equals(AUGUST)) {
            return 7;
        }
        if (month.equals(SEPTEMBER)) {
            return 8;
        }
        if (month.equals(OCTOBER)) {
            return 9;
        }
        if (month.equals(NOVEMBER)) {
            return 10;
        }
        if (month.equals(DECEMBER)) {
            return 11;
        }
        return -1;
    }

    static {
        numbers = null;
        labels = null;
        labelint = new int[]{84, 85, 57, 58, 15, 16};
    }
}

