/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.bean;

import com.loboltd.javamap.bean.Building;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotOpenException;

public class BuildingHomeByRMS {
    private String recordStoreName = "J2ME_MAP";
    private static BuildingHomeByRMS home;
    private static int currentPage;
    private int maxResutlNum = 8;

    static {
        currentPage = 0;
    }

    private BuildingHomeByRMS() {
    }

    public static BuildingHomeByRMS getInstance() {
        if (home == null) {
            home = new BuildingHomeByRMS();
        }
        return home;
    }

    private RecordStore openRecordStore() {
        if (this.recordStoreName == null) {
            throw new RuntimeException("\u5c1a\u672a\u6307\u5b9a\u66f8\u7c3d\u3002");
        }
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true, (int)0, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return rs;
    }

    private void closeRecordStore(RecordStore rs) {
        try {
            rs.closeRecordStore();
        }
        catch (Exception e) {
            throw new RuntimeException("Error when closing record store!" + e.toString());
        }
    }

    public void delteRecordStore() {
        RecordStore rs = this.openRecordStore();
        try {
            rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)this.recordStoreName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when deleting record store!\n" + e.toString());
        }
    }

    public void addToBookMark(Building building) {
        RecordStore rs = this.openRecordStore();
        String name = building.getName();
        double x = building.getLn();
        double y = building.getLat();
        String area = building.getArea();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(name);
            dos.writeUTF(area);
            dos.writeDouble(x);
            dos.writeDouble(y);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        byte[] data = baos.toByteArray();
        try {
            rs.addRecord(data, 0, data.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.closeRecordStore(rs);
        try {
            dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Vector checkOutBookMark(boolean next) {
        currentPage = next ? ++currentPage : (currentPage > 1 ? currentPage - 1 : 1);
        Vector<Building> result = new Vector<Building>();
        RecordStore rs = this.openRecordStore();
        RecordEnumeration re = null;
        try {
            re = rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreNotOpenException e) {
            throw new RuntimeException("Error when getting enumer!\n" + e.toString());
        }
        int count = 0;
        while (re.hasNextElement()) {
            byte[] data;
            try {
                data = re.nextRecord();
            }
            catch (Exception e) {
                throw new RuntimeException("Error when getting record!\n" + e.toString());
            }
            if (++count <= (currentPage - 1) * this.maxResutlNum) {
                data = null;
                continue;
            }
            if (count >= currentPage * this.maxResutlNum) break;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            String name = null;
            String area = null;
            double x = 0.0;
            double y = 0.0;
            try {
                name = dis.readUTF();
                area = dis.readUTF();
                x = dis.readDouble();
                y = dis.readDouble();
            }
            catch (IOException e) {
                throw new RuntimeException("Error when changing data!\n" + e.toString());
            }
            Building building = new Building();
            if (building == null) continue;
            building.setName(name);
            building.setLn(x);
            building.setLat(y);
            building.setArea(area);
            result.addElement(building);
        }
        if (count <= (currentPage - 1) * this.maxResutlNum) {
            --currentPage;
        }
        this.closeRecordStore(rs);
        return result;
    }

    public boolean delete(int index) {
        RecordStore rs = this.openRecordStore();
        RecordEnumeration re = null;
        try {
            re = rs.enumerateRecords(null, null, false);
        }
        catch (RecordStoreNotOpenException e) {
            throw new RuntimeException("Error when getting enumer!\n" + e.toString());
        }
        int id = -1;
        int i = 0;
        while (i < index) {
            try {
                id = re.nextRecordId();
            }
            catch (InvalidRecordIDException e) {
                throw new RuntimeException("Error when getting next record id!\n" + e.toString());
            }
            ++i;
        }
        try {
            rs.deleteRecord(id);
            this.closeRecordStore(rs);
            return true;
        }
        catch (Exception e) {
            System.out.println("Error when deleting record " + id + "\n" + e.toString());
            this.closeRecordStore(rs);
            return false;
        }
    }

    public void deleteAll() {
        this.delteRecordStore();
        this.closeRecordStore(this.openRecordStore());
    }

    public String getRecordStoreName() {
        return this.recordStoreName;
    }

    public int getMaxResutlNum() {
        return this.maxResutlNum;
    }

    public void setMaxResutlNum(int maxResutlNum) {
        this.maxResutlNum = maxResutlNum;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void resetPage() {
        currentPage = 0;
    }
}

