/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.until.Until;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import com.thread.ThreadManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Dialog
extends View {
    String leftButtonStr;
    String rightButtonStr;
    boolean hasBorder = true;
    int borderColor = 0xDDDDEE;
    int borderWidth = 3;
    Image titleImg;
    int titleHeight = 20;
    int index = 0;
    Image bg;
    Image icon;
    private int popDirect = 0;
    private static final int POP_OUT = 1;
    private static final int POP_IN = 2;
    public static final int moveStep = 25;

    public Dialog() {
        this.id = "dialog";
        this.width = 200;
        this.height = 130;
        this.x = 240 - this.width >> 1;
        this.y = 320 - this.height >> 1;
        this.bg = (Image)Res.imageTable.get("mask");
    }

    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        int tmpx = 0;
        if (this.fillBG) {
            for (int tmpy = 0; tmpy <= 320; tmpy += this.bg.getHeight()) {
                while (true) {
                    if (tmpx > 240) break;
                    g.drawImage(this.bg, tmpx, tmpy, 20);
                    tmpx += this.bg.getWidth();
                }
                tmpx = 0;
            }
        }
        int drawX = this.x;
        int drawY = this.y;
        if (this.popDirect > 0) {
            drawX = this.currentX;
            drawY = this.currentY;
        }
        g.setColor(this.color);
        g.fillRect(drawX, drawY, this.width, this.height);
        if (this.titleImg != null) {
            g.drawImage(this.titleImg, drawX, drawY, 20);
        }
        if (this.icon != null) {
            g.drawImage(this.icon, drawX, drawY, 20);
        }
        if (this.hasBorder) {
            g.setColor(this.borderColor);
            g.fillRect(drawX, drawY, this.width, this.borderWidth);
            g.fillRect(drawX, drawY, this.borderWidth, this.height);
            g.fillRect(drawX, drawY + this.height - this.borderWidth, this.width, this.borderWidth);
            g.fillRect(drawX + this.width - this.borderWidth, drawY, this.borderWidth, this.height);
        }
        g.setColor(this.fontColor);
        int dy = this.getHeight() + drawY - this.font.getHeight() - this.borderWidth - 2;
        if (this.leftButtonStr != null && this.rightButtonStr != null) {
            int dw = this.getWidth() >> 2;
            g.drawString(this.leftButtonStr, drawX + dw, dy, 20);
            g.drawString(this.rightButtonStr, drawX + this.width - dw - this.font.stringWidth(this.rightButtonStr), dy, 20);
            g.setColor(0x55FFFF);
            if (this.index == 0) {
                g.drawRect(drawX + dw - 1, dy - 1, this.font.stringWidth(this.leftButtonStr) + 2, this.font.getHeight() + 2);
            } else {
                g.drawRect(drawX + this.width - dw - this.font.stringWidth(this.rightButtonStr) - 1, dy - 1, this.font.stringWidth(this.rightButtonStr) + 2, this.font.getHeight() + 2);
            }
        } else if (this.leftButtonStr != null || this.rightButtonStr != null) {
            String button = this.rightButtonStr;
            if (this.leftButtonStr != null) {
                button = this.leftButtonStr;
            }
            g.setColor(0x55FFFF);
            g.drawRect(drawX + (this.width - this.font.stringWidth(button) >> 1) - 1, dy - 1, this.font.stringWidth(button) + 2, this.font.getHeight() + 2);
            g.setColor(this.fontColor);
            g.drawString(button, drawX + (this.width - this.font.stringWidth(button) >> 1), dy, 20);
        }
        if (this.label == null) {
            return;
        }
        g.setColor(this.fontColor);
        int tx = drawX + this.borderWidth + 5;
        int ty = drawY + this.titleHeight + 5;
        int i = 0;
        while (i < this.label.length()) {
            char ch = this.label.charAt(i);
            if (tx >= drawX + this.width - this.borderWidth - 3 - g.getFont().charWidth(ch)) {
                tx = drawX + this.borderWidth + 5;
                ty += this.font.getHeight();
            }
            g.drawChar(ch, tx, ty, 20);
            tx += this.font.charWidth(ch);
            ++i;
        }
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public boolean isHasBorder() {
        return this.hasBorder;
    }

    public void setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    public String getLeftButtonStr() {
        return this.leftButtonStr;
    }

    public void setLeftButtonStr(String leftButton) {
        this.leftButtonStr = leftButton;
    }

    public String getRightButtonStr() {
        return this.rightButtonStr;
    }

    public void setRightButtonStr(String rightButton) {
        this.rightButtonStr = rightButton;
    }

    public Image getTitleImage() {
        return this.titleImg;
    }

    public void setTitleImage(Image title) {
        this.titleImg = title;
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public void setTitleHeight(int titleHeight) {
        this.titleHeight = titleHeight;
    }

    public void setIcon(Image img) {
        this.icon = img;
        if (this.icon != null && this.icon.getHeight() > this.titleHeight - 2) {
            this.icon = Until.transImage(this.icon, this.titleHeight - 2, this.titleHeight - 2);
        }
    }

    public ViewEvent pointerReleased(int px, int py) {
        int rightX;
        int w;
        int dw = this.getWidth() >> 2;
        int drawX = this.x;
        int drawY = this.y;
        if (this.popDirect > 0) {
            drawX = this.currentX;
            drawY = this.currentY;
        }
        int dy = this.getHeight() + drawY - this.font.getHeight() - this.borderWidth - 2;
        System.out.println("1111111");
        if (this.leftButtonStr != null) {
            int leftX = drawX + dw;
            w = this.font.stringWidth(this.leftButtonStr);
            if (this.rightButtonStr == null) {
                leftX = this.x + this.width - w >> 1;
            }
            if (View.isPointInRect(px, py, leftX, dy, w, this.font.getHeight())) {
                this.index = 0;
                return this.keyReleasedAction(8);
            }
        }
        if (this.rightButtonStr != null && View.isPointInRect(px, py, rightX = drawX + this.width - dw - this.font.stringWidth(this.rightButtonStr), dy, w = this.font.stringWidth(this.rightButtonStr), this.font.getHeight())) {
            this.index = 1;
            return this.keyReleasedAction(8);
        }
        return new ViewEvent();
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.leftButtonStr == null && this.rightButtonStr == null) {
            return null;
        }
        if (keyCode == 2 || keyCode == 5) {
            ++this.index;
            if (this.index > 1) {
                this.index = 0;
            }
        } else {
            if (keyCode == 8) {
                ViewEvent event = new ViewEvent();
                if (this.index == 0) {
                    event.setDesc("ok");
                    event.setKeyCode(-6);
                    event.setView(this);
                } else {
                    event.setDesc("back");
                    event.setKeyCode(-7);
                    event.setView(this);
                }
                return event;
            }
            if (keyCode == -6) {
                ViewEvent event = new ViewEvent();
                event.setDesc("ok");
                if (this.index > 0) {
                    event.setDesc("back");
                }
                event.setKeyCode(-6);
                event.setView(this);
                return event;
            }
            if (keyCode == -7) {
                ViewEvent event = new ViewEvent();
                event.setDesc("back");
                event.setKeyCode(-7);
                event.setView(this);
                return event;
            }
        }
        return null;
    }

    public void popout() {
        this.popDirect = 1;
        ThreadManager.addTask(this);
    }

    public void popin() {
        this.popDirect = 2;
        this.x = 240 - this.getWidth() >> 1;
        this.y = -this.getHeight();
        ThreadManager.addTask(this);
        System.gc();
    }

    public boolean getActionResult() {
        return this.currentX != this.x || this.currentY != this.y;
    }

    public void setActionResult(boolean result) {
        if (this.popDirect == 2) {
            this.visible = false;
        } else if (this.popDirect == 1) {
            this.visible = true;
        }
    }

    public void threadAction() {
        int step = 25;
        if (this.popDirect == 2) {
            step += 30;
        }
        if (Math.abs(this.x - this.currentX) < step) {
            this.currentX = this.x;
        } else if (this.currentX < this.x) {
            this.currentX += step;
        } else if (this.currentX > this.x) {
            this.currentX -= step;
        }
        if (Math.abs(this.y - this.currentY) < step) {
            this.currentY = this.y;
        } else if (this.currentY < this.y) {
            this.currentY += step;
        } else if (this.currentY > this.y) {
            this.currentY -= step;
        }
    }

    public void clear() {
        this.popin();
    }
}

