/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.until.ViewEvent;
import com.thread.ThreadManager;
import javax.microedition.lcdui.Graphics;

public class ImageListView
extends View {
    public int currentIndex = 0;
    private byte listMode = LISTMODE_LR;
    public static byte LISTMODE_LR = 0;
    public static byte LISTMODE_UD = 1;
    public static final int DISTANCEX = 7;
    public static final int DISTANCEY = 11;

    public ImageListView() {
        this.type = 12;
    }

    public void setListMode(byte mode) {
        this.listMode = mode;
    }

    public void setListMode(String mode) {
        if (mode != null) {
            if (mode.endsWith("UD")) {
                this.setListMode(LISTMODE_UD);
            } else if (mode.endsWith("LR")) {
                this.setListMode(LISTMODE_LR);
            }
        }
    }

    public byte getListMode() {
        return this.listMode;
    }

    public void addItem(View view) {
        if (view == null) {
            return;
        }
        if (this.items.size() == 0) {
            this.currentIndex = 0;
            this.currentSub = view;
            view.setFocus(true);
        }
        this.items.addElement(view);
        this.refreshItems();
    }

    public void refreshItems() {
        if (this.listMode == LISTMODE_UD) {
            this.refreshItems_UD();
        } else {
            this.refreshItems_LR();
        }
    }

    public void refreshItems_UD() {
        View item;
        int index;
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        this.currentSub.setImageSize(0);
        int dx = this.x + (this.getWidth() - this.currentSub.getWidth()) / 2;
        int dy = this.y + (this.getHeight() - this.currentSub.getHeight()) / 2;
        this.currentSub.setX(dx);
        this.currentSub.setY(dy);
        this.currentSub.setCurrentX(dx);
        this.currentSub.setCurrentY(dy);
        dy += this.currentSub.getHeight();
        dy += 11;
        dy += 11;
        int i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex + i;
            item = (View)this.items.elementAt(index %= this.items.size());
            if (item != null) {
                item.setImageSize(i);
                item.setY(dy);
                item.setX(this.x + (this.width - item.getWidth() >> 1));
                item.setCurrentX(item.getX());
                item.setCurrentY(item.getY());
                dy += item.getHeight();
                dy += 11;
            }
            ++i;
        }
        dx = this.currentSub.getX();
        dy = this.currentSub.getY();
        dy -= 11;
        i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex - i;
            if (index < 0) {
                index = this.items.size() + index;
            }
            if ((item = (View)this.items.elementAt(index)) != null) {
                item.setImageSize(i);
                dy -= item.getHeight();
                item.setY(dy -= 11);
                item.setX(this.x + (this.width - item.getWidth() >> 1));
                item.setCurrentX(item.getX());
                item.setCurrentY(item.getY());
            }
            ++i;
        }
    }

    public void refreshItems_LR() {
        View item;
        int index;
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        this.currentSub.setImageSize(0);
        int dx = this.x + (this.getWidth() - this.currentSub.getWidth()) / 2;
        int dy = this.y + (this.getHeight() - this.currentSub.getHeight()) / 2;
        this.currentSub.setX(dx);
        this.currentSub.setY(dy);
        this.currentSub.setCurrentX(dx);
        this.currentSub.setCurrentY(dy);
        dx += this.currentSub.getWidth();
        dx += 7;
        dx += 7;
        int i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex + i;
            item = (View)this.items.elementAt(index %= this.items.size());
            if (item != null) {
                item.setX(dx);
                item.setImageSize(i);
                item.setY(this.y + (this.height - item.getHeight() >> 1) - i);
                item.setCurrentX(item.getX());
                item.setCurrentY(item.getY());
                dx += item.getWidth();
                dx += 7;
            }
            ++i;
        }
        dx = this.currentSub.getX();
        dx -= 7;
        dy = this.currentSub.getY();
        i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex - i;
            if (index < 0) {
                index = this.items.size() + index;
            }
            if ((item = (View)this.items.elementAt(index)) != null) {
                item.setImageSize(i);
                dx -= item.getWidth();
                item.setX(dx -= 7);
                item.setY(this.y + (this.height - item.getHeight() >> 1) - i);
                item.setCurrentX(item.getX());
                item.setCurrentY(item.getY());
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        if (this.transparency == -1 && this.fillBG) {
            g.setColor(this.color);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        super.drawImage(g, this.img, this.x, this.y);
        g.setFont(this.font);
        this.paint_LR(g);
    }

    public void paint_LR(Graphics g) {
        if (this.currentSub != null && this.fillBG) {
            g.setColor(this.color);
            g.fillRoundRect(this.currentSub.getCurrentX() - 7, this.y + 1, this.currentSub.getWidth() + 7 + 7, this.height - 2, this.currentSub.getWidth() >> 1, this.currentSub.getWidth() >> 1);
        }
        int i = 0;
        while (i < this.items.size()) {
            View view = (View)this.items.elementAt(i);
            view.paint(g);
            ++i;
        }
    }

    public ViewEvent keyPressedAction(int keyCode) {
        ViewEvent e = new ViewEvent();
        e.setView(this);
        e.setDesc("keyPressed");
        e.setKeyCode(keyCode);
        e.setSource(this.currentSub);
        return e;
    }

    public void animaStart() {
        int i = 0;
        while (i < this.items.size()) {
            View item = (View)this.items.elementAt(i);
            ThreadManager.addTask(item);
            ++i;
        }
    }

    public void setAnimaToDown() {
        View item;
        int index;
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        this.currentSub.setImageSize(0);
        int dx = this.x + (this.getWidth() - this.currentSub.getWidth()) / 2;
        int dy = this.y + (this.getHeight() - this.currentSub.getHeight()) / 2;
        this.currentSub.setX(dx);
        this.currentSub.setY(dy);
        this.currentSub.setCurrentX(dx);
        this.currentSub.setCurrentY(dy - this.currentSub.getHeight() - 11);
        dy += this.currentSub.getHeight();
        dy += 11;
        dy += 11;
        int i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex + i;
            item = (View)this.items.elementAt(index %= this.items.size());
            if (item != null) {
                item.setImageSize(i);
                item.setY(dy);
                item.setX(this.x + (this.width - item.getWidth() >> 1));
                item.setX(item.getX());
                item.setCurrentY(dy - item.getHeight() - 11);
                dy += item.getHeight();
                dy += 11;
            }
            ++i;
        }
        dx = this.currentSub.getX();
        dy = this.currentSub.getY();
        dy -= 11;
        i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex - i;
            if (index < 0) {
                index = this.items.size() + index;
            }
            if ((item = (View)this.items.elementAt(index)) != null) {
                item.setImageSize(i);
                dy -= item.getHeight();
                item.setY(dy -= 11);
                item.setX(this.x + (this.width - item.getHeight() >> 1));
                item.setCurrentY(dy - item.getHeight() - 11 * i);
                item.setCurrentX(item.getX());
            }
            ++i;
        }
    }

    public void setAnimaToUp() {
        View item;
        int index;
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        this.currentSub.setImageSize(0);
        int dx = this.x + (this.getWidth() - this.currentSub.getWidth()) / 2;
        int dy = this.y + (this.getHeight() - this.currentSub.getHeight()) / 2;
        this.currentSub.setX(dx);
        this.currentSub.setY(dy);
        this.currentSub.setCurrentX(this.currentSub.getX());
        this.currentSub.setCurrentY(dy + this.currentSub.getHeight() - 11);
        dy += this.currentSub.getHeight();
        dy += 11;
        dy += 11;
        int i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex + i;
            item = (View)this.items.elementAt(index %= this.items.size());
            if (item != null) {
                item.setImageSize(i);
                item.setY(dy);
                item.setX(this.x + (this.width - item.getWidth() >> 1));
                item.setCurrentX(item.getX());
                item.setCurrentY(dy + item.getHeight() + 11);
                dy += item.getHeight();
                dy += 11;
            }
            ++i;
        }
        dy = this.currentSub.getY();
        dy -= 11;
        dx = this.currentSub.getX();
        i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex - i;
            if (index < 0) {
                index = this.items.size() + index;
            }
            if ((item = (View)this.items.elementAt(index)) != null) {
                item.setImageSize(i);
                dy -= item.getHeight();
                item.setY(dy -= 11);
                item.setX(this.x + (this.width - item.getWidth() >> 1));
                item.setCurrentX(item.getX());
                item.setCurrentY(dy + item.getHeight() + 11 * i);
            }
            ++i;
        }
    }

    public void setAnimaToRight() {
        View item;
        int index;
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        this.currentSub.setImageSize(0);
        int dx = this.x + (this.getWidth() - this.currentSub.getWidth()) / 2;
        int dy = this.y + (this.getHeight() - this.currentSub.getHeight()) / 2;
        this.currentSub.setX(dx);
        this.currentSub.setY(dy);
        this.currentSub.setCurrentY(this.currentSub.getY());
        this.currentSub.setCurrentX(dx - this.currentSub.getWidth() + 7);
        dx += this.currentSub.getWidth();
        dx += 7;
        dx += 7;
        int i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex + i;
            item = (View)this.items.elementAt(index %= this.items.size());
            if (item != null) {
                item.setX(dx);
                item.setImageSize(i);
                item.setY(this.y + (this.height - item.getHeight() >> 1) - i);
                item.setCurrentY(item.getY());
                item.setCurrentX(dx - item.getWidth() - 7);
                dx += item.getWidth();
                dx += 7;
            }
            ++i;
        }
        dx = this.currentSub.getX();
        dx -= 7;
        dy = this.currentSub.getY();
        i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex - i;
            if (index < 0) {
                index = this.items.size() + index;
            }
            if ((item = (View)this.items.elementAt(index)) != null) {
                item.setImageSize(i);
                dx -= item.getWidth();
                item.setX(dx -= 7);
                item.setY(this.y + (this.height - item.getHeight() >> 1) - i);
                item.setCurrentY(item.getY());
                item.setCurrentX(dx - item.getWidth() - 7 * i);
            }
            ++i;
        }
    }

    public void setAnimaToLeft() {
        View item;
        int index;
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        this.currentSub.setImageSize(0);
        int dx = this.x + (this.getWidth() - this.currentSub.getWidth()) / 2;
        int dy = this.y + (this.getHeight() - this.currentSub.getHeight()) / 2;
        this.currentSub.setX(dx);
        this.currentSub.setY(dy);
        this.currentSub.setCurrentY(this.currentSub.getY());
        this.currentSub.setCurrentX(dx + this.currentSub.getWidth() - 7);
        dx += this.currentSub.getWidth();
        dx += 7;
        dx += 7;
        int i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex + i;
            item = (View)this.items.elementAt(index %= this.items.size());
            if (item != null) {
                item.setX(dx);
                item.setImageSize(i);
                item.setY(this.y + (this.height - item.getHeight() >> 1) - i);
                item.setCurrentY(item.getY());
                item.setCurrentX(dx + item.getWidth() + 7);
                dx += item.getWidth();
                dx += 7;
            }
            ++i;
        }
        dx = this.currentSub.getX();
        dx -= 7;
        dy = this.currentSub.getY();
        i = 1;
        while (i < this.items.size() / 2 + 1) {
            index = this.currentIndex - i;
            if (index < 0) {
                index = this.items.size() + index;
            }
            if ((item = (View)this.items.elementAt(index)) != null) {
                item.setImageSize(i);
                dx -= item.getWidth();
                item.setX(dx -= 7);
                item.setY(this.y + (this.height - item.getHeight() >> 1) - i);
                item.setCurrentY(item.getY());
                item.setCurrentX(dx + item.getWidth() + 7 * i);
            }
            ++i;
        }
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.listMode == LISTMODE_UD) {
            return this.keyReleasedAction_UD(keyCode);
        }
        return this.keyReleasedAction_LR(keyCode);
    }

    public ViewEvent keyReleasedAction_LR(int keyCode) {
        System.out.println("ImagelistView keyReleasedAction id:" + this.id + " listView keyReleased Code=" + keyCode);
        this.currentSub.setFocus(false);
        if (keyCode == 2) {
            --this.currentIndex;
            if (this.currentIndex < 0) {
                this.currentIndex = this.items.size() - 1;
            }
            this.setAnimaToRight();
            this.animaStart();
        } else if (keyCode == 5) {
            ++this.currentIndex;
            this.currentIndex %= this.items.size();
            this.setAnimaToLeft();
            this.animaStart();
        } else if (keyCode == 6) {
            this.currentSub.keyReleasedAction(keyCode);
        } else if (keyCode == 1) {
            this.currentSub.keyReleasedAction(keyCode);
        }
        this.currentSub.setFocus(true);
        if (keyCode == 8) {
            return this.currentSub.keyReleasedAction(keyCode);
        }
        if (keyCode == 2 || keyCode == 5) {
            ViewEvent e = new ViewEvent();
            e.setView(this);
            e.setDesc("left|right");
            e.setKeyCode(keyCode);
            e.setSource(this.currentSub);
            return e;
        }
        if (keyCode == 1 || keyCode == 6) {
            ViewEvent e = new ViewEvent();
            e.setView(this);
            e.setDesc("up|down");
            e.setKeyCode(keyCode);
            e.setSource(this.currentSub);
            return e;
        }
        return null;
    }

    public ViewEvent keyReleasedAction_UD(int keyCode) {
        System.out.println("ImagelistView keyReleasedAction id:" + this.id + " listView keyReleased Code=" + keyCode);
        this.currentSub.setFocus(false);
        if (keyCode == 1) {
            --this.currentIndex;
            if (this.currentIndex < 0) {
                this.currentIndex = this.items.size() - 1;
            }
            this.setAnimaToDown();
            this.animaStart();
        } else if (keyCode == 6) {
            ++this.currentIndex;
            this.currentIndex %= this.items.size();
            this.setAnimaToUp();
            this.animaStart();
        } else if (keyCode == 2) {
            this.currentSub.keyReleasedAction(keyCode);
        } else if (keyCode == 5) {
            this.currentSub.keyReleasedAction(keyCode);
        }
        this.currentSub.setFocus(true);
        if (keyCode == 8) {
            return this.currentSub.keyReleasedAction(keyCode);
        }
        if (keyCode == 2 || keyCode == 5) {
            ViewEvent e = new ViewEvent();
            e.setView(this);
            e.setDesc("left|right");
            e.setKeyCode(keyCode);
            e.setSource(this.currentSub);
            return e;
        }
        if (keyCode == 1 || keyCode == 6) {
            ViewEvent e = new ViewEvent();
            e.setView(this);
            e.setDesc("up|down");
            e.setKeyCode(keyCode);
            e.setSource(this.currentSub);
            return e;
        }
        return null;
    }

    public ViewEvent pointerReleased(int px, int py) {
        System.out.println("ImageListIVew PointerReleased");
        int i = 0;
        while (i < this.items.size()) {
            View v = (View)this.items.elementAt(i);
            if (View.isPointInRect(px, py, v.getX(), v.getY(), v.getWidth(), v.getHeight())) {
                boolean isfocus = false;
                if (this.getCurrentSub().getId().equals(v.getId())) {
                    isfocus = true;
                }
                this.setCurrentSub(v);
                v.setFocus(true);
                this.currentIndex = i;
                this.refreshItems();
                ViewEvent e = new ViewEvent();
                e.setView(v);
                e.setSource(v.getData());
                if (isfocus) {
                    e.setKeyCode(8);
                }
                return e;
            }
            ++i;
        }
        ViewEvent e = new ViewEvent();
        e.setView(this);
        return e;
    }
}

