/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import javax.microedition.lcdui.Graphics;

public class SoundProgress
extends View {
    private int totalSound = 98;
    private int currentSound = 70;
    private int totalCol = 7;
    private int currentCol = 5;
    private static final int FILLWIDTH = 4;
    private static final int DISTANCE = 2;

    public SoundProgress() {
        this.width = this.totalCol * 6;
        this.height = this.totalCol;
    }

    public int getCurrentCol() {
        return this.currentCol;
    }

    public void setCurrentCol(int currentCol) {
        this.currentCol = currentCol;
    }

    public int getCurrentSound() {
        return this.currentSound;
    }

    public void setCurrentSound(int currentSound) {
        this.currentSound = currentSound;
        this.setCurrentCol(currentSound * this.totalCol / this.totalSound);
    }

    public int getTotalCol() {
        return this.totalCol;
    }

    public void setTotalCol(int totalCol) {
        this.totalCol = totalCol;
    }

    public int getTotalSound() {
        return this.totalSound;
    }

    public void setTotalSound(int totalSound) {
        this.totalSound = totalSound;
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        if (this.isFocus()) {
            g.setColor(Res.UICOLOR_BORDER);
            g.drawRect(this.x - 2, this.y - 2 - 4, this.totalCol * 6 + 2, this.totalCol + 4 + 4);
        }
        int dx = this.x;
        int dy = this.y;
        g.setColor(this.color);
        int i = this.totalCol;
        while (i > 0) {
            if (this.currentCol >= i) {
                g.fillRect(dx, dy - 4, 4, i + 4);
            } else {
                g.drawRect(dx, dy - 4, 4, i + 4);
            }
            dx += 4;
            dx += 2;
            ++dy;
            --i;
        }
    }

    public ViewEvent pointerReleased(int px, int py) {
        ViewEvent e = new ViewEvent();
        if (super.isPointMe(px, py)) {
            e.setView(this);
            e.setKeyCode(8);
            if (px >= this.x && px <= this.x + this.width / 2) {
                e.setDesc("add");
            } else {
                e.setDesc("del");
            }
        }
        return e;
    }
}

