/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.item.ButtonView;
import com.canvas.view.until.ViewEvent;
import com.image.ImageHandleImpl;
import com.image.ImageHolder;
import com.image.ImageLoaderManager;
import com.res.Res;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageTextView
extends View
implements ImageHandleImpl {
    private int startLine = 0;
    private Vector imgVect = new Vector();
    private Image defaultImg;
    private Vector itemVect = new Vector();
    private int itemindex = -1;
    private String txt;
    private Vector txtVector = new Vector();
    private int margin = 3;
    private int totalHeight;
    private int limitLine = 2;
    private Image img_Scrol_bg;
    private Image img_Scrol_top;
    private Image img_Scrol_bot;
    private Image img_Scrol_bar;

    public ImageTextView() {
        this.fillBG = false;
        this.type = 5;
        this.startLine = 0;
        this.defaultImg = (Image)Res.imageTable.get("default_list");
        this.img_Scrol_bg = (Image)Res.imageTable.get("Scrollbar_bg");
        this.img_Scrol_bot = (Image)Res.imageTable.get("Scrollbar_bot");
        this.img_Scrol_top = (Image)Res.imageTable.get("Scrollbar_top");
        this.img_Scrol_bar = (Image)Res.imageTable.get("Scrollbar_bar");
    }

    public void removeImages() {
        this.imgVect.removeAllElements();
    }

    public void addImageUrl(String url) {
        ImageHolder holder = new ImageHolder();
        holder.url = url;
        holder.addListenner(this);
        ImageLoaderManager.add(holder);
        this.imgVect.addElement(holder);
        this.refrehTotalHeight();
    }

    public void addImage(Image img) {
        ImageHolder holder = new ImageHolder();
        holder.url = "";
        holder.img = img;
        this.imgVect.addElement(holder);
        this.refrehTotalHeight();
    }

    public void addItem(View view) {
        this.itemVect.addElement(view);
        if (view instanceof ButtonView) {
            ButtonView bv = (ButtonView)view;
            bv.setBoardColor(0xFF00FF);
        }
    }

    public void setText(String txt) {
        if (txt == null || txt.length() < 1) {
            return;
        }
        this.txt = txt;
        this.txtVector.removeAllElements();
        int dx = this.x + this.margin;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < txt.length()) {
            char ch = txt.charAt(i);
            if (ch == '\n') {
                dx = this.x;
                this.txtVector.addElement(buffer.toString());
                buffer.setLength(0);
            } else {
                if (dx >= this.x + this.width - this.font.charWidth(ch) - this.margin - this.img_Scrol_bg.getWidth()) {
                    dx = this.x + this.margin;
                    this.txtVector.addElement(buffer.toString());
                    buffer.setLength(0);
                }
                buffer.append(ch);
                dx += this.font.charWidth(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            this.txtVector.addElement(buffer.toString());
        }
        this.txtVector.addElement(" ");
        this.txtVector.addElement(" ");
        this.refrehTotalHeight();
    }

    public void insertTxtLine(String txt, int index) {
        if (index >= this.txtVector.size() - 1) {
            this.txtVector.addElement(txt);
        } else {
            this.txtVector.insertElementAt(txt, index);
        }
    }

    public void refrehTotalHeight() {
        int h = 0;
        int i = 0;
        while (i < this.imgVect.size()) {
            ImageHolder holder = (ImageHolder)this.imgVect.elementAt(i);
            Image img = holder.img;
            if (img == null) {
                img = this.defaultImg;
            }
            h += img.getHeight();
            ++i;
        }
        h += this.txtVector.size() * Res.UIFONT.getHeight();
        this.limitLine = this.imgVect.size() - 1 + this.txtVector.size() - 2;
        i = 0;
        while (i < this.itemVect.size()) {
            View v = (View)this.itemVect.elementAt(i);
            h += v.getHeight();
            ++i;
        }
        this.totalHeight = h;
    }

    public String getText() {
        return this.txt;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        g.setColor(this.color);
        if (this.fillBG) {
            g.fillRect(this.x, this.y, this.width, this.height);
            g.setColor(Res.UICOLOR_BORDER);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
        g.setColor(this.fontColor);
        g.setFont(this.font);
        int dx = this.x + this.margin;
        int dy = this.y;
        int i = 0;
        while (i < this.imgVect.size()) {
            if (this.startLine <= i) {
                ImageHolder holder = (ImageHolder)this.imgVect.elementAt(i);
                Image img = holder.img;
                if (img == null) {
                    img = this.defaultImg;
                }
                g.drawImage(img, this.x + (this.width - img.getWidth() >> 1), dy, 20);
                dy += img.getHeight();
                dy += 3;
            }
            ++i;
        }
        i = 0;
        while (i < this.itemVect.size()) {
            View v = (View)this.itemVect.elementAt(i);
            v.setX(this.x + (this.width - v.getWidth()) / 2);
            v.setY(dy);
            if (dy < this.y + this.height - v.getHeight()) {
                v.paint(g);
            }
            dy += v.getHeight() + 3;
            ++i;
        }
        g.setColor(this.fontColor);
        i = 0;
        while (i < this.txtVector.size()) {
            if (this.startLine <= this.imgVect.size() + this.itemVect.size() + i) {
                if (dy > this.y + this.height - g.getFont().getHeight()) break;
                String str = (String)this.txtVector.elementAt(i);
                g.drawString(str, dx, dy, 20);
                dy += g.getFont().getHeight();
            }
            ++i;
        }
        dx = this.x + this.width - this.img_Scrol_bg.getWidth();
        dy = this.y;
        if (this.totalHeight > this.height) {
            g.drawImage(this.img_Scrol_top, dx, dy, 20);
            g.drawImage(this.img_Scrol_bot, dx, dy + this.height - this.img_Scrol_bot.getHeight(), 20);
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            int rectH = this.height - this.img_Scrol_top.getHeight() - this.img_Scrol_bot.getHeight();
            g.setClip(dx, dy += this.img_Scrol_top.getHeight(), this.img_Scrol_bg.getWidth(), rectH);
            do {
                g.drawImage(this.img_Scrol_bg, dx, dy, 20);
            } while ((dy += this.img_Scrol_bg.getHeight()) < this.y + this.height - this.img_Scrol_bot.getHeight());
            dy = this.startLine == 0 ? this.y + this.img_Scrol_top.getHeight() + 5 : this.y + this.img_Scrol_top.getHeight() + this.startLine * rectH / this.limitLine;
            dx += this.img_Scrol_bg.getWidth() - this.img_Scrol_bar.getWidth() >> 1;
            for (int tmpY = this.y + this.img_Scrol_top.getHeight(); tmpY <= dy - this.img_Scrol_bar.getHeight(); tmpY += this.img_Scrol_bar.getHeight()) {
                g.drawImage(this.img_Scrol_bar, dx, tmpY, 20);
            }
            g.setClip(0, 0, cw, ch);
        }
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (keyCode == 6) {
            if (this.totalHeight > this.height) {
                ++this.startLine;
                if (this.startLine > this.limitLine) {
                    this.startLine = this.limitLine;
                }
                if (this.startLine >= this.imgVect.size()) {
                    this.itemindex = this.startLine - this.imgVect.size();
                }
            } else {
                ++this.itemindex;
            }
            if (this.itemindex > this.itemVect.size() - 1) {
                this.itemindex = this.itemVect.size() - 1;
            }
        } else if (keyCode == 1) {
            if (this.totalHeight > this.height) {
                --this.startLine;
                if (this.startLine < 0) {
                    this.startLine = 0;
                }
                if (this.startLine <= this.imgVect.size() - 1 + this.itemVect.size() - 1) {
                    --this.itemindex;
                }
            } else {
                --this.itemindex;
            }
            if (this.itemindex < 0) {
                this.itemindex = 0;
            }
        } else if (keyCode == 8) {
            ViewEvent e = new ViewEvent();
            e.setView(this.container);
            e.setDesc("text fire");
            if (this.itemindex >= 0 && this.itemindex < this.itemVect.size()) {
                View v = (View)this.itemVect.elementAt(this.itemindex);
                e.setSource(v);
            }
            e.setKeyCode(keyCode);
            return e;
        }
        int i = 0;
        while (i < this.itemVect.size()) {
            ButtonView v = (ButtonView)this.itemVect.elementAt(i);
            v.setFocus(false);
            v.isSelected = false;
            v.setBoardColor(0xFF00FF);
            if (i == this.itemindex) {
                v.setFocus(true);
                v.isSelected = true;
            }
            ++i;
        }
        return null;
    }

    public ViewEvent pointerReleased(int px, int py) {
        ViewEvent e = new ViewEvent();
        e.setView(this);
        int i = 0;
        while (i < this.itemVect.size()) {
            View v = (View)this.itemVect.elementAt(i);
            if (v.isPointMe(px, py)) {
                if (this.itemindex >= 0 && this.itemindex < this.itemVect.size()) {
                    View current = (View)this.itemVect.elementAt(this.itemindex);
                    current.isSelected = false;
                    current.setFocus(false);
                }
                e.setSource(v);
                e.setKeyCode(8);
                this.itemindex = i;
                v.setFocus(true);
                v.isSelected = true;
            }
            ++i;
        }
        return e;
    }

    public ViewEvent pointerDragged(int lastX, int lastY, int px, int py) {
        if (py > lastY) {
            this.keyReleasedAction(1);
        } else if (py < lastY) {
            this.keyReleasedAction(6);
        }
        return null;
    }

    public void ImageAction(ImageHolder holder, Image img) {
        int i = 0;
        while (i < this.imgVect.size()) {
            ImageHolder hd = (ImageHolder)this.imgVect.elementAt(i);
            if (hd.url == holder.url) {
                hd.img = holder.img;
            }
            ++i;
        }
        this.refrehTotalHeight();
    }

    public void ImageLoadError(String id, String desc) {
    }
}

