/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextView
extends View {
    public static final int TEXTMODE_LABEL = 0;
    public static final int TEXTMODE_TEXT = 1;
    private int textMode = 0;
    private int startLine = 0;
    private int lineNumPerPage = 10;
    private String txt;
    private Vector txtVector = new Vector();
    private int margin = 1;
    public boolean drawBoard = true;
    private Image img_Scrol_bg;
    private Image img_Scrol_top;
    private Image img_Scrol_bot;
    private Image img_Scrol_bar;

    public TextView() {
        this.fillBG = false;
        this.type = 5;
        this.startLine = 0;
        this.textMode = 0;
    }

    public void setTextMode(int mode) {
        this.textMode = mode;
    }

    public void setText(String txt) {
        if (txt == null || txt.length() < 1) {
            return;
        }
        this.txtVector.removeAllElements();
        int dx = this.x + this.margin;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < txt.length()) {
            char ch = txt.charAt(i);
            if (ch == '\n') {
                dx = this.x;
                this.txtVector.addElement(buffer.toString());
                buffer.setLength(0);
            } else {
                if (dx >= this.x + this.width - this.font.charWidth(ch) - this.margin - this.margin) {
                    dx = this.x + this.margin;
                    this.txtVector.addElement(buffer.toString());
                    buffer.setLength(0);
                }
                buffer.append(ch);
                dx += this.font.charWidth(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            this.txtVector.addElement(buffer.toString());
        }
        this.txt = txt;
        this.lineNumPerPage = (this.height - this.margin - this.margin) / this.font.getHeight();
    }

    public String getText() {
        return this.txt;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        g.setColor(this.color);
        if (this.fillBG) {
            g.fillRect(this.x, this.y, this.width, this.height);
            if (this.drawBoard) {
                g.setColor(Res.UICOLOR_BORDER);
                g.drawRect(this.x, this.y, this.width, this.height);
            }
        }
        g.setColor(this.fontColor);
        g.setFont(this.font);
        if (this.txt != null) {
            int dy = this.y + this.margin;
            boolean lastLine = false;
            int i = this.startLine;
            while (i < this.txtVector.size()) {
                if (dy > this.y + this.height - g.getFont().getHeight() - this.margin) break;
                if (dy > this.y + this.height - g.getFont().getHeight() - g.getFont().getHeight() - this.margin) {
                    lastLine = true;
                }
                String str = (String)this.txtVector.elementAt(i);
                if (this.textMode == 0 && lastLine && i != this.txtVector.size() - 1) {
                    if (str.length() > 3) {
                        str = str.substring(0, str.length() - 2);
                    }
                    str = String.valueOf(str) + "...";
                    g.drawString(str, this.x + this.margin, dy, 20);
                    return;
                }
                g.drawString(str, this.x + this.margin, dy, 20);
                dy += g.getFont().getHeight();
                ++i;
            }
        }
        if (this.lineNumPerPage < this.txtVector.size() && this.textMode == 1) {
            if (this.img_Scrol_bg == null) {
                this.img_Scrol_bg = (Image)Res.imageTable.get("Scrollbar_bg");
                this.img_Scrol_bot = (Image)Res.imageTable.get("Scrollbar_bot");
                this.img_Scrol_top = (Image)Res.imageTable.get("Scrollbar_top");
                this.img_Scrol_bar = (Image)Res.imageTable.get("Scrollbar_bar");
            }
            int dx = this.x + this.width;
            g.drawImage(this.img_Scrol_top, dx, this.y, 20);
            g.drawImage(this.img_Scrol_bot, dx, this.y + this.height - this.img_Scrol_bot.getHeight(), 20);
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            int rectH = this.height - this.img_Scrol_top.getHeight() - this.img_Scrol_bot.getHeight();
            int dy = this.y + this.img_Scrol_top.getHeight();
            g.setClip(dx, dy, this.img_Scrol_bg.getWidth(), rectH);
            do {
                g.drawImage(this.img_Scrol_bg, dx, dy, 20);
            } while ((dy += this.img_Scrol_bg.getHeight()) < this.y + this.height - this.img_Scrol_bot.getHeight());
            dy = this.y + this.img_Scrol_top.getHeight() + (this.startLine + 1) * rectH / (this.txtVector.size() - this.lineNumPerPage + 3);
            dx += this.img_Scrol_bg.getWidth() - this.img_Scrol_bar.getWidth() >> 1;
            for (int tmpY = this.y + this.img_Scrol_top.getHeight(); tmpY <= dy - this.img_Scrol_bar.getHeight(); tmpY += this.img_Scrol_bar.getHeight()) {
                g.drawImage(this.img_Scrol_bar, dx, tmpY, 20);
            }
            g.setClip(0, 0, cw, ch);
        }
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.textMode == 1) {
            if (keyCode == 6) {
                ++this.startLine;
            } else if (keyCode == 1) {
                --this.startLine;
            }
            if (this.startLine > this.txtVector.size() - this.lineNumPerPage + 2) {
                this.startLine = this.txtVector.size() - this.lineNumPerPage + 2;
            }
            if (this.startLine > this.txtVector.size() - 1) {
                this.startLine = this.txtVector.size() - 1;
            }
            if (this.startLine < 0) {
                this.startLine = 0;
            }
        }
        if (keyCode == 8) {
            ViewEvent e = new ViewEvent();
            e.setView(this.container);
            e.setDesc("text fire");
            e.setKeyCode(keyCode);
            return e;
        }
        return null;
    }

    public ViewEvent keyRepeatAction(int keyCode) {
        if (this.textMode == 1) {
            if (keyCode == 6) {
                ++this.startLine;
            } else if (keyCode == 1) {
                --this.startLine;
            }
            if (this.startLine > this.txtVector.size() - this.lineNumPerPage + 2) {
                this.startLine = this.txtVector.size() - this.lineNumPerPage + 2;
            }
            if (this.startLine > this.txtVector.size() - 1) {
                this.startLine = this.txtVector.size() - 1;
            }
            if (this.startLine < 0) {
                this.startLine = 0;
            }
        }
        return null;
    }
}

