/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.res.Res;
import com.thread.ThreadManager;
import javax.microedition.lcdui.Graphics;

public class TickerView
extends View {
    private byte tickerMode = 0;
    public static final byte TICKERMODE_LR = 0;
    public static final byte TICKERMODE_UD = 1;
    private String txt;
    private int margin = 1;
    private boolean isRunning = false;
    int drawingX;
    int drawingY;
    private final int step;

    public TickerView() {
        this.step = 3;
        this.fillBG = false;
        this.type = 5;
    }

    public void setTickerMode(byte mode) {
        this.tickerMode = mode;
    }

    public void setText(String txt) {
        this.txt = txt;
    }

    public String getText() {
        return this.txt;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        g.setColor(this.color);
        if (this.fillBG) {
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        g.setColor(this.fontColor);
        int dx = this.drawingX;
        int dy = this.drawingY;
        if (this.tickerMode == 0) {
            dy = this.y + (this.height - g.getFont().getHeight() >> 1);
            int i = 0;
            while (i < this.txt.length()) {
                char ch = this.txt.charAt(i);
                int w = g.getFont().charWidth(ch);
                if (dx <= this.x + this.width - w - this.margin) {
                    g.drawChar(ch, dx, dy, 20);
                    dx += w;
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            dx = this.drawingX;
            int i = 0;
            while (i < this.txt.length()) {
                char ch = this.txt.charAt(i);
                if (dy <= this.y + this.height - g.getFont().getHeight() - this.margin) {
                    g.drawChar(ch, dx, dy, 20);
                    dy += g.getFont().getHeight();
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public boolean getActionResult() {
        return this.isRunning;
    }

    public void setActionResult(boolean result) {
    }

    public void threadAction() {
        if (this.txt == null || this.txt.trim().length() < 1) {
            return;
        }
        int dx = this.x + this.margin;
        int dy = this.y + this.margin;
        if (this.tickerMode == 0) {
            this.drawingX -= 3;
            if (this.drawingX < dx - Res.UIFONT.stringWidth(this.txt)) {
                this.drawingX = dx + this.width;
            }
        } else {
            this.drawingY -= 3;
            if (this.drawingY < dy - Res.UIFONT.getHeight() * this.txt.length()) {
                this.drawingY = dy + this.height;
            }
        }
    }

    public void start() {
        this.isRunning = true;
        this.drawingX = this.x;
        this.drawingY = this.y;
        ThreadManager.addTask(this);
    }

    public void stop() {
        this.isRunning = false;
    }
}

