/*
 * Decompiled with CFR 0.152.
 */
package com.file;

import com.file.DownloadManager;
import com.file.FileManager;
import com.file.FileOperatException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class DownloadFile {
    public static final byte LOADING = 1;
    public static final byte WAITING = 2;
    public static final byte PAUSED = 3;
    public static final byte FAIL = 4;
    public static final String FILE_SUB = ".do";
    public static final String INFO_SUB = ".data";
    public static final String NULL = "null";
    private byte type;
    private String downloadUrl;
    private String fileUrl;
    private String infoUrl;
    private long totalSize;
    public long currentSize;
    private int failCount;
    public static final byte FOE_TYPE_FILE_EXIST = 1;

    private DownloadFile() {
    }

    public DownloadFile(String downloadUrl, boolean directDownload) throws FileOperatException {
        if (downloadUrl == null || downloadUrl.length() < 1) {
            throw new FileOperatException("\u65e0\u6cd5\u6dfb\u52a0\u4efb\u52a1\uff01\u60a8\u8981\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        this.type = (byte)2;
        this.downloadUrl = downloadUrl;
        DownloadManager.addDownloadFile(this, false, true);
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        if (!this.fileUrl.endsWith(FILE_SUB)) {
            this.fileUrl = String.valueOf(this.fileUrl) + FILE_SUB;
        }
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public void setInfoUrl(String infoUrl) {
        this.infoUrl = infoUrl;
        if (!this.infoUrl.endsWith(INFO_SUB)) {
            this.infoUrl = String.valueOf(this.infoUrl) + INFO_SUB;
        }
    }

    public String getTempFileName(String locator) {
        if (locator != null) {
            return locator.substring(locator.lastIndexOf(47) + 1, locator.lastIndexOf(46));
        }
        return null;
    }

    public String getFileName() {
        String name;
        if (this.downloadUrl == null) {
            return null;
        }
        int qm = this.downloadUrl.indexOf(63);
        if (qm < 0) {
            qm = this.downloadUrl.length();
        }
        if ((name = this.downloadUrl.substring(this.downloadUrl.lastIndexOf(47) + 1, qm)).indexOf(".3gp") < 0) {
            name = String.valueOf(name) + ".3gp";
        }
        return name;
    }

    public String getLocator(String locator) {
        if (locator != null) {
            return locator.substring(0, locator.lastIndexOf(47) + 1);
        }
        return null;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }

    public void setCurrentSize(byte currentSize) {
        this.currentSize = currentSize;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public void fail() {
        ++this.failCount;
        if (this.failCount > 5) {
            this.type = (byte)4;
            DownloadManager.saveInfo(this);
        }
    }

    public byte[] getSeriers() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte oldType = this.type;
            if (this.type == 1) {
                this.type = (byte)2;
            }
            dos.writeByte(this.type);
            this.type = oldType;
            dos.writeLong(this.totalSize);
            dos.writeUTF(this.downloadUrl);
            if (this.fileUrl != null) {
                dos.writeUTF(this.fileUrl);
            } else {
                dos.writeUTF(NULL);
            }
            if (this.infoUrl != null) {
                dos.writeUTF(this.infoUrl);
            } else {
                dos.writeUTF(NULL);
            }
            return baos.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static DownloadFile createFromSeriers(DataInputStream dis) {
        DownloadFile ret = new DownloadFile();
        try {
            ret.type = dis.readByte();
            ret.totalSize = dis.readLong();
            ret.downloadUrl = dis.readUTF();
            ret.fileUrl = dis.readUTF();
            if (ret.fileUrl.equals(NULL)) {
                ret.fileUrl = null;
            }
            ret.infoUrl = dis.readUTF();
            if (ret.infoUrl.equals(NULL)) {
                ret.infoUrl = null;
            }
            if (ret.fileUrl != null) {
                ret.currentSize = FileManager.getFileSize(ret.fileUrl);
            }
        }
        catch (Exception e) {
            ret.type = (byte)4;
            e.printStackTrace();
        }
        return ret;
    }
}

