/*
 * Decompiled with CFR 0.152.
 */
package com.file;

import com.file.FileManager;

public class File {
    private File father;
    private String name;
    private String type;
    private String locator;
    private long fileSize;
    private boolean isDir;

    public File(File father, boolean isDir, String fullName) {
        this.father = father;
        this.isDir = isDir;
        this.setFullName(fullName);
        if (!isDir) {
            this.fileSize = FileManager.getFileSize(this.getLocator());
        }
    }

    public File(String locator, String fullName) {
        this.locator = locator;
        this.isDir = true;
        this.setFullName(fullName);
    }

    public boolean isDir() {
        return this.isDir;
    }

    public File getFather() {
        return this.father;
    }

    public String getName() {
        if (this.isDir) {
            return this.getDisplayName();
        }
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        if (this.name == null) {
            return null;
        }
        if (this.isDir) {
            if (this.name.endsWith("/")) {
                return this.name.substring(0, this.name.length() - 1);
            }
            return this.name;
        }
        if (this.type == null) {
            return this.name;
        }
        return String.valueOf(this.name) + '.' + this.type;
    }

    public String getFullName() {
        if (this.name == null) {
            return null;
        }
        if (this.isDir) {
            if (this.name.endsWith("/")) {
                return this.name;
            }
            return String.valueOf(this.name) + '/';
        }
        if (this.type == null) {
            return this.name;
        }
        return String.valueOf(this.name) + '.' + this.type;
    }

    public void setFullName(String fullName) {
        if (this.isDir) {
            this.name = fullName;
        } else {
            int dot = fullName.lastIndexOf(46);
            if (dot < 0 || dot == fullName.length() - 1) {
                this.name = fullName;
                this.type = null;
            } else {
                this.name = fullName.substring(0, dot);
                this.type = fullName.substring(dot + 1, fullName.length());
            }
        }
    }

    public String getLocator() {
        if (this.father == null) {
            return this.locator;
        }
        StringBuffer ret = new StringBuffer();
        ret.append(this.getFullName());
        File fa = this.getFather();
        if (fa != null) {
            ret.insert(0, fa.getLocator());
        }
        return ret.toString();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }
}

