/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.canvas.TheCanvas;
import com.canvas.view.View;
import com.canvas.view.item.ButtonView;
import com.canvas.view.item.FormView;
import com.canvas.view.item.ImageItem;
import com.canvas.view.item.ImageListView;
import com.canvas.view.item.ListItem;
import com.canvas.view.item.ListView;
import com.canvas.view.item.PageNumView;
import com.canvas.view.item.TextView;
import com.canvas.view.item.TitleView;
import com.canvas.view.until.ViewManager;
import com.freexml.XmlReader;
import com.http.Connection;
import com.model.Node;
import com.model.Resource;
import com.res.Res;
import com.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Image;

public class EpgMenu {
    public static Node rootNode = new Node();
    public static final int LIVEQERRYTIME = 7;
    private static final byte MODE_GETEPG = 1;
    private static final byte MODE_GETPLAYURL = 2;
    private static final byte MODE_GETPROGINFO = 3;
    private static final byte MODE_GETCHANNELDATA = 4;
    private static final byte MODE_GETSEARCHRESULT = 5;
    private static final byte MODE_GETFAVORITE = 6;
    private static final byte MODE_GETPRODUCT = 7;
    private static final byte MODE_UPDATEFAVORITE = 8;
    private static final byte MODE_UPDATESUBSCRIBE = 9;
    private static final byte MODE_UPDATEBOOKING = 10;
    private static final byte MODE_RECOMMEND = 11;

    public static synchronized Node getEpgMenu() {
        String result;
        block3: {
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<Id>").append("0").append("</Id>");
            sb.append("<Recursive>").append("0").append("</Recursive>");
            sb.append("<Filter>").append("1").append("</Filter>");
            sb.append("<Page>").append("1").append("</Page>");
            sb.append("<PSize>").append("0").append("</PSize>");
            sb.append("</Body></InterWBSC>");
            try {
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/getepg.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEPGMenu ERR:" + e);
                return null;
            }
        }
        rootNode = EpgMenu.buildBodyByXml(result, rootNode, (byte)1);
        return rootNode;
    }

    public static synchronized Node getPlayUrl(Node node) {
        String result;
        Node urlNode;
        block3: {
            urlNode = new Node();
            urlNode.nodeType = (byte)6;
            urlNode.desc = node.desc;
            urlNode.name = node.name;
            urlNode.isLive = node.isLive;
            urlNode.id = node.id;
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<Id>").append(node.id).append("</Id>");
            sb.append("<CntType>").append(node.isLive ? "1" : "0").append("</CntType>");
            sb.append("<SvrType>").append(node.SvrType).append("</SvrType>");
            sb.append("</Body></InterWBSC>");
            try {
                Tools.Println("\u7528\u6237\u53d6\u76f4\u64ad\u8282\u76ee\u5730\u5740 :" + sb.toString() + "\n");
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/getplayurl.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getPlayUrl ERR:" + e);
                return null;
            }
        }
        urlNode = EpgMenu.buildBodyByXml(result, urlNode, (byte)2);
        return urlNode;
    }

    public static String[] getBookLiveResult(Node node) {
        String result;
        String[] ret;
        block3: {
            ret = new String[]{"1", ""};
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<Action>").append("1").append("</Action>");
            sb.append("<Notify>").append("1").append("</Notify>");
            sb.append("<CntId>").append(node.id).append("</CntId>");
            sb.append("</Body></InterWBSC>");
            Tools.Println("\u9884\u8ba2\u8282\u76ee\u5730\u5740 :" + sb.toString() + "\n");
            result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/booking.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
            if (result != null) break block3;
            return null;
        }
        try {
            ret = EpgMenu.buildStringResultByXML(result, (byte)10);
        }
        catch (Exception e) {
            System.out.println("book ERR:" + e);
        }
        return ret;
    }

    private static String[] buildRecommondBody(XmlReader parser, String tag) {
        String[] ret = new String[]{"1", ""};
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Tips")) {
                    String Tips;
                    parser.next();
                    ret[1] = Tips = parser.getText();
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            ret[0] = "0";
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
        }
        return ret;
    }

    private static String[] buildBookBody(XmlReader parser, String tag) {
        String[] ret = new String[]{"1", ""};
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Tips")) {
                    String Tips;
                    parser.next();
                    ret[1] = Tips = parser.getText();
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            ret[0] = "0";
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
        }
        return ret;
    }

    private static Node buildPlayUrlBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                Node tmpNode;
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("PlayUrl")) {
                    String PlayUrl;
                    parser.next();
                    node.playUrl = PlayUrl = parser.getText();
                    System.out.println("PlayUrl=" + PlayUrl);
                } else if (tagname.equalsIgnoreCase("PId")) {
                    String PId;
                    parser.next();
                    node.id = PId = parser.getText();
                    System.out.println("PId=" + PId);
                } else if (tagname.equalsIgnoreCase("PName")) {
                    String PName;
                    parser.next();
                    node.name = PName = parser.getText();
                    System.out.println("PName=" + PName);
                } else if (tagname.equalsIgnoreCase("ProductType")) {
                    parser.next();
                    String ProductType = parser.getText();
                    node.productType = Byte.parseByte(ProductType);
                    System.out.println("ProductType=" + ProductType);
                } else if (tagname.equalsIgnoreCase("Confirm")) {
                    parser.next();
                    String Confirm = parser.getText();
                    node.confirm = Byte.parseByte(Confirm);
                    System.out.println("Confirm=" + Confirm);
                } else if (tagname.equalsIgnoreCase("ChargeDesc")) {
                    String ChargeDesc;
                    parser.next();
                    node.chargeDesc = ChargeDesc = parser.getText();
                    System.out.println("ChargeDesc=" + ChargeDesc);
                } else if (tagname.equalsIgnoreCase("DiscountDesc")) {
                    parser.next();
                    String DiscountDesc = parser.getText();
                    System.out.println("DiscountDesc=" + DiscountDesc);
                    node.discountDesc = DiscountDesc;
                } else if (tagname.equalsIgnoreCase("Tips")) {
                    String Tips;
                    parser.next();
                    node.desc = Tips = parser.getText();
                    System.out.println("Tips=" + Tips);
                } else if (tagname.equalsIgnoreCase("Cnt")) {
                    System.out.println("\u89e3\u6790Cnt");
                    tmpNode = new Node();
                    tmpNode = EpgMenu.buildChannelDataBody(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("ProductList")) {
                    System.out.println("ProductList");
                    node = EpgMenu.buildPlayUrlBody(parser, tagname, node);
                } else if (tagname.equalsIgnoreCase("Product")) {
                    System.out.println("\u89e3\u6790Product");
                    tmpNode = new Node();
                    tmpNode = EpgMenu.buildPlayUrlBody(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("Ret")) {
                    String Ret = parser.getText();
                    System.out.println("Ret=" + Ret);
                    node.retCode = Ret.trim();
                } else {
                    parser.next();
                }
                if (parser.getText() == null || parser.getText().length() == 0) {
                    event = parser.next();
                    continue;
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            return node;
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
            return null;
        }
    }

    public static synchronized Node getLiveData(Node node) {
        block7: {
            System.out.println("getLiveInfo...");
            Connection conn = new Connection();
            String host = Resource.WBSC_MOBILE_HOST;
            String path = "service/querylivedetail.do";
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            Calendar calendar = Calendar.getInstance();
            Date localDate = calendar.getTime();
            long mill = localDate.getTime() - Resource.serverTimeOffset;
            Date serverDate = new Date();
            serverDate.setTime(mill);
            Calendar severTime = Calendar.getInstance();
            severTime.setTime(serverDate);
            System.out.println("\u5f53\u524d\u65f6\u95f4\uff1a" + severTime.getTime());
            StringBuffer buffer = new StringBuffer();
            int month = severTime.get(2);
            int date = severTime.get(5);
            String str_m = String.valueOf(month);
            String str_d = String.valueOf(date);
            if (month < 10) {
                str_m = "0" + month;
            }
            if (date < 10) {
                str_d = "0" + date;
            }
            buffer.append(severTime.get(1)).append("-");
            buffer.append(str_m).append("-");
            buffer.append(str_d).append(" ");
            sb.append("<Body>");
            sb.append("<ChannelId>").append(node.id).append("</ChannelId>");
            sb.append("<BeginTime>").append(String.valueOf(buffer.toString()) + "00:00:00").append("</BeginTime>");
            sb.append("<EndTime>").append(String.valueOf(buffer.toString()) + "23:59:59").append("</EndTime>");
            sb.append("</Body></InterWBSC>");
            try {
                Tools.Println("\u7528\u6237\u53d6\u76f4\u64ad\u8282\u76ee\u5355 :" + sb.toString() + "\n");
                byte[] bts = conn.doPost(host, path, Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (bts == null) break block7;
                String xml = "";
                try {
                    xml = new String(bts, "UTF-8");
                    if (xml != null) {
                        xml = xml.trim();
                    }
                    Tools.Println("\u83b7\u5f97\u76f4\u64ad\u8282\u76ee\u5355:" + xml + "/n");
                    node = EpgMenu.buildBodyByXml(xml, node, (byte)4);
                }
                catch (Exception ex) {
                    System.out.println("getLiveData ERR1:" + ex);
                }
                return node;
            }
            catch (Exception e) {
                System.out.println("getLiveData ERR:" + e);
            }
        }
        return null;
    }

    public static synchronized Node getProgInfo(Node node) {
        String result;
        block3: {
            System.out.println("getProgInfo...");
            node.isLive = false;
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<CntId>").append(node.id).append("</CntId>");
            sb.append("</Body></InterWBSC>");
            try {
                Tools.Println("\u7528\u6237\u53d6\u8282\u76ee\u8be6\u60c5 :" + sb.toString() + "\n");
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/queryother.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEpgNodeList ERR:" + e);
                return null;
            }
        }
        Tools.Println("\u7528\u6237\u53d6\u8282\u76ee\u8be6\u60c5\u7ed3\u679c:" + result + "/n");
        node = EpgMenu.buildBodyByXml(result, node, (byte)3);
        return node;
    }

    private static Node buildProgInfoBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("NeedDRMPack")) {
                    parser.next();
                    String NeedDRMPack = parser.getText();
                    node.needDRMPack = NeedDRMPack.trim().equals("0");
                    System.out.println("NeedDRMPack=" + NeedDRMPack);
                } else if (tagname.equalsIgnoreCase("DRMPackType")) {
                    parser.next();
                    String DRMPackType = parser.getText();
                    node.DRMPackType = Byte.parseByte(DRMPackType);
                    System.out.println("DRMPackType=" + DRMPackType);
                } else if (tagname.equalsIgnoreCase("PublishArea")) {
                    String PublishArea;
                    parser.next();
                    node.publishArea = PublishArea = parser.getText();
                    System.out.println("PublishArea=" + PublishArea);
                } else if (tagname.equalsIgnoreCase("PublishDate")) {
                    String PublishDate;
                    parser.next();
                    node.date = PublishDate = parser.getText();
                    System.out.println("PublishDate=" + PublishDate);
                } else if (tagname.equalsIgnoreCase("Feature")) {
                    String Feature2;
                    parser.next();
                    node.feature = Feature2 = parser.getText();
                    System.out.println("Feature=" + Feature2);
                } else if (tagname.equalsIgnoreCase("Actors")) {
                    String Actors;
                    parser.next();
                    node.actors = Actors = parser.getText();
                    System.out.println("Actors=" + Actors);
                } else if (tagname.equalsIgnoreCase("Director")) {
                    String Director;
                    parser.next();
                    node.director = Director = parser.getText();
                    System.out.println("Director=" + Director);
                } else if (tagname.equalsIgnoreCase("Description")) {
                    String Description;
                    parser.next();
                    node.desc = Description = parser.getText();
                    System.out.println("Description=" + Description);
                } else if (tagname.equalsIgnoreCase("ClickNum")) {
                    parser.next();
                    String ClickNum = parser.getText();
                    node.clickNum = Integer.parseInt(ClickNum);
                    System.out.println("ClickNum=" + ClickNum);
                } else if (tagname.equalsIgnoreCase("Picture")) {
                    String Picture;
                    parser.next();
                    node.icon = Picture = parser.getText();
                    System.out.println("Picture=" + Picture);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            return node;
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
            return null;
        }
    }

    public static synchronized Node getEpgNodeList(Node node, String page) {
        String result;
        block3: {
            System.out.println("getEpgNodeList...");
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<Id>").append(node.id).append("</Id>");
            sb.append("<Recursive>").append("0").append("</Recursive>");
            sb.append("<Filter>").append("1").append("</Filter>");
            sb.append("<Page>").append(page).append("</Page>");
            sb.append("<PSize>").append("0").append("</PSize>");
            sb.append("</Body></InterWBSC>");
            try {
                Tools.Println("\u7528\u6237\u53d6NodeList\u8282\u76ee\u5355 :" + sb.toString() + "\n");
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/getepg.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEpgNodeList ERR:" + e);
                return null;
            }
        }
        Tools.Println("\u83b7\u5f97NodeList\u8282\u76ee\u5355:" + result + "/n");
        node = EpgMenu.buildBodyByXml(result, node, (byte)1);
        return node;
    }

    private static synchronized void buildEPGNodeList(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                System.out.println("tagname1== " + tagname);
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Node")) {
                    System.out.println("\u89e3\u6790Node");
                    Node tmpNode = new Node();
                    EpgMenu.buildEPGNodeList(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("NodeType")) {
                    parser.next();
                    String nodeType = parser.getText();
                    node.nodeType = Byte.parseByte(nodeType);
                    System.out.println("nodeType=" + nodeType);
                } else if (tagname.equalsIgnoreCase("FatherId")) {
                    String fatherId;
                    parser.next();
                    node.fatherId = fatherId = parser.getText();
                    System.out.println("fatherId=" + fatherId);
                } else if (tagname.equalsIgnoreCase("Id")) {
                    String id;
                    parser.next();
                    node.id = id = parser.getText();
                    System.out.println("Id=" + id);
                } else if (tagname.equalsIgnoreCase("Name")) {
                    String name;
                    parser.next();
                    node.name = name = parser.getText();
                    System.out.println("Name=" + name);
                } else if (tagname.equalsIgnoreCase("Icon")) {
                    String icon;
                    parser.next();
                    node.icon = icon = parser.getText();
                    System.out.println("Icon=" + icon);
                } else if (tagname.equalsIgnoreCase("Desc")) {
                    String desc;
                    parser.next();
                    node.desc = desc = parser.getText();
                    System.out.println("Desc=" + desc);
                } else if (tagname.equalsIgnoreCase("SvrType")) {
                    parser.next();
                    String svrType = parser.getText();
                    node.SvrType = Byte.parseByte(svrType);
                    System.out.println("SvrType=" + svrType);
                } else {
                    parser.next();
                }
                if (parser.getText() == null || parser.getText().length() == 0) {
                    event = parser.next();
                    continue;
                }
                event = parser.next();
                String tagname2 = parser.getName();
                System.out.println("tagname2== " + tagname2);
                if (event == 2) continue;
                event = parser.next();
                String tagname3 = parser.getName();
                System.out.println("tagname3== " + tagname3);
            }
            Tools.Println("EPG Body.NodeList \u89e3\u6790\u5b8c\u6bd5");
        }
        catch (Exception e) {
            System.out.println("buildEPGNodeList Err:" + e);
        }
    }

    private static synchronized void buildEPGBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("PTotal")) {
                    parser.next();
                    String pTotal = parser.getText();
                    node.pTotal = Integer.parseInt(pTotal);
                    System.out.println("PTotal=" + pTotal);
                } else if (tagname.equalsIgnoreCase("Page")) {
                    parser.next();
                    String page = parser.getText();
                    node.page = Integer.parseInt(page);
                    System.out.println("Page=" + page);
                } else if (tagname.equalsIgnoreCase("NodeList")) {
                    System.out.println("\u89e3\u6790NodeList");
                    EpgMenu.buildEPGNodeList(parser, tagname, node);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
        }
    }

    private static synchronized Node buildBodyByXml(String content, Node node, byte mode) {
        if (content == null || content.length() <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
            InputStreamReader isrx = new InputStreamReader((InputStream)bais, "UTF-8");
            XmlReader parser = new XmlReader(isrx);
            parser.next();
            parser.require(2, "InterWBSC");
            int eventType = parser.next();
            while (eventType != 3) {
                if (eventType == 4) {
                    eventType = parser.next();
                    continue;
                }
                String tagName = parser.getName();
                if (tagName == null) break;
                if (!Tools.parseXMLHead(parser, tagName) && "Body".equalsIgnoreCase(tagName)) {
                    if (mode == 1) {
                        EpgMenu.buildEPGBody(parser, tagName, node);
                    } else if (mode == 2) {
                        node = EpgMenu.buildPlayUrlBody(parser, tagName, node);
                    } else if (mode == 3) {
                        node = EpgMenu.buildProgInfoBody(parser, tagName, node);
                    } else if (mode == 4) {
                        node = EpgMenu.buildChannelDataBody(parser, tagName, node);
                    } else if (mode == 5) {
                        node = EpgMenu.buildSearchDataBody(parser, tagName, node);
                    } else if (mode == 6) {
                        node = EpgMenu.buildFavoriteBody(parser, tagName, node);
                    } else if (mode == 7) {
                        node = EpgMenu.buildProductBody(parser, tagName, node);
                    }
                }
                if ((eventType = parser.next()) == 2) continue;
                eventType = parser.next();
            }
            parser.require(1, null);
            parser = null;
            isrx.close();
            bais.close();
            content = null;
            Tools.Println("EPG \u5185\u5bb9\u5168\u90e8\u89e3\u6790\u5b8c\u6bd5");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return node;
    }

    private static Node buildProductBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("PId")) {
                    String PId;
                    parser.next();
                    node.id = PId = parser.getText();
                    System.out.println("PId=" + PId);
                } else if (tagname.equalsIgnoreCase("PName")) {
                    String PName;
                    parser.next();
                    node.name = PName = parser.getText();
                    System.out.println("PName=" + PName);
                } else if (tagname.equalsIgnoreCase("ProductType")) {
                    parser.next();
                    String ProductType = parser.getText();
                    node.productType = Byte.parseByte(ProductType);
                    System.out.println("ProductType=" + ProductType);
                } else if (tagname.equalsIgnoreCase("Confirm")) {
                    parser.next();
                    String Confirm = parser.getText();
                    System.out.println("Confirm=" + Confirm);
                    node.confirm = Byte.parseByte(Confirm);
                    System.out.println("Confirm ok");
                } else if (tagname.equalsIgnoreCase("ChargeDesc")) {
                    parser.next();
                    String ChargeDesc = parser.getText();
                    System.out.println("ChargeDesc=" + ChargeDesc);
                    node.chargeDesc = ChargeDesc;
                    System.out.println("ChargeDesc ok");
                } else if (tagname.equalsIgnoreCase("DiscountDesc")) {
                    parser.next();
                    String DiscountDesc = parser.getText();
                    System.out.println("DiscountDesc=" + DiscountDesc);
                    node.discountDesc = DiscountDesc;
                    System.out.println("DiscountDesc ok");
                } else if (tagname.equalsIgnoreCase("Status")) {
                    parser.next();
                    String Status = parser.getText();
                    System.out.println("Status=" + Status);
                    node.status = Byte.parseByte(Status);
                    System.out.println("Status ok");
                } else if (tagname.equalsIgnoreCase("Product")) {
                    System.out.println("\u89e3\u6790Product");
                    Node tmpNode = new Node();
                    tmpNode = EpgMenu.buildProductBody(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("ProductList")) {
                    System.out.println("ProductList");
                    node = EpgMenu.buildProductBody(parser, tagname, node);
                } else {
                    parser.next();
                }
                if (parser.getText() == null || parser.getText().length() == 0) {
                    event = parser.next();
                    continue;
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            return node;
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
            return null;
        }
    }

    public static View buildViews(View view, String tag, XmlReader parser) {
        try {
            parser.require(2, tag);
            while (true) {
                String w;
                int event = parser.next();
                String tagname = parser.getName();
                if (tagname == null) continue;
                if (event == 3 && tagname.equals(tag)) {
                    parser.require(3, tag);
                    return view;
                }
                View v = null;
                if (tagname.equals("form")) {
                    v = new FormView();
                } else if (tagname.equals("list")) {
                    v = new ListView();
                } else if (tagname.equals("imageList")) {
                    v = new ImageListView();
                }
                if (tagname.equals("title")) {
                    v = new TitleView();
                } else if (tagname.equals("button")) {
                    v = new ButtonView();
                } else if (tagname.equals("imgitem")) {
                    v = new ImageItem();
                } else if (tagname.equals("text")) {
                    v = new TextView();
                } else if (tagname.equals("listItem")) {
                    v = new ListItem();
                }
                if (v != null) {
                    String id;
                    if (parser.getAttributeCount() <= 0 || (id = parser.getAttributeValue(0).trim()) == null || id.length() <= 0) continue;
                    v.setId(id);
                    view.addItem(v);
                    v = EpgMenu.buildViews(v, tagname, parser);
                    ViewManager.addView(id, v);
                }
                if (tagname.equals("x")) {
                    parser.next();
                    String x = parser.readText();
                    view.setX(Integer.parseInt(x));
                } else if (tagname.equals("y")) {
                    parser.next();
                    String y = parser.readText();
                    view.setY(Integer.parseInt(y));
                } else if (tagname.equals("width")) {
                    parser.next();
                    w = parser.readText();
                    view.setWidth(Integer.parseInt(w));
                } else if (tagname.equals("height")) {
                    parser.next();
                    w = parser.readText();
                    view.setHeight(Integer.parseInt(w));
                }
                if (tagname.equals("color")) {
                    parser.next();
                    w = parser.readText();
                    int color = EpgMenu.getColorByString(w);
                    view.setColor(color);
                    continue;
                }
                if (tagname.equalsIgnoreCase("fontColor")) {
                    parser.next();
                    w = parser.readText();
                    int color = EpgMenu.getColorByString(w);
                    view.setFontColor(color);
                    continue;
                }
                if (tagname.equals("label")) {
                    parser.next();
                    w = parser.readText();
                    view.setLabel(w);
                    continue;
                }
                if (tagname.equals("image")) {
                    parser.next();
                    w = parser.readText();
                    view.setImg(w);
                    continue;
                }
                if (tagname.equals("imgtype")) {
                    parser.next();
                    w = parser.readText();
                    view.setImgType(w);
                    continue;
                }
                if (tagname.equals("layout")) {
                    parser.next();
                    w = parser.readText();
                    if (view.getType() == 1) {
                        ListView list = (ListView)view;
                        list.setListMode(w);
                        continue;
                    }
                    if (view.getType() != 12) continue;
                    ImageListView list = (ImageListView)view;
                    list.setListMode(w);
                    continue;
                }
                if (tagname.equals("labelMode")) {
                    parser.next();
                    w = parser.readText();
                    TitleView title = (TitleView)view;
                    title.setLabelMode(w);
                    continue;
                }
                if (tagname.equals("bind")) {
                    parser.next();
                    w = parser.readText();
                    if (view.getType() != 3) continue;
                    ButtonView button = (ButtonView)view;
                    button.setBindKey(w);
                    continue;
                }
                if (tagname.equals("buttontype")) {
                    parser.next();
                    w = parser.readText();
                    if (view.getType() != 3) continue;
                    ButtonView button = (ButtonView)view;
                    button.setButtonType(w);
                    continue;
                }
                if (tagname.equals("fillBG")) {
                    parser.next();
                    w = parser.readText();
                    view.setFillBG(w);
                    continue;
                }
                if (tagname.equals("showDesc")) {
                    parser.next();
                    w = parser.readText();
                    ImageItem iiv = (ImageItem)view;
                    if (w.equalsIgnoreCase("false")) {
                        iiv.setShowDesCribe(false);
                    } else {
                        iiv.setShowDesCribe(true);
                    }
                    view.setFillBG(w);
                    continue;
                }
                if (tagname.equals("icon")) {
                    parser.next();
                    w = parser.readText();
                    if (!(view instanceof ListItem)) continue;
                    ListItem item = (ListItem)view;
                    item.setIcon(w);
                    continue;
                }
                parser.next();
            }
        }
        catch (IOException e) {
            View view2;
            System.out.println("buildViews: " + e);
            return view2;
        }
    }

    public static View buildViewsByXml(String content) {
        if (content == null || content.length() <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
            InputStreamReader isrx = new InputStreamReader((InputStream)bais, "UTF-8");
            XmlReader parser = new XmlReader(isrx);
            parser.next();
            parser.require(2, "views");
            while (parser.next() != 1) {
                String id;
                String tagname = parser.getName();
                if (tagname == null || !tagname.equals("form") && !tagname.equals("list") && !tagname.equals("title") && !tagname.equals("foot") && !tagname.equals("button")) continue;
                View view = new View();
                if (tagname.equals("form")) {
                    view = new FormView();
                } else if (tagname.equals("list")) {
                    view = new ListView();
                } else if (tagname.equals("title")) {
                    view = new TitleView();
                } else if (tagname.equals("button")) {
                    view = new ButtonView();
                }
                if (parser.getAttributeCount() <= 0 || (id = parser.getAttributeValue(0).trim()) == null || id.length() <= 0) continue;
                view.setId(id);
                view = EpgMenu.buildViews(view, tagname, parser);
                ViewManager.addView(id, view);
            }
            parser.require(1, null);
            parser = null;
            isrx.close();
            bais.close();
        }
        catch (Exception e) {
            System.out.println("buildViewsByXml:" + e.toString());
        }
        return null;
    }

    public static int getColorByString(String str) {
        int result = 0xFFFFFF;
        if (str == null || str.trim().length() > 0) {
            if (str.startsWith("0x") || str.startsWith("ox")) {
                str = str.substring(2);
            }
            result = Integer.parseInt(str, 16);
        }
        return result;
    }

    public static void buildListViewByProgs(Node node, ListView view) {
        if (node == null || node.nodeList == null || node.nodeList.size() < 1) {
            return;
        }
        int i = 0;
        while (i < node.nodeList.size()) {
            ListItem item = new ListItem();
            Node prog = (Node)node.nodeList.elementAt(i);
            item.setLabel(prog.name);
            item.setDeskCribe(prog.desc);
            item.setData(prog);
            item.setId(prog.id);
            item.setIconUrl(prog.icon);
            System.out.println("prog.icon:" + prog.icon);
            System.out.println("prog.name:" + prog.name);
            System.out.println("prog.type:" + prog.nodeType);
            view.addItem(item);
            ++i;
        }
        System.out.println("PTotal:" + node.pTotal);
        System.out.println("page:" + node.page);
        if (node.pTotal > 1) {
            PageNumView pnv = new PageNumView(view);
            pnv.setTotalPage(node.pTotal);
            pnv.setCurrentPage(node.page);
            Image img1 = (Image)Res.imageTable.get("prepage");
            Image img2 = (Image)Res.imageTable.get("nextpage");
            pnv.setPageImg(img1, img2);
            pnv.setX(view.getX());
            pnv.setY(view.getY() + view.getHeight() - pnv.getHeight());
            view.setPageNumber(pnv);
            view.setListMode(view.getListMode());
            view.refreshItems();
        }
    }

    private static synchronized Node buildChannelDataBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Id")) {
                    String Id;
                    parser.next();
                    node.id = Id = parser.getText();
                    System.out.println("id=" + Id);
                } else if (tagname.equalsIgnoreCase("Name")) {
                    String Name;
                    parser.next();
                    node.name = Name = parser.getText();
                    System.out.println("Name=" + Name);
                } else if (tagname.equalsIgnoreCase("Date")) {
                    String Date2;
                    parser.next();
                    node.date = Date2 = parser.getText();
                    System.out.println("Date=" + Date2);
                } else if (tagname.equalsIgnoreCase("STime")) {
                    String STime;
                    parser.next();
                    node.startTime = STime = parser.getText();
                    System.out.println("STime=" + STime);
                } else if (tagname.equalsIgnoreCase("ETime")) {
                    String ETime;
                    parser.next();
                    node.endTime = ETime = parser.getText();
                    System.out.println("ETime=" + ETime);
                } else if (tagname.equalsIgnoreCase("Status")) {
                    parser.next();
                    String Status = parser.getText();
                    node.status = Byte.parseByte(Status);
                    System.out.println("Status=" + Status);
                } else if (tagname.equalsIgnoreCase("Cnt")) {
                    System.out.println("\u89e3\u6790Cnt");
                    Node tmpNode = new Node();
                    tmpNode = EpgMenu.buildChannelDataBody(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("CntList")) {
                    System.out.println("\u89e3\u6790CntList");
                    node = EpgMenu.buildChannelDataBody(parser, tagname, node);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            return node;
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
            return null;
        }
    }

    public static Object getSearchResult(Node node, String page, String key) {
        String result;
        block4: {
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<Key>").append(key).append("</Key>");
            System.out.println("Search id=" + node.id);
            if (node.id != null && node.id.trim().length() > 0) {
                sb.append("<CntId>").append(node.id).append("</CntId>");
            }
            sb.append("<PSize>").append("0").append("</PSize>");
            sb.append("<Page>").append(page).append("</Page>");
            sb.append("</Body></InterWBSC>");
            try {
                Tools.Println("\u7528\u6237\u641c\u7d22 :" + sb.toString() + "\n");
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/search.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block4;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEPGMenu ERR:" + e);
                return null;
            }
        }
        node = EpgMenu.buildBodyByXml(result, node, (byte)5);
        return node;
    }

    private static Node buildSearchDataBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Count")) {
                    parser.next();
                    String Count = parser.getText();
                    System.out.println("Count=" + Count);
                } else if (tagname.equalsIgnoreCase("Id")) {
                    String Id;
                    parser.next();
                    node.id = Id = parser.getText();
                    System.out.println("id=" + Id);
                } else if (tagname.equalsIgnoreCase("PTotal")) {
                    parser.next();
                    String PTotal = parser.getText();
                    node.pTotal = Integer.parseInt(PTotal);
                    System.out.println("PTotal=" + PTotal);
                } else if (tagname.equalsIgnoreCase("Page")) {
                    parser.next();
                    String Page = parser.getText();
                    node.page = Integer.parseInt(Page);
                    System.out.println("Page=" + Page);
                } else if (tagname.equalsIgnoreCase("Name")) {
                    String Name;
                    parser.next();
                    node.name = Name = parser.getText();
                    System.out.println("Name=" + Name);
                } else if (tagname.equalsIgnoreCase("Type")) {
                    parser.next();
                    String Type2 = parser.getText();
                    if (Type2.trim().equals("1")) {
                        node.isLive = true;
                        node.nodeType = (byte)3;
                    } else {
                        node.isLive = false;
                        node.nodeType = (byte)2;
                    }
                    System.out.println("Type=" + Type2);
                } else if (tagname.equalsIgnoreCase("Level")) {
                    parser.next();
                    String Level2 = parser.getText();
                    node.level = Byte.parseByte(Level2);
                    System.out.println("Level=" + Level2);
                } else if (tagname.equalsIgnoreCase("STime")) {
                    String STime;
                    parser.next();
                    node.startTime = STime = parser.getText();
                    System.out.println("STime=" + STime);
                } else if (tagname.equalsIgnoreCase("ETime")) {
                    String ETime;
                    parser.next();
                    node.endTime = ETime = parser.getText();
                    System.out.println("ETime=" + ETime);
                } else if (tagname.equalsIgnoreCase("Status")) {
                    parser.next();
                    String Status = parser.getText();
                    node.status = Byte.parseByte(Status);
                    System.out.println("Status=" + Status);
                } else if (tagname.equalsIgnoreCase("Cnt")) {
                    System.out.println("\u89e3\u6790Cnt");
                    Node tmpNode = new Node();
                    tmpNode = EpgMenu.buildSearchDataBody(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("CntList")) {
                    System.out.println("\u89e3\u6790CntList");
                    node = EpgMenu.buildSearchDataBody(parser, tagname, node);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            return node;
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
            return null;
        }
    }

    public static synchronized Node getProductInfo() {
        String result;
        Node node;
        block3: {
            System.out.println("getProgInfo...");
            node = null;
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<FilterType>").append("0").append("</FilterType>");
            sb.append("</Body></InterWBSC>");
            Tools.Println("\u7528\u6237\u53d6\u4ea7\u54c1\u8ba2\u8d2d\u8be6\u60c5 :" + sb.toString() + "\n");
            result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/getproduct.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
            if (result != null) break block3;
            return null;
        }
        try {
            node = EpgMenu.buildBodyByXml(result, new Node(), (byte)7);
        }
        catch (Exception e) {
            System.out.println("getEpgNodeList ERR:" + e);
        }
        return node;
    }

    public static String getDataFromServer(String server, String port, boolean isProxy, byte[] toSend) {
        Connection conn = new Connection();
        if (conn == null) {
            return null;
        }
        try {
            Tools.Println("\u4ece\u670d\u52a1\u5668\u53d6\u8d44\u6599 :" + toSend + "\n");
            byte[] bts = conn.doPost(server, port, Resource.isProxy, toSend);
            if (bts != null) {
                try {
                    String xml = new String(bts, "UTF-8");
                    if (xml != null) {
                        xml = xml.trim();
                    }
                    Tools.Println("\u4ece\u670d\u52a1\u5668\u53d6\u8d44\u6599\u7ed3\u679c:" + xml + "/n");
                    return xml;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println("updateUserInfo ERR:" + e);
        }
        return null;
    }

    public static Object getFavoriteList(Node node) {
        String result;
        block3: {
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<Filter>").append("0").append("</Filter>");
            sb.append("</Body></InterWBSC>");
            try {
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/getfavorite.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEPGMenu ERR:" + e);
                return null;
            }
        }
        node = EpgMenu.buildBodyByXml(result, node, (byte)6);
        return node;
    }

    private static Node buildFavoriteBody(XmlReader parser, String tag, Node node) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Id")) {
                    String Id;
                    parser.next();
                    node.id = Id = parser.getText();
                    System.out.println("id=" + Id);
                } else if (tagname.equalsIgnoreCase("Icon")) {
                    String Icon;
                    parser.next();
                    node.icon = Icon = parser.getText();
                    System.out.println("Icon=" + Icon);
                } else if (tagname.equalsIgnoreCase("Name")) {
                    String Name;
                    parser.next();
                    node.name = Name = parser.getText();
                    System.out.println("Name=" + Name);
                } else if (tagname.equalsIgnoreCase("Type")) {
                    parser.next();
                    String Type2 = parser.getText();
                    if (Type2.trim().equals("1")) {
                        node.isLive = false;
                        node.nodeType = (byte)2;
                    } else if (Type2.trim().equals("3")) {
                        node.isLive = true;
                        node.nodeType = (byte)3;
                    } else {
                        node.isLive = false;
                        node.nodeType = 1;
                    }
                    System.out.println("Type=" + Type2);
                } else if (tagname.equalsIgnoreCase("Cnt")) {
                    System.out.println("\u89e3\u6790Cnt");
                    Node tmpNode = new Node();
                    tmpNode = EpgMenu.buildFavoriteBody(parser, tagname, tmpNode);
                    node.addNode(tmpNode);
                } else if (tagname.equalsIgnoreCase("CntList")) {
                    System.out.println("\u89e3\u6790CntList");
                    node = EpgMenu.buildFavoriteBody(parser, tagname, node);
                } else {
                    parser.next();
                }
                if (parser.getText() == null || parser.getText().length() == 0) {
                    event = parser.next();
                    continue;
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
            return node;
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
            return null;
        }
    }

    public static String[] updateFavorite(Node node, String type) {
        String result;
        String[] ret;
        block3: {
            ret = null;
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            int tmpType = 1;
            tmpType = node.nodeType == 1 ? 2 : (node.nodeType == 2 ? 1 : 3);
            sb.append("<Body>");
            sb.append("<Action>").append(type).append("</Action>");
            sb.append("<CntId>").append(node.id).append("</CntId>");
            sb.append("<Type>").append(tmpType).append("</Type>");
            sb.append("</Body></InterWBSC>");
            try {
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/updatefavorite.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEPGMenu ERR:" + e);
                return ret;
            }
        }
        System.out.println("\u6536\u85cf\u64cd\u4f5c\u7ed3\u679c\uff1a" + result);
        ret = EpgMenu.buildStringResultByXML(result, (byte)8);
        return ret;
    }

    private static String[] buildFavoriUpdateBody(XmlReader parser, String tag) {
        String[] ret = new String[]{"1", ""};
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Tips")) {
                    parser.next();
                    String Tips = parser.getText();
                    if (Tips != null && Tips.trim().length() > 0) {
                        ret[1] = Tips;
                    }
                    System.out.println("Tips=" + Tips);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("buildFavoriUpdateBody \u89e3\u6790\u5b8c\u6bd5");
            ret[0] = "0";
            return ret;
        }
        catch (IOException e) {
            System.out.println("buildBody ERR:" + e);
            return ret;
        }
    }

    public static String[] getUpdateProudctResult(Node node, String type) {
        String result;
        String[] ret;
        block3: {
            ret = new String[]{"1", ""};
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("<PId>").append(node.id).append("</PId>");
            sb.append("<Action>").append(type).append("</Action>");
            sb.append("</Body></InterWBSC>");
            System.out.println("tUpdateProudctResult:" + sb.toString());
            try {
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/subscribe.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                TheCanvas.addTestInfo("\u8ba2\u8d2d\u7ed3\u679c:" + result);
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEPGMenu ERR:" + e);
                return ret;
            }
        }
        ret = EpgMenu.buildStringResultByXML(result, (byte)9);
        return ret;
    }

    private static String[] buildStringResultByXML(String content, byte type) {
        String[] ret = new String[]{"1", ""};
        if (content == null || content.length() <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
            InputStreamReader isrx = new InputStreamReader((InputStream)bais, "UTF-8");
            XmlReader parser = new XmlReader(isrx);
            parser.next();
            parser.require(2, "InterWBSC");
            int eventType = parser.next();
            while (eventType != 3) {
                if (eventType == 4) {
                    eventType = parser.next();
                    continue;
                }
                String tagName = parser.getName();
                if (tagName == null) break;
                if (!Tools.parseXMLHead(parser, tagName) && "Body".equalsIgnoreCase(tagName)) {
                    if (type == 8) {
                        ret = EpgMenu.buildFavoriUpdateBody(parser, tagName);
                    } else if (type == 9) {
                        ret = EpgMenu.BuildUpdateSubscribeBody(parser, tagName);
                    } else if (type == 10) {
                        ret = EpgMenu.buildBookBody(parser, tagName);
                    } else if (type == 11) {
                        ret = EpgMenu.buildRecommondBody(parser, tagName);
                    }
                }
                if ((eventType = parser.next()) == 2) continue;
                eventType = parser.next();
            }
            parser.require(1, null);
            parser = null;
            isrx.close();
            bais.close();
            content = null;
            Tools.Println("buildFavoriteByXML \u5185\u5bb9\u5168\u90e8\u89e3\u6790\u5b8c\u6bd5");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    private static String[] BuildUpdateSubscribeBody(XmlReader parser, String tag) {
        String[] ret = new String[]{"1", ""};
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Tips")) {
                    parser.next();
                    String Tips = parser.getText();
                    if (Tips != null && Tips.trim().length() > 0) {
                        ret[1] = Tips;
                    }
                    System.out.println("Tips=" + Tips);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("BuildUpdateSubscribeBody \u89e3\u6790\u5b8c\u6bd5");
            ret[0] = "0";
            return ret;
        }
        catch (IOException e) {
            System.out.println("buildBody ERR:" + e);
            return ret;
        }
    }

    public static String[] sendCommendMSM(String friends, String contentId, String txt) {
        String result;
        String[] ret;
        block4: {
            System.out.println("\u51c6\u5907\u53d1\u9001\u597d\u53cb\u63a8\u8350");
            ret = null;
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            if (contentId != null && contentId.trim().length() > 0) {
                sb.append("<CntId>").append(contentId).append("</CntId>");
            }
            sb.append("<Words>").append(txt).append("</Words>");
            sb.append(friends);
            sb.append("</Body></InterWBSC>");
            System.out.println("\u53d1\u9001\u597d\u53cb\u63a8\u8350\uff1a" + sb.toString());
            try {
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/recommend.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block4;
                return null;
            }
            catch (Exception e) {
                System.out.println("getEPGMenu ERR:" + e);
                return ret;
            }
        }
        System.out.println("\u7528\u6237\u63a8\u8350\u8fd4\u56de\u7ed3\u679c:" + result);
        ret = EpgMenu.buildStringResultByXML(result, (byte)11);
        return ret;
    }
}

