/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.freexml.XmlReader;
import com.image.ImageBuffer;
import com.image.ImageHolder;
import com.model.EpgMenu;
import com.model.Resource;
import com.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class UserInfo {
    public static UserInfo iUserInfo = null;
    public static String iUserRecordName = "UserInformation";
    public String uid = "";
    public byte sex = 0;
    public String pwd = "";
    public int age = 0;
    public String imsi = UserInfo.getIMSI();
    public int status = -1;
    public String nickName = "\u4f5a\u540d";
    public String userlevel = "\u672a\u77e5";
    public String city = "\u672a\u77e5";
    public String sign = "\u6b64\u4eba\u592a\u61d2\u5565\u90fd\u6ca1\u5199";
    public String desc = "";
    public String skin = "default";
    public String saveDirectoryUrl = "null";

    private UserInfo() {
    }

    public static String getIMSI() {
        String imsi = null;
        imsi = System.getProperty("IMSI");
        if (imsi == null) {
            imsi = System.getProperty("com.nokia.mid.imsi");
        }
        if (imsi == null) {
            imsi = System.getProperty("com.sonyericsson.imsi");
        }
        if (imsi == null) {
            imsi = "";
        }
        Tools.Println("IMSI : " + imsi);
        return imsi;
    }

    /*
     * WARNING - void declaration
     */
    public static UserInfo getRecord() {
        void var0;
        UserInfo ret = new UserInfo();
        RecordStore store = null;
        try {
            try {
                store = RecordStore.openRecordStore((String)"conf", (boolean)false);
                byte[] bytes = store.getRecord(1);
                ByteArrayInputStream inbyte = new ByteArrayInputStream(bytes);
                DataInputStream indata = new DataInputStream(inbyte);
                ret.uid = indata.readUTF();
                ret.sex = indata.readByte();
                ret.pwd = indata.readUTF();
                ret.age = indata.readInt();
                ret.imsi = indata.readUTF();
                ret.status = indata.readInt();
                ret.nickName = indata.readUTF();
                ret.userlevel = indata.readUTF();
                ret.city = indata.readUTF();
                ret.sign = indata.readUTF();
                ret.desc = indata.readUTF();
                ret.skin = indata.readUTF();
                ret.saveDirectoryUrl = indata.readUTF();
                inbyte.close();
                indata.close();
            }
            catch (Exception e) {
                System.out.println("getRecord:" + e);
            }
        }
        finally {
            if (store != null) {
                try {
                    store.closeRecordStore();
                }
                catch (Throwable throwable) {}
            }
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean saveRecord(UserInfo iUser) {
        void var1_1;
        boolean ret = false;
        RecordStore store = null;
        try {
            try {
                try {
                    RecordStore.deleteRecordStore((String)"conf");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                store = RecordStore.openRecordStore((String)"conf", (boolean)true);
                ByteArrayOutputStream outbyte = new ByteArrayOutputStream();
                DataOutputStream outdata = new DataOutputStream(outbyte);
                outdata.writeUTF(iUser.uid);
                outdata.writeByte(iUser.sex);
                outdata.writeUTF(iUser.pwd);
                outdata.writeInt(iUser.age);
                outdata.writeUTF(iUser.imsi);
                outdata.writeInt(iUser.status);
                outdata.writeUTF(iUser.nickName);
                outdata.writeUTF(iUser.userlevel);
                outdata.writeUTF(iUser.city);
                outdata.writeUTF(iUser.sign);
                outdata.writeUTF(iUser.desc);
                outdata.writeUTF(iUser.skin);
                outdata.writeUTF(iUser.saveDirectoryUrl);
                outdata.flush();
                byte[] bytes = outbyte.toByteArray();
                store.addRecord(bytes, 0, bytes.length);
                outdata.close();
                outbyte.close();
            }
            catch (RecordStoreFullException recordStoreFullException) {
            }
            catch (Exception exception) {}
        }
        finally {
            if (store != null) {
                try {
                    store.closeRecordStore();
                }
                catch (Throwable throwable) {}
            }
        }
        return (boolean)var1_1;
    }

    public static UserInfo initUser() {
        if (iUserInfo == null && (iUserInfo = UserInfo.getRecord()) == null) {
            iUserInfo = new UserInfo();
        }
        return iUserInfo;
    }

    public static boolean saveUser() {
        boolean ret = false;
        ret = UserInfo.saveRecord(iUserInfo);
        return ret;
    }

    public static Object downLoadUserInfo() {
        String result;
        UserInfo userInfo;
        block3: {
            userInfo = iUserInfo;
            StringBuffer sb = new StringBuffer();
            sb = Tools.createXMLHead(sb);
            sb.append("<Body>");
            sb.append("</Body></InterWBSC>");
            try {
                result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/getuserinfo.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("downLoadUserInfo ERR:" + e);
                return userInfo;
            }
        }
        userInfo = UserInfo.buildUserInfoByXML(result, userInfo);
        return userInfo;
    }

    private static UserInfo buildUserInfoByXML(String content, UserInfo userinfo) {
        if (content == null || content.length() <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
            InputStreamReader isrx = new InputStreamReader((InputStream)bais, "UTF-8");
            XmlReader parser = new XmlReader(isrx);
            parser.next();
            parser.require(2, "InterWBSC");
            int eventType = parser.next();
            while (eventType != 3) {
                if (eventType == 4) {
                    eventType = parser.next();
                    continue;
                }
                String tagName = parser.getName();
                if (tagName == null) break;
                if (!Tools.parseXMLHead(parser, tagName) && "Body".equalsIgnoreCase(tagName)) {
                    System.out.println("\u89e3\u6790: Body");
                    UserInfo.buildUserInfoBody(parser, tagName, userinfo);
                }
                if ((eventType = parser.next()) == 2) continue;
                eventType = parser.next();
            }
            parser.require(1, null);
            parser = null;
            isrx.close();
            bais.close();
            content = null;
            Tools.Println("UserInfo \u5185\u5bb9\u5168\u90e8\u89e3\u6790\u5b8c\u6bd5");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return userinfo;
    }

    private static void buildUserInfoBody(XmlReader parser, String tag, UserInfo userinfo) {
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("NickName")) {
                    String NickName;
                    parser.next();
                    userinfo.nickName = NickName = parser.getText();
                    System.out.println("NickName=" + NickName);
                } else if (tagname.equalsIgnoreCase("Level")) {
                    String Level2;
                    parser.next();
                    userinfo.userlevel = Level2 = parser.getText();
                    System.out.println("Level=" + Level2);
                } else if (tagname.equalsIgnoreCase("desc")) {
                    String desc;
                    parser.next();
                    userinfo.desc = desc = parser.getText();
                    System.out.println("desc=" + desc);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
        }
    }

    public static String[] updateUserInfo() {
        String[] str = new String[]{"1", ""};
        StringBuffer sb = new StringBuffer();
        sb = Tools.createXMLHead(sb);
        sb.append("<Body>");
        sb.append("<NickName>").append(UserInfo.iUserInfo.nickName).append("</NickName>");
        sb.append("</Body></InterWBSC>");
        try {
            String result = EpgMenu.getDataFromServer(Resource.WBSC_MOBILE_HOST, "service/updateuser.do", Resource.isProxy, sb.toString().getBytes("UTF-8"));
            if (result == null) {
                return str;
            }
            String ret = UserInfo.buildUserUpdateByXML(result);
            if (ret != null && ret.trim().length() > 0) {
                str[0] = "0";
                str[1] = ret;
            }
        }
        catch (Exception e) {
            System.out.println("updateUserInfo ERR:" + e);
        }
        return str;
    }

    private static String buildUserUpdateByXML(String content) {
        if (content == null || content.length() <= 0) {
            return null;
        }
        String str = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
            InputStreamReader isrx = new InputStreamReader((InputStream)bais, "UTF-8");
            XmlReader parser = new XmlReader(isrx);
            parser.next();
            parser.require(2, "InterWBSC");
            int eventType = parser.next();
            while (eventType != 3) {
                if (eventType == 4) {
                    eventType = parser.next();
                    continue;
                }
                String tagName = parser.getName();
                if (tagName == null) break;
                if (!Tools.parseXMLHead(parser, tagName) && "Body".equalsIgnoreCase(tagName)) {
                    System.out.println("\u89e3\u6790: Body");
                    str = UserInfo.buildUserUpdateBody(parser, tagName);
                }
                if ((eventType = parser.next()) == 2) continue;
                eventType = parser.next();
            }
            parser.require(1, null);
            parser = null;
            isrx.close();
            bais.close();
            content = null;
            Tools.Println("UserInfo \u5185\u5bb9\u5168\u90e8\u89e3\u6790\u5b8c\u6bd5");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return str;
    }

    public static String buildUserUpdateBody(XmlReader parser, String tag) {
        String result = null;
        try {
            parser.require(2, tag);
            int event = parser.next();
            while (event != 3) {
                if (event == 4) {
                    event = parser.next();
                    continue;
                }
                String tagname = parser.getName();
                if (tagname == null) break;
                if (tagname.equalsIgnoreCase("Tips")) {
                    String Tips;
                    parser.next();
                    result = Tips = parser.getText();
                    System.out.println("Tips=" + Tips);
                } else {
                    parser.next();
                }
                event = parser.next();
                if (event == 2) continue;
                event = parser.next();
            }
            Tools.Println("EPG Body \u89e3\u6790\u5b8c\u6bd5");
        }
        catch (IOException e) {
            System.out.println("buildEPGBody ERR:" + e);
        }
        return result;
    }

    public static void getRMSImage() {
        RecordStore store = null;
        boolean hasstore = false;
        try {
            try {
                store = RecordStore.openRecordStore((String)"epgimgs", (boolean)false);
                if (store != null) {
                    hasstore = true;
                }
                int size = store.getNumRecords();
                int i = 0;
                while (i < size) {
                    byte[] bytes = store.getRecord(i + 1);
                    ByteArrayInputStream inbyte = new ByteArrayInputStream(bytes);
                    DataInputStream indata = new DataInputStream(inbyte);
                    String name = indata.readUTF();
                    int w = indata.readInt();
                    int h = indata.readInt();
                    int[] tmp = new int[w * h];
                    int j = 0;
                    while (j < tmp.length) {
                        tmp[j] = indata.readInt();
                        ++j;
                    }
                    Image img = Image.createRGBImage((int[])tmp, (int)w, (int)h, (boolean)true);
                    ImageHolder holder = new ImageHolder();
                    holder.img = img;
                    holder.url = name;
                    ImageBuffer.addHolder(holder);
                    indata.close();
                    inbyte.close();
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("getRecord:" + e);
            }
        }
        finally {
            if (store != null) {
                try {
                    store.closeRecordStore();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            if (hasstore) {
                RecordStore.deleteRecordStore((String)"epgimgs");
            }
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public static void saveRMSImages(ImageHolder[] holders) {
        RecordStore store = null;
        try {
            try {
                store = RecordStore.openRecordStore((String)"epgimgs", (boolean)true);
                int i = 0;
                while (i < holders.length) {
                    ImageHolder holder = holders[i];
                    if (holder != null) {
                        String name = holder.url;
                        Image img = holder.img;
                        ByteArrayOutputStream outbyte = new ByteArrayOutputStream();
                        DataOutputStream outdata = new DataOutputStream(outbyte);
                        outdata.writeUTF(name);
                        int w = img.getWidth();
                        int h = img.getHeight();
                        outdata.writeInt(w);
                        outdata.writeInt(h);
                        int[] pixels = new int[w * h];
                        img.getRGB(pixels, 0, w, 0, 0, w, h);
                        int j = 0;
                        while (j < pixels.length) {
                            outdata.writeInt(pixels[j]);
                            ++j;
                        }
                        outdata.flush();
                        byte[] bytes = outbyte.toByteArray();
                        store.addRecord(bytes, 0, bytes.length);
                        outdata.close();
                        outbyte.close();
                    }
                    ++i;
                }
            }
            catch (RecordStoreFullException recordStoreFullException) {
            }
            catch (Exception exception) {}
        }
        finally {
            if (store != null) {
                try {
                    store.closeRecordStore();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

