/*
 * Decompiled with CFR 0.152.
 */
package com.canvas;

import com.canvas.view.View;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import com.scene.PlayerScene;
import com.thread.ThreadImpl;
import com.thread.ThreadManager;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class TheCanvas
extends Canvas {
    public static final int SOFTKEY_LEFT = -6;
    public static final int SOFTKEY_RIGHT = -7;
    public static final int UICOLOR = 0xEEEEFF;
    public static final int FONTCOLOR = 0x111111;
    public static View view;
    public static View lastView;
    public static View flashView;
    private boolean needRepaint = true;
    private static Vector vect_repaint;
    private int lastX;
    private int lastY;
    Graphics g;
    public static Vector testinfo;
    public static PlayerScene player;

    static {
        vect_repaint = new Vector();
        testinfo = new Vector();
    }

    public TheCanvas() {
        this.setFullScreenMode(true);
    }

    public static void setFlashView(View view) {
        flashView = view;
    }

    public static void clearFlashView() {
        flashView = null;
    }

    public static void setRepaintRect(Vector vect) {
        if (vect == null) {
            vect_repaint.removeAllElements();
        } else {
            vect_repaint = vect;
        }
    }

    public void startCanvas() {
        ThreadManager.addTask(new ThreadImpl(){

            public boolean getActionResult() {
                return TheCanvas.this.needRepaint;
            }

            public void setActionResult(boolean result) {
                TheCanvas.this.needRepaint = result;
            }

            public void threadAction() {
                TheCanvas.this.repaintCanvas();
            }
        });
    }

    public static void setCurrentView(View view) {
        lastView = TheCanvas.view;
        TheCanvas.view = view;
    }

    public static View getCurrentView() {
        return view;
    }

    protected void pointerReleased(int px, int py) {
        ViewEvent obj = TheCanvas.getCurrentView().pointerReleased(px, py);
        TheCanvas.getCurrentView().getScene().ActionPointReleased(obj);
    }

    protected void pointerDragged(int px, int py) {
        TheCanvas.getCurrentView().pointerDragged(this.lastX, this.lastY, px, py);
        this.lastX = px;
        this.lastY = py;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -6 || keyCode == -7) {
            this.keyPressedAction(keyCode);
        } else {
            int keyAction = this.getGameAction(keyCode);
            this.keyPressedAction(keyAction);
        }
        this.repaintCanvas();
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -6 || keyCode == -7) {
            this.keyReleasedAction(keyCode);
        } else {
            int keyAction = keyCode;
            keyAction = keyAction == 50 ? 1 : (keyAction == 56 ? 6 : (keyAction == 52 ? 2 : (keyAction == 54 ? 5 : (keyAction == 53 ? 8 : this.getGameAction(keyCode)))));
            this.keyReleasedAction(keyAction);
        }
    }

    protected void keyRepeated(int keyCode) {
        this.keyReleased(keyCode);
    }

    public void keyPressedAction(int keyCode) {
        if (keyCode == -6 || keyCode == -7) {
            ViewEvent obj = TheCanvas.getCurrentView().keyPressedAction(keyCode);
            TheCanvas.getCurrentView().getScene().ActionkeyPressed(obj);
        } else {
            ViewEvent obj = TheCanvas.getCurrentView().keyPressedAction(keyCode);
            TheCanvas.getCurrentView().getScene().ActionkeyPressed(obj);
        }
    }

    public void keyReleasedAction(int keyCode) {
        if (keyCode == -6 || keyCode == -7) {
            ViewEvent obj = TheCanvas.getCurrentView().keyReleasedAction(keyCode);
            TheCanvas.getCurrentView().getScene().ActionKeyReleased(obj);
        } else {
            ViewEvent obj = TheCanvas.getCurrentView().keyReleasedAction(keyCode);
            TheCanvas.getCurrentView().getScene().ActionKeyReleased(obj);
        }
    }

    public void repaintCanvas() {
        if (vect_repaint.size() > 0) {
            int i = 0;
            while (i < vect_repaint.size()) {
                Object obj = vect_repaint.elementAt(i);
                int[] array = (int[])obj;
                this.repaint(array[0], array[1], array[2], array[3]);
                ++i;
            }
        } else {
            this.repaint();
        }
    }

    protected void paint(Graphics g) {
        this.g = g;
        g.setFont(Res.UIFONT);
        if (lastView != null) {
            lastView.paint(g);
        }
        if (view != null) {
            view.paint(g);
        }
        if (flashView != null && flashView.isVisible()) {
            flashView.paint(g);
        }
    }

    public void flushFullScreen(int rgb) {
        if (this.g == null) {
            return;
        }
        this.g.setClip(0, 0, 240, 320);
        this.g.setColor(rgb);
        this.g.fillRect(0, 0, 240, 320);
    }

    public static void addTestInfo(String info) {
    }

    public void hideNotify() {
    }

    public void showNotify() {
    }
}

