/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.item.ListView;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PageNumView
extends View {
    private int currentPage = 1;
    private int totalPage = 2;
    private Image prePageImg;
    private Image nextPageImg;
    private ListView list;
    private byte pageMode = 0;
    private static final byte PAGENUMBERMODE__LEFT_RIGHT = 0;
    private static final byte PAGENUMBERMODE_UP_DOWN = 1;
    private static final int DISTANCE = 8;
    private static final int startDrawX = 5;

    public PageNumView(ListView list) {
        this.type = 11;
        this.list = list;
        this.width = list.getWidth();
        this.height = 16;
        this.pageMode = list.listMode == ListView.LISTMODE_LEFT_RIGHT ? (byte)1 : 0;
        Image img1 = (Image)Res.imageTable.get("prepage");
        Image img2 = (Image)Res.imageTable.get("nextpage");
        this.setPageImg(img1, img2);
    }

    public void setPageImg(Image prePage, Image nextPage) {
        this.prePageImg = prePage;
        this.nextPageImg = nextPage;
        if (this.prePageImg == null || this.nextPageImg == null) {
            return;
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        System.out.println("\u8bbe\u7f6e\u5f53\u524d\u9875\u4e3a:" + currentPage);
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        g.fillRect(this.x, this.y, this.width, this.height);
        g.setFont(this.font);
        if (this.img != null) {
            g.drawImage(this.img, this.x, this.y, 20);
        }
        if (this.pageMode == 1) {
            this.paint_LR(g);
        } else {
            this.paint_LR(g);
        }
    }

    public boolean pointerLeftArrow(int px, int py) {
        int w = 10;
        int h = 10;
        if (this.prePageImg != null) {
            w = this.prePageImg.getWidth();
            h = this.prePageImg.getHeight();
        }
        return View.isPointInRect(px, py, this.x, this.y, w, h);
    }

    public boolean pointerRigtArrow(int px, int py) {
        int w = 10;
        int h = 10;
        if (this.nextPageImg != null) {
            w = this.nextPageImg.getWidth();
            h = this.nextPageImg.getHeight();
        }
        return View.isPointInRect(px, py, this.x + this.width - w, this.y, w, h);
    }

    public void paint_UD(Graphics g) {
    }

    public void paint_LR(Graphics g) {
        if (this.prePageImg != null) {
            g.drawImage(this.prePageImg, this.x, this.y + (this.height - this.prePageImg.getHeight()) / 2, 20);
        }
        if (this.nextPageImg != null) {
            g.drawImage(this.nextPageImg, this.x + this.width - this.nextPageImg.getWidth(), this.y + (this.height - this.nextPageImg.getHeight()) / 2, 20);
        }
        int dx = this.x + this.prePageImg.getWidth() + 5;
        int dy = this.y + (this.height - g.getFont().getHeight() >> 1);
        String str = "1";
        int i = this.currentPage;
        while (i <= this.totalPage) {
            if (i == this.currentPage) {
                g.setColor(0xFF0000);
            } else {
                g.setColor(this.fontColor);
            }
            str = "" + i;
            if (dx > this.x + this.width - this.nextPageImg.getWidth() - 8) break;
            g.drawString(str, dx, dy, 20);
            dx += g.getFont().stringWidth(str);
            dx += 8;
            ++i;
        }
    }

    public ViewEvent keyPressedAction(int keyCode) {
        return null;
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.pageMode != 1) {
            ViewEvent e = new ViewEvent();
            e.setView(this);
            e.setKeyCode(keyCode);
            e.setDesc("pageNuber");
            e.setSource(this.list);
            if (keyCode == 2 && this.currentPage > 1) {
                return e;
            }
            if (keyCode == 5 && this.currentPage < this.totalPage) {
                return e;
            }
        }
        return null;
    }
}

