/*
 * Decompiled with CFR 0.152.
 */
package com.file;

import com.file.File;
import com.model.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FileManager {
    public static final String DEFAULT_STORE_NAME = "TV_Client";
    public static final byte GETSUB_NOMAL = 0;
    public static final byte GETSUB_ONLY_DIR = 1;
    public static final byte GETSUB_ONLY_FILE = 2;
    public static final char[] FORBIDDANCE = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    public static final String[] ROOT_NAME = new String[]{"\u5df2\u4e0b\u8f7d", "\u624b\u673a\u5361", "\u5b58\u50a8\u5361"};
    public static final String FILE = "file://";
    public static final String DIR = "/";
    public static String defaultStoreURL = UserInfo.iUserInfo.saveDirectoryUrl;
    private static String tempName;
    private static String tempType;

    static {
        if (defaultStoreURL != null && defaultStoreURL.equals("null")) {
            defaultStoreURL = null;
        }
        if (defaultStoreURL == null) {
            File[] roots = FileManager.getRoot(false);
            if (roots != null && roots.length > 0) {
                String url;
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getName().toLowerCase().indexOf("video") >= 0) {
                        try {
                            url = String.valueOf(roots[i].getLocator()) + DEFAULT_STORE_NAME + DIR;
                            if (FileManager.isExist(url)) {
                                if (FileManager.isExist(String.valueOf(url) + "temp")) {
                                    defaultStoreURL = url;
                                    break;
                                }
                                FileManager.makeDir(url, "temp");
                                defaultStoreURL = url;
                                break;
                            }
                            FileManager.makeDir(roots[i], DEFAULT_STORE_NAME);
                            FileManager.makeDir(url, "temp");
                            defaultStoreURL = url;
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                if (defaultStoreURL == null) {
                    i = 1;
                    while (i > -1) {
                        if (i <= roots.length - 1) {
                            try {
                                url = String.valueOf(roots[i].getLocator()) + DEFAULT_STORE_NAME + DIR;
                                if (FileManager.isExist(url)) {
                                    if (FileManager.isExist(String.valueOf(url) + "temp")) {
                                        defaultStoreURL = url;
                                        break;
                                    }
                                    FileManager.makeDir(url, "temp");
                                    defaultStoreURL = url;
                                    break;
                                }
                                FileManager.makeDir(roots[i], DEFAULT_STORE_NAME);
                                FileManager.makeDir(url, "temp");
                                defaultStoreURL = url;
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        --i;
                    }
                }
            }
            if (defaultStoreURL != null) {
                UserInfo.iUserInfo.saveDirectoryUrl = defaultStoreURL;
                UserInfo.saveRecord(UserInfo.iUserInfo);
            }
        } else if (!FileManager.isExist(defaultStoreURL)) {
            defaultStoreURL = null;
        }
    }

    public static File[] getRoot(boolean withinDefaultRoot) {
        Enumeration enu;
        Vector<File> v = new Vector<File>();
        if (withinDefaultRoot && defaultStoreURL != null && FileManager.isExist(defaultStoreURL)) {
            v.addElement(new File(defaultStoreURL, ROOT_NAME[0]));
        }
        if ((enu = FileSystemRegistry.listRoots()) != null) {
            int count = 0;
            Vector<String> temp = new Vector<String>();
            while (enu.hasMoreElements()) {
                int index;
                count = (byte)(count + 1);
                String s = (String)enu.nextElement();
                if (FileManager.hasChinese(s)) {
                    count = (byte)(count - 1);
                    continue;
                }
                if (!s.endsWith(DIR)) {
                    s = String.valueOf(s) + DIR;
                }
                if ((index = s.indexOf(47)) > -1 && index != s.length() - 1) {
                    s = s.substring(0, index + 1);
                }
                int i = 0;
                while (i < temp.size()) {
                    String ts = (String)temp.elementAt(i);
                    if (s.equals(ts)) {
                        // empty if block
                    }
                    ++i;
                }
                temp.addElement(s);
                v.addElement(new File("file:///" + s, s.substring(0, s.length() - 1)));
            }
        }
        if (v.size() > 0) {
            File[] ret = new File[v.size()];
            int i = 0;
            while (i < v.size()) {
                ret[i] = (File)v.elementAt(i);
                ++i;
            }
            return ret;
        }
        return null;
    }

    public static File[] getSubFiles(File file, byte readType) {
        FileConnection conn;
        if (!file.isDir()) {
            return null;
        }
        boolean saveDir = false;
        if (file.getFather() == null && ROOT_NAME[0].equals(file.getDisplayName()) && readType == 0) {
            saveDir = true;
            readType = (byte)2;
        }
        if ((conn = FileManager.getConnection(file.getLocator())) != null) {
            try {
                Vector<File> v = new Vector<File>();
                int dirCount = 0;
                Enumeration enu = conn.list();
                while (enu.hasMoreElements()) {
                    String s = (String)enu.nextElement();
                    if (s.endsWith(DIR)) {
                        if (readType != 1 && readType != 0) continue;
                        v.insertElementAt(new File(file, true, s), dirCount);
                        ++dirCount;
                        continue;
                    }
                    if (readType != 2 && readType != 0 || saveDir && s.endsWith(".do")) continue;
                    v.addElement(new File(file, false, s));
                }
                if (v.size() > 0) {
                    File[] ret = new File[v.size()];
                    int i = 0;
                    while (i < v.size()) {
                        ret[i] = (File)v.elementAt(i);
                        ++i;
                    }
                    File[] fileArray = ret;
                    return fileArray;
                }
                return null;
            }
            catch (Exception exception) {
            }
            finally {
                FileManager.closeConnection(conn);
            }
        }
        return null;
    }

    public static boolean isExist(File file, String name) {
        return FileManager.isExist(String.valueOf(file.getLocator()) + name);
    }

    public static boolean isExist(String locator) {
        boolean ret = false;
        FileConnection conn = FileManager.getConnection(locator);
        if (conn != null) {
            ret = conn.exists();
            FileManager.closeConnection(conn);
        }
        return ret;
    }

    public static long getFileSize(File file) throws Exception {
        if (file == null) {
            return 0L;
        }
        return FileManager.getFileSize(file.getLocator());
    }

    public static long getFileSize(String locator) {
        FileConnection conn = FileManager.getConnection(locator);
        if (conn != null) {
            try {
                long l = conn.fileSize();
                return l;
            }
            catch (Exception exception) {
                return 0L;
            }
            finally {
                FileManager.closeConnection(conn);
            }
        }
        return 0L;
    }

    public static long getAvailable(File file) throws Exception {
        return FileManager.getAvailable(file.getLocator());
    }

    public static long getAvailable(String locator) throws Exception {
        Exception te = null;
        FileConnection conn = FileManager.getConnection(locator);
        if (conn != null) {
            try {
                if (!conn.exists()) {
                    te = new Exception("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                    throw te;
                }
                long l = conn.availableSize();
                return l;
            }
            catch (IOException e) {
                throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
            }
            catch (SecurityException se) {
                throw new Exception("\u6743\u9650\u4e0d\u591f\uff01\u65e0\u6cd5\u8bfb\u53d6\u5c5e\u6027");
            }
            catch (Exception e) {
                if (e == te) {
                    throw te;
                }
                throw new Exception("\u64cd\u4f5c\u51fa\u9519\uff01" + e.getMessage());
            }
            finally {
                FileManager.closeConnection(conn);
            }
        }
        throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
    }

    public static void makeDir(File file, String dirName) throws Exception {
        FileManager.makeDir(file.getLocator(), dirName);
    }

    public static void makeDir(String locator, String dirName) throws Exception {
        block12: {
            if (!locator.endsWith(DIR)) {
                throw new Exception("\u6307\u5b9a\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            }
            String check = FileManager.checkFileName(dirName);
            if (check != null) {
                throw new Exception(check);
            }
            Exception te = null;
            FileConnection conn = FileManager.getConnection(String.valueOf(locator) + dirName);
            if (conn != null) {
                try {
                    try {
                        if (conn.exists()) {
                            te = new Exception("\u6587\u4ef6\u5df2\u5b58\u5728\uff01");
                            throw te;
                        }
                        conn.mkdir();
                        break block12;
                    }
                    catch (IOException e) {
                        throw new Exception("\u60a8\u9009\u62e9\u7684\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u6839\u76ee\u5f55\uff0c\u5f53\u524d\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
                    }
                    catch (SecurityException se) {
                        throw new SecurityException("\u6743\u9650\u4e0d\u591f\uff01\u5f53\u524d\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
                    }
                    catch (Exception e) {
                        if (e == te) {
                            throw te;
                        }
                        throw new Exception("\u64cd\u4f5c\u51fa\u9519\uff01" + e.getMessage());
                    }
                }
                finally {
                    FileManager.closeConnection(conn);
                }
            }
            throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
        }
    }

    public static FileConnection makeFile(File file, String fileName) throws Exception {
        if (!file.isDir()) {
            throw new Exception("\u65e0\u6cd5\u5728\u4e00\u4e2a\u6587\u4ef6\u4e2d\u518d\u521b\u5efa\u6587\u4ef6\uff01");
        }
        return FileManager.makeFile(file.getLocator(), fileName);
    }

    public static FileConnection makeFile(String locator, String fileName) throws Exception {
        if (!FileManager.isExist(locator)) {
            throw new Exception("\u5f53\u524d\u76ee\u5f55\u4e0d\u5b58\u5728\uff01\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6");
        }
        String check = FileManager.checkFileName(fileName);
        if (check != null) {
            throw new Exception(check);
        }
        Exception te = null;
        FileConnection conn = FileManager.getConnection(String.valueOf(locator) + fileName);
        if (conn != null) {
            try {
                if (conn.exists()) {
                    te = new Exception("\u6587\u4ef6\u5df2\u5b58\u5728\uff01");
                    throw te;
                }
                conn.create();
                return conn;
            }
            catch (IOException e) {
                FileManager.closeConnection(conn);
                throw new Exception("\u60a8\u9009\u62e9\u7684\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u6839\u76ee\u5f55\uff0c\u5f53\u524d\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
            }
            catch (SecurityException se) {
                FileManager.closeConnection(conn);
                throw new Exception("\u6743\u9650\u4e0d\u591f\uff01\u5f53\u524d\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
            }
            catch (Exception e) {
                FileManager.closeConnection(conn);
                if (e == te) {
                    throw te;
                }
                throw new Exception("\u64cd\u4f5c\u51fa\u9519\uff01" + e.getMessage());
            }
        }
        throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
    }

    public static FileConnection openFile(File file) throws Exception {
        if (file.isDir()) {
            throw new Exception("\u4e0d\u80fd\u628a\u4e00\u4e2a\u6587\u4ef6\u5939\u4f5c\u4e3a\u6587\u4ef6\u6253\u5f00\uff01");
        }
        return FileManager.openFile(file.getLocator());
    }

    public static FileConnection openFile(String locator) throws Exception {
        Exception te = null;
        FileConnection conn = FileManager.getConnection(locator);
        if (conn != null) {
            try {
                if (!conn.exists()) {
                    te = new Exception("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                    throw te;
                }
                return conn;
            }
            catch (IOException e) {
                FileManager.closeConnection(conn);
                throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
            }
            catch (SecurityException se) {
                FileManager.closeConnection(conn);
                throw new Exception("\u6743\u9650\u4e0d\u591f\uff01\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6");
            }
            catch (Exception e) {
                FileManager.closeConnection(conn);
                if (e == te) {
                    throw te;
                }
                throw new Exception("\u64cd\u4f5c\u51fa\u9519\uff01" + e.getMessage());
            }
        }
        throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
    }

    public static void delFile(File file) throws Exception {
        if (file.isDir()) {
            FileManager.delDir(file);
        } else {
            FileManager.delFile(file.getLocator());
        }
    }

    public static void delFile(String locator) throws Exception {
        block10: {
            Exception te = null;
            FileConnection conn = FileManager.getConnection(locator);
            if (conn != null) {
                try {
                    try {
                        if (!conn.exists()) {
                            te = new Exception("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                            throw te;
                        }
                        conn.delete();
                        break block10;
                    }
                    catch (IOException e) {
                        throw new Exception("\u60a8\u9009\u62e9\u7684\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u6839\u76ee\u5f55\uff0c\u5f53\u524d\u76ee\u5f55\u65e0\u6cd5\u5220\u9664\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
                    }
                    catch (SecurityException se) {
                        throw new Exception("\u6743\u9650\u4e0d\u591f\uff01\u65e0\u6cd5\u5220\u9664\u6587\u4ef6");
                    }
                    catch (Exception e) {
                        if (e == te) {
                            throw te;
                        }
                        throw new Exception("\u64cd\u4f5c\u51fa\u9519\uff01" + e.getMessage());
                    }
                }
                finally {
                    FileManager.closeConnection(conn);
                }
            }
            throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
        }
    }

    private static void delDir(File file) throws Exception {
        if (!file.isDir()) {
            return;
        }
        if (!FileManager.isExist(file.getLocator())) {
            throw new Exception("\u6587\u4ef6\u5939 '" + file.getDisplayName() + "' \u4e0d\u5b58\u5728\uff01");
        }
        File[] files = FileManager.getSubFiles(file, (byte)0);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDir()) {
                    FileManager.delDir(files[i]);
                } else {
                    FileManager.delFile(files[i].getLocator());
                }
                ++i;
            }
        }
        FileManager.delFile(file.getLocator());
    }

    public static void rename(File file, String newName) throws Exception {
        FileManager.rename(file.getLocator(), newName);
        file.setFullName(newName);
    }

    public static void rename(String file, String newName) throws Exception {
        block11: {
            String check = FileManager.checkFileName(newName);
            if (check != null) {
                throw new Exception(check);
            }
            Exception te = null;
            FileConnection conn = FileManager.getConnection(file);
            if (conn != null) {
                try {
                    try {
                        if (!conn.exists()) {
                            te = new Exception("\u6307\u5b9a\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
                            throw te;
                        }
                        conn.rename(newName);
                        break block11;
                    }
                    catch (IOException e) {
                        throw new Exception("\u60a8\u9009\u62e9\u7684\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u6839\u76ee\u5f55\uff0c\u5f53\u524d\u76ee\u5f55\u65e0\u6cd5\u91cd\u547d\u540d\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
                    }
                    catch (SecurityException se) {
                        throw new Exception("\u6743\u9650\u4e0d\u591f\uff01\u65e0\u6cd5\u91cd\u547d\u540d\u6587\u4ef6");
                    }
                    catch (Exception e) {
                        if (e == te) {
                            throw te;
                        }
                        throw new Exception("\u64cd\u4f5c\u51fa\u9519\uff01" + e.getMessage());
                    }
                }
                finally {
                    FileManager.closeConnection(conn);
                }
            }
            throw new Exception("\u5f53\u524d\u76ee\u5f55\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u6216\u5df2\u88ab\u5220\u9664!");
        }
    }

    public static void moveFile(File src, File dest) throws Exception {
        if (src.isDir()) {
            FileManager.copyOrMoveOneDir(src, dest, true);
        } else {
            FileManager.moveOneFile(src.getLocator(), dest.getLocator(), src.getFullName());
        }
    }

    public static void copyFile(File src, File dest) throws Exception {
        if (src.isDir()) {
            FileManager.copyOrMoveOneDir(src, dest, false);
        } else {
            FileManager.copyOneFile(src.getLocator(), dest.getLocator(), src.getFullName());
        }
    }

    private static void copyOrMoveOneDir(File src, File dest, boolean del) throws Exception {
        if (!src.isDir() || !dest.isDir()) {
            return;
        }
        if (!FileManager.isExist(dest.getLocator())) {
            throw new Exception("\u76ee\u6807\u76ee\u5f55\u9519\u8bef\u6216\u4e0d\u5b58\u5728\uff01");
        }
        if (!FileManager.isExist(src.getLocator())) {
            throw new Exception("\u8981\u590d\u5236\u7684\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        try {
            if (!FileManager.isExist(dest, src.getDisplayName())) {
                FileManager.makeDir(dest, src.getDisplayName());
            }
        }
        catch (Exception e) {
            throw new Exception("\u60a8\u9009\u62e9\u7684\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u6839\u76ee\u5f55\uff0c\u8be5\u76ee\u5f55\u4e0b\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939");
        }
        File currentDest = new File(dest, true, src.getFullName());
        File[] files = FileManager.getSubFiles(src, (byte)0);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDir()) {
                    FileManager.copyOrMoveOneDir(files[i], currentDest, del);
                } else if (del) {
                    FileManager.copyOneFile(files[i].getLocator(), currentDest.getLocator(), files[i].getFullName(), false);
                    FileManager.delFile(files[i].getLocator());
                } else {
                    FileManager.copyOneFile(files[i].getLocator(), currentDest.getLocator(), files[i].getFullName(), false);
                }
                ++i;
            }
        }
        if (del) {
            FileManager.delFile(src.getLocator());
        }
    }

    public static void copyOneFile(String src, String dest, String fileName) throws Exception {
        FileManager.copyOneFile(src, dest, fileName, true);
    }

    public static void moveOneFile(String src, String dest, String fileName) throws Exception {
        FileManager.copyOneFile(src, dest, fileName, true);
        FileManager.delFile(src);
    }

    private static void copyOneFile(String src, String dest, String fileName, boolean checkUrl) throws Exception {
        if (checkUrl) {
            if (!dest.endsWith(DIR) || !FileManager.isExist(dest)) {
                throw new Exception("\u76ee\u6807\u76ee\u5f55\u9519\u8bef\u6216\u4e0d\u5b58\u5728\uff01");
            }
            if (!FileManager.isExist(src)) {
                throw new Exception("\u8981\u590d\u5236\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
            }
        }
        FileConnection srcConn = FileManager.getConnection(src);
        FileConnection destConn = null;
        InputStream in = null;
        OutputStream out = null;
        if (srcConn == null) {
            return;
        }
        try {
            try {
                destConn = FileManager.checkDuplicatName(dest, fileName, 0);
                in = srcConn.openInputStream();
                out = destConn.openOutputStream();
                int length = -1;
                byte[] b = new byte[1024];
                while ((length = in.read(b)) != -1) {
                    out.write(b, 0, length);
                }
            }
            catch (IOException e) {
                throw new Exception("\u590d\u5236\u6587\u4ef6 '" + fileName + "' \u5931\u8d25\uff0c\u60a8\u9009\u62e9\u7684\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u6839\u76ee\u5f55");
            }
            catch (SecurityException se) {
                throw new Exception("\u6743\u9650\u4e0d\u591f\uff01\u6587\u4ef6\u65e0\u6cd5\u590d\u5236");
            }
            catch (Exception e) {
                throw new Exception("\u590d\u5236\u6587\u4ef6 '" + fileName + "' \u5931\u8d25");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            FileManager.closeConnection(srcConn);
            FileManager.closeConnection(destConn);
        }
    }

    public static FileConnection getConnection(String url) {
        try {
            return (FileConnection)Connector.open((String)url, (int)3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void closeConnection(FileConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String checkFileName(String name) {
        int i = 0;
        while (i < FORBIDDANCE.length) {
            if (name.indexOf(FORBIDDANCE[i]) > -1) {
                StringBuffer temp = new StringBuffer();
                temp.append("\u6587\u4ef6\u540d\u4e0d\u80fd\u4f7f\u7528\u4ee5\u4e0b\u5b57\u7b26\u4e4b\u4e00\uff1a");
                int j = 0;
                while (j < FORBIDDANCE.length) {
                    temp.append(' ').append(FORBIDDANCE[j]);
                    ++j;
                }
                return temp.toString();
            }
            ++i;
        }
        return null;
    }

    public static boolean hasChinese(String s) {
        int i = 1;
        while (i < s.length()) {
            char chr = s.charAt(i);
            if (chr < '!' || chr > '~') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String changeSizeToString(long size) {
        int g = 0x40000000;
        int m = 0x100000;
        int k = 1024;
        StringBuffer ret = new StringBuffer();
        if (size <= 0L) {
            return null;
        }
        if (size < (long)m) {
            ret.append(String.valueOf(size / (long)k)).append('.').append(String.valueOf(size % (long)k / 100L)).append(" KB");
        } else if (size < (long)g) {
            ret.append(String.valueOf(size / (long)m)).append('.').append(String.valueOf(size % (long)m / (long)(k * 100))).append(" MB");
        } else {
            ret.append(String.valueOf(size / (long)g)).append('.').append(String.valueOf(size % (long)g / (long)(m * 100))).append(" GB");
        }
        return ret.toString();
    }

    public static FileConnection checkDuplicatName(String dest, String fileName, int count) throws Exception {
        FileConnection file = FileManager.getConnection(String.valueOf(dest) + fileName);
        if (file == null) {
            throw new Exception();
        }
        if (!file.exists()) {
            file.create();
            return file;
        }
        FileManager.closeConnection(file);
        if (count == 0) {
            tempName = fileName.substring(0, fileName.lastIndexOf(46));
            tempType = fileName.substring(fileName.lastIndexOf(46), fileName.length());
        }
        StringBuffer temp = new StringBuffer();
        temp.append(tempName).append('(').append(++count).append(')').append(tempType);
        return FileManager.checkDuplicatName(dest, temp.toString(), count);
    }
}

