/*
 * Decompiled with CFR 0.152.
 */
package com.freexml;

import com.freexml.XmlReader;
import com.tools.GZIP;
import com.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class XmlTools {
    public static XmlReader createXmlReader(byte[] inBytes) {
        XmlReader ret = null;
        if (inBytes != null) {
            byte[] temBytes = Tools.XMLZIP(inBytes);
            String xml = "";
            try {
                temBytes = GZIP.inflate(temBytes);
                xml = new String(temBytes, "UTF-8");
                if (xml != null) {
                    xml = xml.trim();
                }
                temBytes = null;
                int index = xml.indexOf("<");
                if (index >= 0) {
                    xml = xml.substring(index);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                xml = null;
                InputStreamReader isrx = new InputStreamReader((InputStream)bais, "UTF-8");
                bais.close();
                bais = null;
                ret = new XmlReader(isrx);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public static String readText(XmlReader iParser) {
        String ret = null;
        try {
            int eventType = iParser.next();
            if (4 == eventType) {
                ret = iParser.getText();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static int readAttributeValue(XmlReader iParser, int index) {
        int ret = 0;
        String str = iParser.getAttributeValue(index);
        if (str != null && str.length() > 0) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public static int readInt(XmlReader iParser) {
        int ret = 0;
        try {
            String str;
            int eventType = iParser.next();
            if (4 == eventType && (str = iParser.getText()) != null && str.length() > 0) {
                try {
                    ret = Integer.parseInt(str);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static long readLong(XmlReader iParser) {
        long ret = 0L;
        try {
            String str;
            int eventType = iParser.next();
            if (4 == eventType && (str = iParser.getText()) != null && str.length() > 0) {
                try {
                    ret = Long.parseLong(str);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }
}

