/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.model;

import com.beeweeb.globallauncher.Controller;
import com.beeweeb.globallauncher.Launcher;
import com.beeweeb.globallauncher.model.AppMidlet;
import com.beeweeb.globallauncher.model.Configuration;
import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.model.Midlet;
import com.beeweeb.globallauncher.model.Shortcut;
import com.beeweeb.globallauncher.model.Teaser;
import com.beeweeb.globallauncher.model.Upgrade;
import com.beeweeb.globallauncher.util.Log;
import java.util.Vector;

public class InstantLauncherData {
    private Configuration configuration;
    private Upgrade upgrade;
    private Teaser teaser;
    private Vector shortcuts = new Vector();
    private Vector notdeletables = new Vector();
    private String shortcutsListVersion;
    private Vector appUpgrade = new Vector();
    private boolean attached = true;
    private Vector nativeShortcuts = new Vector();

    public Teaser getTeaser() {
        return this.teaser;
    }

    public void setTeaser(Teaser teaser) {
        this.teaser = teaser;
    }

    public int getShortcutCount() {
        return this.shortcuts.size();
    }

    public Shortcut getShortcut(int n) {
        return (Shortcut)this.shortcuts.elementAt(n);
    }

    public void deleteShortcut(int n) {
        this.shortcuts.removeElementAt(n);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Upgrade getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(Upgrade upgrade) {
        this.upgrade = upgrade;
    }

    public String getShortcutsListVersion() {
        return this.shortcutsListVersion;
    }

    public void setShortcutsListVersion(String string) {
        this.shortcutsListVersion = string;
    }

    public String toXML() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<n:instantlauncher xmlns:n=\"InstantLauncher\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"InstantLauncher C:\\IL_schema\\il.xsd\">");
        if (this.configuration != null) {
            stringBuffer.append(this.configuration.toXML());
        }
        if (this.teaser != null) {
            stringBuffer.append("<teasers>");
            stringBuffer.append(this.teaser.toXML());
            stringBuffer.append("</teasers>");
        }
        if (this.shortcuts.size() > 0) {
            stringBuffer.append("<shortcuts list_version=\"" + this.shortcutsListVersion + "\">");
            for (n = 0; n < this.shortcuts.size(); ++n) {
                object = (Shortcut)this.shortcuts.elementAt(n);
                stringBuffer.append(((Shortcut)object).toXML());
            }
            stringBuffer.append("</shortcuts>");
        }
        if (this.notdeletables.size() > 0) {
            stringBuffer.append("<LOCAL_notdeletables>");
            for (n = 0; n < this.notdeletables.size(); ++n) {
                object = (Shortcut)this.notdeletables.elementAt(n);
                stringBuffer.append(((Shortcut)object).toXML());
            }
            stringBuffer.append("</LOCAL_notdeletables>");
        }
        if (this.appUpgrade.size() > 0) {
            stringBuffer.append("<appupgrade>");
            for (n = 0; n < this.appUpgrade.size(); ++n) {
                object = (AppMidlet)this.appUpgrade.elementAt(n);
                stringBuffer.append(((AppMidlet)object).toXML());
            }
            stringBuffer.append("</appupgrade>");
        }
        stringBuffer.append("</n:instantlauncher>");
        return stringBuffer.toString();
    }

    public String toPostData() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<n:ilpostdata xmlns:n=\"InstantLauncherPostData\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"InstantLauncherPostData C:\\ActiveDesktop\\test\\IL\\IL_full4\\POST_data.xsd\">\n");
        stringBuffer.append("<clientinfo");
        stringBuffer.append(" handset_type=\"" + this.configuration.getHandsetType() + "\" " + "client_version" + "=\"" + Launcher.VERSION + "\" " + "list_version" + "=\"" + this.shortcutsListVersion + "\" " + "count" + "=\"" + Controller.getCounters()[0] + "\" />");
        stringBuffer.append("<shortcut>");
        if (this.teaser != null) {
            stringBuffer.append(this.teaser.toPostData());
        }
        for (n = 0; n < this.shortcuts.size(); ++n) {
            if (this.getShortcut(n).getWebURL() == null) continue;
            stringBuffer.append("<web href=\"" + this.getShortcut(n).getWebURL() + "\" count=\"" + this.getShortcut(n).getLOCAL_click_count() + "\"/>\n");
        }
        stringBuffer.append("<applications> \n");
        for (n = 0; n < this.shortcuts.size(); ++n) {
            if (this.getShortcut(n).getApplication() == null) continue;
            Midlet midlet = (Midlet)this.getShortcut(n).getApplication();
            stringBuffer.append("<midlet MIDlet-Vendor=\"" + midlet.getVendor() + "\" " + "MIDlet-Name" + "=\"" + midlet.getName() + "\" " + "MIDlet-X" + "=\"" + midlet.getRealName() + "\" " + "installed=\"" + midlet.isInstalled() + "\" " + "count=\"" + this.getShortcut(n).getLOCAL_click_count() + "\" ");
            if (midlet.getVersion() != null) {
                stringBuffer.append("version=\"" + midlet.getVersion() + "\" ");
            }
            stringBuffer.append("/>\n");
        }
        stringBuffer.append("</applications>\n");
        stringBuffer.append("</shortcut>");
        stringBuffer.append("</n:ilpostdata>");
        return stringBuffer.toString();
    }

    public void addShortcut(Shortcut shortcut) {
        this.shortcuts.addElement(shortcut);
    }

    public void setShortcut(Shortcut shortcut, int n) {
        this.shortcuts.setElementAt(shortcut, n);
    }

    public void insertShortcut(Shortcut shortcut) {
        if (shortcut.getPosition() == 0) {
            this.insertShortcutOnTop(shortcut);
        } else {
            this.insertShortcutOnBottom(shortcut);
        }
    }

    public void insertShortcutOnTop(Shortcut shortcut) {
        Log.log("Inserting on top " + this.shortcuts.size());
        this.shortcuts.insertElementAt(shortcut, 0);
        Log.log("Inserted on top " + this.shortcuts.size());
    }

    public void insertShortcutOnBottom(Shortcut shortcut) {
        this.shortcuts.addElement(shortcut);
    }

    public void clearShortcuts() {
        this.shortcuts.removeAllElements();
    }

    public void setShortcuts(Vector vector) {
        this.shortcuts = null;
        this.shortcuts = vector;
    }

    public Vector getShortcuts() {
        return this.shortcuts;
    }

    public void removeShortcut(int n) {
        this.shortcuts.removeElementAt(n);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getAppUpgradeCount() {
        return this.appUpgrade.size();
    }

    public AppMidlet getAppMidlet(int n) {
        return (AppMidlet)this.appUpgrade.elementAt(n);
    }

    public void addAppMidlet(AppMidlet appMidlet) {
        this.appUpgrade.addElement(appMidlet);
    }

    public int containsApplicationShortcut(Shortcut shortcut) {
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            if (((Shortcut)this.shortcuts.elementAt(i)).getApplication() == null || !((Midlet)((Shortcut)this.shortcuts.elementAt(i)).getApplication()).equals(shortcut.getApplication())) continue;
            return i;
        }
        return -1;
    }

    public int containsWebShortcut(Shortcut shortcut) {
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            if (((Shortcut)this.shortcuts.elementAt(i)).getWebURL() == null || !((Shortcut)this.shortcuts.elementAt(i)).getWebURL().equals(shortcut.getWebURL())) continue;
            return i;
        }
        return -1;
    }

    public void addNotDeletable(Shortcut shortcut) {
        this.notdeletables.addElement(shortcut);
    }

    public Shortcut getNotDeletable(int n) {
        return (Shortcut)this.notdeletables.elementAt(n);
    }

    public void removeNotDeletable(int n) {
        this.notdeletables.removeElementAt(n);
    }

    public int getNotDeletableCount() {
        return this.notdeletables.size();
    }

    public boolean isImageInUse(String string) {
        int n;
        if (this.teaser != null && this.teaser.getStrip() != null) {
            if (this.isImageInUseOnItem(string, this.getTeaser().getStrip())) {
                Log.log("L'immagine " + string + "e' dello strip del teaser");
                return true;
            }
            if (this.teaser.getStrip().getShortcut() != null && this.isImageInUseOnItem(string, this.teaser.getStrip().getShortcut())) {
                Log.log("L'immagine " + string + "e' dello shortcut del teaser");
                return true;
            }
        }
        if (this.getShortcutCount() > 0) {
            for (n = 0; n < this.getShortcutCount(); ++n) {
                if (!this.isImageInUseOnItem(string, this.getShortcut(n))) continue;
                return true;
            }
        }
        if (this.getNotDeletableCount() > 0) {
            for (n = 0; n < this.getNotDeletableCount(); ++n) {
                if (!this.isImageInUseOnItem(string, this.getNotDeletable(n))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isImageInUseOnItem(String string, Item item) {
        if (item.getImgSrc() != null && item.getImgSrc().equals(string)) {
            return true;
        }
        return item.getImgSrcDwl() != null && item.getImgSrcDwl().equals(string);
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean bl) {
        this.attached = bl;
    }
}

