/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.CalCanvas;
import CalendarPKG.SDATE;
import CalendarPKG.Tools;

public class ConvertDate {
    byte ADJUST_INVALID = (byte)55;
    private int HBASEYEAR = 1318;
    private int HBASEMONTH = 1;
    private int HBASEDAY = 1;
    public static short[] ndmnth = new short[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int GBASEYEAR = 1900;
    private int GBASEMONTH = 5;
    private int GBASEDAY = 1;
    byte nAdjustVal;
    boolean m_bIsDeleted = false;
    private int NUMOFYEARS = 183;
    int HStartYear = 1420;
    int HEndYear = 1450;
    int m_nYearHas30;
    double m_dBaseJD;
    SDATE dD = new SDATE();
    SDATE[] m_EndStoredDate = new SDATE[1];
    SDATE[] m_sdStart = new SDATE[1];
    SDATE[] m_sdEnd = new SDATE[1];
    final double TIMZ;
    final double MINAGE;
    final double SUNSET;
    final double TIMDIF;
    final double RPD = Math.PI / 180;
    final int NMONTHS;
    final int[] MonthMap = new int[]{19410, 19396, 19337, 19093, 13613, 13741, 15210, 18132, 19913, 19858, 19110, 18774, 12974, 13677, 13162, 15189, 19114, 14669, 13469, 14685, 12986, 13749, 17834, 15701, 19098, 14638, 12910, 13661, 15066, 18132, 18085};
    final short[] gmonth = new short[]{31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31};
    final short[] smonth = new short[]{31, 30, 30, 30, 30, 30, 29, 31, 31, 31, 31, 31, 31, 30};
    public final HijriYear[] HijriYears = new HijriYear[]{new HijriYear(1388, 354), new HijriYear(2921, 709), new HijriYear(1874, 1063), new HijriYear(3749, 1418), new HijriYear(3402, 1772), new HijriYear(2710, 2126), new HijriYear(1366, 2480), new HijriYear(2741, 2835), new HijriYear(1450, 3189), new HijriYear(3493, 3544), new HijriYear(3402, 3898), new HijriYear(2709, 4252), new HijriYear(2347, 4606), new HijriYear(603, 4960), new HijriYear(1371, 5315), new HijriYear(2742, 5670), new HijriYear(1706, 6024), new HijriYear(1429, 6378), new HijriYear(3371, 6733), new HijriYear(2646, 7087), new HijriYear(1198, 7441), new HijriYear(2414, 7796), new HijriYear(748, 8150), new HijriYear(2793, 8505), new HijriYear(1746, 8859), new HijriYear(1685, 9213), new HijriYear(1195, 9567), new HijriYear(2395, 9922), new HijriYear(698, 10276), new HijriYear(1465, 10631), new HijriYear(2994, 10986), new HijriYear(2980, 11340), new HijriYear(2889, 11694), new HijriYear(1685, 12048), new HijriYear(1325, 12402), new HijriYear(2413, 12757), new HijriYear(2922, 13112), new HijriYear(1748, 13466), new HijriYear(3785, 13821), new HijriYear(3730, 14175), new HijriYear(3366, 14529), new HijriYear(2646, 14883), new HijriYear(1197, 15237), new HijriYear(2477, 15592), new HijriYear(3434, 15947), new HijriYear(2900, 16301), new HijriYear(2853, 16655), new HijriYear(2635, 17009), new HijriYear(1179, 17363), new HijriYear(2391, 17718), new HijriYear(698, 18072), new HijriYear(1461, 18427), new HijriYear(1450, 18781), new HijriYear(3413, 19136), new HijriYear(3242, 19490), new HijriYear(2358, 19844), new HijriYear(622, 20198), new HijriYear(1373, 20553), new HijriYear(2794, 20908), new HijriYear(1492, 21262), new HijriYear(1449, 21616), new HijriYear(3413, 21971), new HijriYear(2730, 22325), new HijriYear(1370, 22679), new HijriYear(2742, 23034), new HijriYear(1460, 23388), new HijriYear(2985, 23743), new HijriYear(1874, 24097), new HijriYear(1701, 24451), new HijriYear(1363, 24805), new HijriYear(2731, 25160), new HijriYear(1370, 25514), new HijriYear(2777, 25869), new HijriYear(1746, 26223), new HijriYear(3749, 26578), new HijriYear(3402, 26932), new HijriYear(3349, 27286), new HijriYear(2349, 27640), new HijriYear(685, 27994), new HijriYear(1387, 28349), new HijriYear(2905, 28704), new HijriYear(2898, 29058), new HijriYear(2709, 29412), new HijriYear(1323, 29766), new HijriYear(1111, 30120), new HijriYear(2231, 30475), new HijriYear(2422, 30830), new HijriYear(1396, 31184), new HijriYear(2921, 31539), new HijriYear(2890, 31893), new HijriYear(2709, 32247), new HijriYear(1197, 32601), new HijriYear(349, 32955), new HijriYear(733, 33310), new HijriYear(1498, 33665), new HijriYear(1492, 34019), new HijriYear(3493, 34374), new HijriYear(3402, 34728), new HijriYear(2710, 35082), new HijriYear(1206, 35436), new HijriYear(1461, 35791), new HijriYear(882, 36145), new HijriYear(3026, 36500), new HijriYear(3012, 36854), new HijriYear(2953, 37208), new HijriYear(2709, 37562), new HijriYear(1325, 37916), new HijriYear(1453, 38271), new HijriYear(2922, 38626), new HijriYear(1748, 38980), new HijriYear(3529, 39335), new HijriYear(3474, 39689), new HijriYear(2726, 40043), new HijriYear(2390, 40397), new HijriYear(686, 40751), new HijriYear(1389, 41106), new HijriYear(874, 41460), new HijriYear(2901, 41815), new HijriYear(2730, 42169), new HijriYear(2381, 42523), new HijriYear(1181, 42877), new HijriYear(2397, 43232), new HijriYear(698, 43586), new HijriYear(1461, 43941), new HijriYear(1450, 44295), new HijriYear(3413, 44650), new HijriYear(2714, 45004), new HijriYear(2350, 45358), new HijriYear(622, 45712), new HijriYear(1373, 46067), new HijriYear(2778, 46422), new HijriYear(1748, 46776), new HijriYear(1701, 47130), new HijriYear(2857, 47484), new HijriYear(1365, 47838), new HijriYear(685, 48192), new HijriYear(1389, 48547), new HijriYear(2922, 48902), new HijriYear(1874, 49256), new HijriYear(3909, 49611), new HijriYear(3722, 49965), new HijriYear(3366, 50319), new HijriYear(2390, 50673), new HijriYear(2741, 51028), new HijriYear(1452, 51382), new HijriYear(3497, 51737), new HijriYear(3410, 52091), new HijriYear(2837, 52445), new HijriYear(2603, 52799), new HijriYear(1115, 53153), new HijriYear(2395, 53508), new HijriYear(2746, 53863), new HijriYear(1460, 54217), new HijriYear(1449, 54571), new HijriYear(3403, 54926), new HijriYear(2710, 55280), new HijriYear(2222, 55634), new HijriYear(366, 55988), new HijriYear(1261, 56343), new HijriYear(2794, 56698), new HijriYear(1748, 57052), new HijriYear(1705, 57406), new HijriYear(1355, 57760), new HijriYear(2651, 58115), new HijriYear(1242, 58469), new HijriYear(1466, 58824), new HijriYear(2996, 59179), new HijriYear(2984, 59533), new HijriYear(2898, 59887), new HijriYear(2725, 60241), new HijriYear(1355, 60595), new HijriYear(2731, 60950), new HijriYear(1386, 61304), new HijriYear(1749, 61659), new HijriYear(1746, 62013), new HijriYear(3749, 62368), new HijriYear(3402, 62722), new HijriYear(2710, 63076), new HijriYear(1326, 63430), new HijriYear(2669, 63785), new HijriYear(1386, 64139), new HijriYear(2901, 64494), new HijriYear(2890, 64848)};
    HijriYear[] m_HijriYears = this.HijriYears;

    public ConvertDate(CalCanvas mainWnd) {
        this.TIMZ = 3.0;
        this.MINAGE = 13.5;
        this.SUNSET = 19.5;
        this.TIMDIF = 6.0;
        this.NMONTHS = 16861;
        this.nAdjustVal = mainWnd.HijryAdjustVal;
        this.m_HijriYears = new HijriYear[this.NUMOFYEARS];
        Tools.memcpy(this.m_HijriYears, this.HijriYears, this.NUMOFYEARS);
        this.m_bIsDeleted = true;
        this.m_EndStoredDate[0] = new SDATE();
        this.m_EndStoredDate[0].year = this.HBASEYEAR + this.NUMOFYEARS;
        this.m_EndStoredDate[0].mon = 12;
        int pp = 2048;
        int nTemp = this.HijriYears[this.NUMOFYEARS - 1].MonLength & pp;
        this.m_EndStoredDate[0].day = nTemp != 0 ? 30 : 29;
        this.m_dBaseJD = this.GCalendarToJD(this.GBASEYEAR, this.GBASEMONTH, this.GBASEDAY);
        this.m_nYearHas30 = -1;
        this.InitIslamicCalender();
    }

    public SDATE GregorianToHijriDate(SDATE sd1, boolean bAdjust) {
        short nAdjVal;
        double mjd;
        SDATE dD = new SDATE();
        int day = sd1.day;
        int month = sd1.mon;
        int year = sd1.year;
        int Dow = sd1.dw;
        float time = sd1.time;
        SDATE sd = new SDATE();
        sd.day = sd1.day;
        sd.dw = sd1.dw;
        sd.mon = sd1.mon;
        sd.time = sd1.time;
        sd.year = sd1.year;
        int[] d = new int[1];
        int[] m = new int[1];
        int[] y = new int[1];
        int[] dw = new int[1];
        if (!bAdjust) {
            if (this.m_HijriYears != null) {
                this.m_HijriYears = new HijriYear[this.NUMOFYEARS];
            }
            Tools.memcpy(this.m_HijriYears, this.HijriYears, this.NUMOFYEARS);
            this.m_bIsDeleted = true;
        } else {
            this.InitIslamicCalender();
        }
        if (this.NewGregorianToHijri(sd.day, sd.mon, sd.year, d, m, y, dw)) {
            dD.day = d[0];
            dD.mon = m[0];
            dD.year = y[0];
            dD.dw = dw[0];
            sd1.day = day;
            sd1.mon = month;
            sd1.year = year;
            sd1.dw = Dow;
            sd1.time = time;
            return dD;
        }
        double[] rjd = new double[1];
        double jd = this.julianday(sd.year, sd.mon, sd.day, 0.0);
        long k = (long)(0.6 + ((double)sd.year + (double)((short)((double)sd.mon - 0.5)) / 12.0 + (double)sd.day / 365.0 - 1900.0) * 12.3685);
        while ((mjd = this.visible(k--, rjd[0])) > jd) {
        }
        long hm = ++k - 1048L;
        dD.year = Integer.parseInt(1405L + hm / 12L + "");
        dD.mon = (int)(hm % 12L) + 1;
        if (hm != 0L && dD.mon <= 0) {
            dD.mon += 12;
            --dD.year;
        }
        if (dD.year <= 0) {
            --dD.year;
        }
        dD.day = (int)(jd - mjd + 1.0);
        dD.time = 0.5f;
        dD.dw = (int)(jd + 1.5) % 7;
        if (bAdjust && (nAdjVal = this.GetAdjustHijriValue()) != this.ADJUST_INVALID && nAdjVal != 0) {
            if (nAdjVal < 0 && dD.day < 3) {
                if (dD.day + nAdjVal <= 0) {
                    dD.day = 30 + dD.day + nAdjVal;
                    if (dD.mon == 1) {
                        dD.mon = 12;
                        --dD.year;
                    } else {
                        --dD.mon;
                    }
                } else {
                    dD.day += nAdjVal;
                }
            } else if (nAdjVal > 0 && dD.day > 28) {
                if (dD.day + nAdjVal > 30) {
                    dD.day = dD.day + nAdjVal - 30;
                    if (dD.mon == 12) {
                        dD.mon = 1;
                        ++dD.year;
                    } else {
                        ++dD.mon;
                    }
                } else {
                    dD.day += nAdjVal;
                }
            } else {
                dD.day += nAdjVal;
            }
        }
        return dD;
    }

    double julianday(int year, int month, int day, double time) {
        long m;
        long y;
        if (year < 0) {
            ++year;
        }
        if (month > 2) {
            y = year;
            m = month;
        } else {
            y = year - 1;
            m = month + 12;
        }
        double jul = (double)y * 365.25;
        if (y < 1L) {
            jul -= 0.75;
        }
        jul = (double)((long)jul + (long)(30.6001 * (double)(m + 1L)) + (long)day) + time + 1720994.5;
        if ((double)year + (double)month * 0.01 + ((double)day + time) * 1.0E-4 >= 1582.1015) {
            long ja = (long)(0.01 * (double)y);
            jul = jul + 2.0 - (double)ja + (double)((long)(0.25 * (double)ja));
        }
        return jul;
    }

    int G2HA(int yg, int mg, int dg, int yh, int mh, int dh, int dayweek, boolean bAdjust) {
        short nAdjVal;
        int[] yh1 = new int[1];
        int[] mh1 = new int[1];
        int[] dh1 = new int[1];
        double GJD = this.GCalendarToJD(yg, mg, (double)dg + 0.5);
        if (bAdjust && (nAdjVal = this.GetAdjustHijriValue()) != this.ADJUST_INVALID) {
            GJD += (double)nAdjVal;
        }
        this.JDToHCalendar(GJD, yh1[0], mh1[0], dh1[0]);
        double HJD = this.HCalendarToJDA(yh1[0], mh1[0], dh1[0]);
        if (HJD == 0.0 || yh1[0] < this.HStartYear || yh1[0] > this.HEndYear) {
            dayweek = 0;
            dh = 0;
            mh = 0;
            yh = 0;
            return 0;
        }
        int df = (int)(GJD - HJD);
        dh1[0] = dh1[0] + df;
        while (dh1[0] > 30) {
            dh1[0] = dh1[0] - this.HMonthLength(yh1[0], mh1[0]);
            mh1[0] = mh1[0] + 1;
            if (mh1[0] <= 12) continue;
            yh1[0] = yh1[0] + 1;
            mh1[0] = 1;
        }
        if (dh1[0] == 30) {
            int mh2 = mh1[0] + 1;
            int yh2 = yh1[0];
            if (mh2 > 12) {
                mh2 = 1;
                ++yh2;
            }
            int[] v1 = new int[1];
            int[] v2 = new int[1];
            int[] v3 = new int[1];
            int[] v4 = new int[1];
            this.BH2GA(yh2, mh2, v1[0], v2[0], v3[0], v4[0]);
            int yg1 = v1[0];
            int mg1 = v2[0];
            int dg1 = v3[0];
            int dw2 = v4[0];
            if (dg == dg1) {
                yh1[0] = yh2;
                mh1[0] = mh2;
                dh1[0] = 1;
            }
        }
        long J = (long)(this.GCalendarToJD(yg, mg, dg) + 2.0);
        dayweek = (int)J % 7;
        yh = yh1[0];
        mh = mh1[0];
        dh = dh1[0];
        return 1;
    }

    void JDToHCalendar(double JD, int yh, int mh, int dh) {
        double yd = JD - 1948439.0;
        double md = this.mod(yd, 354.367068);
        dh = this.mod(md + 0.5, 29.530589) + 1;
        mh = (int)(md / 29.530589 + 1.0);
        yh = (int)((yd -= md) / 354.367068 + 1.0);
        if (dh > 30) {
            dh -= 30;
            ++mh;
        }
        if (mh > 12) {
            mh -= 12;
            ++yh;
        }
    }

    int mod(double x, double y) {
        double d = x / y;
        int r = (int)d;
        if (r < 0) {
            --r;
        }
        d = x - y * (double)r;
        r = (int)d;
        return r;
    }

    public SDATE HijriToGregorianDate(SDATE sd1, boolean bAdjust) {
        SDATE sd = new SDATE(sd1.day, sd1.mon, sd1.year, sd1.dw, sd1.time);
        int[] d = new int[1];
        int[] m = new int[1];
        int[] y = new int[1];
        int[] dw = new int[1];
        if (!bAdjust) {
            if (this.m_HijriYears == null) {
                this.m_HijriYears = new HijriYear[this.NUMOFYEARS];
            }
            Tools.memcpy(this.m_HijriYears, this.HijriYears, this.NUMOFYEARS);
            this.m_bIsDeleted = true;
        } else {
            this.InitIslamicCalender();
        }
        if (this.NewHijriToGregorian(sd.day, sd.mon, sd.year, d, m, y, dw)) {
            this.dD.day = d[0];
            this.dD.mon = m[0];
            this.dD.year = y[0];
            this.dD.dw = dw[0];
            return this.dD;
        }
        return this.HijriToGregorianDateOld(sd, bAdjust);
    }

    short nDaysInGregorianMonth(int m, int y) {
        short nd = ndmnth[m];
        if (m == 2 && y % 4 == 0 && (y < 1582 || y % 100 != 0 || y % 400 == 0)) {
            nd = (short)(nd + 1);
        }
        return nd;
    }

    boolean NewGregorianToHijri(int nDayg, int nMonthg, int nYearg, int[] nDayh, int[] nMonthh, int[] nYearh, int[] nDayWeek) {
        if (nMonthg > 12 || nMonthg < 1) {
            return false;
        }
        if (nDayg > this.nDaysInGregorianMonth(nMonthg, nYearg) || nDayg < 1) {
            return false;
        }
        SDATE[] sdGTemp1 = new SDATE[1];
        SDATE[] sdGTemp2 = new SDATE[1];
        SDATE[] sdHTemp = new SDATE[1];
        int[] dg = new int[1];
        int[] mg = new int[1];
        int[] yg = new int[1];
        int[] dw = new int[1];
        sdGTemp1[0] = new SDATE();
        sdGTemp1[0].day = nDayg;
        sdGTemp1[0].mon = nMonthg;
        sdGTemp1[0].year = nYearg;
        double JD2 = this.GCalendarToJD(nYearg, nMonthg, nDayg);
        int nDays = (int)(JD2 - this.m_dBaseJD);
        sdHTemp[0] = new SDATE();
        sdHTemp[0].day = this.HBASEDAY;
        sdHTemp[0].mon = this.HBASEMONTH;
        sdHTemp[0].year = this.HBASEYEAR;
        if (!this.AddHDateInternal(sdHTemp, nDays)) {
            return false;
        }
        this.NewHijriToGregorian(sdHTemp[0].day, sdHTemp[0].mon, sdHTemp[0].year, dg, mg, yg, dw);
        nDayh[0] = sdHTemp[0].day;
        nMonthh[0] = sdHTemp[0].mon;
        nYearh[0] = sdHTemp[0].year;
        sdGTemp2[0] = new SDATE();
        sdGTemp2[0].day = dg[0];
        sdGTemp2[0].mon = mg[0];
        sdGTemp2[0].year = yg[0];
        int nRes = this.DateCmp(sdGTemp1[0], sdGTemp2[0]);
        if (nRes > 0) {
            do {
                try {
                    if (!this.AddHDateInternal(sdHTemp, 1)) {
                        return false;
                    }
                    this.NewHijriToGregorian(sdHTemp[0].day, sdHTemp[0].mon, sdHTemp[0].year, dg, mg, yg, dw);
                    nDayh[0] = sdHTemp[0].day;
                    nMonthh[0] = sdHTemp[0].mon;
                    nYearh[0] = sdHTemp[0].year;
                    sdGTemp2[0].day = dg[0];
                    sdGTemp2[0].mon = mg[0];
                    sdGTemp2[0].year = yg[0];
                    nRes = this.DateCmp(sdGTemp1[0], sdGTemp2[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } while (nRes != 0);
        } else if (nRes < 0) {
            do {
                if (!this.AddHDateInternal(sdHTemp, -1)) {
                    return false;
                }
                this.NewHijriToGregorian(sdHTemp[0].day, sdHTemp[0].mon, sdHTemp[0].year, dg, mg, yg, dw);
                nDayh[0] = sdHTemp[0].day;
                nMonthh[0] = sdHTemp[0].mon;
                nYearh[0] = sdHTemp[0].year;
                sdGTemp2[0].day = dg[0];
                sdGTemp2[0].mon = mg[0];
                sdGTemp2[0].year = yg[0];
            } while ((nRes = this.DateCmp(sdGTemp1[0], sdGTemp2[0])) != 0);
        }
        sdHTemp[0].dw = (int)(JD2 + 1.5) % 7;
        nDayh[0] = sdHTemp[0].day;
        nMonthh[0] = sdHTemp[0].mon;
        nYearh[0] = sdHTemp[0].year;
        nDayWeek[0] = sdHTemp[0].dw;
        return true;
    }

    int DateCmp(SDATE sd1, SDATE sd2) {
        if (sd1.year > sd2.year) {
            return 1;
        }
        if (sd1.year < sd2.year) {
            return -1;
        }
        if (sd1.mon > sd2.mon) {
            return 1;
        }
        if (sd1.mon < sd2.mon) {
            return -1;
        }
        if (sd1.day > sd2.day) {
            return 1;
        }
        if (sd1.day < sd2.day) {
            return -1;
        }
        return 0;
    }

    boolean AddHDateInternal(SDATE[] HDate, int nDays) {
        SDATE sdTemp = HDate[0];
        sdTemp.day += nDays;
        int nYearIndex = sdTemp.year - this.HBASEYEAR;
        if (nDays >= 0) {
            int nMask = 1 << sdTemp.mon - 1;
            int nTemp = this.m_HijriYears[nYearIndex].MonLength & nMask;
            int nMonLen = nTemp != 0 ? 30 : 29;
            while (sdTemp.day > nMonLen) {
                sdTemp.day -= nMonLen;
                ++sdTemp.mon;
                if (sdTemp.mon == 13) {
                    sdTemp.mon = 1;
                    ++sdTemp.year;
                }
                if ((nYearIndex = sdTemp.year - this.HBASEYEAR) >= this.NUMOFYEARS) {
                    return false;
                }
                nMask = 1 << sdTemp.mon - 1;
                nTemp = this.m_HijriYears[nYearIndex].MonLength & nMask;
                if (nTemp != 0) {
                    nMonLen = 30;
                    continue;
                }
                nMonLen = 29;
            }
        } else {
            while (sdTemp.day <= 0) {
                --sdTemp.mon;
                if (sdTemp.mon == 0) {
                    sdTemp.mon = 12;
                    --sdTemp.year;
                }
                int nMask = 1 << sdTemp.mon - 1;
                nYearIndex = sdTemp.year - this.HBASEYEAR;
                if (nYearIndex < 0) {
                    return false;
                }
                int nTemp = this.m_HijriYears[nYearIndex].MonLength & nMask;
                int nMonLen = nTemp != 0 ? 30 : 29;
                sdTemp.day += nMonLen;
            }
        }
        HDate[0] = sdTemp;
        return true;
    }

    int H2GA(int yhh, int mhh, int dhh, int yg, int mg, int dg, int dayweek) {
        int[] found = new int[1];
        int[] yg1 = new int[1];
        int[] mg1 = new int[1];
        int[] dg1 = new int[1];
        int[] dw1 = new int[1];
        int[] mh1 = new int[1];
        int[] yh1 = new int[1];
        int yh = yhh;
        int mh = mhh;
        int dh = dhh;
        if (dh > 30) {
            dh = 1;
            ++mh;
        }
        if (dh < 1) {
            dh = 1;
            --mh;
        }
        if (mh > 12) {
            mh = 1;
            ++yh;
        }
        if (mh < 1) {
            mh = 12;
            --yh;
        }
        found[0] = this.BH2GA(yh, mh, yg, mg, dg, dayweek);
        dg = dg + dh - 1;
        this.GDateAjust(yg, mg, dg);
        dayweek = dayweek + dh - 1;
        dayweek %= 7;
        if (dh == 30) {
            mh1[0] = mh + 1;
            yh1[0] = yh;
            if (mh1[0] > 12) {
                mh1[0] = mh1[0] - 12;
                yh1[0] = yh1[0] + 1;
            }
            found[0] = this.BH2GA(yh1[0], mh1[0], yg1[0], mg1[0], dg1[0], dw1[0]);
            if (dg == dg1[0]) {
                yh = yh1[0];
                mh = mh1[0];
                dh = 1;
            }
        }
        return found[0];
    }

    void GDateAjust(int yg, int mg, int dg) {
        int dys;
        if (mg < 1) {
            mg = 12 + mg;
            --yg;
        }
        if (dg < 1) {
            dg = this.gmonth[--mg] + dg;
            if (mg == 2) {
                dg += this.GLeapYear(yg);
            }
            if (mg < 1) {
                mg = 12 + mg;
                --yg;
            }
        }
        if (mg > 12) {
            mg -= 12;
            ++yg;
        }
        if (dg > (dys = mg == 2 ? this.gmonth[mg] + this.GLeapYear(yg) : this.gmonth[mg])) {
            dg -= dys;
            if (++mg == 2 && dg > (dys = this.gmonth[mg] + this.GLeapYear(yg))) {
                dg -= dys;
                ++mg;
            }
            if (mg > 12) {
                mg -= 12;
                ++yg;
            }
        }
    }

    int GLeapYear(int year) {
        int T = 0;
        if (year % 4 == 0) {
            T = 1;
        }
        if (year % 100 == 0) {
            T = 0;
            if (year % 400 == 0) {
                T = 1;
            }
        }
        return T;
    }

    int BH2GA(int yh, int mh, int yg, int mg, int dg, int dayweek) {
        int flag = 1;
        if (mh < 1 || mh > 12 || yh < this.HStartYear || yh > this.HEndYear) {
            flag = 0;
        }
        if (mh < 1) {
            mh = 12;
        }
        if (mh > 12) {
            mh = 1;
        }
        if (yh < this.HStartYear) {
            yh = this.HStartYear;
        }
        if (yh > this.HEndYear) {
            yh = this.HEndYear;
        }
        double GJD = this.HCalendarToJDA(yh, mh, 1);
        this.JDToGCalendar(GJD, yg, mg, dg);
        long JD = (long)GJD;
        dayweek = (int)(JD + 1L) % 7;
        return flag;
    }

    double JDToGCalendar(double JD, int yy, int mm, int dd) {
        long Z = (long)Math.floor(JD + 0.5);
        double F = JD + 0.5 - (double)Z;
        int alpha = (int)(((double)Z - 1867216.25) / 36524.25);
        double A = Z + 1L + (long)alpha - (long)(alpha / 4);
        double B = A + 1524.0;
        int C = (int)((B - 122.1) / 365.25);
        long D = (long)(365.25 * (double)C);
        int E = (int)((B - (double)D) / 30.6001);
        dd = (int)(B - (double)D - Math.floor(30.6001 * (double)E) + F);
        mm = E < 14 ? E - 1 : E - 13;
        yy = mm > 2 ? C - 4716 : C - 4715;
        return F *= 24.0;
    }

    double HCalendarToJDA(int yh, int mh, int dh) {
        if (yh < this.HStartYear) {
            return 0.0;
        }
        long JD = (long)this.HCalendarToJD(yh, 1, 1);
        int Dy = this.MonthMap[yh - this.HStartYear] / 4096;
        double GJD = JD - 3L + (long)Dy;
        int b = this.MonthMap[yh - this.HStartYear];
        b -= Dy * 4096;
        for (int m = 1; m < mh; ++m) {
            int flag = b % 2;
            Dy = flag != 0 ? 30 : 29;
            GJD += (double)Dy;
            b = (b - flag) / 2;
        }
        GJD = GJD + (double)dh - 1.0;
        return GJD;
    }

    double HCalendarToJD(int yh, int mh, int dh) {
        double md = ((double)mh - 1.0) * 29.530589;
        double yd = ((double)yh - 1.0) * 354.367068 + md + (double)dh - 1.0;
        return yd += 1948439.0;
    }

    SDATE HijriToGregorianDateOld(SDATE sd, boolean bAdjust) {
        short nAdjVal;
        double rjd = 0.0;
        if (sd.year < 0) {
            ++sd.year;
        }
        long k = sd.mon + sd.year * 12 - 16861;
        double jd = this.visible(k + 1048L, rjd) + (double)sd.day;
        if (bAdjust && (nAdjVal = this.GetAdjustHijriValue()) != this.ADJUST_INVALID) {
            jd -= (double)nAdjVal;
        }
        SDATE rd = this.caldate(jd);
        return rd;
    }

    public boolean NewHijriToGregorian(int nDayh, int nMonthh, int nYearh, int[] nDayg, int[] nMonthg, int[] nYearg, int[] nDayWeek) {
        int nYearIndex = nYearh - this.HBASEYEAR;
        if (nYearIndex < 0 || nYearIndex >= this.NUMOFYEARS) {
            return false;
        }
        if (nMonthh > 12 || nMonthh < 1) {
            return false;
        }
        if (nDayh > this.GetHLength(nMonthh, nYearh)) {
            return false;
        }
        int nAccum = 0;
        int ushTemp = 1 << nMonthh - 1;
        int uTemp = this.m_HijriYears[nYearIndex].MonLength & ushTemp;
        nAccum = uTemp != 0 ? (nAccum += 30) : (nAccum += 29);
        if (nDayh > nAccum || nDayh < 1) {
            return false;
        }
        nAccum = 0;
        if (nYearIndex != 0) {
            nAccum = this.m_HijriYears[nYearIndex - 1].nAccumdays;
        }
        for (int i = 1; i < nMonthh; ++i) {
            int pp = 1 << i - 1;
            int nTemp = this.m_HijriYears[nYearIndex].MonLength & pp;
            if (nTemp != 0) {
                nAccum += 30;
                continue;
            }
            nAccum += 29;
        }
        double JD = nAccum + nDayh - 1;
        int nIndex = (int)JD;
        SDATE[] sd = new SDATE[]{new SDATE()};
        sd[0].day = this.GBASEDAY;
        sd[0].mon = this.GBASEMONTH;
        sd[0].year = this.GBASEYEAR;
        this.AddGDate(sd[0], nIndex);
        nDayg[0] = sd[0].day;
        nMonthg[0] = sd[0].mon;
        nYearg[0] = sd[0].year;
        JD = this.GCalendarToJD(sd[0].year, sd[0].mon, sd[0].day);
        nDayWeek[0] = sd[0].dw = (int)(JD + 1.5) % 7;
        return true;
    }

    void InitIslamicCalender() {
        if (!this.m_bIsDeleted) {
            return;
        }
        short nAdjust = this.GetAdjustHijriValue();
        if (nAdjust != 0 && nAdjust != this.ADJUST_INVALID) {
            SDATE[] sdHTemp = new SDATE[]{new SDATE()};
            sdHTemp[0].day = 15;
            sdHTemp[0].mon = 7;
            sdHTemp[0].year = 1428;
            this.AdjustHigriDate(nAdjust, sdHTemp);
        }
        this.m_bIsDeleted = false;
        this.nAdjustVal = this.ADJUST_INVALID;
    }

    boolean AdjustHigriDate(int nDays, SDATE[] sdHDate) {
        SDATE[] sdTemp = new SDATE[]{new SDATE()};
        sdTemp[0].day = this.HBASEDAY;
        sdTemp[0].mon = this.HBASEMONTH;
        sdTemp[0].year = this.HBASEYEAR;
        if (this.DateCmp(sdHDate[0], this.m_EndStoredDate[0]) > 0 || this.DateCmp(sdHDate[0], sdTemp[0]) < 0) {
            return false;
        }
        boolean bPrevMon = true;
        if (sdHDate[0].day >= 1 && sdHDate[0].day <= 27) {
            if (nDays < 0) {
                return this.BackPropagate(sdHDate[0], bPrevMon, true, -nDays);
            }
            return this.BackPropagate(sdHDate[0], bPrevMon, false, nDays);
        }
        if (sdHDate[0].day + nDays >= 30) {
            int nYearIndex = sdHDate[0].year - this.HBASEYEAR;
            int pp = 1 << sdHDate[0].mon - 1;
            int nTemp = this.m_HijriYears[nYearIndex].MonLength & pp;
            if (nTemp == 0) {
                this.m_HijriYears[nYearIndex].MonLength |= pp;
                this.m_nYearHas30 = nYearIndex;
            }
        }
        if (sdHDate[0].day + nDays > 30) {
            bPrevMon = false;
        }
        if (nDays < 0) {
            return this.BackPropagate(sdHDate[0], bPrevMon, true, -nDays);
        }
        return this.BackPropagate(sdHDate[0], bPrevMon, false, nDays);
    }

    boolean BackPropagate(SDATE Hdate, boolean bStartPrev, boolean bMake30, int nTimes) {
        int nWantedLen = bMake30 ? 29 : 30;
        int nCurYear = Hdate.year;
        int nYearIndex = nCurYear - this.HBASEYEAR;
        if (nYearIndex < 0 || nYearIndex > this.NUMOFYEARS) {
            return false;
        }
        int nCurMon = Hdate.mon;
        if (nCurMon > 12 || nCurMon < 1) {
            return false;
        }
        int nMonLen = 0;
        if (bStartPrev && --nCurMon == 0) {
            nCurMon = 12;
            if ((nYearIndex = --nCurYear - this.HBASEYEAR) < 0) {
                return false;
            }
        }
        int pp = 0;
        pp = 1 << nCurMon - 1;
        int nTemp = this.m_HijriYears[nYearIndex].MonLength & pp;
        nMonLen = nTemp != 0 ? 30 : 29;
        int[] nTempYear = new int[nTimes];
        for (int i = 0; i < nTimes; i = (int)((short)(i + 1))) {
            while (nMonLen != nWantedLen) {
                if (--nCurMon == 0) {
                    nCurMon = 12;
                    if ((nYearIndex = --nCurYear - this.HBASEYEAR) < 0) {
                        return false;
                    }
                }
                if ((nTemp = this.m_HijriYears[nYearIndex].MonLength & (pp = 1 << nCurMon - 1)) != 0) {
                    nMonLen = 30;
                    continue;
                }
                nMonLen = 29;
            }
            this.m_HijriYears[nYearIndex].MonLength = bMake30 ? (this.m_HijriYears[nYearIndex].MonLength |= pp) : (this.m_HijriYears[nYearIndex].MonLength &= (pp ^= 0xFFFFFFFF));
            nTempYear[nTimes - 1 - i] = nYearIndex;
            nMonLen = 0;
        }
        int nInc = 0;
        int nUnit = bMake30 ? 1 : -1;
        for (int j = 0; j < nTimes - 1; ++j) {
            this.UpdateYearsAccum(nTempYear[j], nTempYear[j + 1] - 1, nInc += nUnit);
        }
        this.UpdateYearsAccum(nTempYear[nTimes - 1], this.NUMOFYEARS - 1, nInc += nUnit);
        this.m_nYearHas30 = -1;
        return true;
    }

    void UpdateYearsAccum(int nBaseIndex, int nEndIndex, int nInc) {
        if (nBaseIndex < 0 || nBaseIndex >= this.NUMOFYEARS) {
            return;
        }
        if (nEndIndex < nBaseIndex || nEndIndex >= this.NUMOFYEARS) {
            return;
        }
        for (int i = nBaseIndex; i <= nEndIndex; ++i) {
            this.m_HijriYears[i].nAccumdays += nInc;
            if (this.m_nYearHas30 == -1 || i < this.m_nYearHas30) continue;
            ++this.m_HijriYears[i].nAccumdays;
        }
    }

    short GetAdjustHijriValue() {
        if (this.nAdjustVal != this.ADJUST_INVALID) {
            return this.nAdjustVal;
        }
        return this.ADJUST_INVALID;
    }

    int AddHDate(SDATE sd, int nDay) {
        if (nDay < -2 || nDay > 2) {
            return 0;
        }
        int nD = sd.day;
        int nMonDays = this.HMonthLength(sd.year, sd.mon);
        if ((nD += nDay) > 0 && nD <= nMonDays) {
            sd.day = nD;
        } else if (nD <= 0) {
            sd = this.DecrementMonth(sd);
            nMonDays = this.HMonthLength(sd.year, sd.mon);
            sd.day = nMonDays + nD;
        } else {
            sd = this.IncrementMonth(sd);
            sd.day = nD -= nMonDays;
        }
        return 1;
    }

    int HMonthLength(int yh, int mh) {
        int Dy = this.GetHLength(mh, yh);
        if (Dy != 0) {
            return Dy;
        }
        if (yh < this.HStartYear || yh > this.HEndYear) {
            boolean flag = false;
            Dy = 0;
        } else {
            Dy = this.MonthMap[yh - this.HStartYear] / 4096;
            int b = this.MonthMap[yh - this.HStartYear];
            b -= Dy * 4096;
            for (int m = 1; m <= mh; ++m) {
                int flag = b % 2;
                Dy = flag != 0 ? 30 : 29;
                b = (b - flag) / 2;
            }
        }
        return Dy;
    }

    short GetHLength(int nMonth, int nYear) {
        if (nMonth > 12 || nMonth < 1) {
            return 0;
        }
        int nYearIndex = nYear - this.HBASEYEAR;
        if (nYearIndex < 0 || nYearIndex >= this.NUMOFYEARS) {
            return 0;
        }
        int pp = 1 << nMonth - 1;
        int nTemp = this.m_HijriYears[nYearIndex].MonLength & pp;
        if (nTemp != 0) {
            return 30;
        }
        return 29;
    }

    SDATE DecrementMonth(SDATE sd) {
        if (--sd.mon == 0) {
            sd.mon = 12;
            --sd.year;
        }
        return sd;
    }

    SDATE IncrementMonth(SDATE sd) {
        if (++sd.mon == 13) {
            sd.mon = 1;
            ++sd.year;
        }
        return sd;
    }

    boolean AddGDate(SDATE GDate, int nDays) {
        SDATE sdTemp = GDate;
        sdTemp.day += nDays;
        if (nDays >= 0) {
            short nMonLen = this.nDaysinGregorianMonth(sdTemp.mon, sdTemp.year);
            while (sdTemp.day > nMonLen) {
                sdTemp.day -= nMonLen;
                ++sdTemp.mon;
                if (sdTemp.mon == 13) {
                    sdTemp.mon = 1;
                    ++sdTemp.year;
                }
                nMonLen = this.nDaysinGregorianMonth(sdTemp.mon, sdTemp.year);
            }
        } else {
            while (sdTemp.day <= 0) {
                --sdTemp.mon;
                if (sdTemp.mon == 0) {
                    sdTemp.mon = 12;
                    --sdTemp.year;
                }
                short nMonLen = this.nDaysinGregorianMonth(sdTemp.mon, sdTemp.year);
                sdTemp.day += nMonLen;
            }
        }
        GDate = sdTemp;
        return true;
    }

    short nDaysinGregorianMonth(int m, int y) {
        short nd = ndmnth[m];
        if (m == 2 && y % 4 == 0 && (y < 1582 || y % 100 != 0 || y % 400 == 0)) {
            nd = (short)(nd + 1);
        }
        return nd;
    }

    double GCalendarToJD(int yy, int mm, double dd) {
        int m;
        int y;
        if (mm > 2) {
            y = yy;
            m = mm;
        } else {
            y = yy - 1;
            m = mm + 12;
        }
        int A = y / 100;
        int B = 2 - A + A / 4;
        double T1 = this.ip(365.25 * (double)(y + 4716));
        double T2 = this.ip(30.6001 * (double)(m + 1));
        double Tr = T1 + T2 + dd + (double)B - 1524.5;
        return Tr;
    }

    double ip(double x) {
        double tmp = 0.0;
        try {
            tmp = Double.parseDouble(x + "");
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        return tmp;
    }

    double visible(long n, double rjd) {
        double jd;
        rjd = jd = this.tmoonphase(n, 0);
        long d = (long)jd;
        float tf = (float)(jd - (double)d);
        if ((double)tf <= 0.5) {
            return jd + 1.0;
        }
        if ((double)(tf = (float)(((double)tf - 0.5) * 24.0 + 3.0)) > 6.0) {
            return jd + 1.0;
        }
        return jd;
    }

    double tmoonphase(long n, int nph) {
        double xtra;
        double k = (double)n + (double)nph / 4.0;
        double t = k / 1236.85;
        double t2 = t * t;
        double t3 = t2 * t;
        double jd = 2415020.75933 + 29.53058868 * k - 1.178E-4 * t2 - 1.55E-7 * t3 + 3.3E-4 * Math.sin(Math.PI / 180 * (166.56 + 132.87 * t - 0.009173 * t2));
        double sa = Math.PI / 180 * (359.2242 + 29.10535608 * k - 3.33E-5 * t2 - 3.47E-6 * t3);
        double ma = Math.PI / 180 * (306.0253 + 385.81691806 * k + 0.0107306 * t2 + 1.236E-5 * t3);
        double tf = Math.PI / 90 * (21.2964 + 390.67050646 * k - 0.0016528 * t2 - 2.39E-6 * t3);
        if (nph == 0 || nph == 2) {
            xtra = (0.1734 - 3.93E-4 * t) * Math.sin(sa) + 0.0021 * Math.sin(sa * 2.0) - 0.4068 * Math.sin(ma) + 0.0161 * Math.sin(2.0 * ma) - 4.0E-4 * Math.sin(3.0 * ma) + 0.0104 * Math.sin(tf) - 0.0051 * Math.sin(sa + ma) - 0.0074 * Math.sin(sa - ma) + 4.0E-4 * Math.sin(tf + sa) - 4.0E-4 * Math.sin(tf - sa) - 6.0E-4 * Math.sin(tf + ma) + 0.001 * Math.sin(tf - ma) + 5.0E-4 * Math.sin(sa + 2.0 * ma);
        } else if (nph == 1 || nph == 3) {
            xtra = (0.1721 - 4.0E-4 * t) * Math.sin(sa) + 0.0021 * Math.sin(sa * 2.0) - 0.628 * Math.sin(ma) + 0.0089 * Math.sin(2.0 * ma) - 4.0E-4 * Math.sin(3.0 * ma) + 0.0079 * Math.sin(tf) - 0.0119 * Math.sin(sa + ma) - 0.0047 * Math.sin(sa - ma) + 3.0E-4 * Math.sin(tf + sa) - 4.0E-4 * Math.sin(tf - sa) - 6.0E-4 * Math.sin(tf + ma) + 0.0021 * Math.sin(tf - ma) + 3.0E-4 * Math.sin(sa + 2.0 * ma) + 4.0E-4 * Math.sin(sa - 2.0 * ma) - 3.0E-4 * Math.sin(2.0 * sa + ma);
            xtra = nph == 1 ? xtra + 0.0028 - 4.0E-4 * Math.cos(sa) + 3.0E-4 * Math.cos(ma) : xtra - 0.0028 + 4.0E-4 * Math.cos(sa) - 3.0E-4 * Math.cos(ma);
        } else {
            return -1.0;
        }
        return jd += xtra - (0.41 + 1.2053 * t + 0.4992 * t2) / 1440.0;
    }

    SDATE caldate(double julday) {
        long a;
        long z = (long)(julday += 0.5);
        double f = julday - (double)z;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a + 1524L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        this.dD.day = (short)(f += (double)(b - d - (long)(30.6001 * (double)e)));
        this.dD.time = (float)(f - (double)this.dD.day);
        this.dD.mon = (int)(e > 13L ? e - 13L : e - 1L);
        this.dD.year = (int)(this.dD.mon > 2 ? c - 4716L : c - 4715L);
        this.dD.dw = (int)(julday - (double)this.dD.time + 1.1) % 7;
        if (this.dD.year <= 0) {
            --this.dD.year;
        }
        return this.dD;
    }

    class HijriYear {
        int MonLength;
        int nAccumdays;

        public HijriYear(int month, int accDays) {
            this.MonLength = month;
            this.nAccumdays = accDays;
        }
    }
}

