/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.CustomComponent;
import MobmeControls.MobmeChoiceListener;
import MobmeControls.MobmeEdit;
import MobmeControls.MobmeForm;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class MobmeNumChoice
extends CustomComponent
implements CommandListener,
Runnable {
    String m_strLabel = "";
    String m_strTitle = "";
    int m_iStartNo = -1;
    int m_iEndNo = -1;
    int m_nSize = -1;
    Displayable m_Parent = null;
    MobmeChoiceListener m_SelListener = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    Font m_F;
    boolean m_bIsRightPressed = false;
    boolean m_bIsLeftPressed = false;
    boolean m_bIsTraversedOut = true;
    boolean m_bIsLocked = false;
    int m_iPos;
    MobmeForm m_EditForm = null;
    MobmeEdit m_EditCtrl = null;

    public MobmeNumChoice(String Title, Displayable parent, Display display, Font f, boolean bIsArabic, int iStartNo, int iEndNo) {
        this.m_strTitle = Title;
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_iPos = -1;
        this.m_iStartNo = iStartNo;
        this.m_iEndNo = iEndNo;
        this.m_nSize = this.m_iEndNo - this.m_iStartNo + 1;
        this.m_EditForm = new MobmeForm();
        this.m_EditForm.addCommand(new Command("\u0631\u062c\u0648\u0639", 2, 0));
        this.m_EditForm.addCommand(new Command("\u062a\u0645", 4, 1));
        this.m_EditCtrl = new MobmeEdit("", (Displayable)this.m_EditForm, display, f, bIsArabic);
        this.m_EditCtrl.SetNumberInputMode(true);
        this.m_EditForm.append(this.m_EditCtrl);
        this.m_EditForm.setTitle("\u0623\u062f\u062e\u0644 \u0631\u0642\u0645");
        this.m_EditForm.setCommandListener(this);
    }

    public void setSelListener(MobmeChoiceListener SelListener) {
        this.m_SelListener = SelListener;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_F.getHeight() + 4;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_F.getHeight() + 4;
    }

    protected void paint(Graphics graphics, int w, int h) {
        if (this.m_bIsLocked) {
            return;
        }
        int oldC = graphics.getColor();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, w, h);
        graphics.setColor(0);
        graphics.drawRect(1, 1, w - 5, h - 2);
        int xUnit = 3;
        int yUnit = 3;
        int TrWidth = (h - 4) / 2;
        if (this.m_bIsArabic) {
            if (this.m_bIsLeftPressed) {
                graphics.setColor(0);
                graphics.fillRect(xUnit - 1, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(xUnit, h / 2, TrWidth + xUnit, yUnit, TrWidth + xUnit, h - yUnit);
            if (this.m_bIsRightPressed) {
                graphics.setColor(0);
                graphics.fillRect(TrWidth + xUnit + xUnit, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(TrWidth + xUnit + xUnit * 2, yUnit, TrWidth + xUnit + xUnit * 2, h - yUnit, TrWidth * 2 + xUnit + xUnit * 2, h / 2);
        } else {
            int xorigin = w - (TrWidth * 2 + xUnit + xUnit * 3) - 5;
            if (this.m_bIsLeftPressed) {
                graphics.setColor(0);
                graphics.fillRect(xorigin + xUnit - 1, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(xorigin + xUnit, h / 2, xorigin + TrWidth + xUnit, yUnit, xorigin + TrWidth + xUnit, h - yUnit);
            if (this.m_bIsRightPressed) {
                graphics.setColor(0);
                graphics.fillRect(xorigin + TrWidth + xUnit + xUnit, yUnit - 1, TrWidth + xUnit + 2, h - 2 * yUnit + 3);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillTriangle(xorigin + TrWidth + xUnit + xUnit * 2, yUnit, xorigin + TrWidth + xUnit + xUnit * 2, h - yUnit, xorigin + TrWidth * 2 + xUnit + xUnit * 2, h / 2);
        }
        graphics.setColor(oldC);
        if (this.m_iPos == -1) {
            return;
        }
        if (this.m_iPos < 0 || this.m_iPos >= this.m_nSize) {
            return;
        }
        this.m_strLabel = Integer.toString(this.m_iStartNo + this.m_iPos);
        if (this.m_strLabel == "") {
            return;
        }
        if (this.m_bIsArabic) {
            graphics.setClip(TrWidth * 2 + xUnit + xUnit * 2 + 2, yUnit, w - (TrWidth * 2 + xUnit + xUnit * 2 + 4) - 5, h - yUnit * 2);
            graphics.drawString(this.m_strLabel, w - 8, 1, 24);
        } else {
            graphics.setClip(2, yUnit, w - (TrWidth * 2 + xUnit + xUnit * 3), h - yUnit * 2);
            graphics.drawString(this.m_strLabel, 5, 0, 20);
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.m_bIsLeftPressed = false;
        this.m_bIsRightPressed = false;
        switch (dir) {
            case 6: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.m_bIsLeftPressed = true;
                if (this.m_iPos < this.m_nSize - 1) {
                    ++this.m_iPos;
                }
                this.rePaint();
                new Thread(this).start();
                break;
            }
            case 5: {
                this.m_bIsRightPressed = true;
                if (this.m_iPos > 0) {
                    --this.m_iPos;
                }
                this.rePaint();
                new Thread(this).start();
            }
        }
        return true;
    }

    protected void traverseOut() {
        this.m_bIsTraversedOut = true;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8) {
            String stre = Integer.toString(this.m_iPos + this.m_iStartNo);
            this.m_EditCtrl.SetString(stre);
            this.m_Display.setCurrent((Displayable)this.m_EditForm);
            this.m_EditForm.RefreshScreen();
        }
    }

    protected void keyReleased(int keyCode) {
        this.m_bIsLeftPressed = false;
        this.m_bIsRightPressed = false;
        this.rePaint();
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if ((keyAction == 2 || keyAction == 5) && this.m_SelListener != null) {
            this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
        }
    }

    protected void keyRepeated(int keyCode) {
    }

    public void SetPos(int iPos) {
        if (iPos < 0 || iPos >= this.m_nSize) {
            return;
        }
        this.m_iPos = iPos;
        this.rePaint();
    }

    public int GetPos() {
        return this.m_iPos;
    }

    public int GetValue() {
        return this.m_iStartNo + this.m_iPos;
    }

    public String GetString(int iPos) {
        if (iPos < 0 || iPos >= this.m_nSize) {
            return "";
        }
        return Integer.toString(this.m_iPos + this.m_iStartNo);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.m_EditForm) {
            String stre;
            int iVal;
            if (command.getPriority() == 1 && (iVal = Integer.parseInt(stre = this.m_EditCtrl.GetString())) >= this.m_iStartNo && iVal < this.m_nSize + this.m_iStartNo) {
                this.m_iPos = iVal - this.m_iStartNo;
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    MobmeForm frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.m_SelListener != null) {
                    this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
                }
            }
            if (command.getPriority() == 0) {
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    MobmeForm frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        while (this.m_bIsLeftPressed || this.m_bIsRightPressed) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            if (this.m_bIsLeftPressed) {
                if (this.m_iPos < this.m_nSize - 1) {
                    ++this.m_iPos;
                }
                this.rePaint();
                continue;
            }
            if (!this.m_bIsRightPressed) break;
            if (this.m_iPos > 0) {
                --this.m_iPos;
            }
            this.rePaint();
        }
    }

    public void Reset(int iStartNo, int iEndNo) {
        this.m_iStartNo = iStartNo;
        this.m_iEndNo = iEndNo;
        this.m_nSize = this.m_iEndNo - this.m_iStartNo + 1;
        this.m_iPos = 0;
    }

    public void Lock(boolean bIsLocked) {
        this.m_bIsLocked = bIsLocked;
        if (!bIsLocked) {
            this.rePaint();
        }
    }
}

