/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.wap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.kxml.Attribute;
import org.kxml.io.ParseException;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;
import org.kxml.parser.Tag;
import org.kxml.wap.WapExtensionEvent;

public class WbxmlParser
extends AbstractXmlParser {
    InputStream in;
    String[] attrStartTable;
    String[] attrValueTable;
    String[] tagTable;
    String stringTable;
    int version;
    int publicIdentifierId;
    int charSet;
    StartTag current;
    ParseEvent next;
    boolean whitespace;

    public WbxmlParser(InputStream in) throws IOException {
        this.in = in;
        this.version = this.readByte();
        this.publicIdentifierId = this.readInt();
        if (this.publicIdentifierId == 0) {
            this.readInt();
        }
        this.charSet = this.readInt();
        int strTabSize = this.readInt();
        StringBuffer buf = new StringBuffer(strTabSize);
        for (int i = 0; i < strTabSize; ++i) {
            buf.append((char)this.readByte());
        }
        this.stringTable = buf.toString();
    }

    public ParseEvent peek() throws IOException {
        if (this.next != null) {
            return this.next;
        }
        if (this.current != null && this.current.getDegenerated()) {
            this.next = new Tag(16, this.current, this.current.getNamespace(), this.current.getName());
            this.current = this.current.getParent();
            return this.next;
        }
        Object result = null;
        block10: do {
            int id = this.in.read();
            switch (id) {
                case -1: {
                    if (this.current != null) {
                        throw new RuntimeException("unclosed elements: " + this.current);
                    }
                    this.next = new ParseEvent(8, null);
                    break;
                }
                case 0: {
                    if (this.readByte() == 0) continue block10;
                    throw new IOException("Curr. only CP0 supported");
                }
                case 1: {
                    this.next = new Tag(16, this.current, this.current.getNamespace(), this.current.getName());
                    this.current = this.current.getParent();
                    break;
                }
                case 2: {
                    this.next = new ParseEvent(128, "" + (char)this.readInt());
                    break;
                }
                case 3: {
                    String s = this.readStrI();
                    this.next = new ParseEvent(this.whitespace ? 256 : 128, s);
                    break;
                }
                case 64: 
                case 65: 
                case 66: 
                case 128: 
                case 129: 
                case 130: 
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    this.next = this.parseWapExtension(id);
                    break;
                }
                case 67: {
                    throw new RuntimeException("PI curr. not supp.");
                }
                case 131: {
                    int pos = this.readInt();
                    int end = this.stringTable.indexOf(0, pos);
                    this.next = new ParseEvent(128, this.stringTable.substring(pos, end));
                    break;
                }
                default: {
                    this.next = this.parseElement(id);
                }
            }
        } while (this.next == null);
        return this.next;
    }

    public ParseEvent read() throws IOException {
        if (this.next == null) {
            this.peek();
        }
        ParseEvent result = this.next;
        this.next = null;
        return result;
    }

    public ParseEvent parseWapExtension(int id) throws IOException {
        switch (id) {
            case 64: 
            case 65: 
            case 66: {
                return new WapExtensionEvent(id, (Object)this.readStrI());
            }
            case 128: 
            case 129: 
            case 130: {
                return new WapExtensionEvent(id, new Integer(this.readInt()));
            }
            case 192: 
            case 193: 
            case 194: {
                return new WapExtensionEvent(id, (Object)null);
            }
            case 195: {
                int len = this.readInt();
                byte[] buf = new byte[len];
                for (int i = 0; i < len; ++i) {
                    buf[i] = (byte)this.readByte();
                }
                return new WapExtensionEvent(id, buf);
            }
        }
        throw new IOException("illegal id!");
    }

    public Vector readAttr() throws IOException {
        Vector<Attribute> result = new Vector<Attribute>();
        int id = this.readByte();
        while (id != 1) {
            StringBuffer value;
            String name = this.resolveId(this.attrStartTable, id);
            int cut = name.indexOf(61);
            if (cut == -1) {
                value = new StringBuffer();
            } else {
                value = new StringBuffer(name.substring(cut + 1));
                name = name.substring(0, cut);
            }
            id = this.readByte();
            while (id > 128 || id == 2 || id == 3 || id == 131 || id >= 64 && id <= 66 || id >= 128 && id <= 130) {
                switch (id) {
                    case 2: {
                        value.append((char)this.readInt());
                        break;
                    }
                    case 3: {
                        value.append(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        ParseEvent e = this.parseWapExtension(id);
                        if (e.getType() == 128 || e.getType() == 256) {
                            throw new RuntimeException("parse WapExtension must return Text Event in order to work inside Attributes!");
                        }
                        value.append(e.getText());
                    }
                    case 131: {
                        value.append(this.readStrT());
                        break;
                    }
                    default: {
                        value.append(this.resolveId(this.attrValueTable, id));
                    }
                }
                id = this.readByte();
            }
            result.addElement(new Attribute(null, name, value.toString()));
        }
        return result;
    }

    String resolveId(String[] tab, int id) throws IOException {
        int idx = (id & 0x7F) - 5;
        if (idx == -1) {
            return this.readStrT();
        }
        if (idx < 0 || tab == null || idx >= tab.length || tab[idx] == null) {
            throw new IOException("id " + id + " undef.");
        }
        return tab[idx];
    }

    StartTag parseElement(int id) throws IOException {
        String tag = this.resolveId(this.tagTable, id & 0x3F);
        try {
            this.current = new StartTag(this.current, null, tag, (id & 0x80) != 0 ? this.readAttr() : null, (id & 0x40) == 0, this.processNamespaces);
        }
        catch (Exception e) {
            throw new ParseException(null, e, -1, -1);
        }
        return this.current;
    }

    int readByte() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("Unexpected EOF");
        }
        return i;
    }

    int readInt() throws IOException {
        int i;
        int result = 0;
        do {
            i = this.readByte();
            result = result << 7 | i & 0x7F;
        } while ((i & 0x80) != 0);
        return result;
    }

    String readStrI() throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean wsp = true;
        while (true) {
            int i;
            if ((i = this.in.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (i == 0) break;
            if (i > 32) {
                wsp = false;
            }
            buf.append((char)i);
        }
        this.whitespace = wsp;
        return buf.toString();
    }

    String readStrT() throws IOException {
        int pos = this.readInt();
        int end = this.stringTable.indexOf(0, pos);
        return this.stringTable.substring(pos, end);
    }

    public void setTagTable(int page, String[] tagTable) {
        this.tagTable = tagTable;
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrStartTable(int page, String[] attrStartTable) {
        this.attrStartTable = attrStartTable;
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrValueTable(int page, String[] attrStartTable) {
        this.attrValueTable = attrStartTable;
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }
}

