/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.CalCanvas;
import CalendarPKG.CalData;
import CalendarPKG.EDate;
import CalendarPKG.HijryCalendar;
import CalendarPKG.SDATE;
import CalendarPKG.Tools;
import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class HolidayData {
    final int COUNTRY_NAME_MAX_LEN;
    final int HOLIDAY_NAME_MAX_LEN;
    public static String[] NamesAr;
    public static String[] NamesEn;
    Calendar Today = Calendar.getInstance();
    String[] NoYearholidays;
    CountryA[] Countries = this.LoadCountry();
    Holiday[] valid;
    int HolidayCount = 0;
    public Vector allHolidays = new Vector(this.Countries.length);

    public HolidayData() {
        this.COUNTRY_NAME_MAX_LEN = 18;
        this.HOLIDAY_NAME_MAX_LEN = 50;
        this.allHolidays.setSize(this.Countries.length);
        NamesAr = new String[this.Countries.length];
        NamesEn = new String[this.Countries.length];
        for (int i = 0; i < this.Countries.length; ++i) {
            HolidayData.NamesAr[i] = this.Countries[i].szArbName;
            HolidayData.NamesEn[i] = this.Countries[i].szEngName;
        }
        this.setHoliday();
    }

    public String getCountryName(int index, boolean arabic) {
        return arabic ? this.Countries[index].szArbName : this.Countries[index].szEngName;
    }

    public void setHoliday() {
        int i;
        Holiday[] holidays = this.getHoliday(this.Countries[CalCanvas.CountryIndex]);
        Holiday tmp = null;
        this.valid = new Holiday[this.HolidayCount];
        this.HolidayCount = 0;
        int n = 0;
        for (int j = 0; j < holidays.length; ++j) {
            if (holidays[j] == null) continue;
            this.valid[n] = holidays[j];
            ++n;
        }
        Calendar cal = Calendar.getInstance();
        int ThisHijryYear = HijryCalendar.mainMidlet.mainWnd.dateConvert.GregorianToHijriDate((SDATE)new SDATE((int)cal.get((int)5), (int)(cal.get((int)2) - 1), (int)cal.get((int)1), (int)0, (float)0.0f), (boolean)false).year;
        for (i = 0; i < this.valid.length; ++i) {
            if (this.valid[i].nType) {
                SDATE tmpDate1 = HijryCalendar.mainMidlet.mainWnd.dateConvert.HijriToGregorianDate(new SDATE(this.valid[i].nDay, this.valid[i].nMonth, ThisHijryYear, 0, 0.0f), false);
                this.valid[i].gDay = tmpDate1.day;
                this.valid[i].gMonth = tmpDate1.mon;
                this.valid[i].gYear = tmpDate1.year;
                continue;
            }
            this.valid[i].gDay = this.valid[i].nDay;
            this.valid[i].gMonth = this.valid[i].nMonth;
            this.valid[i].gYear = this.valid[i].nYear;
        }
        for (i = 0; i < this.valid.length; ++i) {
            for (int j = 0; j < this.valid.length - 1; ++j) {
                if (this.valid[j].gMonth > this.valid[j + 1].gMonth) {
                    tmp = this.valid[j];
                    this.valid[j] = this.valid[j + 1];
                    this.valid[j + 1] = tmp;
                    continue;
                }
                if (this.valid[j].gMonth != this.valid[j + 1].gMonth || this.valid[j].gDay <= this.valid[j + 1].gDay) continue;
                tmp = this.valid[j];
                this.valid[j] = this.valid[j + 1];
                this.valid[j + 1] = tmp;
            }
        }
        this.allHolidays.insertElementAt(this.valid, CalCanvas.CountryIndex);
    }

    CountryA[] LoadCountry() {
        CountryA[] Countries;
        char[] arName = new char[18];
        char[] enName = new char[18];
        char[] arabic = new char[18];
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/Data/INHolidays.bin"));
            int cCount = dis.readByte();
            Countries = new CountryA[cCount];
            for (int i = 0; i < cCount; ++i) {
                for (int j = 0; j < 18; ++j) {
                    arName[j] = (char)dis.readByte();
                }
                String s = Tools.ArabicAscii2Unicode(arName);
                for (int j = 0; j < 18; ++j) {
                    enName[j] = (char)dis.readByte();
                }
                byte engSrt = dis.readByte();
                byte count = dis.readByte();
                int offset1 = dis.readUnsignedByte();
                int offset2 = dis.readUnsignedByte();
                int offset = Integer.parseInt(Integer.toHexString(offset2) + Integer.toHexString(offset1), 16);
                int k = 0;
                while (enName[k] != '\u0000') {
                    ++k;
                }
                String englishName = String.valueOf(enName, 0, k);
                Countries[i] = new CountryA(Tools.ArabicAscii2Unicode(arName), englishName, engSrt, count, offset);
            }
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return Countries;
    }

    Holiday[] getHoliday(CountryA Country) {
        if (Country.nEngSrtID == 7) {
            this.NoYearholidays = new String[CalData.LebHolidays.length];
            for (int n = 0; n < this.NoYearholidays.length; ++n) {
                this.NoYearholidays[n] = CalData.LebHolidays[n];
            }
        } else if (Country.nEngSrtID == 2) {
            this.NoYearholidays = new String[1];
            this.NoYearholidays[0] = CalData.EgyHoliday;
        }
        Holiday[] holidays = new Holiday[Country.cHolidays];
        char[] szArName = new char[50];
        char[] szEnName = new char[50];
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/Data/INHolidays.bin"));
            dis.skip(Country.pHolidays);
            for (int i = 0; i < Country.cHolidays; ++i) {
                int j;
                for (j = 0; j < 50; ++j) {
                    szArName[j] = (char)dis.readByte();
                }
                for (j = 0; j < 50; ++j) {
                    szEnName[j] = (char)dis.readByte();
                }
                byte nDay = dis.readByte();
                byte cDays = dis.readByte();
                byte nMonth = dis.readByte();
                boolean nType = dis.readByte() == 1;
                int nYear1 = dis.readUnsignedByte();
                int nYear2 = dis.readUnsignedByte();
                int nYear = Integer.parseInt(Integer.toHexString(nYear2) + Integer.toHexString(nYear1), 16);
                int k = 0;
                while (szEnName[k] != '\u0000') {
                    ++k;
                }
                if ((Country.nEngSrtID == 7 || Country.nEngSrtID == 2) && nYear != 0) {
                    EDate date1 = new EDate();
                    int s = 0;
                    int strLength = 0;
                    if (Country.nEngSrtID == 7) {
                        strLength = CalData.LebHolidays.length;
                    } else if (Country.nEngSrtID == 2) {
                        strLength = 1;
                    }
                    for (int n = 0; n < strLength; ++n) {
                        String str1;
                        String str;
                        if (nYear == 0 || (s = (str = Tools.ArabicAscii2Unicode(szArName)).compareTo(str1 = this.NoYearholidays[n])) != 0) continue;
                        if (n == 0) {
                            date1 = Tools.OrthodoxEasterSunday(this.Today.get(1));
                            date1 = this.addDaysToCalendar(date1, 1);
                        } else if (n == 1) {
                            date1 = Tools.ArmenianEasterSunday(this.Today.get(1));
                            if (date1.m_date > 4) {
                                date1 = this.addDaysToCalendar(date1, -2);
                            }
                        } else if (n == 2) {
                            date1 = Tools.ArmenianEasterSunday(this.Today.get(1));
                        } else if (n == 3) {
                            date1 = Tools.ArmenianEasterSunday(this.Today.get(1));
                            date1 = this.addDaysToCalendar(date1, 1);
                        } else if (n == 4) {
                            date1 = Tools.OrthodoxEasterSunday(this.Today.get(1));
                            date1 = this.addDaysToCalendar(date1, -2);
                        } else if (n == 5) {
                            date1 = Tools.OrthodoxEasterSunday(this.Today.get(1));
                        }
                        nYear = 0;
                        nMonth = (byte)date1.m_month;
                        nDay = (byte)date1.m_date;
                        this.NoYearholidays[n] = " ";
                        break;
                    }
                }
                if (nYear != 0) continue;
                ++this.HolidayCount;
                holidays[i] = new Holiday(Tools.ArabicAscii2Unicode(szArName), String.valueOf(szEnName, 0, k), nDay, cDays, nMonth, nType, nYear);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return holidays;
    }

    private EDate addDaysToCalendar(EDate date, int days) {
        Calendar c = Calendar.getInstance();
        c.set(5, date.m_date);
        c.set(2, date.m_month - 1);
        c.set(1, date.m_year);
        long add = days * 86400000;
        c.setTime(new Date(c.getTime().getTime() + add));
        date.m_date = c.get(5);
        date.m_month = c.get(2) + 1;
        date.m_year = c.get(1);
        return date;
    }

    public class Holiday {
        String szArName;
        String szEnName;
        byte nDay;
        byte cDays;
        byte nMonth;
        boolean nType;
        int nYear;
        int gYear;
        int gMonth;
        int gDay;

        public Holiday(String arName, String enName, byte day, byte dayCount, byte month, boolean type, int year) {
            this.szArName = arName;
            this.szEnName = enName;
            this.nDay = day;
            this.cDays = dayCount;
            this.nMonth = month;
            this.nType = type;
            this.nYear = year;
        }
    }

    public class CountryA {
        String szArbName;
        String szEngName;
        byte nEngSrtID;
        byte cHolidays;
        int pHolidays;

        public CountryA(String arName, String enName, byte engSrt, byte count, int offset) {
            this.szArbName = arName;
            this.szEngName = enName;
            this.nEngSrtID = engSrt;
            this.cHolidays = count;
            this.pHolidays = offset;
        }
    }
}

