/*
 * Decompiled with CFR 0.152.
 */
package IO;

import java.io.IOException;
import java.io.InputStream;

class CustomInputStream {
    InputStream In;
    byte[] buff;
    int pos = -1;
    int size = -1;

    public CustomInputStream(String FileName) throws IOException {
        this.OpenFile(FileName);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -2) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -2; ++i) {
                if (b == null) continue;
                b[off + i] = (byte)c;
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
        return i;
    }

    public long skip(long n) throws IOException {
        if (n + (long)this.pos > (long)this.size) {
            this.pos = this.size;
            return this.size - this.pos;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int available() throws IOException {
        return this.size;
    }

    public void close() throws IOException {
        this.size = -1;
        this.pos = -1;
        this.buff = null;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        this.pos = 0;
    }

    public boolean markSupported() {
        return false;
    }

    private void OpenFile(String FileName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(FileName);
        if (is != null) {
            this.size = is.available();
            this.buff = new byte[this.size];
            is.read(this.buff);
            is.close();
            this.pos = 0;
        } else {
            this.pos = -1;
            this.size = -1;
        }
    }

    private int read() {
        if (this.pos == this.size) {
            return -2;
        }
        return this.buff[this.pos++];
    }
}

