/*
 * Decompiled with CFR 0.152.
 */
package GPackage;

import GPackage.GListener;
import GPackage.GSubMenu;
import GPackage.settingScreen;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GridList
extends Canvas {
    boolean SCROLL = false;
    boolean disableReleaseEffect = false;
    GListener glistener;
    private int IconsPerPg = 0;
    private int IconsPerRow = 0;
    private int IconsPerColumn = 0;
    private int selectedIndex = 1;
    private int totalIconsNo = 0;
    private int Space = 10;
    private int baseY = 0;
    private int baseX = 0;
    private int stepY;
    private int stepX;
    private int Xpointer = 0;
    private int Ypointer = 0;
    private int startDrawingIndex = 0;
    private int Width = 0;
    private int Height = 0;
    private int lang;
    private int old = 0;
    private int newPos = -1;
    private int Pos = 0;
    private int oldY = 0;
    private Image img_GridFooter = null;
    private Image img_MainHeader = null;
    private Image img_BackGround = null;
    private Image img_IconSel = null;
    private Image img_UP = null;
    private Image img_DOWN = null;
    private Vector GridIcons = null;
    boolean first = true;

    public GridList(Image Header, Image Footer, Vector I) {
        this.setFullScreenMode(true);
        this.img_MainHeader = Header;
        this.img_GridFooter = Footer;
        this.GridIcons = I;
        this.init();
    }

    private void init() {
        this.Height = this.getHeight();
        this.Width = this.getWidth();
        this.totalIconsNo = this.GridIcons.size();
        this.baseY = this.img_MainHeader.getHeight() + 5;
        this.baseX = 10;
        this.stepY = ((Image)this.GridIcons.elementAt(0)).getHeight() + this.Space;
        this.stepX = ((Image)this.GridIcons.elementAt(0)).getWidth() + this.Space;
        this.IconsPerColumn = (this.Height - (this.baseY + this.img_GridFooter.getHeight())) / this.stepY;
        this.IconsPerRow = (this.Width - this.baseX) / this.stepX;
        this.IconsPerPg = this.IconsPerColumn * this.IconsPerRow;
        this.Xpointer = 0;
        this.Ypointer = 0;
        this.selectedIndex = 1;
        this.SCROLL = this.totalIconsNo > this.IconsPerPg;
    }

    public void setBackGround(Image BackGround) {
        this.img_BackGround = BackGround;
    }

    public Image getBackGround() {
        return this.img_BackGround;
    }

    public void setFooter(Image Footer) {
        this.img_GridFooter = Footer;
    }

    public Image getFooter() {
        return this.img_GridFooter;
    }

    public void setHeader(Image Header) {
        this.img_MainHeader = Header;
    }

    public Image getHeader() {
        return this.img_MainHeader;
    }

    public void setScrollArrows(Image up, Image down) {
        this.img_DOWN = down;
        this.img_UP = up;
    }

    public void setSelection(Image Selection) {
        this.img_IconSel = Selection;
    }

    public Image getSelection() {
        return this.img_IconSel;
    }

    public void setGListener(GListener glistener) {
        this.glistener = glistener;
    }

    public GListener getGlistener() {
        return this.glistener;
    }

    public void setLanguage(int lang) {
        this.lang = lang;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void resetSelectedIndex() {
        this.selectedIndex = 1;
        this.Xpointer = 0;
        this.Ypointer = 0;
        this.startDrawingIndex = 0;
    }

    protected void paint(Graphics g) {
        if (this.first) {
            this.init();
            this.first = false;
        }
        this.Height = this.getHeight();
        this.Width = this.getWidth();
        this.setFullScreenMode(true);
        this.DrawBG(g);
        this.DrawIcons(g);
        this.DrawSelection(g);
        if (this.SCROLL) {
            if (this.selectedIndex <= this.IconsPerRow) {
                this.DrawDownArrow(g);
            } else if (this.selectedIndex >= this.totalIconsNo - this.IconsPerRow) {
                this.DrawUpArrow(g);
            } else {
                this.DrawDownArrow(g);
                this.DrawUpArrow(g);
            }
        }
        this.glistener.GFPaint(g, this.Width, this.Height);
    }

    private void DrawBG(Graphics g) {
        if (this.img_BackGround != null) {
            g.drawImage(this.img_BackGround, 0, 0, 20);
        }
        if (this.img_GridFooter != null) {
            g.drawImage(this.img_GridFooter, 0, this.getHeight() - this.img_GridFooter.getHeight(), 20);
        }
        if (this.img_MainHeader != null) {
            g.drawImage(this.img_MainHeader, 0, 0, 20);
        }
    }

    private void DrawIcons(Graphics g) {
        for (int i = 0; i < this.IconsPerColumn; ++i) {
            for (int j = 0; j < this.IconsPerRow; ++j) {
                if (this.startDrawingIndex + (j + i * this.IconsPerRow) > this.GridIcons.size() - 1) continue;
                g.drawImage((Image)this.GridIcons.elementAt(this.startDrawingIndex + (j + i * this.IconsPerRow)), this.getWidth() - (this.baseX + j * this.stepX), this.baseY + i * this.stepY, 24);
            }
        }
    }

    private void DrawSelection(Graphics g) {
        g.drawImage(this.img_IconSel, this.getWidth() - (this.baseX + this.stepX * this.Xpointer), this.baseY + this.stepY * this.Ypointer, 24);
    }

    private void DrawUpArrow(Graphics g) {
        if (this.img_UP != null && this.img_GridFooter != null) {
            g.drawImage(this.img_UP, this.Width / 2 - this.img_UP.getWidth() / 2, this.Height - this.img_UP.getHeight() * 2, 20);
        }
    }

    private void DrawDownArrow(Graphics g) {
        if (this.img_DOWN != null) {
            g.drawImage(this.img_DOWN, this.Width / 2 - this.img_DOWN.getWidth() / 2, this.Height - this.img_DOWN.getHeight(), 20);
        }
    }

    private boolean isValidGameAction(int key) {
        int keycode = this.getGameAction(key);
        return keycode != 0;
    }

    protected void keyPressed(int key) {
        if (this.isValidGameAction(key)) {
            key = this.getGameAction(key);
        }
        this.glistener.GFKeyPressed(key);
        if (!GSubMenu.isShown() && !settingScreen.isShown()) {
            if (key == 2) {
                this.leftPressed();
            } else if (key == 5) {
                this.rightPressed();
            } else if (key == 1) {
                this.upPressed();
            } else if (key == 6) {
                this.downPressed();
            }
        }
        this.repaint();
    }

    private void rightPressed() {
        if (this.selectedIndex == 1) {
            return;
        }
        if (this.selectedIndex > this.IconsPerRow && this.Xpointer == 0) {
            this.Xpointer = this.IconsPerRow - 1;
            if (this.startDrawingIndex > 0 && this.Ypointer == 0) {
                this.startDrawingIndex -= this.IconsPerRow;
            }
            if (this.Ypointer > 0) {
                --this.Ypointer;
            }
        } else {
            --this.Xpointer;
        }
        --this.selectedIndex;
    }

    private void leftPressed() {
        if (this.selectedIndex == this.totalIconsNo) {
            return;
        }
        if (this.selectedIndex > 1 && this.selectedIndex % this.IconsPerRow == 0) {
            this.Xpointer = 0;
            if (this.selectedIndex >= this.IconsPerPg && this.Ypointer == this.IconsPerColumn - 1) {
                this.startDrawingIndex += this.IconsPerRow;
            }
            if (this.Ypointer < this.IconsPerColumn - 1) {
                ++this.Ypointer;
            }
        } else {
            ++this.Xpointer;
        }
        ++this.selectedIndex;
    }

    private void upPressed() {
        if (this.selectedIndex <= this.IconsPerRow) {
            return;
        }
        if (this.Ypointer == 0 && this.selectedIndex > this.IconsPerRow) {
            this.startDrawingIndex -= this.IconsPerRow;
        }
        if (this.Ypointer > 0) {
            --this.Ypointer;
        }
        this.selectedIndex -= this.IconsPerRow;
    }

    private void downPressed() {
        if (this.selectedIndex + this.IconsPerRow > this.totalIconsNo) {
            return;
        }
        if (this.Ypointer == this.IconsPerColumn - 1 && this.selectedIndex <= this.totalIconsNo - this.IconsPerRow) {
            this.startDrawingIndex += this.IconsPerRow;
        }
        if (this.Ypointer < this.IconsPerColumn - 1) {
            ++this.Ypointer;
        }
        this.selectedIndex += this.IconsPerRow;
    }

    protected void pointerDragged(int x, int y) {
        if (this.hasPointerMotionEvents()) {
            if (this.isPSelected(x, y) && !GSubMenu.isShown() && !settingScreen.isShown()) {
                if (this.oldY == 0) {
                    this.oldY = y;
                    return;
                }
                int diff = this.oldY - y;
                if (y < this.oldY - 15) {
                    this.oldY = 0;
                    this.disableReleaseEffect = true;
                    if (this.selectedIndex < this.totalIconsNo - this.IconsPerRow && this.startDrawingIndex < this.totalIconsNo - this.IconsPerPg) {
                        this.startDrawingIndex += this.IconsPerRow;
                        if (this.selectedIndex <= this.totalIconsNo - this.IconsPerRow) {
                            this.selectedIndex += this.IconsPerRow;
                        }
                        this.repaint();
                    }
                    return;
                }
                if (y > this.oldY + 15) {
                    this.oldY = 0;
                    this.disableReleaseEffect = true;
                    if (this.startDrawingIndex > 0) {
                        this.startDrawingIndex -= this.IconsPerRow;
                        if (this.selectedIndex >= this.IconsPerRow) {
                            this.selectedIndex -= this.IconsPerRow;
                        }
                        this.repaint();
                    }
                }
            } else {
                this.glistener.GFPointerDragged(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        this.oldY = 0;
        if (this.disableReleaseEffect) {
            this.disableReleaseEffect = false;
            return;
        }
        if (this.isPLeftkey(x, y)) {
            this.keyPressed(-6);
        } else if (this.isPRightkey(x, y)) {
            this.keyPressed(-7);
        } else if (this.isPSelected(x, y) && !GSubMenu.isShown() && !settingScreen.isShown()) {
            if (this.selectedIndex < 0 || this.selectedIndex >= this.totalIconsNo || this.startDrawingIndex > this.totalIconsNo) {
                return;
            }
            if (!this.disableReleaseEffect) {
                this.old = this.selectedIndex;
                this.Ypointer = (y - this.baseY) / this.stepY;
                this.Xpointer = (this.getWidth() - (x - this.baseX)) / this.stepX;
                this.selectedIndex = 1 + this.startDrawingIndex + this.Ypointer * this.IconsPerRow + this.Xpointer;
                this.repaint();
                if (this.old == this.selectedIndex) {
                    this.keyPressed(this.getKeyCode(8));
                }
            }
        } else if (this.SCROLL && !this.isPSelected(x, y) && !GSubMenu.isShown() && !settingScreen.isShown()) {
            if (this.selectedIndex < 0 || this.selectedIndex >= this.GridIcons.size() || this.startDrawingIndex > this.GridIcons.size()) {
                return;
            }
            if (this.isScrollDown(x, y)) {
                this.keyPressed(this.getKeyCode(6));
            } else if (this.isScrollUp(x, y)) {
                this.keyPressed(this.getKeyCode(1));
            }
        } else {
            this.glistener.GFPointerRealesed(x, y);
        }
        this.repaint();
    }

    private boolean isPLeftkey(int x, int y) {
        return x <= this.img_GridFooter.getWidth() / 3 && y > this.getHeight() - this.img_GridFooter.getHeight();
    }

    private boolean isPRightkey(int x, int y) {
        return x >= this.getWidth() - this.img_GridFooter.getWidth() / 3 && y > this.getHeight() - this.img_GridFooter.getHeight();
    }

    private boolean isScrollDown(int x, int y) {
        return x >= this.img_GridFooter.getWidth() / 3 && x < this.getWidth() - this.img_GridFooter.getWidth() / 3 && y >= this.getHeight() - this.img_DOWN.getHeight();
    }

    private boolean isScrollUp(int x, int y) {
        return x >= this.img_GridFooter.getWidth() / 3 && x < this.getWidth() - this.img_GridFooter.getWidth() / 3 && y >= this.getHeight() - this.img_GridFooter.getHeight() && y < this.getHeight() - this.img_UP.getHeight();
    }

    private boolean isPSelected(int x, int y) {
        return y > this.img_MainHeader.getHeight() && y < this.img_MainHeader.getHeight() + this.IconsPerColumn * this.stepY && x > this.baseX && x < this.baseX + this.IconsPerRow * this.stepX;
    }
}

